% modern
%
%  Data from maddison (see verylongrun.m)


if exist('modern.log'); delete('modern.log'); end;
diary modern.log;
fprintf(['modern                 ' date]);
disp ' ';
disp ' ';
help modern


% Modern era of "Catch-Up" Growth

%GDP per capita				
%(1990 Int. GK$) 				
%	USA	China 	Japan 	Ethiopia Haiti
data=[
1870	2445	530	737	NaN   NaN 
1900	4091	545	1180	NaN   NaN 
1930	6213	568	1850	NaN   NaN 
1950	9561	448	1921	390   1051
1960	11328	662	3986	440   1055
1970	15030	778	9714	595   906 
1980	18577	1061	13428	648   1310
1990	23201	1871	18789	578   1032
2000	28449	3421	20742	605   796 
2006	31049	6048	22471	753   697 
];





yrs=data(:,1);
gdppc=data(:,[2:6]);
mygreen=[0 .6 .4];
myo=[1 .5 0];
myred=[.7 0 .4];
myunc=[0 .3 .7];

figure(2); figsetup;
plot(yrs,log(gdppc(:,2)),'Color',myred);  % china
hold on;
plot(yrs,log(gdppc(:,3)),'Color',mygreen); % japan
plot(yrs,log(gdppc(:,4)),'Color',myo); % ethiopia
plot([1870 1950],log([390 390]),'--','Color',myo); % ethiopia extrapolation
plot(yrs,log(gdppc(:,5)),'Color',myunc); % haiti
plotlog(yrs,(gdppc(:,1)),'-','250 500 1000 2000 4000 8000 16000 32000');
chadfig('Year','Log Scale',1,1);
ax=axis; ax(1)=1865; ax(2)=2008; ax(4)=log(36000); axis(ax);
text(1932,log(16000),'United States','Color','b');
text(1942,log(4000),'Japan','Color',mygreen);
text(1980,log(3000),'China','Color',myred);
text(1950,log(1400),'Haiti','Color',myunc);
text(1970,log(400),'Ethiopia','Color',myo);

makefigwide;
wait;
print modern.eps

diary off;