% LifeExpectancyWB80  6/4/13
%
% World Bank data 
%  -- Order for pwt80
%  -- Use LifeExpectancyWB-Mar2012.xls for underlying data


if exist('LifeExpectancyWB80.log'); delete('LifeExpectancyWB80.log'); end;
diary LifeExpectancyWB80.log;
fprintf(['LifeExpectancyWB80                 ' date]);
disp ' ';
disp ' ';
help LifeExpectancyWB80

clear all;

data=[
    % 1980 1990 2000 2007
39.2041219512	42.3293658537	45.2928536585	47.2053170732
69.6740487805	71.6454390244	74.2387317073	76.4734146341
59.6036829268	67.0717804878	70.0241707317	72.150902439
NaN	NaN	NaN	NaN
NaN	NaN	NaN	NaN
40.161804878	41.1414146341	45.2049268293	49.4352926829
NaN	NaN	NaN	NaN
56.8434757825	63.1621907039	67.4105501475	69.3696505513
69.4696097561	71.4982926829	73.7179756098	75.1149756098
70.680097561	67.7572439024	70.9894390244	73.3278292683
72.2201463415	73.3899756098	73.720097561	74.5282926829
74.3336585366	76.9946341463	79.2341463415	81.2926829268
72.4236585366	75.53	78.0268292683	79.9829268293
64.6813170732	64.7463658537	66.7572195122	69.7486585366
67.6973658537	69.4370487805	71.6282926829	74.3654390244
69.8744878049	72.4649512195	73.7960731707	74.6312926829
55.2358536585	59.4711463415	64.7303414634	67.6666585366
71.9743658537	74.4172682927	75.4082682927	76.1293658537
70.3346585366	70.8365853659	68.912195122	70.2034146341
73.1846341463	75.9682926829	78.1731707317	79.5341463415
70.147	72.486804878	73.5311219512	75.1118536585
45.2471219512	48.6485365854	52.5653414634	54.4307317073
72.3046341463	NaN	77.8648780488	78.8614390244
46.3592195122	52.5896341463	61.3742195122	65.759097561
51.9635609756	58.7780731707	62.9636829268	65.3477317073
70.2735853659	67.4668536585	74.3081219512	74.9686097561
60.4592195122	64.0171707317	50.7654878049	52.0689512195
62.4965853659	66.3407317073	70.1382682927	72.1099512195
70.7172195122	73.6536585366	76.2323414634	77.524195122
71.1575609756	71.6414634146	71.6634146341	72.6634146341
46.3316097561	48.4530487805	50.2012926829	53.4769512195
46.8593170732	46.2271463415	46.0050487805	48.5466341463
38.6240731707	55.3972926829	57.4641463415	61.0645853659
51.1865365854	53.253097561	50.0712682927	49.8151707317
75.0780487805	77.3770731707	79.2365853659	80.8043902439
59.8433414634	65.0802195122	69.4482682927	73.0108536585
NaN	NaN	NaN	NaN
48.8095365854	48.8288780488	43.6633658537	45.4825365854
47.8966829268	50.6799268293	48.4889756098	48.3685853659
73.3449512195	75.4182439024	77.5241219512	79.3007560976
69.1917317073	73.6035609756	76.8217317073	78.5342682927
66.993804878	69.4597317073	71.2417073171	72.6125853659
65.4611463415	68.3055365854	71.0009756098	72.7537804878
51.9551707317	55.5994146341	57.8764390244	59.53
45.8246829268	46.8400731707	45.651902439	47.3492926829
56.2368292683	56.2465609756	54.1458536585	55.7704146341
72.5508292683	75.747	77.8040731707	78.8214146341
51.4042439024	52.6441463415	50.1608780488	52.7258780488
70.1753658537	72.1704878049	72.807804878	75.7056097561
73.5623414634	74.459804878	76.365804878	78.2852439024
NaN	NaN	NaN	NaN
74.7484878049	76.5047073171	77.9569268293	78.857902439
70.2780487805	71.383902439	74.9682926829	76.7243902439
74.1017073171	74.8053658537	76.5926829268	78.1951219512
47.9128536585	51.3663170732	53.8503414634	56.3565365854
NaN	NaN	NaN	NaN
63.001195122	67.704195122	70.8937073171	72.5044634146
65.9039951109	68.9576480001	71.0400614225	72.544165189
64.8017162852	67.926380472	69.9868377698	71.4673664786
62.9199268293	68.8568780488	73.3920487805	75.0049512195
56.150195122	62.0128292683	69.0826585366	72.1922195122
56.8276097561	65.9908536585	69.7016097561	71.1041707317
42.8141707317	46.7654390244	48.6902682927	49.9526341463
43.9783658537	48.2335365854	56.0249756098	59.6392195122
69.0330487805	69.4756097561	70.4170731707	72.8146341463
43.9142439024	47.0453902439	51.7101219512	56.7239268293
73.6627294908	76.0235230437	78.3338682679	80.1474093291
70.1101606594	71.9806273214	72.9640999214	74.8402827452
66.1703953168	68.0807078954	67.5468037912	69.3603909587
72.9283566734	74.8923018215	77.151407907	78.9160466592
NaN	76.0097560976	78.5829268293	79.6317073171
63.0091463415	65.5708536585	67.6073170732	68.8316341463
73.44	74.8131707317	77.4658536585	79.2634146341
74.0512195122	76.6	78.9585365854	80.8146341463
64.4997073171	69.3337804878	72.4210731707	74.4788780488
54.8438292683	61.2891219512	59.6909512195	60.8991463415
47.5411707317	53.1250487805	55.1567560976	57.2200487805
69.3627804878	70.2478780488	71.563097561	72.8413414634
72.8186341463	75.3161219512	77.9268292683	79.5341463415
53.1104390244	56.8430243902	58.3822439024	62.3002439024
NaN	NaN	NaN	NaN
74.4152926829	76.9390243902	77.887804878	79.4390243902
NaN	NaN	65.9268292683	68.4390243902
65.0093170732	68.9273658537	73.4077073171	75.1467560976
69.3905365854	72.0855365854	74.1653902439	75.4598292683
57.312	62.2866829268	67.7441707317	70.1250487805
38.8347317073	43.6706829268	48.1101463415	52.1885609756
40.0567317073	42.8241463415	44.8848780488	46.6426829268
59.5235853659	61.1014634146	64.4482682927	68.3481707317
50.8797317073	55.0904146341	58.3720731707	60.6877317073
47.1771001759	49.0305512474	51.0380203944	54.2253190744
73.2825781396	75.4771979706	77.6081902727	79.2042689535
69.6980603816	72.5070977025	74.8809311959	76.326183132
73.494425954	75.6881087522	77.8189164778	79.450648697
59.4186829268	66.3393902439	70.3820243902	71.958902439
74.6731707317	77.3804878049	80.8780487805	82.3756097561
69.0617073171	69.3156097561	71.2463414634	73.1512195122
76.6127804878	78.0327317073	79.6608536585	81.1073170732
60.3491307765	63.188756503	65.1971289947	66.9607749629
55.3470731707	58.3528536585	61.6138780488	64.0685365854
57.5911219512	62.1038536585	65.6463658537	67.7095853659
52.3442439024	61.9104634146	69.7396585366	71.9346341463
57.2847073171	67.534195122	70.7434878049	67.8640731707
72.5493658537	74.7413170732	76.5407317073	79.0414634146
NaN	NaN	NaN	NaN
73.8756097561	76.6073170732	78.9536585366	80.6048780488
73.9431707317	76.8590243902	79.4268292683	81.2853658537
70.4855365854	70.6456341463	70.4722926829	72.040804878
76.0917073171	78.8368292683	81.076097561	82.5070731707
67.0367804878	70.4345121951	72.0750243902	72.8869268293
66.6243902439	68.3365853659	65.5170731707	66.5048780488
57.7401707317	59.3399512195	52.2996341463	54.3860243902
NaN	NaN	59.5365853659	NaN
67.6986341463	70.4662682927	65.1105121951	68.3409268293
65.8019512195	71.2948780488	75.8554878049	79.3495121951
NaN	67.7587804878	67.9512195122	69.1824390244
70.4567073171	72.6818536585	73.7524878049	74.279902439
62.8702439024	68.2975609756	68.5585365854	67.8951219512
48.7622195122	54.3082195122	61.3946097561	65.6595609756
64.4853561289	68.2400069782	71.6228990148	73.3858480821
64.3829540847	68.1814583763	71.5898179894	73.3575650382
68.8085365854	69.2731707317	70.3146341463	71.0195121951
48.4717547927	51.1441256527	54.3598631788	57.4518197743
66.5743902439	68.6720243902	70.6370243902	71.8628536585
53.6587317073	59.3268536585	47.5863658537	45.2150243902
43.8481707317	42.276804878	45.9643170732	53.8888536585
60.0124634146	68.0800243902	72.5307560976	74.1029268293
NaN	NaN	NaN	NaN
70.482195122	71.1607317073	72.0195121951	70.9
60.2664406467	63.1040630159	65.0614617959	66.8260342706
50.2392959914	52.7289811862	54.6730465795	57.5865767698
56.1759267677	59.4685742899	62.2537969556	64.3984366839
71.9602682927	74.8532926829	77.8731707317	80.087804878
73.2440487805	76.1404390244	78.5369756098	80.0226829268
69.6565853659	71.2797804878	72.9102195122	74.0906097561
48.2081219512	50.7423902439	59.6745609756	65.3755609756
44.336195122	47.0942682927	46.0297317073	50.8623170732
67.4028536585	70.0653658537	72.1424878049	73.3590487805
52.6288292683	60.8846341463	70.3741219512	75.3870243902
39.6098292683	44.1622195122	47.2432682927	49.7107560976
72.9324390244	75.1757804878	78.2	79.443902439
NaN	NaN	65.2390243902	NaN
52.994804878	55.9369756098	56.9947804878	57.4702682927
66.9879756098	69.4048780488	71.6634146341	72.5707317073
68.4713902439	72.240097561	75.2959268293	77.1559756098
66.5718536585	70.791097561	74.2742439024	75.9971463415
65.1835853659	66.1975853659	67.2737317073	68.2274878049
57.6351395475	64.8231414634	69.8420806271	71.7337278429
56.713231552	64.064420779	69.3672897038	71.269722175
61.511808036	64.4903700462	66.5860556108	68.2798500367
64.7687073171	67.4436829268	66.8882682927	68.123902439
NaN	NaN	NaN	NaN
57.332902439	60.5382682927	63.1213414634	67.0575609756
73.6019756098	75.4203170732	74.8900243902	73.9695365854
57.6312439024	64.146	68.6751463415	71.0191219512
42.805902439	43.1762682927	47.2378536585	48.5605853659
55.0355853659	57.2737073171	61.8557073171	63.4181707317
57.802902439	60.7774146341	57.6577317073	60.2232682927
48.1546097561	53.9567317073	61.5216341463	66.966097561
75.7431707317	76.8780487805	77.987804878	80.0975609756
66.5695121951	70.4853658537	74.9195121951	75.9463414634
72.8292682927	75.3780487805	78.6365853659	80.1512195122
58.4604390244	64.1580243902	69.6457317073	72.7593902439
39.5295853659	41.4328536585	48.2666829268	52.8181463415
45.4882682927	45.6373414634	46.2723170732	49.9994878049
73.7968487149	75.4312646802	76.8924210047	78.1314496455
NaN	NaN	NaN	NaN
75.6717073171	76.5373170732	78.6341463415	80.3951219512
72.2037016436	74.6330321618	77.0361315649	78.7434726464
60.7683902439	70.6329512195	74.1102926829	73.1088780488
57.9148292683	60.767195122	63.1619512195	64.5025365854
NaN	69.0692682927	70.4936585366	NaN
69.9607073171	72.3481707317	74.2231463415	75.4594878049
52.8837073171	55.7093414634	58.7957804878	61.323902439
66.7257317073	67.9726097561	70.045195122	71.6586585366
60.016195122	65.5495121951	70.4762682927	73.0503902439
63.1697317073	65.1593902439	66.7951463415	67.780097561
70.0975609756	70.8902439024	73.7487804878	75.243902439
71.2146341463	73.9658536585	76.3146341463	78.3219512195
73.7759268293	74.3985853659	76.6892682927	78.4258536585
71.2498780488	74.1287804878	76.303195122	77.6044390244
69.0909756098	69.7412195122	71.1634146341	72.5658536585
67.033902439	68.9024390244	65.3414634146	67.4975609756
48.2001463415	32.8269756098	46.5102195122	53.6597317073
59.9695121951	65.0404146341	69.487804878	71.5563658537
NaN	NaN	80.6195121951	82.506097561
59.4880243902	60.9157560976	62.3577804878	63.6389512195
62.2977073171	68.7704878049	71.492097561	73.1631219512
47.3332682927	53.2483414634	55.7392439024	57.9872195122
NaN	NaN	72.1365853659	73.3829268293
NaN	NaN	NaN	73.1926829268
43.0436585366	38.7214634146	39.7315853659	45.7958780488
71.6817560976	75.582195122	78.0512195122	80.4414634146
NaN	NaN	NaN	NaN
70.4085365854	70.9326829268	73.0512195122	74.2073170732
71.1048780488	73.2048780488	75.412195122	78.5609756098
58.8907317073	56.7047560976	62.8342439024	66.2837804878
42.9156341463	44.5211707317	48.2957804878	50.2111707317
56.9700243902	61.5496097561	54.7763170732	51.0036585366
55.3832501702	58.524493481	61.8930822685	64.3000156951
NaN	NaN	NaN	NaN
75.3492682927	76.8375609756	78.9658536585	80.8731707317
68.2219268293	69.6786829268	70.9842926829	74.3120731707
NaN	NaN	NaN	NaN
68.9843902439	70.9086585366	71.1056097561	73.7232195122
NaN	NaN	NaN	NaN
65.6770243902	69.2184146341	70.3769512195	71.5154634146
48.0574681825	49.5602860405	49.8041519888	52.7242316322
48.0604554859	49.5623254911	49.8050219599	52.7264829284
49.2990487805	52.5306585366	56.974097561	60.1786097561
65.9350731707	67.4989268293	67.9352926829	69.4684146341
54.226195122	59.3440487805	48.6702195122	46.7695121951
75.7409756098	77.5368292683	79.643902439	80.9
75.4592682927	77.2424390244	79.6804878049	81.7414634146
66.2019512195	71.0647560976	74.0188780488	75.2587804878
62.2442682927	62.8568536585	63.7553414634	66.3237804878
50.4534390244	50.5971463415	50.3732926829	54.9425121951
65.4977804878	72.4709268293	72.5152195122	73.465902439
34.6581463415	45.785804878	56.1902439024	60.6236585366
49.6226829268	52.9919756098	54.8094878049	55.626195122
67.55	69.5823170732	70.7609268293	71.7380487805
67.2882926829	68.9447804878	68.3956097561	69.0661463415
62.1231707317	70.3073170732	72.6	74.2024390244
56.5696097561	63.0604634146	69.4468780488	72.8106585366
60.836195122	62.6627073171	63.8955121951	64.5983170732
NaN	NaN	NaN	NaN
NaN	NaN	NaN	NaN
50.0716097561	47.3567317073	46.0916829268	51.7296829268
68.8275121951	70.1365853659	67.8634146341	68.222195122
68.6840487805	72.1435365854	74.615902439	76.0384390244
73.6756097561	75.8804878049	77.7414634146	79.4487804878
73.6585365854	75.2146341463	76.6365853659	77.8390243902
65.8247853811	68.8283731209	70.5974499477	72.0862562661
70.2482195122	72.4846829268	74.8868292683	75.8551219512
65.2665121951	66.6821219512	66.9508780488	67.4112926829
58.5427073171	63.1968536585	67.555	69.9446585366
68.2224878049	71.0623658537	73.2695121951	73.5624390244
55.6710731707	65.4783658537	71.9455121951	74.1653414634
71.425195122	74.788	77.5756585366	78.7943902439
NaN	68.0477317073	70.9079512195	72.0935853659
62.947248386	65.4039840656	67.2266464816	68.8923973938
48.8352682927	56.0690243902	59.6898536585	63.6653414634
52.0180243902	47.4806341463	41.9298780488	46.1976341463
59.1740487805	60.5289268293	44.6179756098	45.7970731707    
  ];    
    
wbcodes=[   
'AFG'
'ALB'
'DZA'
'ASM'
'ADO'
'AGO'
'ATG'
'ARB'
'ARG'
'ARM'
'ABW'
'AUS'
'AUT'
'AZE'    
'BHS'
'BHR'
'BGD'
'BRB'
'BLR'
'BEL'
'BLZ'
'BEN'
'BMU'
'BTN'
'BOL'
'BIH'
'BWA'
'BRA'
'BRN'
'BGR'
'BFA'
'BDI'
'KHM'
'CMR'
'CAN'
'CPV'
'CYM'
'CAF'
'TCD'
'CHI'
'CHL'
'CHN'
'COL'
'COM'
'ZAR'
'COG'
'CRI'
'CIV'
'HRV'
'CUB'
'CUW'
'CYP'
'CZE'
'DNK'
'DJI'
'DMA'
'DOM'
'EAS'
'EAP'
'ECU'
'EGY'
'SLV'
'GNQ'
'ERI'
'EST'
'ETH'
'EMU'
'ECS'
'ECA'
'EUU'
'FRO'
'FJI'
'FIN'
'FRA'
'PYF'
'GAB'
'GMB'
'GEO'
'DEU'
'GHA'
'GIB'
'GRC'
'GRL'
'GRD'
'GUM'
'GTM'
'GIN'
'GNB'
'GUY'
'HTI'
'HPC'
'HIC'
'NOC'
'OEC'
'HND'
'HKG'
'HUN'
'ISL'
'IBT'
'IND'
'IDN'
'IRN'
'IRQ'
'IRL'
'IMY'
'ISR'
'ITA'
'JAM'
'JPN'
'JOR'
'KAZ'
'KEN'
'KIR'
'PRK'
'KOR'
'KSV'
'KWT'
'KGZ'
'LAO'
'LCN'
'LAC'
'LVA'
'LDC'
'LBN'
'LSO'
'LBR'
'LBY'
'LIE'
'LTU'
'LMY'
'LIC'
'LMC'
'LUX'
'MAC'
'MKD'
'MDG'
'MWI'
'MYS'
'MDV'
'MLI'
'MLT'
'MHL'
'MRT'
'MUS'
'MYT'
'MEX'
'FSM'
'MEA'
'MNA'
'MIC'
'MDA'
'MCO'
'MNG'
'MNE'
'MAR'
'MOZ'
'MMR'
'NAM'
'NPL'
'NLD'
'NCL'
'NZL'
'NIC'
'NER'
'NGA'
'NAC'
'MNP'
'NOR'
'OED'
'OMN'
'PAK'
'PLW'
'PAN'
'PNG'
'PRY'
'PER'
'PHL'
'POL'
'PRT'
'PRI'
'QAT'
'ROM'
'RUS'
'RWA'
'WSM'
'SMR'
'STP'
'SAU'
'SEN'
'SRB'
'SYC'
'SLE'
'SGP'
'SXM'
'SVK'
'SVN'
'SLB'
'SOM'
'ZAF'
'SAS'
'SSD'
'ESP'
'LKA'
'KNA'
'LCA'
'MAF'
'VCT'
'SSF'
'SSA'
'SDN'
'SUR'
'SWZ'
'SWE'
'CHE'
'SYR'
'TJK'
'TZA'
'THA'
'TMP'
'TGO'
'TON'
'TTO'
'TUN'
'TUR'
'TKM'
'TCA'
'TUV'
'UGA'
'UKR'
'ARE'
'GBR'
'USA'
'UMC'
'URY'
'UZB'
'VUT'
'VEN'
'VNM'
'VIR' 
'WBG'
'WLD'
'YEM'   
'ZMB'   
'ZWE' 
    ];

%Now we need to load pwt71 and put the incdist data in the proper order
%load pwt71;
load pwt80

[T,N]=size(rgdpe);
lifeWB=zeros(T,N)*NaN;
KeyYears=[1980 1990 2000 2007];

wb=mat2cell(wbcodes,ones(size(wbcodes,1),1),3);  % Make it a cell instead of strmat

for i=1:N;
  indx=find(ismember(wb,codes(i))==1);
  if ~isempty(indx);
    lifeWB(KeyYears-1949,i)=data(indx,:)';
  end;
end;

% % Fix for China Version 2 as well
% indx=find(ismember(wb,'CHN')==1);
% lifeWB(KeyYears-1949,CH2)=data(indx,:)';


y=rgdpe(2007-1949,:)'./pop(2007-1949,:)'/1000;

figure(1); figsetup;
plotname(log(y),lifeWB(2007-1949,:)',codes);
set(gca,'XTick',log([0.25 0.5 1 2 4 8 16 32 64]));
set(gca,'XTickLabel',strmat('0.25 0.5 1 2 4 8 16 32 64'));

chadfig('Per capita GDP (thousands)','Life Expectancy, 2007',1,0);
print LifeExpectancyWB80.eps

save LifeExpectancyWB80 lifeWB;


diary off;

