% WHOSurvivalRate2013     6/25/13
%
%  Reads in the data from the WHO-CumulativeSurvivalRates1990-2000-2011.xls


if exist('WHOSurvivalRate2013.log'); delete('WHOSurvivalRate2013.log'); end;
diary WHOSurvivalRate2013.log;
fprintf(['WHOSurvivalRate2013                 ' date]);
disp ' ';
disp ' ';
help WHOSurvivalRate2013

clear all;

% Here is the cumulative survival rate data, copied from
% WHO-CumulativeSurvivalRates1990-2000-2011.xls 


%Year	Age <1	Age 1-4	Age 5-9	Age 10-14	Age 15-19	Age 20-24	Age 25-29	Age 30-34	Age 35-39	Age 40-44	Age 45-49	Age 50-54	Age 55-59	Age 60-64	Age 65-69	Age 70-74	Age 75-79	Age 80-84	Age 85-89	Age 90-94	Age 95-99	Age 100+ 
data=[
1990	1	0.95120000	0.94200000	0.93979240	0.93737990	0.93127110	0.92230840	0.91219530	0.89966210	0.88398420	0.86275300	0.83349780	0.79423830	0.74016700	0.66974530	0.57655770	0.45481980	0.31637310	0.17994660	0.07418479	0.02140241	0.00428132
2000	1	0.96880000	0.96430000	0.96252880	0.96055450	0.95481110	0.94616300	0.93689630	0.92599350	0.91257660	0.89399300	0.86884530	0.83356490	0.78527170	0.71946640	0.62972910	0.51795820	0.38723920	0.25130790	0.12949640	0.04988997	0.01343545
2011	1	0.98610000	0.98440000	0.98319300	0.98151980	0.97572140	0.96757550	0.95945290	0.95020610	0.93906270	0.92405970	0.90371340	0.87403450	0.83301690	0.77558410	0.69551580	0.58988140	0.45693770	0.31577750	0.18057200	0.07990096	0.02500978
1990	1	0.96130000	0.95110000	0.94670930	0.94314210	0.93935270	0.93408580	0.92738070	0.91965210	0.91093310	0.89730810	0.87674230	0.84705780	0.80196580	0.73160560	0.62712020	0.49306570	0.33127570	0.17771040	0.06717990	0.01771857	0.00332772
2000	1	0.97120000	0.96500000	0.96268190	0.96072520	0.95727320	0.95159260	0.94602670	0.93994270	0.93164880	0.91945980	0.90409990	0.87784300	0.83454800	0.77030940	0.67395390	0.53515160	0.36601840	0.20281740	0.08408897	0.02035401	0.00389776
2011	1	0.98740000	0.98540000	0.98435720	0.98316600	0.98057240	0.97647880	0.97186920	0.96622730	0.96019010	0.95120660	0.93872170	0.91852910	0.88761020	0.83756450	0.75248870	0.62244250	0.46343160	0.27978330	0.13760610	0.03267366	0.00508029
1990	1	0.99270000	0.99120000	0.99028550	0.98934530	0.98656000	0.98177320	0.97647240	0.97037510	0.96221130	0.95109830	0.93463880	0.91047630	0.87537720	0.82660280	0.76264410	0.67564340	0.55040850	0.38361650	0.21062160	0.08323714	0.02181560
2000	1	0.99560000	0.99460000	0.99397120	0.99317800	0.99077800	0.98735090	0.98374450	0.97921460	0.97262850	0.96202810	0.94582890	0.92363130	0.89362410	0.85183020	0.79182170	0.70755050	0.59120110	0.43390300	0.26239630	0.11952720	0.03695423
2011	1	0.99660000	0.99590000	0.99547870	0.99500270	0.99347520	0.99113270	0.98837480	0.98508730	0.98011890	0.97245880	0.96008730	0.94027280	0.91232720	0.87601910	0.82797530	0.76130690	0.66287590	0.51352980	0.33064700	0.16029210	0.05268321
1990	1	0.99300000	0.99150000	0.99040870	0.98939480	0.98653900	0.98279700	0.97890160	0.97373300	0.96627160	0.95579950	0.93854660	0.91288900	0.87230770	0.81378160	0.73208980	0.61993990	0.46582560	0.28671870	0.12924870	0.04021757	0.00827378
2000	1	0.99560000	0.99460000	0.99403270	0.99339160	0.99115410	0.98810450	0.98523990	0.98175590	0.97643660	0.96729590	0.95286820	0.93162390	0.89963100	0.85332340	0.78242110	0.68140570	0.54837210	0.37807960	0.20406510	0.07935243	0.02049194
2011	1	0.99670000	0.99600000	0.99558050	0.99513730	0.99384230	0.99205990	0.98993630	0.98739230	0.98364990	0.97760810	0.96703230	0.94882140	0.92139030	0.88171980	0.82507590	0.74542590	0.62400080	0.45188300	0.25771070	0.10444360	0.02744507
1990	1	0.91900000	0.88580000	0.87203500	0.86460510	0.85415520	0.84052870	0.82689730	0.81264290	0.79534420	0.77329120	0.74043030	0.69422670	0.62782010	0.53544840	0.41858890	0.29229410	0.18146360	0.09350321	0.03591461	0.01019098	0.00209195
2000	1	0.93580000	0.91230000	0.90271770	0.89627660	0.88685000	0.87446840	0.86042380	0.84551820	0.82757910	0.80578160	0.77552670	0.73200910	0.66687380	0.58462260	0.46940090	0.34542890	0.21877580	0.12709680	0.06292584	0.02542007	0.00762235
2011	1	0.95280000	0.93870000	0.93289450	0.92867180	0.92196600	0.91269400	0.90303740	0.89099200	0.87541500	0.85591630	0.82941010	0.79080550	0.73784000	0.65340160	0.54378370	0.40124570	0.26511080	0.14846690	0.06407779	0.02074639	0.00482602
1990	1	0.94590000	0.91840000	0.91225230	0.90679730	0.89800520	0.88589590	0.87221650	0.85663090	0.83652800	0.80934600	0.77505270	0.72939980	0.66733760	0.58620710	0.47963860	0.35162390	0.22012330	0.10374890	0.03105062	0.00602914	0.00083623
2000	1	0.96240000	0.94750000	0.94336630	0.93939940	0.93269800	0.92324300	0.91265230	0.90027190	0.88398770	0.86186160	0.83015540	0.78405080	0.72382570	0.64445930	0.53933330	0.40900480	0.26035050	0.12544900	0.03867782	0.00777137	0.00111040
2011	1	0.97520000	0.96820000	0.96553660	0.96276140	0.95778770	0.95077050	0.94307540	0.93383200	0.92132310	0.90349940	0.87754420	0.84030050	0.78653660	0.71018400	0.61079260	0.48367580	0.33215280	0.18013640	0.06698587	0.01675137	0.00290175
1990	1	0.86640000	0.77300000	0.75525440	0.74401070	0.73064060	0.70854770	0.68240520	0.65454500	0.62279370	0.59251570	0.55621320	0.51694480	0.46965920	0.40864320	0.32826750	0.23196920	0.12347220	0.03840414	0.00369355	0.00008524	0.00000210
2000	1	0.90160000	0.83590000	0.82011460	0.81046140	0.79942480	0.77749360	0.72842090	0.66269660	0.59106240	0.53037300	0.47736800	0.43865700	0.39813200	0.35090150	0.29182060	0.21487160	0.12637360	0.05194167	0.01161067	0.00150511	0.00014364
2011	1	0.94710000	0.91740000	0.90382450	0.89380480	0.88541870	0.87235490	0.84555130	0.80888370	0.75496160	0.70088960	0.65081210	0.61114270	0.56927310	0.51920510	0.44601120	0.34257260	0.21566570	0.09627570	0.02393831	0.00339607	0.00034179
1990	1	0.96190000	0.95120000	0.94837010	0.94590700	0.94124740	0.93470010	0.92673230	0.91710270	0.90362690	0.88687880	0.86307030	0.83180920	0.78677460	0.72617320	0.64506090	0.54682620	0.42820760	0.30454980	0.18421540	0.08865715	0.03066799
2000	1	0.97590000	0.97090000	0.96940290	0.96774090	0.96421760	0.95905660	0.95278920	0.94532870	0.93530390	0.92190300	0.90232570	0.87415530	0.83314050	0.77400390	0.69225030	0.58584640	0.45834640	0.32768570	0.20102050	0.09895999	0.03518498
2011	1	0.98660000	0.98430000	0.98304860	0.98153180	0.97713360	0.97090170	0.96354050	0.95482120	0.94428910	0.93164110	0.91374620	0.88737900	0.84833110	0.79152510	0.71439560	0.60710810	0.47119370	0.32208400	0.17889980	0.07562757	0.02243708
1990	1	0.95179940	0.93769690	0.93551800	0.93321160	0.92729550	0.91584150	0.90079980	0.88242660	0.86061020	0.83153650	0.79648300	0.74595300	0.68680740	0.59621560	0.49114310	0.35096630	0.22345080	0.11492380	0.04236735	0.01118533	0.00213090
2000	1	0.94770000	0.92590000	0.92193410	0.91860800	0.90978050	0.88676710	0.84649130	0.79734690	0.74676310	0.69969190	0.65184830	0.59823140	0.54132820	0.46603510	0.37997930	0.26636120	0.16944500	0.08980152	0.03581971	0.01067426	0.00230654
2011	1	0.96540000	0.95330000	0.94934570	0.94518610	0.93666500	0.91620590	0.87930920	0.82964470	0.77287800	0.71538810	0.65606160	0.59698290	0.53050490	0.45864590	0.37376110	0.28480960	0.18916650	0.11011420	0.05197600	0.01920646	0.00517395
1990	1	0.99060000	0.98870000	0.98760520	0.98632030	0.98199620	0.97662080	0.97055340	0.96312930	0.95368650	0.94170220	0.92409840	0.89722130	0.85629370	0.79606670	0.71449810	0.60654850	0.47630860	0.32754580	0.17349100	0.06833412	0.01813171
2000	1	0.99290000	0.99150000	0.99071540	0.98971200	0.98639670	0.98179010	0.97731990	0.97190860	0.96420180	0.95274130	0.93609090	0.91256410	0.87709640	0.82430040	0.74928650	0.64699240	0.51745810	0.36111370	0.19371140	0.07690555	0.02048851
2011	1	0.99360000	0.99250000	0.99189580	0.99113320	0.98835040	0.98385980	0.97924040	0.97408240	0.96744830	0.95744840	0.94198590	0.91920480	0.88753310	0.84262160	0.77869360	0.68922510	0.56899790	0.41675540	0.24083840	0.10440740	0.03060960
1990	1	0.99160000	0.99030000	0.98947030	0.98851390	0.98578630	0.98228200	0.97805230	0.97351090	0.96797980	0.96013200	0.94767540	0.92800520	0.89496670	0.84373120	0.76871510	0.66117330	0.51485330	0.33390790	0.15867470	0.05147586	0.01078735
2000	1	0.99520000	0.99440000	0.99377710	0.99301270	0.99096390	0.98800220	0.98479690	0.98134220	0.97656410	0.96987990	0.95970910	0.94308340	0.91771090	0.87840190	0.81748060	0.72378000	0.59287430	0.41036980	0.21213570	0.07515512	0.01697479
2011	1	0.99680000	0.99630000	0.99589940	0.99539620	0.99401690	0.99205430	0.99005700	0.98777180	0.98473280	0.97982710	0.97184720	0.95906730	0.93943020	0.90872550	0.86192090	0.79088180	0.67995060	0.51195510	0.30642770	0.13251500	0.03744248
1990	1	0.97700000	0.97270000	0.97010810	0.96796300	0.96248680	0.95442630	0.94466720	0.93205920	0.91564410	0.89316020	0.85996610	0.81660910	0.75675180	0.67798580	0.58474410	0.46496410	0.32830020	0.19460250	0.08684677	0.02777501	0.00616873
2000	1	0.98219540	0.97867580	0.97626950	0.97394080	0.96627400	0.95095160	0.93307840	0.91239080	0.88637000	0.85184110	0.80562630	0.74580630	0.67054720	0.58268760	0.47898590	0.36379360	0.25156820	0.14546810	0.06301672	0.01960247	0.00425079
2011	1	0.99020000	0.98810000	0.98639090	0.98461480	0.98008400	0.97170700	0.95813140	0.93832180	0.91647450	0.89055200	0.85777250	0.81134150	0.74699420	0.65897620	0.56448450	0.44323040	0.30856460	0.17726540	0.07468794	0.02197406	0.00443548
1990	1	0.99070000	0.98910000	0.98792930	0.98668270	0.98343120	0.97845480	0.97273840	0.96664270	0.95989380	0.95062810	0.93715360	0.91607510	0.88487380	0.83859620	0.76849360	0.66825340	0.52704580	0.34515220	0.16755160	0.05552676	0.01197113
2000	1	0.99450000	0.99340000	0.99263060	0.99178640	0.98951320	0.98645220	0.98302610	0.97859190	0.97233920	0.96346620	0.95110540	0.93279730	0.90649220	0.86694950	0.80752330	0.71954380	0.59052070	0.41746420	0.23000210	0.08972653	0.02283112
2011	1	0.99650000	0.99580000	0.99537800	0.99485540	0.99370790	0.99208240	0.98983990	0.98750340	0.98407160	0.97797190	0.96788860	0.95211410	0.92904730	0.89661050	0.85156640	0.77890140	0.66871090	0.50671900	0.31237200	0.14258520	0.04343132
1990	1	0.99220000	0.99080000	0.98994780	0.98896580	0.98640550	0.98325020	0.97992020	0.97613440	0.97050410	0.96217700	0.94817350	0.92501360	0.88619320	0.82276020	0.72835700	0.60492960	0.45454970	0.28672290	0.13951230	0.04950486	0.01183085
2000	1	0.99440000	0.99340000	0.99283870	0.99215660	0.99012250	0.98726650	0.98397960	0.98007090	0.97475710	0.96691190	0.95453880	0.93538410	0.90503490	0.85698470	0.78281130	0.67173990	0.52546540	0.35094060	0.18515690	0.07234362	0.01914448
2011	1	0.99560000	0.99490000	0.99443750	0.99393200	0.99247840	0.99041130	0.98798880	0.98448370	0.97950660	0.97232470	0.96190420	0.94559800	0.92033270	0.88284280	0.82683870	0.74223640	0.62072870	0.44815160	0.25661410	0.10698600	0.02952578
   ];

% Create a list of country names and indexes
% Brazil=1, China=2, and so on
survivalctys=strmat('Brazil China France Germany India Indonesia Malawi Mexico SouthAfrica US Italy Russia Spain UK');
%survivalctys=strmat('BRA CHN FRA GER IND IDN MWI MEX ZAF USA ITA RUS ESP GBR');
for i=1:size(survivalctys,1);
  eval([survivalctys(i,:) '=i;']);
end;


% Now create a 3-dimensional array of the survival rate data
%   Rows = Ages  Cols=[1990 2000 2011]  3rd Dimension=Country
% Example: the 2000 survival rate by age for China = survivaldata(:,2,CHN)

[blah N]=size(data);
survivaldata=zeros(N-2,3);

for i=1:size(survivalctys,1);
  beg=(i-1)*3+1; fin=beg+2;
  survivaldata(:,:,i)=[data(beg:fin,3:N)'];
end;
  
survivalyears=[1990 2000 2011]
survivalages=[1 5:5:100];
clear i data beg fin blah N
save WHOSurvivalRate2013;


diary off;
