% WBAdultPopulation80.m
%
%  6/4/13 -- pwt80
%  1/29/13 -- pwt71
%  3/1/12 -- Updated for pwt70
%
%  Read in the World Bank % of population ages 0-14 and
%  combine with PWT data to get adult population numbers
%  in every year 1960-2008


if exist('WBAdultPopulation80.m.log'); delete('WBAdultPopulation80.m.log'); end;
diary WBAdultPopulation80.m.log;
fprintf(['WBAdultPopulation80.m                 ' date]);
disp ' ';
disp ' ';
help WBAdultPopulation80.m

% Copied from WBPopulation0-14.xls
data=[
%Country Code	YR1960	YR1961	YR1962	YR1963	YR1964	YR1965	YR1966	YR1967	YR1968	YR1969	YR1970	YR1971	YR1972	YR1973	YR1974	YR1975	YR1976	YR1977	YR1978	YR1979	YR1980	YR1981	YR1982	YR1983	YR1984	YR1985	YR1986	YR1987	YR1988	YR1989	YR1990	YR1991	YR1992	YR1993	YR1994	YR1995	YR1996	YR1997	YR1998	YR1999	YR2000	YR2001	YR2002	YR2003	YR2004	YR2005	YR2006	YR2007	YR2008
	43.0698727469759	43.0727498140443	43.060592337578	43.0524032468616	43.0724002171346	43.1354598050038	43.2449417859233	43.3916040142728	43.5616160086181	43.7362035845962	43.9017565351369	44.0542165692074	44.1960496019978	44.3285702441114	44.4552321564899	44.5785896766717	44.6997140561714	44.8171963056098	44.929397278157	45.0351480565175	45.1353067649367	45.23368521122	45.3341003715226	45.4370620463265	45.5406339010718	45.6422722482884	45.7363460270818	45.8239694399562	45.9147480313931	46.0202521131396	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	41.098558580374	41.5578872595054	42.0080989626671	42.4130663558112	42.7313851741786	42.937053662627	43.0220416245883	42.9950378059876	42.8677375704302	42.6573943709315	42.3761202360556	42.0402458504063	41.6490194827587	41.1809312296504	40.6074781681943	39.9195518495702	39.1064001959048	38.2023703910447	37.2943307974165	36.4895630814717	35.8548272376745	35.4164204902	35.1385836614428	34.9510486349346	34.7603891775516	34.5064059863596	34.1750040957816	33.7972780668274	33.4113989092516	33.0631441763571	32.776183977847	32.5433042030036	32.3422209993707	32.1607682786874	31.9849301428976	31.8024136508264	31.6207540487459	31.4340778137661	31.2006076161406	30.8649105576648	30.3900564488472	29.7614668736571	29.0022920532942	28.1594771436634	27.2970279583745	26.4626296261886	25.6723550340818	24.9221058492122	24.2147096550882
	43.7592714146124	44.3183095302883	44.8830608377671	45.4476656891557	46.0042867795639	46.5402963565968	47.0506386381976	47.5198226242101	47.9152110404119	48.2015630055696	48.3600248621727	48.3929244953034	48.3167667192899	48.1476786756837	47.9064359504964	47.6122089668785	47.2648461037236	46.8749350031735	46.4809202300689	46.1268118561101	45.8374111340679	45.6175957088254	45.4478970066256	45.2976630836746	45.1279810113312	44.911652953027	44.6416820397355	44.3210127022976	43.9463315005602	43.516544882925	43.0300585206812	42.4947219637321	41.9076389072338	41.2465585455599	40.4827197848481	39.6013400321971	38.5965566823143	37.4899446071159	36.3281314958388	35.1741194928502	34.0759902935988	33.0531545776892	32.1026986721511	31.223411842322	30.4066087614752	29.6478522675789	28.9437376341683	28.3038198281939	27.7493176488153
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	43.7526650750212	44.0875712097913	44.4392407477879	44.7856350467809	45.0985055819028	45.3592250150714	45.56356796155	45.7194141403481	45.8358010638673	45.9260386797244	46.0004474586992	46.0610551460488	46.1083248738319	46.1483823413703	46.1878489433452	46.2314908330348	46.2816314370764	46.3386513673084	46.4025029882131	46.4722408346831	46.5469587232194	46.6247040700692	46.7052485746586	46.7908954116503	46.8850639430711	46.9892565304755	47.1022917592416	47.2203345700445	47.3384202362144	47.4495864991218	47.5472496262238	47.6306862085908	47.6973823841994	47.7381595261687	47.7431814660326	47.7075644237228	47.6274276477632	47.5075046632515	47.361711667057	47.2085744339971	47.0599287735062	46.923365691039	46.7922634793689	46.6485190066307	46.4685924123409	46.2393371264628	45.955198717499	45.6284233939606	45.2844220787635
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	30.5797273597428	30.5167192801798	30.4300882529115	30.3220188814506	30.1958747881798	30.0555135321674	29.9042911080472	29.7465091505255	29.5886686312599	29.4383656490368	29.3030769694819	29.1798148278358	29.0729296214957	29.0040317322403	28.9993280986638	29.072889200671	29.2299123095709	29.4543652654549	29.7129994104572	29.9627869861483	30.1734039208343	30.3341812963565	30.4507246608365	30.5294053232432	30.5820178080376	30.6154752621893	30.6338319925952	30.6301517340228	30.5884506898979	30.4882478154261	30.3184795067511	30.0732907789763	29.7656166386574	29.425579029407	29.0925650432731	28.7931294454446	28.5370455206705	28.3147093270705	28.1092378460424	27.8957895185721	27.6575062357318	27.3913157306125	27.105014915544	26.8061307193826	26.5061278993767	26.2137330076424	25.9311719646297	25.6570199587663	25.3920036719422
	38.4340011438388	39.5079408490884	40.4116034102998	41.1011636241395	41.537200194188	41.7023110244256	41.5964925808832	41.2450350999411	40.6901430448244	39.9858897421357	39.1772897798927	38.2863366618983	37.3283646060269	36.3327843452652	35.3283508501019	34.3407003698264	33.3717793377413	32.4389707649152	31.5956711857915	30.9054988151017	30.4066985800462	30.1116124360514	29.993673423367	30.00306864756	30.0721379929602	30.150185062233	30.2211209617396	30.2869296906119	30.3377501648656	30.3679411795423	30.3707653267771	30.3432829573763	30.2723517732141	30.1289139793145	29.8763247017522	29.4891456203507	28.9577589997967	28.2953592797179	27.5325758070415	26.7111027124346	25.8659586040885	25.0117683518599	24.1624079548087	23.3474892686681	22.5977548170318	21.9363279688736	21.3683856844943	20.8968670289616	20.537300899163
	43.9203332994614	43.7686582016479	43.578187493903	43.3104187809969	42.9345984412064	42.433234421365	41.7984768599883	41.0423983489627	40.1688716790362	39.1898374344852	38.1127688432474	36.9487381014759	35.7069858481578	34.4297228093692	33.1496425707608	31.8956309445094	30.6784063691259	29.5090777783376	28.417109795659	27.4383352170733	26.6033880429767	25.9244189831391	25.393290826952	25.0157728706625	24.7800174737893	24.6634959122136	24.6764613941857	24.8009245333798	24.9671337416231	25.0654628990024	25.0233264276564	24.8107563640803	24.4758187384825	24.0971784255121	23.7489761691174	23.4757501462334	23.2684946676617	23.0990310395796	22.942061786974	22.7627072819034	22.547624562913	22.2935087340953	22.0082183120851	21.6977537000608	21.3605744020007	21.0004354883408	20.6196810064461	20.2165649118765	19.7997269003186
	30.1018160608217	30.1065021008953	30.0414291620792	29.9274862439556	29.7904394835117	29.6478590391483	29.5027389605788	29.3508003930388	29.1915986498656	29.0225080663388	28.8400267057144	28.6497461457603	28.4493320746445	28.2194500726337	27.9358634480249	27.5857394326268	27.1636807464703	26.6848114754087	26.1816231438507	25.6952587406887	25.252834977254	24.8657110628813	24.5247345398051	24.2113698552619	23.8992511276008	23.5725182819797	23.2253127660319	22.8699742287863	22.5296220588959	22.233799082842	21.9998595772691	21.8322541659963	21.7179131978197	21.6349114406656	21.5538796070363	21.4539460575852	21.3302417882517	21.187888488821	21.0291001762802	20.8590566406709	20.6820418157987	20.4984394492875	20.3080450145582	20.1139965972245	19.9198401288322	19.728500757033	19.5404346061285	19.3569619315962	19.182653931708
	22.0290448147667	22.1817214761385	22.4086652863451	22.6898547847175	22.9973166452748	23.3070790305193	23.6154778978599	23.9151786612601	24.1745602604277	24.3555839389588	24.431375259379	24.3936566417685	24.2487047045174	24.0034222264603	23.6707566394617	23.2633168208265	22.7809698592348	22.2299941787327	21.6383233627901	21.0430532679878	20.4741470098948	19.9453472238055	19.4594542999833	19.0222850236917	18.6357570305327	18.3012349428629	18.0196771668177	17.7934137744013	17.6253048285794	17.5178979853483	17.4693791666868	17.4828879872563	17.5471407268444	17.6289764806412	17.6862214554174	17.6895225882678	17.6262153216579	17.5030765891947	17.3350678652757	17.1472284070338	16.9586613484658	16.7759380934574	16.5938691222704	16.4064523464894	16.2034423121134	15.9786168516924	15.7298145412261	15.4645701860395	15.1978338310964
	38.3659083824497	39.8680494551278	41.2294419874521	42.4031559226888	43.3515563090852	44.0552410099464	44.5105617316213	44.7272329449236	44.7206016507011	44.5120914859591	44.1221020409505	43.5696540963865	42.8698126880322	42.0364399191924	41.0834379505553	40.0315732281103	38.8886775993995	37.6885423159522	36.5072987902756	35.4371255609115	34.5435810263514	33.8382645670509	33.3086804008086	32.9601117281431	32.7907827944155	32.7890777884938	32.9559033287992	33.264518570612	33.6418393125239	33.9967288580012	34.2627499898776	34.4188094690148	34.4704237557302	34.4136078191347	34.2518421664236	33.9881006446351	33.6237378840298	33.1567071256295	32.5850099585415	31.908157660896	31.1332476585657	30.2637769045146	29.3207390548929	28.3523226612668	27.4195572222252	26.5699898437283	25.8169455444594	25.1616721942826	24.6212459193499
	42.4856809310131	42.9297572992384	43.3415480478377	43.6921727004223	43.9547407363208	44.1176051826013	44.1868226928133	44.1699114119215	44.066305010592	43.8757355129007	43.6009520218682	43.2382319173364	42.7986681564748	42.2964284141454	41.7588827141492	41.2060301507538	40.6475977050847	40.0828901857411	39.516942791671	38.953035933153	38.3934053277109	37.8474663884918	37.3179210767317	36.7871697238298	36.2358961819262	35.6501416794364	35.0198066800812	34.3583649013345	33.711145805876	33.1395557326427	32.6791939061748	32.346020229938	32.1144883561592	31.932134063281	31.7322352719621	31.4680291991566	31.1261193586595	30.7237732685582	30.2859306693354	29.8479783720435	29.4328963426637	29.0474619256499	28.6786226090509	28.3096204254461	27.9180095317497	27.4882026200015	27.0188832684471	26.5202064711066	26.0072023407607
	43.0677974787332	44.6503070504695	46.6745633264974	48.6789237263267	50.1442140874393	50.7957032027054	50.5572580768117	49.6146912577508	48.279094036254	46.9755742059854	45.9791316545747	45.3923880538027	45.0674395743945	44.7476334958811	44.1136524986881	43.0090682434967	41.4402378246044	39.5958596038986	37.7035774051972	36.012426174436	34.6544782807921	33.6181380808798	32.82729808739	32.2499709005316	31.8434426208998	31.5750779328508	31.4398804380823	31.4206375502347	31.4586895330575	31.4878202435951	31.4639153507847	31.3847746550122	31.2570751362882	31.0648383584882	30.7917778897676	30.433570888243	29.9753433713808	29.4353550885211	28.8826741929567	28.4029115214682	28.0500975366609	27.8401212715466	27.7398518832118	27.6942885307904	27.6306804290584	27.4992715497573	27.2929749126117	27.028051803744	26.7130317283492
	42.3695210928089	42.7307829093295	43.0998443181614	43.4514022555135	43.7543475838201	43.9901615103418	44.1530695082556	44.2560035552449	44.32217479002	44.3816972640649	44.4544159264524	44.5425533357332	44.6386175445886	44.7393518159451	44.8391670639061	44.9331481527421	45.0185547367227	45.0933015371935	45.1536107889278	45.1954426115034	45.2144394999069	45.2091770904534	45.1752587392239	45.1026015538674	44.9796175527575	44.7987396141099	44.5601038821957	44.2663809844406	43.9168368297062	43.5112848641843	43.0513897471301	42.5394652452121	41.9808364560519	41.3842874635908	40.760511083905	40.1187465258813	39.461922932745	38.7937843748974	38.124524530196	37.4653114039485	36.8233836831638	36.20314320245	35.6026238867429	35.014534734923	34.4283885738892	33.8372270499872	33.2400492428126	32.6405308507477	32.0423329158691
	38.1077073813632	38.5458175940253	38.8527271944552	39.0323451636545	39.1007668574209	39.0684523809524	38.9503090318697	38.7357711888774	38.3832461616332	37.835519316409	37.0666510297339	36.0528059406683	34.8427047737393	33.5695881592703	32.40517206105	31.4647186490922	30.7940410408705	30.3495128346227	30.0456632065988	29.7565003726008	29.3905960695796	28.9318344625556	28.411491339248	27.843796993227	27.2586543245954	26.6769898288032	26.0937921648227	25.5048627948519	24.9414991709154	24.4389200707189	24.0202874439669	23.6961464332291	23.4515793928668	23.2535203128311	23.0521750213389	22.8117368890267	22.522024287083	22.1897095403177	21.8163978611143	21.4088824465936	20.976253298153	20.5199517767406	20.0430271723354	19.5629395608757	19.0991040923541	18.6652767412567	18.2665721375399	17.9013121709751	17.5743825455229
	28.8617370976285	29.4755129183579	29.9777430494894	30.3505389986086	30.582342320183	30.6670277679699	30.598154402841	30.3787529194338	30.0265865707674	29.566631195866	29.0214185448027	28.4003126805023	27.7145675399253	26.9911995904845	26.2621778249857	25.5550440674521	24.8760435976831	24.2348516488848	23.6647342301279	23.2045750436666	22.8787492881917	22.6981122664885	22.6475016887899	22.6916713570571	22.781195030423	22.8770246905962	22.968851598662	23.054536582041	23.1136990788602	23.1249416827184	23.0721755996764	22.9475780514238	22.7492220528791	22.4756205452092	22.1282425912681	21.7099445633557	21.2213892391663	20.6667333350981	20.0585908510299	19.4146564425521	18.7526452106903	18.0769027787384	17.3977928368889	16.746852062662	16.162893347475	15.6743634143593	15.2950507640192	15.0210372883545	14.8398047825325
	23.505788056004	23.6834453918446	23.779228392002	23.8134672162744	23.8174689015914	23.8131284941324	23.8046598611408	23.782634338187	23.7386367674386	23.6598755395783	23.5372315161914	23.3737683166915	23.1740485386016	22.9329317486623	22.6438490843284	22.3048570431687	21.9113421571319	21.4727921582314	21.0182611027941	20.5865132842035	20.2053005483052	19.8877294433067	19.6271156199437	19.4071366039822	19.2019820496006	18.9937817342787	18.7769999730388	18.5603381132738	18.3567285502662	18.1845922627084	18.0556032358625	17.9737807071353	17.9307433978675	17.9105470377122	17.8911400671416	17.8565382968843	17.8014522852164	17.7296676967504	17.6453817564081	17.5564387918893	17.4687783709245	17.3831544875959	17.2978993000264	17.2141231227955	17.1328258663229	17.0549715335057	16.9812254106243	16.9124858414992	16.8500878816601
	45.6080243920833	46.0012146088122	46.399951123647	46.7683470337724	47.0575206325055	47.2437997192326	47.3191968951947	47.3066944351295	47.2423727941555	47.1742851179295	47.1356947784617	47.1280790536549	47.1386721809694	47.1519231065449	47.1417628008222	47.0911973200132	46.9984278006186	46.8708068374074	46.7014138854494	46.49918124012	46.2662382820106	46.0067934782609	45.7276063882551	45.4359191747916	45.1385814497272	44.8360660702496	44.5242147791723	44.2042355206161	43.904573939029	43.6574204602138	43.4786273456185	43.3762235473412	43.3266344126039	43.2754478621533	43.1561582892499	42.928935254542	42.5844839153925	42.1455938697318	41.6394416394417	41.1069256233387	40.5739595095342	40.0481923970867	39.5195670874276	38.9795170148391	38.4111787432966	37.8071719808851	37.1685343392877	36.5049400740162	35.8324130865741
	37.8260380975465	38.1579272669704	38.5430723431116	38.9664503661019	39.4067484614628	39.8478070872718	40.2857677367861	40.7211132982674	41.147718227219	41.5597140708471	41.9528385496118	42.3242319693756	42.6728337232479	42.9976808216904	43.2986568612767	43.5756534963304	43.8286199988466	44.0577099565607	44.2641347466224	44.4491700372632	44.6145068981616	44.7573044490773	44.8783044127225	44.9859359358071	45.090212154843	45.1957105442167	45.3100026367561	45.4259792921439	45.518459208156	45.5563133753762	45.5235023841064	45.4123814432429	45.2424171914931	45.0546890959022	44.8977736899501	44.7984204916744	44.764487303192	44.7758594255942	44.7970625044486	44.7831204940534	44.7068631969187	44.5639684983696	44.3718817342169	44.1525531645688	43.9334860125113	43.731959297506	43.5484795664678	43.3758287876529	43.2121216039366
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	41.689993705048	41.6995591607953	41.7034234723306	41.7109449241829	41.7367273546425	41.7901394009126	41.8760915140608	41.982523453614	42.0754168803825	42.1171679829331	42.0859382086073	41.9784665959909	41.8181818181818	41.6428915372577	41.4965355289479	41.4096891673957	41.379961275221	41.3957957394952	41.4562674178857	41.5569849265835	41.6934457185857	41.8705075736464	42.0817489639798	42.2971585073605	42.4785311773943	42.6017744759972	42.6443349198296	42.6213986729113	42.5876244213126	42.6117919841007	42.7307051718923	42.9637077573387	43.2817741334327	43.6090440755581	43.8199140537836	43.8046373563727	43.5385022181743	43.0508324101487	42.3529411764706	41.4648954825266	40.4125272864971	39.2038154329282	37.8827945637055	36.5364057874951	35.2577287041349	34.0990614598385	33.0633391820352	32.1284297004776	31.2894682048437
	42.7189966899648	42.7955356832778	42.8370076544352	42.8545110400937	42.8633421387826	42.8739893306938	42.8863225479737	42.8973981700396	42.910414318094	42.9286017545728	42.9528255791923	42.9851956818711	43.0218069803865	43.0507491772157	43.057211241291	43.0321480355612	42.972743013081	42.8841143291844	42.7751723706511	42.657491041179	42.5386467075639	42.4229678626858	42.3075548138957	42.1842388177538	42.0422841599693	41.8764936906473	41.682385200038	41.4679217575122	41.254231294724	41.0676426330048	40.9236351512528	40.8263414879959	40.7634094474903	40.7134503708949	40.6488348033035	40.5507241806787	40.4135114498927	40.2422092331858	40.0421673892743	39.8221319497924	39.5874128976572	39.3410049320786	39.0787400720279	38.7907727104603	38.4645473646214	38.0932518207784	37.6742481980905	37.2154744162289	36.7332008611825
	38.6013609977296	38.7501046385088	38.7731128305447	38.6626443326571	38.4172498998363	38.0402555410108	37.5235021135151	36.8748535906215	36.134063214509	35.3545858550842	34.5768474139179	33.819367107912	33.079410381833	32.3501253728939	31.6155503299868	30.8664626516069	30.1038524492165	29.341510863695	28.598132105273	27.8984165463173	27.2614006204617	26.6918107077053	26.1859853056815	25.7458560513548	25.3732657181758	25.0679651930867	24.8325493459089	24.6587848344869	24.5185449317065	24.3730062428599	24.1885994588458	23.9404382011581	23.6103529689469	23.1838941212781	22.6758203399064	22.130365535726	21.6072842270976	21.1346888494237	20.7013678350863	20.2542081320056	19.7472477906247	19.1530202323473	18.4889020243117	17.7986973010537	17.1557861123995	16.6173887425243	16.2047321054569	15.8949441418332	15.6538166637027
	45.6102710152286	46.3148043541889	47.0039997599052	47.6195541373044	48.0936204295396	48.3885321655495	48.4939218405809	48.4402126392356	48.2823841043322	48.0910106501825	47.9124295783288	47.759257006124	47.621950310946	47.4954537289911	47.3705489825793	47.2423837235619	47.1063866412155	46.9695765784378	46.8494602508632	46.7655785100917	46.7249919039725	46.7263755165603	46.7506143846147	46.765334063024	46.7329626309199	46.627494470137	46.4483060111115	46.2013597136456	45.879549788119	45.4767148550918	44.9924866768916	44.4310850503109	43.8033461141641	43.1259228756278	42.4174787220104	41.6929804978702	40.9553710888295	40.2094153186345	39.4715139832231	38.7585995862511	38.0807800510173	37.4422325428203	36.8391024812631	36.2644261326256	35.709898864825	35.1727794241592	34.6541321975021	34.1608253959866	33.701850428109
	43.2747811277411	43.4650529813368	43.6186615790061	43.7180777919577	43.744487229562	43.6877217290187	43.5458705721235	43.3277919346271	43.048075259917	42.7256469304392	42.3746955728652	42.0033985972566	41.6128196309732	41.20202976205	40.7682225978726	40.3130341510802	39.8338008463605	39.34130896486	38.8646949343167	38.4390772019633	38.0846128597564	37.8057973308998	37.5859446704027	37.3972169127232	37.2034402305172	36.9786063485593	36.7192090636705	36.4285169792862	36.0976226413471	35.7179817421413	35.2853813371	34.798678957717	34.2632741228704	33.6906898673574	33.0966227257629	32.4946391594379	31.8866799819638	31.2765306215275	30.6808037818938	30.1185254817058	29.6014466461891	29.133562850284	28.7084107017999	28.3133713354657	27.9306682928583	27.5463022004386	27.1585392686909	26.7670178510156	26.3614670028978
	43.520782396088	44.3727163419446	45.2142267074505	45.9117951785352	46.3123167904236	46.3405592086008	46.0018245457253	45.3818362582443	44.5986779181867	43.7848225965343	43.0230227143055	42.32863891284	41.6877036117732	41.1022930667657	40.5776355675312	40.1131875991169	39.7007305379198	39.3363020240027	39.024958273493	38.7741880213743	38.5793770851897	38.4517250212206	38.3687126858391	38.2605108166807	38.0423353624792	37.6676546952283	37.1194915365066	36.440444563085	35.7124325125709	35.0401280896628	34.4870388096405	34.0648241320088	33.741875443701	33.4804993148553	33.2320172689924	32.9622120815563	32.6669353400149	32.3549967310052	32.0191936046457	31.6551243774988	31.2599896242852	30.8317542634886	30.3729568922939	29.88804815617	29.3876853441979	28.8779301492941	28.3627683193709	27.8439504017129	27.3274191903742
	26.0581913733913	25.7553153782264	25.3784845136197	24.9604955525069	24.5461970544804	24.1680404724714	23.8371307327726	23.5467600862938	23.2897024632131	23.0525187470433	22.8265806568341	22.6068262340248	22.399561020706	22.2198296770226	22.0877503182072	22.0145135038379	22.0078792726653	22.0549668261239	22.1211271311285	22.1595604062785	22.1373585798218	22.0385381114903	21.8733062026634	21.6666621914266	21.4559072474955	21.2658852819015	21.1071171979365	20.9658351079502	20.8134016898341	20.608420498604	20.3216949023774	19.9393391633434	19.4724742911292	18.9480203983202	18.4095487101211	17.8924527416813	17.4145822938062	16.9717521705055	16.5527216067828	16.135327142657	15.705042372839	15.2577547885103	14.808112322121	14.3818684665106	14.0143348790956	13.7311870749003	13.5408959132045	13.4359423753985	13.4061040874577
	40.465157956191	40.6583826350193	40.9091403598045	41.2057264764374	41.5320242510407	41.8745414024865	42.2314828454509	42.5997201466674	42.9638198125877	43.306573983778	43.6175763584747	43.8901167634956	44.1297964790028	44.3535078735872	44.5838759909751	44.8349261708782	45.1081492985903	45.394728046248	45.6850726888324	45.9664928780424	46.2295702601481	46.4735210281043	46.6985122511271	46.8979902126407	47.0645319743509	47.1939749008719	47.2841995484577	47.3388477234047	47.3664897458874	47.3782024158684	47.3813258143555	47.3766952635478	47.3621656525966	47.3377791626413	47.3029792953894	47.2568088774609	47.2079836004888	47.156310783203	47.0841799893	46.9698391178972	46.8047400878114	46.5803305425475	46.316898191436	46.0660086855991	45.8894082109129	45.8210489975327	45.8656570716806	45.9934918029391	46.1609128914088
	44.0091630706217	44.2630148190916	44.5241604047552	44.7591270837542	44.9239746950048	44.9940956143207	44.9531394349866	44.8250744131788	44.6724038784154	44.574339480854	44.5794791518429	44.7088232336335	44.9342553976542	45.194715362416	45.402871557952	45.4977596191285	45.4689437250425	45.345452887882	45.1560315886615	44.9412537680689	44.733688668539	44.534564872276	44.3476377732009	44.2046023823457	44.1397782030139	44.1706285139173	44.2953008178102	44.4953467721608	44.7493493245936	45.0316491734289	45.3225852443244	45.6099039130714	45.8869468442592	46.1465845085292	46.3825021287985	46.5832806738725	46.7595544305978	46.8921857076195	46.9065716776198	46.7080948133428	46.2431144596425	45.5060083786426	44.5569863818623	43.4913917597879	42.4226862492378	41.4286874084202	40.521373669016	39.6951486115752	38.9739087937918
	42.4934653045494	42.548517625577	42.6015138309161	42.6606773177742	42.7364434350891	42.8322253347931	42.9529895068495	43.0866918274357	43.2019428425242	43.2609983188779	43.2415931055596	43.1437901665639	42.9824004281072	42.7695108254588	42.5216126800928	42.2539237510214	41.9556414868807	41.6325983970223	41.3439097103604	41.1788646398239	41.2034413423452	41.445572153631	41.8604132340291	42.3582980634155	42.8389806616755	43.2480684927397	43.5528981291313	43.7760901013198	43.9849207437655	44.2632869403025	44.6476184421906	45.1586637405316	45.7308324777175	46.2196751201337	46.4518878024242	46.3278797109448	45.8278438681433	45.0219067232498	44.0134530923233	42.9382405352474	41.8897662355657	40.8930011468761	39.9252196100821	38.9733682348527	38.0130799894481	37.0338606139556	36.0408682425878	35.0599860009626	34.1255707403519
	40.5861622180954	40.7458167238363	40.9278404196232	41.1227432596541	41.3181709999469	41.5063007984198	41.6837241452822	41.8543748353581	42.0267835471881	42.2121376397997	42.4168478877556	42.6416248743809	42.8806218144694	43.1249918086866	43.3634875782484	43.5884058348798	43.7956047649509	43.9867854359804	44.1671112158622	44.3440224139975	44.5213293724544	44.6983573308838	44.8694437248728	45.0272775122699	45.1626208033531	45.2688554928608	45.3433617219924	45.3864881685176	45.3984192563787	45.3802385454131	45.3322916677737	45.259302387346	45.1603066087619	45.0247961346787	44.8396476244569	44.5993899563005	44.3025707366019	43.9611268360301	43.5987410377511	43.2449106565337	42.9197433720153	42.6286529291495	42.3662534485797	42.1276262175099	41.9045295058935	41.6911308265696	41.4838808832979	41.2838948035203	41.0946539854492
	33.5417777722933	33.6916810161796	33.7900247759643	33.7989269994428	33.6709229309356	33.3791306588244	32.9199632256645	32.3200190655816	31.6199687182883	30.8692128296658	30.1014028044116	29.327035983968	28.5435816574772	27.7544242074349	26.9620950298813	26.1734284343387	25.392000740004	24.6307342369848	23.9161729225019	23.2790814295656	22.7387298650607	22.3029731710123	21.9625826574438	21.6980965925091	21.482207056924	21.2947557729125	21.1276629280934	20.9826204089595	20.8605748965907	20.7648413976912	20.6947049358117	20.649914030376	20.6200719559475	20.5828232187216	20.5104966236684	20.3846537646527	20.1982047982621	19.9583440221471	19.6792882662694	19.3821908830107	19.0831771968321	18.7882090071226	18.4956596872116	18.2051294447869	17.9138165998478	17.6210042589418	17.3271026960403	17.0380296361491	16.7646296101141
	43.1823621983081	43.7395890485441	44.170413269933	44.5378229512471	44.918791828188	45.3554657638965	45.8629859440294	46.4019497165494	46.902260677612	47.2813845517368	47.4931624892286	47.5324014122699	47.4320473476545	47.2339652792911	47.0033268243292	46.7841435060214	46.596523133762	46.4336047604134	46.2839759602305	46.1328200192493	45.9724373513304	45.7893267417077	45.602404402276	45.4658328119011	45.4459434319329	45.5785966201553	45.8751264944804	46.2919723423166	46.7379085912214	47.0983966761274	47.2967441230192	47.3140342023182	47.1774063264009	46.9124346434007	46.5608805296326	46.1486496667487	45.6813040912667	45.1529419702453	44.5674603080807	43.927505904297	43.2374803802529	42.5035748411741	41.7349155941835	40.9419992128743	40.1374814638308	39.3307612716206	38.5258501338054	37.7271386880612	36.9449257227195
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	38.2772987100761	38.5553689343756	38.8380637351283	39.1167636153993	39.3811642710358	39.6251597830287	39.8440003067209	40.0410960897594	40.227805752423	40.4194224010503	40.6252837847448	40.8482710450336	41.0816958395545	41.3135223493137	41.5272874177469	41.7117479021603	41.8677323499842	41.9993551447624	42.1041398726507	42.1792603515614	42.2256484576651	42.2359128230217	42.2175269141765	42.2011594179512	42.2237996927721	42.305293333995	42.4560552152681	42.6570698002103	42.8636624154351	43.0174618496015	43.0810144840435	43.0456179853875	42.9326959741552	42.772450486313	42.6047840988749	42.4560302845005	42.3278044791411	42.211719482275	42.1090428571827	42.0193980688082	41.9404831158277	41.8738576840214	41.815069347131	41.7490266471217	41.6569921499271	41.5264816344523	41.3552702093646	41.1476902703362	40.906412405246
	40.4046821818094	40.6824861306707	40.9734464717407	41.2540348566144	41.4948438480362	41.67893908276	41.8018961532268	41.877732207367	41.9313079559313	41.9943262285254	42.0882288644088	42.216842053908	42.3729598267274	42.552645095018	42.749515834937	42.9592063419095	43.1817159119957	43.4174374297933	43.6626774510052	43.9125360501456	44.1619628802515	44.4078539772312	44.6473964816121	44.8766529184181	45.0912071944126	45.2876133690719	45.4646433925448	45.6212905254603	45.754925197185	45.8634733810503	45.9467330258548	46.0055281884259	46.042918883163	46.063954045741	46.0745416934987	46.0790444129401	46.0774953161537	46.0700957332385	46.0605604990198	46.0529511331489	46.0490715207977	46.0491658190864	46.0501871494822	46.0465337763698	46.0315450295692	46.0006555811436	45.9524602005518	45.8874368406065	45.8054840778997
	21.5016320110559	21.5082439859447	21.5085518508936	21.5132194768725	21.5302351183455	21.5632887321509	21.6180858977538	21.6843725682579	21.7317089497289	21.7236154693205	21.6322750889155	21.4517516104431	21.1921327912844	20.8744396404144	20.5275301852203	20.1687339455307	19.8050169788586	19.4345351932369	19.0535559832623	18.6623550262741	18.2619803359913	17.8564831917252	17.458656380094	17.0877785433593	16.7623946492307	16.5026568112328	16.3073557801707	16.1736215416095	16.1022057029692	16.0900920103734	16.132989298253	16.2300691357332	16.3756053586029	16.5511277251615	16.7303635945952	16.8956082113392	17.0405853482947	17.1621463199344	17.2479156078733	17.2829878924687	17.2580667148329	17.1679010667935	17.0156252117467	16.8183937876361	16.6041857705378	16.3916339834106	16.1864998389002	15.9859867235593	15.7861660449009
	39.4884146456288	39.7612571762391	40.0229031800567	40.2497959219298	40.4140940434243	40.4969253116244	40.4950716367173	40.4123862224692	40.2476255805911	40.0011514917192	39.6746051109967	39.2760083632247	38.8096342681453	38.2710173900811	37.6534781093667	36.9581917576715	36.182998204943	35.3474053380966	34.5000296257477	33.7029699592436	33.000359526927	32.4086042042101	31.9177087557687	31.5118083236237	31.1646622421151	30.8569780906852	30.5797870923607	30.3366221164053	30.1345320420828	29.9842943867615	29.8881885961238	29.847033719528	29.8423103373262	29.8347544840597	29.7760706551259	29.6336299325053	29.3994709898777	29.0834275872316	28.6945126014989	28.2483258049267	27.7583381845841	27.2280018390114	26.6603963410229	26.0688857915079	25.4693548931172	24.8755130620397	24.2916959394027	23.7233439469752	23.1855385456029
	38.9049032498994	39.2315861226134	39.5584654698102	39.8518493212448	40.0676936689011	40.1805067650157	40.1717894148894	40.0623352441986	39.9097945716788	39.7863972768322	39.7313929395168	39.7628753813571	39.8426883276899	39.8879160680039	39.7927184041786	39.4900833360509	38.9719815933733	38.2739150226562	37.4303314762128	36.4925243225829	35.5051239180207	34.4749586140897	33.4131672573402	32.3739595616054	31.4216892686588	30.6011954716057	29.9267702148121	29.3874439250512	28.9674281749903	28.6396238561968	28.3793254804197	28.1809707643247	28.0357414446853	27.9117645610902	27.7712988676146	27.5855928172594	27.352186806526	27.0702085908578	26.7177946927781	26.2705526927026	25.7170095659873	25.0459621652512	24.2766948877076	23.4659062382414	22.6893130227678	22.0015787625573	21.4203346294927	20.9340295609163	20.53144181372
	46.3813490022393	46.560895494274	46.6866729236013	46.7597787423829	46.7825439580551	46.7563161081968	46.6846683804843	46.5665568314828	46.3942545004309	46.1578436725424	45.8527676716614	45.4791103549525	45.0453203151255	44.5656060782429	44.0584058079704	43.5379902632106	43.0137171166025	42.486671807055	41.9535418726498	41.4077102568201	40.8473647400678	40.26979594305	39.6852356985304	39.1185388768628	38.6000943228302	38.1478326932008	37.7669379192155	37.4442868204565	37.156711615964	36.8737551521233	36.5742028799917	36.2534985881575	35.916607487065	35.5645731411213	35.2008613911579	34.8281636054253	34.4457114432895	34.0526588236116	33.6515712948958	33.245712692594	32.8375008061392	32.4283235958289	32.0184346431648	31.6078203338579	31.1961550850546	30.7837733274997	30.3710683239947	29.9598045016118	29.5531936273214
	42.5150351986822	43.1499811798696	43.79939057895	44.4176888030093	44.9465935334873	45.3489249339872	45.6157189925521	45.7654025336779	45.8302319743141	45.8527060098666	45.8628325091071	45.8691214104097	45.8690648811269	45.8727182874311	45.8935925769009	45.9364414927448	45.9935954583384	46.0651051841494	46.1632075781995	46.3059960826436	46.4980627581215	46.741114665571	47.0120132477771	47.2625790486665	47.4338894684743	47.4891622243886	47.420370594647	47.2408943613145	46.9685669131207	46.6249628480291	46.2277618274302	45.7908675066207	45.3132615052566	44.7815845869892	44.1762162050048	43.491766937252	42.7254110535885	41.9051712954088	41.0914730208744	40.3585550380131	39.7543827230945	39.2889296904907	38.9427286803962	38.6947383420612	38.5163419405256	38.3823522255188	38.2875134558403	38.227790453973	38.1857450096334
	43.8307110374321	43.8437371455369	43.8633905703658	43.8923120404113	43.9332276603101	43.9874266891552	44.0552517746586	44.1349484485118	44.22310023271	44.3156801096253	44.410028382447	44.5064389540403	44.6055594799325	44.7061439677656	44.8067495900831	44.9068293056173	45.0058532391943	45.1053541548478	45.209218536115	45.3222928963175	45.4477220925532	45.5862191282978	45.7363701367479	45.896367904728	46.0635077517771	46.235574351005	46.4076496520595	46.5790524619821	46.7550097893728	46.9416516527046	47.139525081582	47.3475008367198	47.5556032579519	47.7471349064594	47.9049914460255	48.0204839698511	48.0911844337768	48.1226131715913	48.1240004338837	48.107456517648	48.0801880051422	48.045213432326	47.9971665431623	47.9254559186096	47.816618528178	47.6630197949948	47.463011308031	47.2233196887087	46.954715260144
	41.3319016275765	41.5427292512863	41.7672315832377	42.0012383244026	42.2385882013615	42.4758013109211	42.7101336486728	42.9406520099916	43.1660777160277	43.3855937442047	43.5982737457496	43.8013230466927	43.9928840362244	44.1732174399596	44.3435513625886	44.503068465664	44.6509959447273	44.7837193274848	44.8959616367521	44.9811792801501	45.0352761479901	45.0594312375028	45.0549257103685	45.0192486499838	44.9498146658434	44.8462411753617	44.7114152248548	44.5504786680031	44.3688970103462	44.1727716663548	43.9681959646545	43.7527597854889	43.5299416070528	43.3159559166471	43.1292794381263	42.9788416246855	42.8703887557889	42.7929346823063	42.7198541050874	42.6168295229431	42.4627113484794	42.248668519311	41.9884465562019	41.7089956387588	41.4442093555535	41.2124844950645	41.0180334668742	40.8457085892983	40.6703507902296
	44.8121470800548	45.3286776457508	45.796642289046	46.1732235643431	46.4099481156786	46.4794373012188	46.3815140648794	46.1369219330855	45.7694096038271	45.3089801445314	44.7783728131171	44.1890795347729	43.5444881865044	42.8515038795362	42.1174041675074	41.3546709809779	40.5745454234569	39.7952496247939	39.0442277780978	38.3499557407062	37.7322307349719	37.1869654567295	36.7118913640894	36.3245115575339	36.0437596691669	35.8742149644779	35.8164696887183	35.8441401574245	35.9029050246469	35.9271729517434	35.8725577747898	35.728474984988	35.5050600639049	35.2081683641325	34.8499107520108	34.4405275275445	33.9841152360287	33.4817005828258	32.9371803510183	32.3534181161025	31.7342273185303	31.0826887942179	30.4062331337779	29.7171067220794	29.029577460487	28.3546061997587	27.6932019177724	27.0470603644402	26.4282739627087
	42.6258514025808	42.7543369365208	42.8991707650072	43.0569685358842	43.2250099101888	43.400730324764	43.5826000168463	43.7680138332305	43.9522411357286	44.1301606776396	44.2984100701798	44.4524052102847	44.5929596861443	44.7270323859881	44.8631887167625	45.0046152096344	45.1495016611296	45.290329583461	45.4179071872742	45.5219690962527	45.5960886533272	45.637630100033	45.6479161645576	45.6294702307984	45.5857831955014	45.5180377141922	45.4321041597859	45.3247227295346	45.1794256548384	44.9768412814998	44.7090748067525	44.3803246097237	44.0076488985988	43.6124069434662	43.2192332715822	42.8459952950613	42.4895670191659	42.1509708216885	41.8519954805732	41.6171276595808	41.4579272989308	41.3787974324115	41.3628859236516	41.3748046696764	41.3695655612584	41.3166815502898	41.2078058044942	41.0521331131121	40.8593192270522
	27.2459236769239	27.1201402768848	26.8938364663885	26.5720817404095	26.166177635947	25.6890714934041	25.1363409086619	24.5180576376908	23.8803976876205	23.2840652350704	22.7738555099701	22.3691270692403	22.0616475852712	21.8333883387427	21.6538399516417	21.4998023828987	21.3664836863628	21.2594029769682	21.177144735785	21.1201078847303	21.0867134806879	21.0723567053327	21.0695028195774	21.070008449948	21.0646631276754	21.0448534933786	21.0110809136151	20.9590883689981	20.8705158472979	20.7230235043329	20.5038564827452	20.2075643281874	19.847181501717	19.4502388424953	19.0499403902517	18.6673337615477	18.3042055991477	17.9537848192125	17.6179232931236	17.3000837458584	17.0049109717136	16.7407188896986	16.5095109599228	16.3026149479642	16.1053586774007	15.9069716145485	15.7047015876967	15.5031462658569	15.3070541389392
	35.0604649156734	35.3225293808677	35.749490734707	36.254269438258	36.7253215957555	37.0893418617119	37.313312114649	37.4202252727691	37.4601853953885	37.5042945243792	37.5910711072925	37.7438878035213	37.9179181863196	38.0061466059569	37.8710921209007	37.4267389351662	36.648117051484	35.5868929359909	34.3295792666451	32.9984088701526	31.6859298513358	30.41798352282	29.1849817495635	28.0046103954022	26.8921127318171	25.8648298939793	24.9327512912853	24.1110631260157	23.4234487610373	22.8919458494289	22.5222735372195	22.3263699538725	22.2800862306735	22.308381802339	22.3124918278536	22.2231907418809	22.0103679064095	21.6934782669995	21.3140410501469	20.9366586489878	20.6064816351506	20.3364165049438	20.1061778791447	19.8885339062114	19.6431561502446	19.3426236233596	18.9784465245743	18.5649627638487	18.1253120332888
	36.6983364630818	36.6205415680915	36.2756804274995	35.7303949885332	35.0934282577322	34.4493597845799	33.8373734796292	33.2393826803819	32.6182952754797	31.9108194701978	31.0748252419133	30.0866931102815	28.9801198942282	27.8373975793709	26.7819461302153	25.910326443785	25.2584673458205	24.807149638694	24.5353968806102	24.400001315967	24.3648225529526	24.4252728969687	24.5797054929182	24.7922402567571	25.0224366691787	25.2405001104593	25.4303439082259	25.5861075733231	25.7041238969926	25.7828625434098	25.8199075808667	25.8138866969922	25.7569819697407	25.6346626194814	25.4290806030307	25.1313753260459	24.7398870397354	24.266936970046	23.7347945234136	23.1730360250048	22.6034093263854	22.0356377112876	21.4705572657619	20.9099909803734	20.3531954889492	19.8022004837332	19.2580460783467	18.7299062673121	18.2373587281563
	25.6304924694982	25.218916871366	24.7404094171345	24.2201415663895	23.6885456306056	23.1716950090192	22.6753793903252	22.208849332966	21.805118034975	21.5036750920883	21.3310862095019	21.2988483053368	21.3946690626421	21.5901235154868	21.8437604457494	22.1217248767405	22.4141239076694	22.7162396846472	23.0057022713517	23.2585993662534	23.4564787071875	23.5912427401603	23.6590757416004	23.6523459348251	23.564773619649	23.3932319215283	23.1345829837999	22.7925039871634	22.3806132212548	21.9182148397281	21.4220852907983	20.8977783771224	20.3502956941476	19.7947632023963	19.2476718037573	18.7209133417815	18.2226604888918	17.7540683958769	17.3107539648141	16.8845679980025	16.4708882098377	16.0726510612093	15.6965087662104	15.3467085076777	15.0288234358644	14.7488336607251	14.5039297520091	14.2972755194479	14.146608970325
	25.2346704288737	24.9077105275022	24.5776125850153	24.2642353422327	23.9904464426405	23.7705017950827	23.610551653199	23.5029007643705	23.4298306071692	23.3662847913504	23.292559782193	23.2049232243417	23.1031422895898	22.9758641278791	22.8104194432233	22.5980974982727	22.3369835102108	22.0291753551823	21.6763009741069	21.2816032409993	20.8499698127807	20.3818834640752	19.8844491658512	19.3777404965839	18.8886447507987	18.4392329747786	18.0376128153727	17.6866624178651	17.3966955702742	17.1771440067779	17.0337554064273	16.9686381263759	16.9782871628916	17.0543406765846	17.1846190393612	17.3570031796943	17.5679802307216	17.809647385554	18.0600079718454	18.2924188384472	18.4868758299542	18.6359220055128	18.7396289826429	18.7958800041654	18.8051105046774	18.7690899055404	18.6855348853137	18.5566277605913	18.3942923349878
	45.462365084602	45.2938557435441	45.114440761614	44.9738609441388	44.9102564102564	44.943993555188	45.0654174120214	45.2473709099917	45.4427897758818	45.6260584773741	45.7693831072383	45.8731593526753	45.9436238062192	45.9729647047843	45.9566418477288	45.8954523935006	45.7955013393239	45.6706231563831	45.5367449018853	45.4041362773504	45.272231584334	45.1366648026706	44.9902767883421	44.8351630618952	44.6805737655777	44.5363736258272	44.4066722431795	44.2908877192073	44.1891161095199	44.0966138260951	44.0052188284765	43.9116027820444	43.8069338288079	43.6686091207705	43.4749707629159	43.2143097605315	42.8899565074433	42.5140887231402	42.0988069795122	41.6536344676164	41.1814776283272	40.682130540504	40.155175532654	39.6027142881042	39.028788122102	38.4408775809377	37.841412863225	37.2365277822726	36.6424060731162
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	47.8689998862432	48.0549449470777	48.2305837745927	48.3775030392867	48.4749697095647	48.5092580311028	48.4791873302155	48.3877878924715	48.2335278714558	48.0153348376446	47.7346460308962	47.3948242443159	47.0013840857496	46.5607220930994	46.0801658388376	45.5669688419625	45.0244377862804	44.4587998799598	43.8836292826686	43.3145994461686	42.763289099606	42.2342405975641	41.7276194214734	41.2440548054312	40.7827856295516	40.3429056192101	39.9227262499849	39.522128282467	39.1426932056507	38.7864323134862	38.4529298651539	38.1437025075672	37.8530630335674	37.5654472169529	37.2614664297509	36.9286030381607	36.5621508415361	36.1677220589573	35.7560920326128	35.3423642329882	34.937188477829	34.5439181751042	34.1592897043014	33.7793253051896	33.3979213173564	33.0114663727959	32.6183364898138	32.2220078957073	31.8299707486734
	39.508101656903	39.8659971971911	40.2153447840956	40.5259783594159	40.7676535614109	40.9165216563111	40.9561644870308	40.9060967270302	40.8074666903853	40.7134839598415	40.654784522738	40.6448534954123	40.6585008184355	40.6374037412061	40.5082588255122	40.2252890059139	39.7846769763286	39.2117666147575	38.5288840666948	37.7701570062942	36.9671856179474	36.1239277507316	35.2485095903029	34.385211210872	33.5850490698075	32.8795462200868	32.2769914694543	31.7684430146417	31.3455566113658	30.9925118358319	30.6921501275324	30.4419675442795	30.2346603702367	30.0418813806752	29.8300625717187	29.5755603326411	29.2759163622884	28.9319062180812	28.5330212000906	28.0673013819167	27.5311325771807	26.9215193757172	26.2493628106437	25.5539524222845	24.8853935502621	24.2802180216416	23.7486194669693	23.2842538737498	22.881517635997
	43.422999769805	43.7426512898942	44.0467171100183	44.312394448235	44.5123745755118	44.631609670823	44.6664302796659	44.630516442238	44.5473563612962	44.4463914894204	44.3467974059767	44.2520130802457	44.1552115525718	44.051435751396	43.933104508563	43.7948420928778	43.6370071263383	43.4606792788802	43.2627888446215	43.0397186442713	42.7893226490347	42.5118043726413	42.2082453421539	41.8788887578418	41.5240736692689	41.1446269933652	40.7449156382526	40.3270329211121	39.8878586928172	39.4231363773271	38.9326210105263	38.4149413099052	37.878345020602	37.3423204582588	36.8303455196997	36.3569632895009	35.9251623774	35.527496505242	35.1544930495332	34.7930064465877	34.4333377686386	34.0726882111912	33.7117991031492	33.3490716518854	32.9835765046202	32.6139002260439	32.2414783993621	31.8640706884227	31.4731741676901
	43.8662001704286	43.9922833512265	43.973517946957	43.8603328681026	43.7188862493796	43.5935409243534	43.497180711651	43.4164659276689	43.3366595227183	43.2353719822602	43.1001834352388	42.9284238529774	42.7339165938533	42.5398425233043	42.3755331154461	42.2593470785735	42.1987948733982	42.1836350165362	42.193127443573	42.1996969246067	42.1860540390251	42.1371665827103	42.0613195439607	41.9898816961816	41.963154971204	42.0003091112546	42.1102956649933	42.2628044590382	42.3932672614002	42.4225456830093	42.3018729754208	42.0183994412694	41.5974287552936	41.076948675182	40.5100223001127	39.9341579773201	39.3670802687155	38.800165639163	38.2146915326699	37.5830059894171	36.8929053044062	36.1381312184745	35.3451839727907	34.5715822071885	33.8888111373045	33.341578703558	32.9419174927198	32.6649999196233	32.4717980521095
	45.0702458288554	45.387552981661	45.6624990511717	45.8915693454494	46.0738484431288	46.2097082195248	46.3021101913015	46.3516294851329	46.3550303576879	46.3082983372128	46.2119333227143	46.0646372198042	45.8756707089905	45.6676918342716	45.467981176025	45.2934919527447	45.144102710688	45.0111025884607	44.890251834836	44.7748107719527	44.6568570888091	44.5427567902353	44.4256037077793	44.2702127934782	44.0326211092928	43.6863636272707	43.2235566124618	42.6644669124642	42.0468776198102	41.422592072758	40.8310181636763	40.2787196076532	39.7617256730603	39.2927279568607	38.8815189497572	38.5301500958393	38.2413088641224	38.0040733406893	37.7892127486903	37.5586685374317	37.2838656038021	36.9593822932711	36.5873595110213	36.1579417545113	35.6620973253468	35.0964582459916	34.4603805874769	33.762917027264	33.0240037718187
	37.0656140907648	37.3623357732917	37.6824913043984	37.9862340668522	38.2180477262767	38.3492171924366	38.3378239997676	38.2228565761886	38.1412399818434	38.2633957170704	38.7014460855959	39.5313723493534	40.734728934956	42.1896746984736	43.6423044541555	44.8229512328307	45.6414524111953	46.0860283430233	45.9920123859161	45.2186301165779	43.7865042591139	41.76962162441	39.504234332968	37.4899646241546	36.0991598691622	35.4362010248576	35.4400295492528	35.9514928630034	36.8158741951461	37.8370346944673	38.8647186318404	39.8654410585507	40.84692138011	41.7549806226815	42.5437783377621	43.1831003989053	43.6676043553283	44.0004726730699	44.1813977503079	44.2142609427544	44.1092720115262	43.8701124140185	43.5166415657276	43.0955925474805	42.6599759647844	42.2490214468625	41.871977895464	41.5255398528835	41.2193567961165
	44.7527395335768	44.7180766430432	44.6767544254951	44.6458184108198	44.6470361533761	44.6921509294139	44.7915714141331	44.9343378616018	45.0872198543025	45.2077029849261	45.2733673271604	45.2697239654837	45.2190583064478	45.176988117402	45.2132176912696	45.3673278658069	45.6405676410839	45.9971421959608	46.3936341165917	46.7767595323208	47.1099726842356	47.4014785411328	47.6556716468942	47.8344877734299	47.892886155529	47.8104284653029	47.5639763438326	47.1891032467305	46.7860458720444	46.4742974006023	46.3224341208599	46.3548286948308	46.5279604720348	46.7545124615049	46.9059889571127	46.8870356207589	46.6849798622425	46.3387001797232	45.8705373137559	45.3162490106507	44.7108200665787	44.056423204015	43.37705658454	42.7426706646875	42.2253389325757	41.8599135011296	41.6457296605128	41.5488346050934	41.5257913081989
	22.6887598139149	22.6827522831329	22.7420591359916	22.8247392893939	22.8761249624653	22.8607214894547	22.7649602356767	22.6051427070552	22.4108916746391	22.2246164805439	22.0757185703757	21.9721043917969	21.9034406175508	21.8600733136684	21.8261202528884	21.7910220545001	21.7508537560758	21.7111267317075	21.6818192425588	21.6769206607168	21.7046937398245	21.7653365612663	21.8506346799247	21.9497936199638	22.0482682592178	22.1338529707586	22.2038912609398	22.2549457508827	22.2743528561422	22.2467532137013	22.1609138205469	22.0091362447328	21.7884803149555	21.4992766237541	21.1483019223186	20.7451387156858	20.3016790104308	19.8229486307086	19.3064215350046	18.7438915103232	18.1342518435273	17.4734626848587	16.7851331993185	16.126208905707	15.5710396402779	15.1723697565344	14.9506229488203	14.8912799837361	14.9679175839372
	43.572210852846	43.5250450767709	43.4914502680064	43.4780577327834	43.4923172654575	43.5377040560412	43.6136942724173	43.7146770540455	43.8322725730699	43.9558836061271	44.0770456939388	44.1947671487805	44.307539357102	44.4076506528408	44.4873737822834	44.5429906227168	44.5747806894697	44.586622694742	44.5834060593186	44.5718132001001	44.5579293718834	44.5431372800448	44.5299475325859	44.5263087587054	44.5408175923355	44.5786348161911	44.6374584456315	44.7143631223573	44.8113837481695	44.9304779757185	45.0700591096722	45.2272078013965	45.3934837083034	45.5554305301101	45.6980118045557	45.8106927716182	45.8917887218575	45.9409889350073	45.9523424977189	45.9197334533982	45.8398846694172	45.7128541344457	45.5418833853498	45.3314949568187	45.0876599426615	44.8157945482067	44.5181375538647	44.1977157680867	43.8612828211313
	31.4734605118259	31.8193426500817	32.0410924728199	32.1347144001831	32.1055929116851	31.9617670321311	31.7008946557811	31.3265471019397	30.8689743278937	30.3825747966908	29.910268914632	29.4486399272005	29.0070272515572	28.5900398437887	28.198013977835	27.8342881367964	27.4953543825785	27.1910160327327	26.9388892830158	26.7606755022823	26.6635911134047	26.6540241362023	26.7173627803407	26.8230715501005	26.9288803291314	27.0077861250078	27.0503446434314	27.057610360787	27.0228620874073	26.9412923419844	26.8123853548232	26.6280342594029	26.39045923228	26.0926433100299	25.7385377753159	25.3342699903884	24.8864215671704	24.3955984603065	23.8657951432574	23.308230241517	22.7253359380055	22.1326921361582	21.5322645353825	20.9501408486144	20.4255373761909	19.9831779770293	19.6338044058088	19.3711668711063	19.187751716034
	25.0653318148523	25.1127071462083	25.1293134785121	25.1231147623998	25.1133053315398	25.1085693250864	25.1144039517248	25.1236394403043	25.1195723020599	25.0827320339714	25.0026026701042	24.8737022988543	24.7081086932092	24.4991123621667	24.2445955751795	23.9469891871506	23.6003432176998	23.2051981501509	22.7778269752854	22.3340094286038	21.8855089846896	21.4434882604995	21.0057316405517	20.5805427768671	20.1743365212106	19.7899282774461	19.4303864010514	19.0978570255183	18.7899332587711	18.5053700987258	18.2413471386677	18.0033788497215	17.788987529709	17.5910973764501	17.4033843896998	17.2201111941269	17.0365600124297	16.8551469491096	16.6773383389744	16.5059336300332	16.3433250892192	16.189685077302	16.0441661568038	15.9094576907242	15.7870590702717	15.6810911068993	15.5925699257044	15.5167574821182	15.4528184219467
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	47.970151905481	47.8942513847799	47.7647984491164	47.5605816572236	47.2584560895828	46.8451284040822	46.3273515111309	45.7220106345035	45.0401085869066	44.2999415096784	43.5214797502998	42.7035633825879	41.8646148627973	41.0668684555565	40.3841013412922	39.8614571307043	39.5133747801546	39.3138512122196	39.2177462977852	39.1637629538378	39.1069484116338	39.0361282451027	38.9577694410542	38.8732728406665	38.7861685066522	38.6958313108851	38.6017820616605	38.494460422136	38.3508166615654	38.1444487343653	37.8612692796727	37.496575117268	37.0664013051454	36.603003423363	36.1458231745086	35.7195130844237	35.3273140606635	34.9626829937879	34.6279505622531	34.3242601349356	34.0499525372312	33.8101720360051	33.5990874367506	33.3936991313195	33.1626744311809	32.8856126350468	32.5562864953212	32.1814288337399	31.7714158436487
	30.406313678033	29.9127502959222	29.2544191846147	28.5030397472409	27.7560101783051	27.0814955821667	26.5035253540104	26.0017484603883	25.5458709907874	25.0885636176002	24.5983606592969	24.0721119609168	23.5298271950398	22.9904845259753	22.4789397883524	22.0120761585862	21.5939350794556	21.2194075634322	20.8841785620151	20.5816438322801	20.3076155702948	20.0601836336093	19.8417388421532	19.6570497941479	19.5123915738569	19.4100370323075	19.3498288130176	19.3247885406877	19.3215401784362	19.322943193096	19.3153794459816	19.2954507342548	19.262769814037	19.2112101812167	19.1347735751719	19.0298880027064	18.8921293493296	18.7236663264641	18.5361483957344	18.3459601292114	18.1651488933322	18.0000740496194	17.8481088141207	17.7017484823707	17.5493665423325	17.3839854898916	17.2028137055376	17.0128778955485	16.8288697326892
	26.2826381773676	26.3091492630363	26.1916716510848	25.9805588541284	25.7445291530582	25.5313375136738	25.3501581603717	25.1876097080255	25.0398583613225	24.8975022288595	24.7530596036049	24.6129284071397	24.4790903716018	24.3345258151978	24.15650667473	23.9306256255377	23.6488655972808	23.3204428194808	22.9692993864955	22.6292728825331	22.3245450131751	22.0656467121768	21.8449269745323	21.646656694776	21.4469453078548	21.2297654774343	20.9894287802192	20.7347801797824	20.4813977731397	20.2510758443866	20.0582720369783	19.9084457259884	19.79408346042	19.7008655214533	19.6084192288517	19.5024568001759	19.3790737838984	19.2436116896889	19.102510547453	18.9659614948643	18.8418158379078	18.7300207442005	18.6288621126911	18.5422639213222	18.4745219660677	18.4275726188807	18.4025511931715	18.3958438225767	18.3985624217964
	44.5798774800212	44.7983352714364	45.0750558168258	45.3813042377368	45.6816941260346	45.9395427476066	46.1696818465377	46.3599803431918	46.4328548767749	46.3081547307893	45.9403636626019	45.3186494812074	44.4981657735026	43.5905839553615	42.7380848342324	42.0308612016301	41.4875736727696	41.0696302950829	40.7213234570678	40.3692995854244	39.9706156809022	39.5204194402323	39.0418780538031	38.5444842015889	38.0434333720745	37.5534409047028	37.0642263529227	36.5753709458572	36.1058681994386	35.6827963455897	35.3188048273674	35.0152115838592	34.7549775555708	34.5096396448451	34.2416714681074	33.9246325233091	33.5659214446542	33.1673351258162	32.7039086047216	32.1410249225079	31.4649217233575	30.6603262455093	29.757233586309	28.8395573885602	28.0138306539753	27.3507420303706	26.8732472709574	26.5493843632066	26.3234751714327
	30.3496313439013	30.6345195336017	30.9575953463569	31.2945196477855	31.6107011996185	31.8864205699299	32.1121401435372	32.3030242406055	32.4912979969854	32.7191026757791	33.015036457743	33.3834945968536	33.8087141878346	34.2728170005625	34.7537173439267	35.2355448334025	35.7136076622684	36.1900587358639	36.6677579366619	37.1525083995689	37.6449754321203	38.1424859869825	38.6369799708889	39.1143173237523	39.5581110648052	39.9581737909296	40.3068039762814	40.6075000415429	40.8713948322334	41.1144350028087	41.3440198618307	41.5617070550416	41.7562861808227	41.9079859495103	41.9929728173987	41.9968887368401	41.9191389451433	41.7678281253	41.5488692640221	41.2706792067883	40.9401577739762	40.5635765637002	40.1430441134143	39.6779779893115	39.1664395120869	38.6109993288194	38.012383106754	37.3820930540044	36.746248332362
	37.9435971005739	37.7426795179251	37.5874265824248	37.5076587629192	37.5428402380075	37.7085319351764	38.0115882897283	38.4246461707314	38.8912143736424	39.3406266351125	39.7266189054542	40.0349603334678	40.2831961635668	40.4979432687566	40.71677561223	40.9619320586684	41.2327683952975	41.5155487058349	41.7989712413618	42.0700997537235	42.3188720983262	42.5472559111052	42.7559267486295	42.9302500508531	43.0549731382059	43.1228819151093	43.1327780730671	43.0969625653643	43.0368604083133	42.9777509796609	42.9360746553155	42.9139350203766	42.9057471264368	42.9084410960975	42.91693471801	42.927196171402	42.9373766676224	42.9472674188897	42.956633567869	42.9654374306541	42.9724659857675	42.976563045393	42.9736563320679	42.9565535837741	42.9170149076391	42.8494015613267	42.7533431834198	42.6294837980057	42.4764486206481
	28.6789277557399	29.4376815463048	30.1543628258006	30.7782976649142	31.2551375476931	31.5513837765911	31.6495860091877	31.5640035271558	31.3340746060727	31.0164407533141	30.653696417051	30.2620159784943	29.8378869791997	29.381458232538	28.8873260340348	28.3559318304253	27.7855663327211	27.1937319044351	26.6222817094596	26.1252609943206	25.7390301596688	25.4814830175812	25.337021507881	25.2674905676507	25.2184359648975	25.1510591446722	25.0508598941245	24.9282698263164	24.7983824281295	24.6841407279495	24.5981730033284	24.5430843611947	24.5034172970712	24.4511656015494	24.3469702498651	24.1601285959225	23.8831869143189	23.522525440958	23.0786648754881	22.5559700948805	21.9612413720428	21.2900867309407	20.5538122525695	19.7949010847528	19.071055883686	18.4277539716831	17.8827711602726	17.4351631305274	17.0893457202686
	21.2747503776665	21.541292150421	21.8714192466924	22.2282799084264	22.5663278524402	22.8512039302983	23.0716546787411	23.2268638714158	23.3074269695208	23.3061740068018	23.2186766651716	23.0420826219442	22.7771907557584	22.4293300166063	22.007261655909	21.5206877827912	20.9748942278524	20.3787152962659	19.7508140971493	19.1137953384458	18.4878376317914	17.8756322762262	17.2860679063453	16.7530889928011	16.3194911849561	16.0145858508493	15.854587710604	15.8256799639328	15.8889936285709	15.9888219779039	16.0827113921786	16.1587477923317	16.2203429560567	16.2596362539015	16.2718869630893	16.2534574585518	16.2000027957578	16.1082875193834	15.9785034999549	15.8129151809637	15.6150269303189	15.3836968518795	15.1226643637244	14.8467874916549	14.5751381182944	14.321629534983	14.0927346278364	13.8868259300696	13.6995267629268
	44.318545891849	44.3007237697356	44.281977027428	44.2841335015409	44.3343633030351	44.447340701343	44.6260093598182	44.8556209973578	45.1108368493059	45.3570807008076	45.5687772794601	45.7380202731695	45.8689530586996	45.9640938559336	46.030052532181	46.0718552228223	46.0894130470689	46.0804026685521	46.0448396723332	45.9830602398802	45.8965677987622	45.7875135611026	45.6587563776178	45.5134833232818	45.3537654133002	45.1803530833939	44.9928016597034	44.7914125626488	44.5777979385728	44.3546627551155	44.1243362539485	43.8891077017854	43.6485220619915	43.3993966717659	43.1370102491949	42.8584583169232	42.5635621368411	42.2549714633915	41.9359728509705	41.6111262626792	41.2840907548937	40.9564916900889	40.628869825676	40.302456377154	39.9781285580981	39.6566934827969	39.3376637283821	39.0219345794985	38.712949652365
	26.4921253365483	26.3666655378447	26.160417976302	25.9079063059864	25.6617753597855	25.4589957554697	25.3083459206814	25.1937829385888	25.0977185345169	24.9937319797992	24.862953516899	24.7001896399015	24.5118570540738	24.30506519907	24.0919210647999	23.8815286810079	23.6767356802513	23.473973031673	23.2680731455768	23.0503391254926	22.8133895510959	22.5536714266668	22.2711519141366	21.9657743341625	21.6392666742886	21.2931530500613	20.9313976228822	20.5530807061612	20.151033817641	19.7167478741428	19.2483815512641	18.7463481577151	18.2233384235902	17.7037396800128	17.2157599591723	16.7772413438974	16.3938333239689	16.0599477866479	15.7667305293113	15.5010631379607	15.2539806262132	15.0223434552525	14.8097897112338	14.6222237142595	14.4683553658025	14.353448209631	14.2791750455379	14.2399131005275	14.2245515479751
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	49.0967576772815	49.4300995133927	49.5914988475398	49.6427002646268	49.6741129812549	49.7350972367628	49.8666498002382	50.0284390141142	50.0927780706378	49.8954041204437	49.3161714073839	48.2961908606148	46.9035219442581	45.3294296155408	43.8351162091335	42.6091661706618	41.7305945567362	41.1430536909028	40.7538478822604	40.4103862059614	40.0026987821745	39.5137852920051	39.006322036814	38.5570816256296	38.2452822515048	38.1050184849365	38.139599972012	38.3089738811608	38.5552992098654	38.7891565642473	38.9322104387607	38.95599833956	38.8676098103416	38.6732626907299	38.3968028669505	38.0452253781261	37.622690244387	37.1209718974196	36.5230991576009	35.8123615068059	34.9804363291439	34.0253259433125	32.9715848715022	31.8897753702123	30.8690419108941	29.9765853658537	29.2363650509609	28.6348480148883	28.159165539888
	40.6444628981553	40.9959904701029	40.971877173805	40.7129897649682	40.412170648372	40.1878515630146	40.0735294117647	40.0306209527634	39.9919116655841	39.886496970858	39.6576135924829	39.3054919908467	38.8586713224102	38.3532091505415	37.8284256997128	37.3149507234221	36.8192168044473	36.333992194006	35.8543334903439	35.3748416567502	34.8881507337762	34.4073394495413	33.9417695177956	33.4718714927048	32.9777389337309	32.4566396571352	31.8916753858227	31.3071170315506	30.7754681969156	30.3786948864373	30.1708559224577	30.1644507929532	30.3163741806434	30.5563222295351	30.7798986710153	30.9210074334629	30.9583542398394	30.9135121013391	30.8013609765139	30.6554505405441	30.4969932904939	30.3283525268868	30.1431735238155	29.9281528162625	29.6757473481196	29.3749147233477	29.02782569038	28.6413955822714	28.227533722202
	45.7517436917964	45.6951261773362	45.5999379341406	45.4764842676352	45.3375332127234	45.1937720886376	45.0473046879736	44.9020901139453	44.7716658421916	44.6710437516398	44.6096774294719	44.5889456072008	44.6042686849257	44.6504517597146	44.7201970295066	44.8075063236436	44.9091482412933	45.0224424505479	45.142205146814	45.2625882493849	45.3781830020195	45.4881832161525	45.5891174464554	45.6709329077675	45.7221905147631	45.7364298111755	45.7106683341047	45.6498424730694	45.5651040763965	45.4709691170936	45.3771166519512	45.2863693417603	45.1951840149701	45.0987187335901	44.9900445158935	44.8648714010569	44.7204374404553	44.5594187802271	44.3891576345661	44.2192545812525	44.054825058162	43.8980127575309	43.74272417429	43.576224897446	43.382535564649	43.1514481258386	42.8807667451096	42.575362612955	42.2413160068855
	41.3550848184949	41.5094641921414	41.6980027973718	41.9003839983565	42.0885803403603	42.24371684789	42.363107335215	42.4555392843024	42.5291670973176	42.5959443212115	42.6647928897086	42.7385646530417	42.8164974769719	42.8990107535398	42.9845494332881	43.0710442348091	43.1563727414245	43.2410878568657	43.3284360413205	43.4238559166348	43.5306585200125	43.6491885427266	43.7763150067589	43.907336491283	44.0358524552473	44.1567756796868	44.2675037478975	44.3673232294666	44.4545816728902	44.527551943405	44.5845766118209	44.6255706970098	44.6497802914266	44.6547927255349	44.6380779930766	44.5986464273054	44.5366539496027	44.4540395487889	44.3538187559568	44.2402346056463	44.116779113011	43.9836769467886	43.8410926012201	43.6925032703075	43.5420926876357	43.3925135086362	43.2441917283467	43.0957206461147	42.945743418933
	41.4011366391036	41.4578327998967	41.6386749217931	41.8054628021905	41.7620446729659	41.3841796107987	40.5915684990361	39.4718719135699	38.2802648436528	37.3851059838679	37.0437197311237	37.3496799138192	38.1667325795441	39.2459033077311	40.2655309351145	41.0217424138898	41.4600322200263	41.6665115821545	41.7584144751974	41.8886912049555	42.1455594987339	42.5625487294169	43.0780780437116	43.5701038074745	43.872660834902	43.8818069542603	43.5678493368768	43.0053190932631	42.3243198378534	41.6937402637735	41.2282177481827	40.9509907305529	40.8235358542718	40.8143709329998	40.8752634004425	40.9711412371815	41.0989316640305	41.2642676921841	41.4527361109217	41.6478211673276	41.8362846621664	42.0110840666542	42.1688578159435	42.3068507327267	42.4234774420665	42.5178558574954	42.5886551649539	42.6341483040316	42.6522758302882
	48.4784520668426	48.4013320949708	48.0687660561311	47.6295947219604	47.2686309042156	47.1007751937985	47.1672487388436	47.3982026291629	47.6610907737533	47.7811948907175	47.6460397051506	47.2288652021862	46.5831073254306	45.7802263046345	44.9321893315609	44.1273937772012	43.3883874168257	42.7034191639796	42.0824688115561	41.5238369767889	41.0190728251542	40.5701419385648	40.1731104059986	39.8046255172396	39.434565112151	39.040546746686	38.6174187797484	38.1656314808633	37.6763876445608	37.1427849071467	36.5642535651933	35.9473302710777	35.3036962278797	34.646505632996	33.9875540432187	33.3364960012018	32.6794002518268	32.0231858533074	31.4229199430098	30.953920273731	30.6656846397861	30.5861920956186	30.6813329889462	30.8602724314321	30.9976424557272	31.002678592469	30.8495883685998	30.5603978536841	30.150883438974
	40.2934721594792	40.5675094361518	40.8887345670963	41.2179766527492	41.5058932680512	41.7197646652107	41.853402116265	41.9190129331839	41.9264808660238	41.89184778744	41.8280041705938	41.7396191034427	41.6296772247756	41.5073482461579	41.3833417793685	41.2676250469732	41.1597177428355	41.0657977579386	41.0081254479833	41.0129224355791	41.0943973742194	41.2533130056054	41.474367669594	41.7344508102692	42.0047505161828	42.2631806624623	42.5023320931244	42.7190037644498	42.9019080725061	43.039601039004	43.1231245342331	43.1531261477863	43.1272760863159	43.0324974734924	42.8539008306928	42.5851177849371	42.2240591894285	41.7843078273947	41.2941308326521	40.7887793407824	40.2930940020634	39.8140418405859	39.3477177581704	38.8931903250414	38.4468237605858	38.0061362439135	37.5742397706339	37.1536180694679	36.7406811448826
	43.2119664135164	43.3184462280035	43.4290795378595	43.544364057361	43.6649746244758	43.7907553480242	43.9212042634597	44.0543015784805	44.1865860299235	44.3140005136162	44.4336862657926	44.545065658436	44.648422826389	44.7431653633952	44.8289344500636	44.9057652163208	44.9734877519094	45.0328091421766	45.0857833283064	45.1348974426255	45.1835962775092	45.2283669058975	45.2700233745737	45.3098396647738	45.3492160548637	45.3883952987275	45.4277727569367	45.4650251135482	45.4946530041777	45.5108542355033	45.5092620987988	45.488832713465	45.4517878507596	45.4021700255376	45.3433508553724	45.2770628696278	45.2044938103097	45.1244191704293	45.0348429488996	44.933400416038	44.8188723734619	44.6909479099321	44.5505637823505	44.3991479179863	44.238772964408	44.0711432901203	43.8961271858236	43.7114245685872	43.5188119019052
	28.3574703637245	28.289616837638	28.171647473843	28.020730219784	27.8598071051048	27.6993905062097	27.547177733408	27.3990462508683	27.2429431636753	27.0547806256577	26.8383361536173	26.5871889096989	26.3079941361083	26.0030083871002	25.6694985486015	25.3135294499979	24.9310555232752	24.5256121911479	24.1118122116399	23.7065483950852	23.3209623777936	22.9625775554474	22.62953635007	22.3187867847896	22.0239261134464	21.7402242549507	21.4672493242308	21.2080077722674	20.9656953730431	20.7451867619648	20.5528334813038	20.3720575526077	20.209854837021	20.0904720894908	19.968911594878	19.8512434677801	19.6966161131029	19.5284202088429	19.3504275924133	19.1652798505006	18.9851981282691	18.8057464849625	18.6254152869583	18.4468853384435	18.2751840298915	18.1131849303984	17.9591274606803	17.8110969503704	17.6722189830183
	36.9888340999385	37.0612488205094	37.0455567256078	36.9509653619555	36.7982156705204	36.6097199178218	36.3827782943944	36.1243082330057	35.8334210221584	35.5100440719755	35.1642996154405	34.8015298027934	34.4298914939018	34.0628299900085	33.7235230277003	33.420505509118	33.1671333746255	32.9578162445381	32.773705380734	32.5843781199473	32.4262772783824	32.2623315958418	32.1122632205627	31.986905609397	31.8855908145859	31.8103684380231	31.7625179762986	31.7204135068748	31.6759018750671	31.6096786302339	31.5115808335052	31.3188152249239	31.0566412155445	30.892756963714	30.6770992795664	30.336403880984	29.9387330333608	29.4892717184017	29.0364386472922	28.517639316894	28.0456978545691	27.5394113031196	27.0438557357054	26.5698652802406	26.0939602070551	25.6574691449116	25.2410867540907	24.8361120010141	24.4555249002832
	28.0462969194559	27.9702003529911	27.8441982996836	27.6870405556529	27.5215887181295	27.3580308294589	27.205265421803	27.056451246853	26.9012087385164	26.7148717968236	26.4988918262635	26.2476729677073	25.9674830561299	25.6585888573186	25.3195049723626	24.9546486826871	24.5594197537554	24.1377258362005	23.7048763415802	23.2782845629274	22.8711521263424	22.4913336291552	22.1368147081278	21.8044631721402	21.4871014889718	21.1798053501418	20.8818693818928	20.5969725627264	20.3300926790254	20.0883391833634	19.8787629839298	19.7041567804182	19.5595504906241	19.4317144985329	19.3054889774902	19.171009523406	19.0218369783636	18.8622881789413	18.6949761895762	18.5259694089558	18.3593375874488	18.1946190020297	18.0303106766222	17.8682728615513	17.71229721067	17.562891675383	17.4210865494755	17.2856486812078	17.1580801394768
	46.0623192971542	46.3312588784415	46.5617295923017	46.7625437356607	46.9450075071787	47.1165762546474	47.2806868591217	47.4329531194697	47.5642574907644	47.6621543885445	47.7192228779707	47.7342899246981	47.7132392411458	47.6637174066461	47.5957660220349	47.5164062829409	47.4285807028928	47.3316561436475	47.2247482525455	47.1059892708627	46.974905082734	46.8304801987526	46.6754422942145	46.5162799015849	46.3606967758701	46.2127570363854	46.0722140287939	45.9345002195307	45.7936984698172	45.642779577834	45.4760800562637	45.2923216753935	45.0903678388101	44.8655463670641	44.6125579664038	44.3276365395329	44.0093737891985	43.6581952180846	43.2745639070023	42.8601558847297	42.4166141116642	41.9468898240931	41.4523826510808	40.932603284555	40.3866682850004	39.815842607771	39.2218281403115	38.6107605845283	37.993462852046
	40.8865151245635	41.219496756704	41.270258526203	41.1091365748004	40.8212266139789	40.4561446561783	40.0290377671695	39.5136680041081	38.8676427038794	38.0401668050367	37.0129257285627	35.8004032288241	34.4539628127263	33.0451701527187	31.6572448120264	30.3517200635061	29.1458117075733	28.0446254876882	27.0689264847652	26.2306302760683	25.5275924327493	24.9570436716193	24.5013416277959	24.1231084105114	23.7765926381881	23.4283805056374	23.0664921086702	22.6918303854228	22.302353346241	21.9024756790263	21.4970787953923	21.0891701585382	20.676961470349	20.2563939165041	19.8200458606437	19.3626200209115	18.879688805436	18.3752556447546	17.8604408830933	17.3495919917868	16.8508700825173	16.3710624299617	15.9043089037886	15.432319070572	14.9311102185402	14.3881531565106	13.7991572627524	13.1809090704973	12.569099822551
	25.3205052121879	25.0243935079812	24.6484552357988	24.207898393869	23.7240305811196	23.2164022734709	22.6906775356561	22.1568550550988	21.6439422001291	21.1867271173527	20.8115640481095	20.5205918491585	20.3122307986769	20.2017490904766	20.2054682872247	20.3279680055299	20.5808561934816	20.9425004578101	21.3436730796916	21.6936550617877	21.9283038984365	22.0216501282186	21.9890623893297	21.8594635776626	21.681225073685	21.4900748107612	21.2951932215187	21.0839733666287	20.8463221923057	20.5656932322996	20.2329992551742	19.8458409937819	19.4179389820503	18.9752383155463	18.5510577899632	18.1684145161646	17.837795453259	17.5531379169919	17.3000282848523	17.0558779538168	16.8046173976907	16.5438807496263	16.2808549763201	16.0206479594385	15.7714942150108	15.5403672889232	15.3263991287072	15.1297526990218	14.9594156589996
	34.6594847668724	34.7238628005973	34.7422821361188	34.7011155772414	34.5819146911413	34.375	34.077397010385	33.6988192773531	33.2647510462981	32.806392730303	32.3437905742745	31.8934547898445	31.4535970399756	31.0128695226945	30.5507988881	30.0581110025639	29.5240127486856	28.9629632962711	28.4096385542169	27.9144877138028	27.5087657784011	27.2109758266354	27.0047569413168	26.84654814953	26.6776456390013	26.4583799368678	26.1735151587149	25.8401293161074	25.4951387831328	25.187367653007	24.9496650221945	24.7916350962267	24.6936144833292	24.6257450798055	24.5449329196017	24.4207000201886	24.2427383204208	24.0217486883372	23.7747097925302	23.5240044525836	23.2879733888326	23.0741277787774	22.8726960844375	22.6606182819024	22.4082838815078	22.1000770968309	21.7319030760706	21.3259037376232	20.9209808918813
	40.7452577146223	41.0559288798616	41.3460972569226	41.587012000089	41.7440088482154	41.7973105881461	41.7414551981791	41.5936517839032	41.3850855179946	41.156187793407	40.9354750535004	40.7301210989851	40.5352729016548	40.3513161488301	40.17572975174	40.0068219372062	39.8461725187616	39.6956736104413	39.5539735747777	39.4189594328773	39.2885945965287	39.1617049600369	39.0370184492274	38.9122236229383	38.7847789022906	38.6524261406299	38.5135780156686	38.3667785356543	38.2101571730098	38.0418542373375	37.8602181540979	37.6652031673824	37.4558218797478	37.228724986441	36.9799457737862	36.7071996533894	36.4092649407716	36.0880271162177	35.7480871947273	35.3955683754121	35.0346695093415	34.668299569537	34.2953749349908	33.911551529814	33.510711554437	33.0896604695728	32.6472745671864	32.1880918884618	31.7212954426347
	39.9853977197829	40.3385646847499	40.7147893942384	41.0902894076194	41.4371623512396	41.7353039166391	41.9785711114769	42.168038950706	42.3014306806776	42.378648613791	42.4008459936729	42.3664989248545	42.2778309389143	42.1442640535039	41.977554174984	41.7858268929576	41.5719044188874	41.3343064082677	41.071309197895	40.7798786484007	40.4583092640452	40.1088958068415	39.7339095989307	39.3320000917562	38.901112915598	38.4407677892613	37.9515180878522	37.4370173551372	36.9035659071422	36.3589392981148	35.8090250454738	35.2579402714244	34.7064313168442	34.1531888369377	33.5956698759754	33.0336724266871	32.4664202373518	31.8992267651016	31.3448958544107	30.8194659885354	30.333368131287	29.8901205514755	29.4846781098204	29.1080367024417	28.7474170364957	28.3932868443969	28.0425395789116	27.6960559451934	27.3530699351265
	43.8132110487059	44.0256913277367	44.1782234890195	44.2847697328495	44.362965956224	44.4253720187866	44.4772528967652	44.5179884525616	44.5467793581796	44.561268289848	44.5612834998087	44.5466372594194	44.5223090759251	44.4985955578278	44.487586478933	44.4960742788224	44.528316820044	44.5789771562362	44.6340639651632	44.6758978850983	44.6945513968766	44.6663236752567	44.5981818123976	44.5387501311762	44.5453912034912	44.6397180789569	44.828775165344	45.0611409851356	45.2346274165232	45.2261375522374	44.9577725063182	44.4280089108929	43.6694009950176	42.6891563578244	41.5055263643595	40.1452788684163	38.6106648156483	36.9326892089022	35.2012917502306	33.524609148243	31.9783632025271	30.5908744020194	29.3534532219395	28.2564487837537	27.2780089144468	26.4046459759461	25.6321757463571	24.9715730902284	24.4397395780761
	43.0745387347559	43.5608783773598	44.1401333666257	44.7129223525014	45.1528559575418	45.3877303686164	45.3980044145794	45.2438282809751	45.0281944642423	44.8778281844814	44.8688919356283	45.0103788788158	45.2586645142653	45.5675804817769	45.8763969168834	46.1430044548718	46.3688184851004	46.5619616811499	46.70135323195	46.7646922054843	46.7422268020565	46.6234379861573	46.4246386225638	46.1927612411167	45.9855399590617	45.837129644157	45.7604302697963	45.7335387494635	45.713773545322	45.6452110911292	45.4938583739495	45.2534256399036	44.9473793977886	44.6085950879046	44.2787505309104	43.9845257746161	43.7313060829052	43.5085162953244	43.3054535494669	43.1068472503629	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	31.0868360128822	31.1819518229498	31.2224348370115	31.2231860545731	31.2065161286267	31.1893034249819	31.1735084637557	31.1562707961132	31.1429794005592	31.1391403673209	31.1473217535265	31.1714280647384	31.2074369803352	31.2395598283962	31.2476321859659	31.21838083434	31.1450775017393	31.0327609710246	30.8942660583642	30.7476071536332	30.6032727442731	30.4653391699918	30.3243770565561	30.1616131461836	29.9513074719449	29.6747530977577	29.3257260971405	28.9081925162975	28.4277097478779	27.8971181244775	27.330770152189	26.7366866635902	26.1213856125305	25.4971766422496	24.8754190968865	24.2653476869363	23.6743086011694	23.1096731359197	22.5796849573475	22.0938670134195	21.6609767754643	21.2828781277154	20.9626338235492	20.7099454041214	20.5345012169245	20.4388370791132	20.4199087665882	20.4651156382481	20.5548519968708
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	36.0502738857721	35.9444386107743	35.7061297762394	35.3819234072201	35.0244138892205	34.6678841516237	34.3148085390923	33.9627492567449	33.6310374573887	33.34332864368	33.1171576200817	32.9560999041319	32.8545979038958	32.807651106031	32.8067554830424	32.842244370656	32.9136258035988	33.0119015559609	33.1110236377407	33.1795650205002	33.1965691977552	33.1526442724532	33.0529621110762	32.909867349249	32.7413751032709	32.5590277972437	32.3714128359788	32.1715153790734	31.9389997544808	31.6493102306388	31.2937944480138	30.8760508805279	30.4223855500367	29.9722252467083	29.5661134454751	29.2254973110776	28.9506423696346	28.729545634921	28.552488116386	28.4069897994745	28.2837882148554	28.1788146588955	28.091337647335	28.0194884981975	27.9620354100651	27.9160909429734	27.8811813217064	27.8507152702458	27.8093791569877
	24.9203184724285	24.8294759813548	24.6995676112355	24.558868674293	24.4478366497495	24.3927370379082	24.396971331478	24.4439969513047	24.5150924083492	24.5839189407814	24.629301889616	24.6482722130578	24.6393404199278	24.5852892426155	24.4662968817476	24.2692237154268	23.9881542632854	23.6280669511758	23.2010000604154	22.7250375362836	22.2149336437444	21.6771244548818	21.113343082051	20.5286984412788	19.9276594235442	19.3159504539434	18.6958184800124	18.0757250322563	17.4750683262345	16.9182969899684	16.4235771057286	15.9997222989961	15.644377818961	15.3499444940756	15.1026487986302	14.8912604738563	14.7134210005372	14.570054807907	14.4567662202339	14.369129104429	14.3032780499044	14.2563470549211	14.2254796188389	14.2069381401531	14.1968444472633	14.1918269449984	14.1884638866391	14.1846601993021	14.1800662529273
	41.6815529355722	42.1899718582625	42.4746829185196	42.6651624210388	42.940187414727	43.4108174860234	44.1107265504611	44.9644441069343	45.8396126960353	46.5532041263572	46.976892505313	47.0894983094119	46.9378065492053	46.5486364528957	45.9667283740728	45.232367614897	44.3423293432864	43.3115410454861	42.2196402857656	41.1702637388625	40.2400338646324	39.4635238429999	38.8270322254582	38.2974603444344	37.8194496173062	37.3515227049866	36.8836478476372	36.427550564364	35.9911411156006	35.5909265725936	35.238983970724	34.9377445928136	34.6785235120177	34.4495513964216	34.2345758707048	34.0205123713313	33.801049183756	33.5755044566906	33.344084404483	33.1087185177071	32.8697834573218	32.6299422478898	32.3839110354346	32.1144243810173	31.7993137946297	31.4248828288561	30.9857117990132	30.491798170909	29.9646115618481
	30.2552838944204	29.3427811347356	28.3597264341362	27.3747568461608	26.4755754170225	25.7237575750183	25.1344037953234	24.6912241067635	24.3822927146114	24.1846850402205	24.0763685021921	24.0560139324223	24.1133578997823	24.2069003506935	24.2863793938993	24.315586044551	24.2790588839054	24.1792290381994	24.0210139839991	23.816440539901	23.5735335683975	23.2968307097497	22.9803975652937	22.6108954929495	22.1703573606668	21.6496786340109	21.0428859094193	20.3648631305702	19.6531828611238	18.9589957035686	18.3206368612264	17.7528379842028	17.2498371096119	16.8040604791037	16.3994618860345	16.0238231654843	15.6765859306606	15.3623153291878	15.0791977966385	14.8255732328391	14.5995839574005	14.3992625168425	14.2219042612537	14.0639270683728	13.9211569347813	13.7896509964793	13.6677913166989	13.5531396952489	13.4400742927988
	44.4042330238802	44.3957933697376	44.4390064974807	44.5326991581043	44.6701306880806	44.839831597671	45.0332413105497	45.2399644713731	45.4476542286253	45.6524675290616	45.8592069352037	46.0530747466023	46.2400831374691	46.4640218504609	46.7751481331481	47.1922371123694	47.7414197479657	48.3781332102274	48.9682797341685	49.3437701548355	49.408066509381	49.1077758575561	48.5268224605294	47.8572869339458	47.323482515143	47.0409097173649	47.0628349419119	47.2855535358781	47.4835738833457	47.3763626255871	46.8210856532444	45.8152138718387	44.5367729302291	43.2200998497278	42.0905868172844	41.2466438602508	40.672940984028	40.2838205254107	40.0034914724114	39.7380714525174	39.42483145697	39.0692858332214	38.6907098406452	38.2659223594734	37.7709628532701	37.1984024874311	36.5390277363057	35.8200792250143	35.1062817207175
	36.238696350149	37.0583235512523	37.7653691180881	38.3273936827519	38.715234620694	38.9157495242464	38.9266488816268	38.7640043043292	38.4577415741261	38.0482398072424	37.5690770825795	37.0314258983275	36.4431384174445	35.8300527277326	35.2194558305381	34.6323353286636	34.0725510056209	33.5459194169478	33.0750519649492	32.6863285241589	32.3955487338252	32.2111659830676	32.1200721751479	32.0896879948091	32.0758567522673	32.0455472692589	31.9921619578226	31.9185500569708	31.8138322313175	31.6670796952517	31.4705021173624	31.2106860634294	30.8860748092018	30.5150102595279	30.1270024395798	29.7430692234686	29.3809495925189	29.0309117431344	28.6561341754293	28.2039550975012	27.6441721868606	26.967203223945	26.2113081058369	25.4518453793984	24.7833020907041	24.2695014287935	23.924881369635	23.7305217670039	23.6706497030054
	46.4652585645888	47.0036288151632	47.4644949546758	47.8504684020079	48.1676788395225	48.4233450861603	48.6178479113334	48.7584065504846	48.8660885938116	48.9652982326951	49.0716457684877	49.1891005934373	49.3126942356159	49.4368548501061	49.5534166707202	49.6570207492136	49.7444483962161	49.8170679515901	49.8787734753061	49.9346054629669	49.9857854327836	50.028752898449	50.0563132163427	50.0612178711757	50.035395090768	49.9720576331421	49.8770112016656	49.7478775224914	49.5639681585403	49.3012529662165	48.9493700649971	48.5092484331767	48.0006031124723	47.4543974390229	46.9071847020532	46.3834479184426	45.8913979125337	45.4277350076144	44.9902983794087	44.5744025111777	44.1793720655214	43.8010898127074	43.4470118226563	43.139688259489	42.9062124797942	42.7600004511851	42.7013604216927	42.711094440928	42.75872681013
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	36.8513930369756	36.3444002104479	35.810363540972	35.3908399276709	35.2739085944836	35.5596633868483	36.2694182759817	37.2779505136951	38.3664798158164	39.2709093863402	39.8262848594755	39.9998743403809	39.8614269213215	39.4848262363246	38.9734900051745	38.397435454719	37.7675449858408	37.0629726761171	36.2837083019792	35.4285970080317	34.5061353856934	33.5375565781949	32.5485703474613	31.5594282934249	30.5878085972471	29.6501426641728	28.7350150823107	27.8577498051974	27.0870538641097	26.5094302686583	26.1743757648979	26.1067698722116	26.2586633897417	26.5191516723152	26.7435513156999	26.8334753238161	26.7582559888052	26.5483023178898	26.2432015034645	25.9051403636343	25.5770601228153	25.2684743368293	24.9604261512279	24.6342258705031	24.2623952920235	23.8285719701505	23.3295529421144	22.7819342457361	22.2135203960073
	40.8890113799399	41.3242349347239	41.8253370180688	42.3242190961704	42.7379514528397	43.0083868600247	43.1261790697643	43.1023373575187	42.9291881048844	42.603808697504	42.1308138723071	41.5087741230894	40.7547247322226	39.9132377733194	39.0372267746743	38.1627238941172	37.2967073050921	36.43383577084	35.5803993544969	34.7425223380432	33.9250315441897	33.1440928815967	32.3997673840629	31.6631689815749	30.8941098247085	30.0683969501834	29.1735589517152	28.2302905169818	27.2858073573328	26.4027879429461	25.6228233906587	24.9577598172808	24.3891870743926	23.8914804050115	23.4277712543984	22.9721287719696	22.5163330103697	22.0678878902861	21.6340233993659	21.2259304136585	20.8482252345765	20.5046797268701	20.1843954536855	19.8587397334536	19.4906416201211	19.0562587942799	18.5473659744801	17.9781834297581	17.3754726046708
	34.8335665643808	35.1530276472773	35.6298520064732	36.2920133527293	37.1667937822758	38.2250434590422	39.4048723631038	40.602785824559	41.7188782921746	42.6736642189731	43.4329401015774	44.0406706382123	44.5102800175684	44.7699835334968	44.7380341713382	44.389570753283	43.7543020703029	42.9222800818462	41.9994085556832	41.0871226154771	40.2408424029255	39.4345371169504	38.6526095528285	37.9584723175383	37.4356295610683	37.1230997296747	37.0516429246846	37.1421711107	37.218595866686	37.0863738313711	36.62184642593	35.7286443198107	34.3666692782569	32.5704387594806	30.5936763126049	28.8306499532464	27.5985638547289	26.9044887929675	26.5799853179608	26.3379960142877	26.0005097910395	25.5385061393292	25.0215740686459	24.5046360666904	24.0677464814566	23.7583153362931	23.5736295564786	23.4729653040882	23.4197307601263
	36.3648791714615	37.7330504605443	38.9921605891436	40.0818447186177	40.9468309129547	41.5621718954853	41.9224742209028	42.0560201093705	42.0162704695526	41.8694940149818	41.6620481234772	41.4165493044746	41.1287381238369	40.7863603897825	40.3685761189139	39.8698272598281	39.2876513547589	38.6526829288222	38.0305069229496	37.5024453368831	37.1216091306986	36.9024017434206	36.8209788424389	36.8431514716179	36.9204048610172	37.0167370209229	37.1191377853453	37.2286448620716	37.3411565218249	37.4556641123072	37.5677380508645	37.6774230729575	37.7700311861106	37.8091697249863	37.7489387422184	37.5591527688102	37.2361748577519	36.7973344931078	36.2607535241812	35.6491450738752	34.9805433571019	34.2543751029395	33.4792910523597	32.6921979461778	31.9416901088956	31.2647628831742	30.6763246150639	30.1715583533526	29.7432930573196
	42.5303217338165	42.6240215182054	42.6995751120633	42.7471272894227	42.7545319412842	42.7165374114336	42.6356281563668	42.5243413751223	42.4007507127712	42.2871662612691	42.2009148565393	42.1370415178497	42.0963512315477	42.1041280469958	42.1897403684112	42.367773780586	42.6505343396968	43.019350522427	43.4192476505518	43.7730883366618	44.0242123376421	44.1553231069833	44.1865797116217	44.1456653495089	44.0728804786802	43.9969218631427	43.9189226947533	43.8339566285859	43.7543072268854	43.6926769252436	43.6554920599602	43.6396544875325	43.637497226876	43.6426219970085	43.6472950253509	43.6421059373812	43.6304511400919	43.6026606023047	43.5240590633273	43.3527419055335	43.0630978101747	42.6477304477266	42.1221041441855	41.5134813667145	40.8607013174367	40.194136615033	39.528787061382	38.8646124785673	38.1998270198702
	42.4478342669284	42.6560109806591	42.8445088278191	42.9982256919024	43.0998474500874	43.139292798692	43.1140836920439	43.0308744553195	42.9004384083774	42.736965688154	42.5475831888772	42.3425679406565	42.1184732373968	41.8723407848322	41.5992930666223	41.2979378613148	40.9680690004964	40.6158989333182	40.2557964330699	39.9051278778252	39.5744359032942	39.2669351813992	38.9759540151675	38.6907926951712	38.3973323107304	38.0858825472879	37.7552585457163	37.408474375334	37.0457458010559	36.6680271089128	36.2764917012092	35.8718886221231	35.4550495976987	35.0271518601631	34.5897355378027	34.1447886585132	33.6917636169022	33.2329314087074	32.7750932700032	32.3261808907898	31.8911823204837	31.4712413868628	31.0641583620176	30.6641332294804	30.2632060123488	29.8558597013942	29.441836715497	29.0220836602905	28.5971516680814
	21.9407376883389	21.916553789801	21.9849903367722	22.0978442628291	22.1920585096645	22.2250613990375	22.1830433519128	22.0801795925797	21.9367412085596	21.7847422617003	21.6469443265828	21.5317089247745	21.4313190167814	21.3347469619861	21.2251083635243	21.0930890240794	20.93066945007	20.7489736181477	20.579698393705	20.4654307477447	20.4345790411185	20.4968885009508	20.636401559865	20.8229070398151	21.0136254635637	21.1755677770871	21.2968565363701	21.380861585335	21.4290888757587	21.4482701409615	21.441091454444	21.4091308065493	21.3425663903408	21.2195450063608	21.0113193703783	20.6981111632778	20.2758928400903	19.7558441345096	19.1554503324185	18.4988858056275	17.8084228884854	17.0881987851959	16.351441554774	15.6406691958584	15.0094117851164	14.4980220530073	14.1245990918597	13.885496300965	13.7710272698738
	42.7501578915544	42.9461048308735	43.1465500306282	43.3417324693902	43.5195618088226	43.6725810860716	43.7982248092804	43.9008396529877	43.9883661312346	44.0713169530315	44.156499447494	44.2451991628959	44.3344824120401	44.4215377547831	44.5023797980419	44.5743513027312	44.6363807048185	44.6893548195825	44.7348298156252	44.7749457815467	44.8119814267194	44.8428045565611	44.8664756936483	44.8800656105796	44.8800530325633	44.8638011577279	44.8309569626524	44.7813233582191	44.7129929366358	44.6240258283069	44.5135687544334	44.3822155518798	44.2315398286176	44.0630577213901	43.8784099137388	43.6790454403404	43.4653419591675	43.2385640152993	43.0018712033799	42.7590236049757	42.5127182037505	42.2644008172718	42.0139147061757	41.7604524399966	41.5026509318156	41.2398480697234	40.97199049818	40.698079962736	40.4222489926875
	40.5584370540407	41.1936418068698	41.7458505898789	42.1977751145304	42.5322865786894	42.7413606592575	42.830177800166	42.8094155902367	42.6857095145016	42.4685738419395	42.1718017346052	41.7964530769139	41.3608236361558	40.911630375045	40.4989145401164	40.1503074387315	39.8735318070763	39.6526660090338	39.4606082397047	39.2603242121439	39.0267506920821	38.7484553581088	38.4347151169049	38.1051952908228	37.7851277967443	37.4856589845748	37.2219093990483	36.9760229133699	36.6882409153129	36.2836310494193	35.7255079559281	35.0051511585031	34.1813648740963	33.3572815125243	32.6386696695661	32.0744322913489	31.6715608289473	31.3861895404558	31.1482095220828	30.8680668412516	30.4879830065772	29.9960579047098	29.4206743464801	28.7951954587351	28.163023918199	27.5520054174913	26.9677376509764	26.400304435943	25.8429013207483
	43.0771525481058	43.2170746206634	43.3231178095922	43.4073945456933	43.4866325111919	43.5723720789718	43.6669488872595	43.767143316063	43.8704339886294	43.9732961414031	44.0726837547916	44.1681626661128	44.2601941314789	44.3488016466562	44.4339274356043	44.5142707515056	44.5918333507649	44.6656568921267	44.7286322931263	44.7732789099275	44.7952710940997	44.7894984422599	44.761353174194	44.728613514718	44.7132485216509	44.7273141944864	44.7719476136869	44.8353370710875	44.8996116697173	44.9419711686466	44.9448524249268	44.9093792366991	44.8359901519485	44.707290105026	44.5036623401868	44.2157330299987	43.8396576680056	43.3919717115106	42.9074412509751	42.4279141690202	41.9800690487789	41.5692925131411	41.1869881602623	40.8270164707541	40.4796380731503	40.1379539174572	39.8045909311678	39.4819545448952	39.1632689706591
	43.2453573108774	43.6283761498149	43.9998898092189	44.3633320058822	44.7263462779816	45.0877464764743	45.4563405589025	45.8147967834539	46.1112225955099	46.2841074176891	46.3010447572291	46.1540922565867	45.8771577253632	45.5304041870307	45.1916984271108	44.9137172215055	44.7115307502713	44.5703379519913	44.4746013666789	44.4009843494928	44.3351118138931	44.270363366237	44.215522939987	44.1874539435204	44.2071515489751	44.2849640774073	44.4292213153409	44.6271601132967	44.8448245723449	45.0354342018652	45.1641947539271	45.2161521411025	45.1953152478359	45.1080308252548	44.9782453894969	44.836059883842	44.6982150015074	44.569285699214	44.4539595775828	44.3455908814385	44.2348837481018	44.116589929843	43.9878829910431	43.8440730512	43.6841749450948	43.5111699220988	43.328515343765	43.1375965391204	42.9381445744892
	43.291198543518	43.2530958098764	43.2013820362847	43.1785408124614	43.2342027667769	43.3950545780766	43.6620677363754	44.0091795219577	44.3995785367897	44.7896851776207	45.1504513540622	45.4778027362907	45.7767962970814	46.0438126800796	46.2768240070896	46.4760746147607	46.6217484890458	46.7147052605951	46.7915757152108	46.8957294031437	47.0421155729677	47.2394219642753	47.4457943480009	47.5748403804647	47.5295482024995	47.2569880884752	46.7493260913044	46.0417131909592	45.1797213463452	44.2280755009136	43.236003165472	42.2284897943068	41.2001411729131	40.1379105112676	39.0197870592409	37.8406148075685	36.5993304841023	35.3330409071386	34.1169071057687	33.0422513058224	32.1676463024012	31.5062513137921	31.0312365559349	30.7080041887057	30.4872903992969	30.3306593872661	30.22816591015	30.1761956364043	30.1516336592057
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	26.9091238889897	27.0460699794909	27.2018509307197	27.3533362538712	27.4722203095291	27.538490584198	27.5469140819059	27.5006452864496	27.3997562158612	27.2468907256277	27.0457328774432	26.7997843413004	26.5128647159039	26.1894977929644	25.8349650982068	25.4555824006944	25.0484233408318	24.6219364770281	24.2069188566885	23.8431373242884	23.5574844046825	23.3624639044665	23.2463360329971	23.1826541005006	23.1332107221593	23.0702649755089	22.9850116638031	22.8837317319974	22.7715884872352	22.6577426171628	22.5465939793648	22.4357774209819	22.3162567599545	22.1774557687977	22.0062355014193	21.7922068334414	21.5364248405106	21.23848186815	20.8855695603424	20.4623310267675	19.9618146496577	19.3799562691007	18.7318255739607	18.0531275279555	17.3896260260133	16.7747566949859	16.2183752321331	15.7183613938015	15.2813439201968
	39.5304713193789	39.8426854147244	40.1286071347765	40.3690533735699	40.5438686964056	40.6408055797783	40.6543130506519	40.5935566611579	40.4848828811678	40.3679558372459	40.2676784698169	40.187573091454	40.1189287482336	40.0391187824239	39.9180852740626	39.7380945985058	39.4974678061324	39.209259985682	38.8862330632889	38.5456832265354	38.2011578907357	37.8530366450889	37.5012558141347	37.1591376893767	36.8404482997118	36.5521393379018	36.2953044088881	36.0638543440934	35.8515189517967	35.6487426311838	35.4520363835011	35.2498047996266	35.0459300058209	34.8289328255744	34.5873855001025	34.3142433924795	34.0093765594767	33.6743035042695	33.3100245713536	32.917098551294	32.5011134504259	32.0604310755986	31.6004447893217	31.1361487264845	30.6887231796339	30.2723145982463	29.8910554081821	29.5403728516685	29.2201859546744
	42.0726722102959	42.3952431076164	42.7166413372161	43.0239599920363	43.3026543417691	43.5433727524121	43.7439348205527	43.9075933364904	44.038012585221	44.1407045361578	44.2201951259485	44.2768459572172	44.311657754488	44.330195887195	44.338878995641	44.3420020266089	44.3414742862241	44.3363082132308	44.3242086991278	44.3017349975172	44.2683536044772	44.2206928658095	44.16150027665	44.0933877723276	44.0193439938323	43.9403958830129	43.8556852414742	43.7631091303194	43.6599011751111	43.5423909243109	43.4079619497523	43.2574592368137	43.0907629572947	42.9041149207448	42.69206351724	42.4515241471851	42.181656007465	41.887746467365	41.5766421901729	41.2572000933163	40.9439760068772	40.6229728226507	40.3024275039908	39.9810028735301	39.6598052278117	39.3392306253717	39.0191125723738	38.698277863921	38.3831672235901
	39.8014786072021	40.1269389974181	40.4362988308627	40.7043071204355	40.904884291893	41.018245374869	41.0328010437898	40.9656174517438	40.8514182369956	40.7352725134821	40.6449431653183	40.5912255089466	40.5572325716336	40.5077749705509	40.3976366473695	40.1989356873343	39.9103081254246	39.5489496081226	39.1299487692259	38.6750032259696	38.2035353537736	37.7167754908334	37.2164132529368	36.7276067453779	36.2788892187437	35.8845570780389	35.5474933933416	35.2587539099576	35.0100136147755	34.7870812907252	34.5858388105396	34.3880564389961	34.1975618803063	34.0012190869526	33.781670148768	33.5274706301863	33.2374394317406	32.9127897274866	32.5508557404115	32.1470718851984	31.7072004789319	31.223158467206	30.7047880642998	30.1747340006729	29.661866747903	29.1867652309721	28.7550824920134	28.3629160358417	28.0079957461766
	21.3374437105496	21.6680748035964	21.9607097907762	22.2035885395672	22.3916569540092	22.5209272861646	22.5929402309674	22.6039042727075	22.5404828741202	22.3837494026825	22.1272229822161	21.7640069943747	21.3142832427445	20.8300845166614	20.3733592774635	19.9832291422904	19.6780533717196	19.4429738940542	19.2426852152475	19.0282888968897	18.7657555237012	18.4435992008606	18.0822932382389	17.720644666155	17.4128944884475	17.1996858604479	17.0931033921391	17.079041135027	17.1375796586972	17.2367874152496	17.3532184570261	17.4786872097386	17.6149318898492	17.7598332112129	17.9144604064732	18.077016274112	18.2452998240376	18.4116606469831	18.5624550737847	18.6795786076619	18.7520455549376	18.7769106110022	18.7579683965856	18.6991708477299	18.6062637235641	18.485323242097	18.3394283012398	18.1706421129966	17.9861174688517
	41.170165925102	41.9272603670972	42.5163532857104	42.8748256076198	42.9592025753093	42.753543566641	42.3039584330348	41.6568778441968	40.8155945549179	39.7631986325668	38.4875299788524	36.9492079173262	35.1609150833657	33.2207097620503	31.2920581637935	29.5177031904086	27.9445764306328	26.5641705856345	25.4269664282628	24.5878479545345	24.0830529456577	23.955160417472	24.1607910544036	24.5525904912305	24.9535544505765	25.2586747491639	25.4261345872466	25.4885808090491	25.5041415998458	25.5506424624398	25.6680066209506	25.8609461187788	26.0828545787855	26.259581042578	26.2966178189692	26.1282527655337	25.7508632952254	25.1857035457438	24.4333117007419	23.5048374430296	22.4228733176381	21.1993435341233	19.8694123775878	18.5119637547784	17.2184429644586	16.056633799813	15.0471279174901	14.1869267440818	13.4794689249646
	37.2297146338257	37.1842907008679	37.0529978210445	36.8214227278148	36.4741512474947	36.0065046621471	35.4068795472163	34.6961946317669	33.9400172542734	33.2248719469421	32.6104231719015	32.1225487139075	31.7404330511052	31.4210003271691	31.1017565357746	30.7412453695663	30.3305612181318	29.8908785382886	29.4467928417203	29.0302469326836	28.6603745201495	28.3368277222877	28.0469340572633	27.7823214223756	27.5330994295987	27.2925883624556	27.0603120312781	26.8362935743456	26.6146000518284	26.3866714340113	26.1450368685872	25.8874824074238	25.6119686977294	25.3106182736239	24.9750334124859	24.6009268204984	24.1858450345654	23.7339140584602	23.2564856382544	22.7681657445603	22.2798707903206	21.7969673172822	21.3188050049706	20.8427124158841	20.3636771615998	19.8799987422076	19.391086429434	18.9038236407241	18.4328250729177
	42.6013259745164	43.0860285422336	43.5609395352087	43.9983067477415	44.3651675869483	44.6429590938079	44.8253607382281	44.9284655793316	44.9838400173789	45.0318044430561	45.0988796989759	45.1874025413222	45.2876395243658	45.3975665391524	45.5122317031708	45.6259977194983	45.7444552542935	45.8631736383835	45.9571407439643	45.9963005867549	45.9642251046751	45.856530308304	45.6889311914811	45.4898823746348	45.2958413290142	45.1315769020574	45.0057957401434	44.911549861976	44.8384403338618	44.7712673281981	44.7015386056541	44.6204341597504	44.5356819302914	44.4723884597168	44.4614490770935	44.5170935262786	44.6424321953807	44.8137955065587	44.987352939868	45.1100286877706	45.1482000884823	45.0955191622576	44.9656011767411	44.7716688689797	44.5326772561996	44.2623167670787	43.9640461651305	43.6364063438456	43.2819863011441
	45.6969464430994	45.6902066363562	45.6740251632887	45.6693466500648	45.7025655355598	45.7883130230879	45.9317565322785	46.1192929863115	46.3237867564083	46.5106758132024	46.6576032702599	46.7598370324794	46.8276105146366	46.8727475296856	46.9114966147273	46.9549523663129	46.9979638853212	47.0371252544027	47.0841508135052	47.152829603718	47.248344955346	47.3740893868115	47.5165733077847	47.6428388571524	47.7103337808885	47.69343529166	47.603417053919	47.4613772437081	47.2690063625608	47.0230337407092	46.7227763323268	46.3506517895936	45.9181505581988	45.4865720112981	45.1483265574	44.9721614612574	44.9755826078389	45.1227895032286	45.3655899328726	45.6421844792002	45.9093240707739	46.1621727304182	46.4007798220099	46.5996178374731	46.7311647669738	46.7784297821776	46.7370695349088	46.6150314494984	46.4245424952298
	45.2790739527087	45.6496188025658	45.9338234285051	46.1193318286604	46.1951338631477	46.157707605761	46.0067657625325	45.7529553753113	45.4173886531079	45.0264485306745	44.5998412348117	44.1516640555764	43.6839062937487	43.1906043590404	42.6611583542113	42.094020475782	41.4821903587104	40.844809313779	40.2343600342602	39.7158115119972	39.3276579599535	39.0836186189294	38.9551913402339	38.8873909884529	38.8094093972266	38.6751653852187	38.4700019416219	38.21166646938	37.9261113980637	37.6484599227725	37.3979366571065	37.1819405260159	36.982346916814	36.7636919297857	36.4818889311556	36.1122090602134	35.6477809450687	35.1105615207827	34.5390915132721	33.9813924090075	33.4675124599251	33.0053015443995	32.5812782985073	32.1772918870487	31.7684602061238	31.3392459363533	30.8864559764569	30.4194289630159	29.9505821777713
	39.7803067989157	40.3946281197424	41.0025669305172	41.5487635720094	41.9623356049457	42.2011019283747	42.2569157163927	42.1631377382577	41.9855088695712	41.7997354073799	41.667215815486	41.6045646960357	41.6008549627918	41.6438545237055	41.7153879510145	41.8051114720428	41.903857196532	42.0275665202612	42.2007465837427	42.4619892560638	42.8266012220269	43.2871124108399	43.8168658595526	44.385745400621	44.9575156787376	45.5017838176421	46.003133555953	46.4450232368112	46.8052918841955	47.0593586318501	47.1863922347395	47.1929224566203	47.0732889845944	46.7997486669157	46.3386803373574	45.6722078760491	44.7994159085976	43.746083566063	42.545313692653	41.2467615854979	39.8893655784432	38.4905046120456	37.058097913666	35.6156726256394	34.1878415490027	32.7984569294538	31.4580670401236	30.1825618515563	29.0084419309893
	40.2885972998057	40.3985259652823	40.5217629149416	40.668251717581	40.851211569773	41.0761347713988	41.3485481790109	41.6558251519647	41.964609271505	42.232772535695	42.4337832086281	42.5584622740101	42.6217877358377	42.6515178749578	42.6852228553204	42.7484424889381	42.8471932854033	42.9727048360402	43.1170217286252	43.2675081750371	43.4155202169265	43.5597935907402	43.7039767229854	43.8501784875175	44.001625781208	44.1599743229844	44.3220152290121	44.4849023906616	44.6504445211057	44.8212593755476	44.9971050207871	45.1781924218728	45.3578579620805	45.5213011386891	45.6505139544632	45.7335952116276	45.7706060335767	45.7658610640603	45.7183592964817	45.6280883720159	45.4980867033605	45.3273704873515	45.1240563192812	44.9104700399386	44.7130618614235	44.5485219701161	44.4196825888809	44.3189952055094	44.2386380262711
	36.8588562216147	36.423425539514	35.9485175019156	35.3880900154359	34.6744383490073	33.7706025265657	32.6553965847772	31.3744609779318	30.0314937259881	28.7670057362386	27.6793884555795	26.8150456118068	26.1500352685209	25.6318108045444	25.172518639945	24.7164899316946	24.2424933460603	23.7826684564104	23.3888760146407	23.1319186748684	23.048135601587	23.1490022375451	23.3933525082124	23.7018298639256	23.9720679574033	24.132884190963	24.1612726054538	24.0770191008738	23.9061502026328	23.6917171037884	23.4640098187856	23.2270873607532	22.9700560988821	22.6915232134245	22.3872550197105	22.0543430787353	21.6956976640256	21.313604951437	20.9042354018015	20.4616586395452	19.9868348649802	19.480774879005	18.95141151267	18.4144438852542	17.8841492365745	17.3735486851845	16.8863883004101	16.4230593078859	15.9868845699813
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	43.6197349954498	43.750197774975	43.8806084818685	44.0158868562487	44.1623098982328	44.322744316108	44.4976170013282	44.6789315458093	44.8506061091974	44.9941757864926	45.0980750391935	45.1598638736815	45.1860350061718	45.186990622908	45.1760326034623	45.162261929026	45.1478972974163	45.1305894823643	45.1091565875711	45.082112562005	45.0483231940186	45.0058307866812	44.9558932508147	44.9038727803743	44.856085241412	44.8154224164599	44.7825563735513	44.7518105631753	44.7111973756383	44.6462719546128	44.5476788851083	44.4137788390658	44.2485489660981	44.0552911830277	43.8396172948818	43.6055165120839	43.3557956394682	43.0912040510284	42.8120420399696	42.5180579402023	42.210627789257	41.8902737367361	41.561218140694	41.2318198938998	40.9116092495974	40.6060650725038	40.3147322995737	40.0341836775329	39.7620371012607
	46.5708832573428	46.6697292553787	46.757611251278	46.7935395470658	46.7263122272493	46.523688574543	46.180749605546	45.7139470685845	45.1424280350438	44.4922615093133	43.7860935904076	43.0293103345583	42.2239770583211	41.3851862984243	40.530482895895	39.675149824784	38.829907486135	38.0005443380708	37.1905118378089	36.398518515408	35.6220012732458	34.8623356068654	34.1216373370116	33.397824136384	32.6894788351858	31.9977278298511	31.3183881741591	30.655069212077	30.0270499204499	29.461141382277	28.9749602615213	28.5786879462159	28.2623594021601	27.9985646852462	27.7503574225345	27.4908751281558	27.2075089959536	26.9053921649171	26.5975467414587	26.3037605076491	26.0355891305931	25.8008853809424	25.5871463465447	25.3617136060214	25.081933155429	24.7211504062963	24.2679458745467	23.7407632634149	23.1792467573058
	42.8338966078358	43.4540832538926	44.0542788025401	44.6104550691244	45.0824742268041	45.4787846867902	45.7786353715244	46.0195062480951	46.2449663443167	46.5167011360739	46.8601798855274	47.274106628996	47.7339950869805	48.1920768307323	48.5910953542981	48.9127789944035	49.144925992972	49.305085093716	49.388917454416	49.42417331813	49.4121715076072	49.3601875162775	49.2691386571971	49.1258055917081	48.9228434552325	48.6560126492927	48.326609390288	47.9548839636933	47.5787641848043	47.2382239426457	46.954270736304	46.7288955229984	46.5412322914758	46.3783557352566	46.2267813543383	46.0671482515186	45.8975626211041	45.7103085026336	45.4873149723137	45.2053265623583	44.8536736397168	44.4312249289722	43.9457005608511	43.3914361731274	42.7680864252192	42.0771166379118	41.3239121106919	40.5165307185005	39.6629243164708
	45.8704603924591	46.1201509998159	46.365632523242	46.5842977715196	46.748361979001	46.8423453133545	46.8601043317651	46.8148299675693	46.7330020357347	46.6476551413145	46.5782268219467	46.5289172105927	46.4863048795465	46.4303595332361	46.3355401223169	46.1854711819808	45.976549768151	45.7153323594992	45.4082333443269	45.0638218144922	44.6864664281863	44.2813854174615	43.8442619573478	43.3602141940933	42.8114324009339	42.1910387396983	41.497391835682	40.7474895874392	39.9758255550395	39.2248604435206	38.5229857272748	37.8795517988528	37.2861832136192	36.7304130923815	36.1932330270936	35.6613953255738	35.131836787841	34.6088583591426	34.0948604484118	33.5933658528073	33.1049912008483	32.629572849045	32.161745144537	31.6911712654868	31.2056650849958	30.6980394740721	30.1658238445679	29.6138002596766	29.0514649807749
	45.3810571698029	45.8583616261861	46.3468681411447	46.7954489645576	47.0750212959845	47.1501598667458	46.9930431252422	46.6661931565957	46.2961060310285	46.0340414214953	45.9577377657669	46.0938883968113	46.3904451543512	46.7855881314023	47.1666399871939	47.4485270826734	47.6056600549852	47.6664498267802	47.6228871329512	47.4929473639444	47.2874804682146	47.007368923289	46.6660687286985	46.2887888818636	45.9101285594137	45.5514186673514	45.2083143818794	44.870100298786	44.5638473574409	44.3064072180835	44.1093102696417	43.9895082232845	43.9294034034825	43.858229019109	43.6907608130711	43.3767299585929	42.8864030250512	42.2417386954226	41.5078207046534	40.7827741201485	40.1460331095528	39.6267919393024	39.2036540193284	38.8559083397192	38.5434646883837	38.2333318100809	37.9245334571983	37.6210021612394	37.3047140334194
	44.0266452011278	44.2978625786404	44.523624835623	44.7112267839036	44.8705939463227	45.0082330966697	45.1254062382773	45.2199607009717	45.290737964408	45.336122201531	45.3557300598482	45.3522531870908	45.3289935884307	45.284827167589	45.2180562641749	45.1291356967422	45.0179972736909	44.8898151130801	44.7562644652225	44.6313943838002	44.5240094346178	44.4264701555725	44.3333694572602	44.2542508050384	44.2007330714575	44.1710369864511	44.1703702986632	44.179135878413	44.1456023481378	44.0094402337493	43.7548114866878	43.3346203686562	42.7887058980058	42.140488796988	41.4181413172269	40.6443566128018	39.8264632258368	38.9695333957626	38.0922166186448	37.2177612911894	36.3660943169003	35.5436922816539	34.7571375820451	34.0235372072479	33.3577382932965	32.7710992007817	32.2656864989343	31.83966279927	31.4836964890659
	39.1456539645181	39.4517000358524	39.7298697579886	39.9597249195053	40.1179153412317	40.1918776779118	40.1758979160968	40.0792720612479	39.9323063966929	39.7800319439973	39.650247079521	39.5473490950674	39.4603237611316	39.3624424525776	39.2178742978731	39.0051187607019	38.722060163084	38.3837111901617	38.0054590895508	37.6078310167738	37.2057681146957	36.8019725555917	36.3957212147831	36.0012570712356	35.633638981338	35.3012800100137	35.006283101887	34.7417035732825	34.5005680741828	34.2719445111197	34.0532248331226	33.8291003544035	33.6041615479003	33.3669703123139	33.1053521671088	32.8115914148009	32.4856467102451	32.1288085152335	31.7406983401677	31.3201055804351	30.8714902401752	30.3919559213839	29.8882661634053	29.3783392039896	28.887625692695	28.4331589722258	28.0199478641232	27.6439306364555	27.3032714553635
	31.7866822040952	32.4983996309317	33.1776058965116	33.7527630931699	34.1386356746016	34.2837064461458	34.1739080444521	33.8412366644894	33.3395039404143	32.7436741625971	32.1115782134989	31.4616570475543	30.7952464323494	30.1313028685349	29.4855815347959	28.8715180367377	28.2917463341357	27.7570713840423	27.296804236734	26.9466386927784	26.7292652016285	26.6511788506842	26.6956608695376	26.8313451872766	27.0151997671708	27.2124576156181	27.4161126769571	27.6202078298706	27.793634848937	27.9006194941588	27.9159935379645	27.8249338749345	27.6302214988265	27.3466996603866	26.9987809438388	26.6032843560933	26.1687665917221	25.6876766248549	25.141475825162	24.5028283149625	23.7553889914705	22.8865363805073	21.9131635722789	20.8892811001853	19.8975861078611	19.0097754147083	18.2603699371718	17.652005333377	17.1875602057813
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	42.9487533802704	43.0441589070061	43.1404127023745	43.2343552695425	43.3237559678509	43.4060679425242	43.4793556900315	43.5431631786412	43.5993599191477	43.6504088081739	43.6969295388335	43.7397037147139	43.7752100887756	43.7948096979429	43.7881466993777	43.749404103087	43.6787763163198	43.5807756426671	43.4594076013063	43.3195385419796	43.166132098957	42.9928284986681	42.8009403691439	42.609465030176	42.4420491492118	42.3104445399017	42.2204991371905	42.1539568591841	42.0708656159743	41.9220894058264	41.6736760405762	41.3088024805439	40.8311851814089	40.2542749882809	39.6083012267557	38.9199729319174	38.2146261114169	37.486628071099	36.7021429432201	35.8105079037667	34.7841973684045	33.6150173424548	32.3453779613574	31.0552491169093	29.8458834866766	28.7861638476044	27.8949546200177	27.1527208436995	26.5399524007484
	36.3947852248036	36.3933929638262	36.2455538421204	35.9805333062963	35.6423503286091	35.261237113809	34.8348389523086	34.3528379169105	33.8272085286851	33.2772982154075	32.7212580027645	32.1779699242372	31.651540934014	31.1363110045345	30.6165500047943	30.0840256539629	29.534605775669	28.9821887026095	28.4539204380397	27.9816473718485	27.5859794329836	27.2644179585054	27.0049116831601	26.8057512316765	26.6652667967042	26.5760526114765	26.5482749528145	26.5679513395307	26.5772745468851	26.5004780040884	26.2874092347952	25.9212374085177	25.428683034969	24.857105645378	24.2723436089675	23.7224521991747	23.217815529382	22.7512323079123	22.3264344849461	21.9389939188225	21.5818887482819	21.2511216900637	20.9434586304236	20.6548831223998	20.3851930718482	20.1369154636667	19.9167700603948	19.7254480713887	19.5544936273596
	44.8210945141144	44.9572465436621	45.1254058736807	45.3349356470934	45.5962453805718	45.9093297305412	46.2633790082294	46.635351622541	46.9968891881447	47.315948569468	47.5656589045261	47.7658478482036	47.9074610013341	47.9115113248261	47.6828661414582	47.1759743357337	46.3633913778661	45.3141779132201	44.192292991436	43.2038351621439	42.4789747185556	42.0525386185558	41.8580138379519	41.7964362132776	41.7353401370474	41.5866072166111	41.3329829806658	41.0041532577198	40.6194604286938	40.2103551525609	39.7964699972908	39.3818076822528	38.9520607216207	38.4877327578461	37.9636539189863	37.3656880801006	36.6915498842714	35.9560091415945	35.1833122170838	34.4049672133617	33.6445426467407	32.9086229245083	32.196797186651	31.5165964505147	30.8752681018275	30.2787595510358	29.7312099850099	29.2342715508839	28.7875547181235
	42.3016193233278	42.4133237679983	42.5334021773318	42.6588019935383	42.7858663100824	42.9116023984324	43.0345453805913	43.1537508732388	43.2677819713067	43.375280391616	43.475007664932	43.5702711615908	43.6608028367335	43.73876431072	43.7942130203177	43.8230844499599	43.8247121212927	43.8090015021626	43.7949509729096	43.8054273018274	43.855868511995	43.9342953815621	44.0346959389087	44.1807182950735	44.4025528155264	44.7138050069432	45.1459962954333	45.675701416295	46.1906814816126	46.5265960103965	46.5697197779288	46.2803254854483	45.738466746297	45.0876791751998	44.4961241416325	44.0620711548792	43.7947759113904	43.65281399067	43.6088070922355	43.6224818976987	43.6637626655402	43.7294572313533	43.8211202368997	43.920781979849	44.0089265664068	44.0713255720269	44.1011871328055	44.0969517080562	44.0570471575271
	40.4332146751262	40.9498165901676	41.4259582420282	41.8274461276636	42.1129750424554	42.2603748997274	42.2605349258835	42.1379572346429	41.9444844466471	41.7460275212471	41.5861911039778	41.4768164836319	41.4023525968548	41.3438197101698	41.2735587043357	41.1733146524399	41.0381637659837	40.87561726088	40.6947597333494	40.5082416857978	40.322457182585	40.1415567220426	39.9562810297158	39.7444940743155	39.4781449428339	39.1398801045836	38.7236057397959	38.2395820160593	37.7067751886465	37.1511114111652	36.5903408212717	36.0356512011965	35.4818322236197	34.9117979513309	34.3018656143292	33.6402521053673	32.9216425795449	32.1647429978933	31.409270986915	30.7050938926975	30.0846180072057	29.5575879040027	29.1107612691458	28.7246864498281	28.3711720195908	28.0305113481065	27.698014704497	27.3797428939052	27.0796722112244
	41.6518515936371	41.8482523057379	42.0365741641015	42.2121276602306	42.370366361328	42.5097631206817	42.6327515781656	42.7477664932936	42.8633786740484	42.9909019686462	43.1386546059925	43.2976423030103	43.4688341004439	43.6768193660696	43.9530633705754	44.3112496425381	44.7487453154674	45.2400303196193	45.7486642308473	46.2268583874481	46.6362318454416	46.9862083422287	47.2705715277141	47.4219758664063	47.3609243837098	47.0539956765939	46.492762432277	45.7481252013066	44.953301811451	44.2496212132313	43.7127045932061	43.3507875587047	43.116787326859	42.9548116894561	42.7921122314042	42.580608527182	42.3131324383481	42.0071217530722	41.6720574775134	41.322501145942	40.9668985201182	40.6083161280204	40.2402146150398	39.8511226793162	39.427233328886	38.9626531025685	38.4554432049588	37.9177774202938	37.3734362198366
	40.1513231671153	40.33579826581	40.5805777990589	40.8532458441347	41.1123106807103	41.3296639762148	41.4978368735314	41.6256151662432	41.7223372687448	41.8025972342038	41.87682527959	41.945249478826	42.0051781255924	42.0599872413661	42.1131955873952	42.1671046329488	42.2222527653893	42.2778342166273	42.332732900467	42.3852862524176	42.4339094001718	42.4782695752786	42.5175071160795	42.5491394320663	42.5702394961017	42.5787741518766	42.5730615078219	42.553088349834	42.5203698680446	42.4771543987803	42.4244568730649	42.3605254211247	42.2829239657384	42.1907906387144	42.0831517436967	41.9583098491506	41.8151258502916	41.650455343313	41.4583276452329	41.2317100261033	40.9653485406452	40.6608596571086	40.3184907004908	39.9311698341334	39.4905348973845	38.9929416930165	38.4400466051965	37.8398612296247	37.203635353112
	29.9912742038984	29.7334654556976	29.374346103535	28.9668975016612	28.5809703688986	28.2622718973167	28.0242900529999	27.8453516370254	27.6922774130864	27.5178137581509	27.2883495094997	27.0001680504133	26.6629484618025	26.2739703059536	25.8328183335258	25.341163282315	24.7999934377072	24.2146364687067	23.5972675579164	22.9633408098684	22.3266139017575	21.6901733466775	21.0605780961606	20.459315255065	19.9130290548084	19.4416945676961	19.0531885131108	18.7450145784249	18.5128453043261	18.3474726779819	18.2398847782851	18.1885947574551	18.1896920302266	18.2281663545444	18.2855575254308	18.347246198978	18.4064830431418	18.4609709230716	18.5063296078738	18.5394905551696	18.5578209800455	18.5590836056821	18.5409258466177	18.5010824623285	18.437557492857	18.3496935309031	18.2362706896913	18.0993926297579	17.9458722086436
	41.3843833356862	41.3393417958194	41.2308554351886	41.0388160126654	40.7334538375973	40.2917034029785	39.7210882526723	39.046438485326	38.3010837668185	37.5203187250996	36.7315889401617	35.9392093485828	35.1414266447429	34.3520498564184	33.5882260196718	32.8652226233454	32.1900602068155	31.5645944618952	30.9904490528204	30.4629758750523	29.9804215133019	29.5507599582208	29.1708862549857	28.8186247848247	28.45747487821	28.0706868482422	27.6379666920649	27.1760081839229	26.7386774807228	26.3979042659385	26.1960467507397	26.1535088177253	26.2393811943033	26.378079740303	26.4707569554901	26.4431297269514	26.2643751191308	25.9513251797558	25.5406338146818	25.097573578724	24.678271939778	24.3061946313934	23.9671978957141	23.6377998540843	23.276634326697	22.8606979849934	22.3822190258116	21.8659559849258	21.3456387353843
	37.9126443854723	38.2321909561461	38.542129735315	38.819286919095	39.0513459564918	39.2286971946653	39.3473720107422	39.4067532467533	39.4215486783896	39.4021899388626	39.3549244690043	39.285095360143	39.1921502212988	39.0692351388378	38.9144338252405	38.7218628317898	38.4887064274879	38.2184692830623	37.9082220467078	37.5602040525521	37.1810143079359	36.7749491887423	36.3420797680264	35.8838224028245	35.3977548106522	34.8838706354928	34.341971271529	33.7832717333913	33.2362155770379	32.7300096770725	32.2883114605559	31.9119159145436	31.5936776963176	31.3237221494102	31.091835110616	30.8840056554817	30.7044263190917	30.5421448357736	30.3654835602581	30.130778747387	29.8129777199545	29.4027802473864	28.9143138615856	28.3792764996633	27.8415485032636	27.3280395120601	26.8511458376974	26.4013855098759	25.9667812932641
	32.8836424957842	32.9590266403165	32.9392792629146	32.8522189307612	32.7346036937887	32.610300440943	32.484660484644	32.3480794760762	32.19004491838	31.996237368579	31.757836314906	31.4793232775085	31.1679696883667	30.8210744149897	30.4321548983657	29.9954785884893	29.5066959640223	28.9686126229768	28.3912345450541	27.7939436737868	27.1970203194412	26.6108310700054	26.0420882233913	25.5039310955572	25.0065005540472	24.5556114506048	24.1513903208222	23.7948804748966	23.4924115731066	23.2527236445666	23.0809059997495	22.9785709337545	22.9364246276827	22.9344260179534	22.9473424331716	22.9556874541763	22.9555626324232	22.9447026996891	22.909268703162	22.8340587880707	22.7098074789805	22.5331816477481	22.3103556035952	22.0542249809686	21.7819623438273	21.5064192856389	21.2284965077479	20.9491086901459	20.6804247276303
	47.4108181334584	47.8866706259209	48.3672443843215	48.7920378842604	49.0882729577414	49.214589892556	49.1661398002424	48.9780528775927	48.7007318666475	48.3974953856941	48.1129567275637	47.8543547827802	47.6162965930073	47.4109753149672	47.2488535123634	47.1346830828613	47.0683648472733	47.0435516912864	47.0502067143428	47.0754818253298	47.1079475412378	47.1450917291254	47.1807416946245	47.1978095913947	47.1765595774277	47.1036884104676	46.9737266842604	46.7890916237375	46.5557588296262	46.2834167694324	45.9794565870441	45.6495783359581	45.2921662573219	44.8992867540095	44.4591467319009	43.9651005870223	43.4142100903583	42.8148595715021	42.1841074657628	41.5437380702766	40.9088841725228	40.2856104137344	39.6694269986686	39.0523478347532	38.423016842833	37.7757910960813	37.1109191254795	36.436991749676	35.7674917178739
	46.2954239558934	46.2074245195815	46.1698898611019	46.1883057528101	46.2689648054495	46.4113522489681	46.6146573285484	46.8647807299315	47.1332958759193	47.3868248017785	47.6036433164036	47.7798033661278	47.9220794294096	48.0344182828664	48.1235771290948	48.1956119095488	48.2488187163658	48.285190883035	48.3173596999112	48.3602558641921	48.4227849242652	48.5056692541388	48.6030949933668	48.7082599692491	48.8121653316979	48.9077268143714	48.9960343663571	49.0761809511859	49.1378991764335	49.1694227349085	49.1648726256158	49.1249354915875	49.0574351416733	48.9727496460997	48.8835789504108	48.7996765366284	48.7252979348911	48.6623576626039	48.6146535743501	48.5853631361308	48.577478509291	48.5859261329854	48.6124780004981	48.6721361153901	48.7824021977864	48.9493727453235	49.1720849161242	49.4324519156476	49.6995610609373
	42.5733034018534	42.7153380611692	42.8760676485348	43.0377568177006	43.1780393930807	43.2834516176133	43.3504836076289	43.3883091207366	43.4119217467881	43.4410115686455	43.4888637404903	43.5594058244453	43.6486507338577	43.7518672926342	43.8616264893063	43.9732398504218	44.0805462942149	44.1862339207807	44.3034642184656	44.449013322148	44.6307414573881	44.8501604710343	45.0939366245655	45.3374254569013	45.5496830961491	45.7096064775274	45.8136405873721	45.8678332181829	45.8741152927732	45.8369058280205	45.760664121885	45.6471915549751	45.4994332187702	45.32448253992	45.130630763125	44.924885058833	44.7092297200222	44.4865879747133	44.2652002297779	44.0541841490261	43.8593176029955	43.6811407298687	43.5171252436808	43.3653443706811	43.2227900332897	43.0860696880274	42.9538426417056	42.8227781747513	42.6852712078757
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	25.8866383058578	25.7184933766716	25.4781205767438	25.2060094606801	24.9559797192665	24.7649678310589	24.6449461204772	24.5817362799618	24.5530060378349	24.5257501883171	24.4750647537269	24.39739336135	24.2970000744689	24.1669952855601	24.0006834949274	23.793555380764	23.5454419925177	23.257764859188	22.9308917818166	22.5661101448165	22.1676459955537	21.7368486927193	21.2823584206987	20.8253375910484	20.3926776976776	20.0054905889379	19.6688182269457	19.3836446965493	19.160762245081	19.0109797953572	18.9394752073861	18.9496140805194	19.0330865858868	19.1681713750525	19.3255959342898	19.4821094957221	19.6311887631063	19.77101129494	19.8898480193241	19.9757148212047	20.0203346996105	20.0184186477946	19.9708948853182	19.8846062727139	19.7702718862448	19.6367925026917	19.4872026275236	19.3226383500864	19.1479345157599
	46.196194425378	46.5165714325184	46.8254583184547	47.1102441843664	47.3562637369669	47.5531991115569	47.697267214608	47.7901439743522	47.8362599863273	47.8418950863103	47.8111154565277	47.7537364525338	47.6685580442393	47.5395807100359	47.3478915094825	47.0895120360657	46.7631441784356	46.3939050972088	46.0327390456996	45.7341682209788	45.5253776819227	45.3970669485598	45.321334755918	45.2758343648786	45.2352717519756	45.178306734199	45.1116322065447	45.0248227121774	44.8660597239976	44.5768311305118	44.128588311002	43.5196480121629	42.7859185520545	41.9803403990926	41.163222948777	40.3715574554374	39.6047799197715	38.8516725789583	38.1205631693395	37.421733744766	36.7615469922371	36.1495635703291	35.581014505939	35.0329466364658	34.4758015877278	33.8924217091006	33.2827226405449	32.661482595459	32.0447382186641
	37.5377243451492	37.7906643617018	38.0762266885544	38.3901467413817	38.7250690254635	39.0747219779453	39.4349700361454	39.804224543881	40.1812314768704	40.5654117541413	40.9543255961555	41.3434436589825	41.7256819612902	42.09323624641	42.4379713746288	42.7531980865616	43.0429617868276	43.3046079955188	43.5193378643204	43.6646119426578	43.7299712092621	43.7115740616031	43.6272067762492	43.5129202717485	43.411697286856	43.3497468296952	43.3262218456878	43.3279001294609	43.3495329127685	43.3831927650587	43.4198788584686	43.4620456167969	43.5009764021707	43.5052471275688	43.4367804670502	43.2721452922488	43.0104288735506	42.6662716193462	42.2532039360088	41.7884946251894	41.2865156105487	40.7486496523865	40.1814838345051	39.608637124602	39.0582849432595	38.5497118530936	38.088291160416	37.6690739513815	37.2872514222392
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	42.933909936011	43.1254047239858	43.3082078244503	43.4778399110228	43.6286425029001	43.7554484621524	43.8560149266632	43.9276111865201	43.9629348816717	43.954531583974	43.8971581604351	43.7916223555285	43.638477931361	43.4322256642469	43.1661374451878	42.8384752843573	42.4517038613168	42.0132243868453	41.5313140220787	41.0159698595538	40.4757339589231	39.9140691154881	39.3358025066404	38.7524166869206	38.1766953894229	37.6183399674305	37.081100778751	36.5653888461891	36.0727166899761	35.6034821574755	35.1580524207956	34.736493730102	34.3388762314181	33.9649849774711	33.6140017801591	33.2843690965574	32.9760923935143	32.6863952533516	32.4071138168418	32.1286444771573	31.8443026147815	31.550382982431	31.2486187196016	30.9445476143078	30.6464788075975	30.3589464615933	30.0837060242239	29.8162946487991	29.5480196068047
	42.6131398649733	43.2803727153267	44.0841065785095	44.8689381447706	45.4361039392982	45.6647795280406	45.5198750202125	45.0838290334048	44.4988368954222	43.9518225567789	43.5679912471722	43.362669312632	43.2916246283841	43.339367047885	43.4759491484659	43.6729201099333	43.9398791109679	44.2641396067387	44.5721558587352	44.7738391686186	44.8129674875024	44.6765345726476	44.3976385819598	44.0247077663243	43.621796689787	43.2342992020845	42.8682810677872	42.5184690851045	42.2009918237971	41.9317232410996	41.7198873028872	41.5683206041144	41.4711448047409	41.41638690282	41.3880614494036	41.3732768584363	41.3683594118996	41.3702983267941	41.3685272373625	41.3518956024843	41.3122843084683	41.2453739273488	41.1505142917763	41.0287180186716	40.8823330820705	40.7125982437324	40.5214399106551	40.3068086451374	40.0618475096099
	47.87382763463	47.8765342440358	47.8520101222307	47.792139108603	47.687516593189	47.5330382924174	47.3307586749449	47.0857717745238	46.80097402281	46.479280805519	46.1251262205004	45.7405591717382	45.3320587176697	44.9128948679286	44.4995179294091	44.1040443058461	43.7317150759036	43.3834721269949	43.0621548247436	42.7699122923464	42.50798024407	42.2735495277108	42.0663292320644	41.8915076470034	41.754892315271	41.6567031186715	41.594267166619	41.5561925098764	41.5232487117141	41.4730840545748	41.3895316742177	41.2707156725636	41.1171262814482	40.9198111920548	40.6693337994066	40.3615463976352	39.9945517723129	39.5754646995622	39.1198717837522	38.6477960057279	38.1736503162945	37.7020590667723	37.2315599565833	36.762503614499	36.2937244854011	35.8246861743975	35.3567795622588	34.8924631494828	34.4336524546812
	43.3145980472087	43.5245594007155	43.7262481059338	43.906048064411	44.0485763185691	44.1443983560243	44.19073914487	44.1919770480822	44.1550580166025	44.0895305742746	44.0019274665653	43.8936746507811	43.7632112124893	43.6103062874241	43.4339818232648	43.2340202835995	43.0128146561149	42.7719997032914	42.509865765293	42.2239918766939	41.9136911077203	41.5781371112448	41.2209082712768	40.8507691890081	40.4786044882836	40.111383991756	39.7528159213365	39.3997251703537	39.0440050479128	38.6746493012468	38.2849645502954	37.8729924756869	37.4435614238467	37.0050150525209	36.5683867756029	36.1410041024045	35.7254678983494	35.3187963901273	34.9158910974985	34.5094347233699	34.0946383890394	33.6698948408706	33.2378776757281	32.8032183739768	32.3722627312347	31.9492108166543	31.5353551830066	31.1286466342646	30.7260296774596
	45.8506822692055	45.9864231590416	46.1137284979396	46.2111069276436	46.2524063455881	46.2231162096112	46.1217696269823	45.9612676449262	45.7595964102317	45.5393608143413	45.3162882160651	45.0929215690439	44.8668239616106	44.6411584845409	44.4183293752843	44.1993450759138	43.9876839136308	43.7822188774291	43.5744541412778	43.3536752575433	43.1141107137547	42.8535642693729	42.577833547991	42.2984068380034	42.029543620267	41.7797295750283	41.5496796350231	41.3337073211057	41.1254232340181	40.9164036691032	40.7002300909792	40.475178372019	40.2408262235478	39.9940270157638	39.7316838940892	39.4515215654537	39.1542012626403	38.8395596807918	38.5042271442858	38.1442637257865	37.7581596781923	37.3456731463696	36.9111068170696	36.4631307654042	36.0127218053346	35.5679603575951	35.1318192483148	34.703872717865	34.2843296464222
	33.4630021581066	33.3534768295663	32.995749259251	32.4428682168957	31.7719294842678	31.0420347636754	30.2679793254384	29.4483851426839	28.6075546410963	27.7717254392816	26.9656714840573	26.1997599691626	25.4893717805737	24.8682582782675	24.3740614591102	24.0303465340029	23.8439213867592	23.8013248645424	23.8781876313092	24.0396155457437	24.2549049586648	24.5160676682761	24.8121312820371	25.1065751080381	25.3572132225028	25.5331853623327	25.6212305726819	25.6213753530529	25.5340230301704	25.3650563514842	25.1197069343865	24.7988282435312	24.4020465130826	23.9334238455905	23.3979110877018	22.8017397487623	22.1467670194758	21.4416748043705	20.7083022614131	19.9751430419641	19.265678743453	18.5912206067339	17.9553497227636	17.364514410614	16.8226054368572	16.3328721010399	15.8992345174039	15.5250496595327	15.2109214294774
	29.2673862120096	29.2872147855494	29.245033721804	29.1637323474021	29.0778981236218	29.0106858868459	28.9666665176436	28.9329957758699	28.894430224628	28.8284171930747	28.7185656666825	28.5624183588033	28.3663311913922	28.1337133560422	27.8694072434946	27.5774203736483	27.2566347516063	26.9093085570315	26.544618362385	26.1725129690946	25.797304305667	25.4237356906501	25.0456271098761	24.6430529716095	24.1901271722889	23.6706299744931	23.0767145338247	22.4188894443471	21.7237024399876	21.0304914273359	20.3709513871346	19.758480432539	19.1916491359733	18.6700106668283	18.1870774494142	17.7383784856474	17.3245313986247	16.9509013723287	16.6221427146559	16.3439682941392	16.118873582992	15.9481426850048	15.8257959497364	15.7378507457531	15.6659281476809	15.5959844974103	15.5220678841537	15.4442481705002	15.3621775920875
	42.690112751224	42.0741549345655	41.2489292626788	40.3315087546128	39.4673186331513	38.7455995986067	38.1905539115996	37.759725060713	37.3925327087429	37.003915817371	36.53868738309	35.9874340056414	35.3810962133227	34.7549560945102	34.1562885587159	33.6157615353205	33.1381929953434	32.7100384763699	32.3187308301393	31.9451042307047	31.5741493874589	31.2045821340238	30.8365339149799	30.4585866189155	30.0580577373859	29.6279444958372	29.1637439201739	28.6709881456038	28.166188227305	27.6722099772726	27.2063917528111	26.7722073217742	26.3662084264355	25.9883551353523	25.635946491481	25.3048864515146	24.9972513548809	24.7095961008499	24.4254272708282	24.1237118830598	23.7906233044163	23.4208841287894	23.0206971736853	22.6025596943451	22.1845503313834	21.780249835863	21.3942387199824	21.0248356344302	20.6721408062502
	38.9688888888889	38.2188933928682	37.3411146996053	36.5628286241316	36.0795454545455	35.9485714285714	36.1574200601257	36.5511267221227	36.8989513100508	36.9723449581821	36.6936135812449	36.060593687477	35.2211811175623	34.3864909971641	33.7502817218842	33.3781233751439	33.2936002074952	33.3832555597595	33.4124905011399	33.1163210777857	32.3999093452812	31.3075609105424	30.0548204431861	28.8964773662012	28.0398651180217	27.5447474593425	27.3798787124864	27.4366318236312	27.5909484047943	27.7075760198488	27.706299151955	27.5378653432218	27.2348186578841	26.891686839113	26.6370662592242	26.5365126223047	26.6345690542056	26.8356083624325	26.9096195545042	26.57855770193	25.7034096012269	24.3292146790689	22.6281989475868	20.8148612939518	19.176698639332	17.917665700291	17.0603614209789	16.5202997313529	16.2080565993397
	28.1849296463302	27.9667301968663	27.5857063168727	27.1195729440544	26.681049377963	26.3503586775094	26.1584046402722	26.0767816433946	26.0557838013925	26.0229055348362	25.9319707092557	25.7565920741253	25.5236522598813	25.3020534038077	25.1861887564612	25.2331230904132	25.4744360790423	25.8633270549046	26.2857524867893	26.5892481829833	26.6727140360452	26.4936429128402	26.0964780446367	25.5739601936263	25.0615953619799	24.654246129653	24.387414530529	24.2224930468203	24.0917473394269	23.895397364446	23.5650566170131	23.0740667037046	22.4524323613535	21.7572945588498	21.0768856362794	20.4772735750004	19.9899640399522	19.5947112529486	19.2457554584664	18.8713197471792	18.4220983510201	17.8774307067815	17.2653344650599	16.6430789302739	16.0933578847766	15.6752720193519	15.4114834981414	15.2803658998408	15.242638927016
	29.958693123357	30.2839583949128	30.4343511515562	30.4111161992417	30.2292451637548	29.9041257143068	29.4287833400829	28.8081063163978	28.0861601650701	27.3225149970621	26.5649162994132	25.834808552873	25.1361154868596	24.4782835478731	23.8653706597644	23.3029632940193	22.7908515933891	22.3404346498665	21.9798492177186	21.7432754128203	21.6493118985957	21.7052461925241	21.8886083122574	22.1505419753535	22.4256321323563	22.6638482007771	22.8497782633938	22.9846497548811	23.0566860644685	23.0575781443779	22.9814113659785	22.8229226741269	22.579462719561	22.252710472335	21.8475286926617	21.3703083856204	20.8266056392038	20.2238022650383	19.5741460221507	18.892367521232	18.1941032889191	17.4802139517261	16.7644406570761	16.0913510360432	15.5185739140381	15.0883297915253	14.8201483357916	14.7042910353322	14.7163039811364
	46.941749018668	47.0626888230321	47.1890594834051	47.3216901504133	47.4604025952165	47.6029496489368	47.737794114971	47.8597958624188	47.9767779950013	48.100554207544	48.233939371789	48.3991800797344	48.5809274580723	48.7084251106637	48.6951045917108	48.4995937677649	48.1035552890669	47.5679773521437	47.020804816326	46.6164944033479	46.4460671361821	46.5191906491892	46.7791888415973	47.1613698770701	47.5771413928646	47.9600206893358	48.2888712824958	48.5681599272301	48.8002799118745	49.0039635271909	49.1955229272295	49.3986188171854	49.6089340817696	49.7622668321266	49.7246301233115	49.3834966687443	48.7554353856059	47.9890512746769	47.2163853652899	46.4883095470398	45.7894439880786	45.0699345804334	44.3205978241648	43.5890908626182	42.9636059688279	42.5153967798544	42.2642745990335	42.1739709407117	42.1981215121435
	48.7208413697733	48.9920564872021	49.3055020008055	49.5887240454901	49.7514773739173	49.7415939243059	49.5468880686919	49.2013257618267	48.7552337179309	48.2705336128142	47.7935288084634	47.3361931778869	46.8841188811667	46.4108877404692	45.8794266328761	45.2697939803424	44.5790765819276	43.830400733969	43.0737171138317	42.3643724696356	41.749075919726	41.2295087238654	40.7980184296312	40.4708986914499	40.2647203563691	40.1859451468189	40.2589736265829	40.4650604540688	40.7091485820169	40.8684363277764	40.8609682018223	40.6454391632057	40.2654327016996	39.8263733336562	39.4774261286936	39.3166354695903	39.3672583548011	39.5817209494492	39.9008310153591	40.2421697128086	40.5440766668932	40.7969671535519	41.0065886208793	41.1434682553458	41.1792007068047	41.0893689304114	40.8657955453261	40.5107714660929	40.0225863620862
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	32.8508505704191	33.9311989839382	35.4644579901664	37.3169175214407	39.256481279761	41.0737157230375	42.6784712641936	44.0661176574951	45.1949170794745	46.0583748204549	46.6834170854271	47.0657728811309	47.2241368099356	47.223745107289	47.141698383977	47.0361891773416	46.9278042888776	46.8157220492434	46.7104969913082	46.6224118513385	46.5571138898276	46.5112432153011	46.4890107101162	46.4892225672154	46.5147545166387	46.5614528367292	46.6331648815809	46.7156447033664	46.7718549338521	46.7560359472234	46.6383044687686	46.4193823234155	46.1150353178607	45.7333203499034	45.2880977979532	44.7938406221909	44.2469253254974	43.6604123198831	43.0870616776255	42.5921083217108	42.2176392090258	41.9756116374142	41.8404476727358	41.7687388217441	41.6966426858513	41.582471727536	41.4149879129734	41.2045319022063	40.9480821096793
	43.2962216901627	43.4431795257996	43.5883309940322	43.7311092785622	43.8714488930628	44.0081500592311	44.1440792773649	44.2753160894119	44.3876510063076	44.4642482586832	44.4968498993078	44.4722121382821	44.4005559808664	44.3203084830554	44.2764422700064	44.2879934511965	44.3705391246766	44.4914969374266	44.5734947057857	44.5307183824244	44.3268036001097	43.9647122531944	43.501537243942	43.0185272367454	42.6040406192092	42.3047892026493	42.1083328572968	41.9817220267519	41.9133885298143	41.8884703491307	41.889685527845	41.9247178872474	41.9756769244491	41.975134937307	41.8399222102234	41.5202676145183	41.0068842996884	40.3371932461321	39.5676734055325	38.7690041452282	37.9895901406221	37.2392226362614	36.5120438567212	35.8159740844733	35.1551902270262	34.5313772885793	33.9468668853396	33.401232170832	32.8893781381302
	41.1625910373143	41.3115371027691	41.4804587250368	41.676474875849	41.9084741413791	42.1793144401498	42.4899742067095	42.8296782579645	43.1762748608199	43.503966279192	43.7978868673621	44.0492123539306	44.2673478871708	44.476918396737	44.7091932062135	44.9814306623695	45.2971106831525	45.6399576294009	45.9831193611149	46.2923589022209	46.5450616172271	46.7378746913495	46.8790407781213	46.9736712975267	47.0298972021859	47.054405710524	47.0469558828988	47.0091017802154	46.9508320972855	46.8837151132642	46.8147964381992	46.7471021496675	46.6774894204155	46.5993237984334	46.5037700252553	46.3855265865473	46.2449120367733	46.0855137179719	45.9094667402761	45.7197259537866	45.5188947207206	45.3062018752683	45.0827262574716	44.8546002124599	44.6290538080565	44.4102876123452	44.1988834368699	43.991129821125	43.781325292177
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	23.2235784316543	22.993992027899	22.7353127847655	22.4511176751124	22.1431648355082	21.8118312014555	21.4533422631558	21.0696964681951	20.6729920336199	20.2818352082909	19.9116817384908	19.5695291061592	19.2540802178193	18.9641604596415	18.6962053458643	18.4485500205766	18.2223238548586	18.0214904889502	17.8496486457288
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	37.8101785558185	37.7295466971302	37.6668575840685	37.6362206921038	37.6554093577584	37.7345592675467	37.8769557803303	38.0736016868947	38.306847195478	38.553772261128	38.798096081387	39.0335935673537	39.2632425972531	39.4913294469558	39.7250071692471	39.9677672143306	40.2183441284465	40.4707141786811	40.7185032468437	40.9544340088202	41.1735320039965	41.3730058633542	41.5533440392833	41.7161779000776	41.8631278587449	41.9942827714789	42.111304335708	42.2119627326282	42.289441881448	42.3365355310532	42.350326349865	42.331690182794	42.2856670577571	42.2194286308199	42.1439955270505	42.070480550117	42.0012435345351	41.940203813002	41.9027519408824	41.9064387574079	41.9606743140899	42.0631039398065	42.2021923119533	42.3661941355656	42.5432842826175	42.7249035975686	42.9094824315094	43.0920965242418	43.2588133640967
	43.2313341493268	43.5628027967164	43.8563445252794	44.0299903139995	43.9834860756999	43.6580430198453	43.0387545269117	42.1670842549338	41.1106681785284	39.9617254760259	38.7881814382621	37.614132348098	36.4349236856614	35.2514165759687	34.0529444406812	32.8338643588822	31.5860413871344	30.3269692229239	29.1072932996342	27.999567235519	27.0557241203362	26.3147830810397	25.7549433209769	25.2970397451799	24.8333527270309	24.2967743364629	23.6533360317449	22.9438044999462	22.2640863874645	21.7438310905566	21.4620505373991	21.4326159626524	21.5937140876499	21.8557911573949	22.1054796135997	22.2661791432902	22.3197620597	22.2848622634586	22.1717331873342	21.9984693073234	21.7737337610061	21.5021826696836	21.1705844622462	20.7515030831982	20.2162783968105	19.5600991993835	18.7939267164945	17.9577763937677	17.108925110682
	32.5436156586686	32.5980334365797	32.5900646279653	32.4674222106226	32.1623606033467	31.6390688392772	30.8730273371967	29.9107742644211	28.8745584539988	27.9279048724941	27.1860190881668	26.690265727085	26.4060155862478	26.2781452392278	26.2203573283704	26.1704425830879	26.1114702035929	26.0614215343405	26.0336367280868	26.0512248652978	26.1252066505144	26.2580087726188	26.4271941910554	26.5897612793355	26.6899705578441	26.6886105056129	26.5713037514863	26.3485593499055	26.0375390192173	25.666253012619	25.2563368384204	24.8123836634714	24.3312946877589	23.8183366828966	23.2776072501802	22.7130764047539	22.1299038157045	21.5330874820733	20.9258973912344	20.311643547068	19.6949051135902	19.0793814712752	18.4720808060385	17.8854734086721	17.3346677938251	16.8318554199061	16.3810416909424	15.983700312965	15.6454041008533
	27.3591939291523	27.1774902065846	26.9491839913236	26.6764602929895	26.3627767665659	26.0136330820297	25.6243857475109	25.2035005993178	24.7866429401511	24.4197736862871	24.1350253424055	23.9467917803722	23.8422087004763	23.7930346465511	23.7583607823223	23.7083267317411	23.6342005643924	23.5428019008703	23.4383393595759	23.3293486107341	23.2206131293463	23.1090649447074	22.9869490405988	22.8483480248228	22.686276371792	22.4946221256715	22.276185825067	22.0294754696394	21.7403395063991	21.3913216653903	20.972740451165	20.4793478620325	19.9229902618948	19.3319762361144	18.7440904241015	18.1866082122668	17.670782139312	17.192618221425	16.7459120545447	16.3185038786202	15.9031956184277	15.4993846616544	15.1154428330225	14.7642582843824	14.4622248744901	14.2212305801106	14.0444955949201	13.9271658684592	13.8615291168186
	42.7747814766598	43.0851543972231	43.4982757110203	43.9352016446911	44.3009397805429	44.5398639059714	44.6204587829821	44.5878337628159	44.5535144619311	44.6593630114061	44.9784649090049	45.5312834192471	46.2418840101243	46.978498763944	47.5828614145195	47.9676104119765	48.109247906399	48.0642179188709	47.9120560340996	47.7581567820562	47.663375851826	47.6453545990123	47.6674616805998	47.676123033635	47.6016260162602	47.4043198181129	47.0796081160662	46.6583677771921	46.1838817686153	45.7133768614501	45.2843965322084	44.9062123292128	44.5666346469449	44.2510474451701	43.9400659615603	43.6217369436292	43.292753373976	42.959752095483	42.6289920045543	42.3084531351226	42.0032535664093	41.7129951762123	41.4310125730347	41.1485593003745	40.8521069876325	40.5341511859355	40.1937763545926	39.8324492159354	39.4520150938667
	44.1998649848543	44.4840976780148	44.7470337264649	44.9784645242172	45.166735287331	45.3063795612794	45.3962626776983	45.4445550953236	45.467526599261	45.4851074204907	45.5118137358117	45.5429115665069	45.5763152240484	45.628055980692	45.7141606017955	45.8323099740182	45.9792229482667	46.1261963638672	46.2313541211634	46.2641485646898	46.215898538934	46.0814922496487	45.8702234585622	45.6062242803878	45.3361634000443	45.10387692536	44.9372058733028	44.8259908465394	44.7384716566374	44.6250568363336	44.4529378241649	44.2041793375992	43.8981978408587	43.5866073075517	43.3492351908647	43.2452982389147	43.2965148848507	43.4718358793263	43.7163451370496	43.9605389998706	44.160446923506	44.3059517028464	44.4111061582553	44.4892245579108	44.5603394378178	44.636493427163	44.7176493005665	44.7938642583038	44.8552019212382
	40.9481356483844	41.1591667296913	41.3658424021784	41.5580162532505	41.7235038788934	41.8548423402281	41.951177464027	42.0165657921597	42.0551197053321	42.0724799281062	42.0731059134133	42.0555777502555	42.0203386939912	41.9749309842539	41.9281277577172	41.884304338563	41.8456434870682	41.806621644271	41.7548619576005	41.6748896347514	41.5569806839997	41.3954896783899	41.1948360470255	40.9668217583627	40.7264758781163	40.4811701802465	40.238785282688	39.9900843308232	39.7068758311229	39.3544072218589	38.9149595065032	38.3862562657037	37.7908899107721	37.1654180132122	36.5526620724297	35.9791220843982	35.4498445137012	34.9554807916653	34.4887443399858	34.0393161561175	33.6013793757264	33.1768690468742	32.7706829229055	32.3841536000678	32.0184756112613	31.6745109149668	31.3491307999611	31.0423802546426	30.7610476030575
	40.6823758814651	40.9781115681487	41.2610300422013	41.5064403492048	41.6844213018176	41.7776589892312	41.7812161907267	41.7093194022659	41.5877174188367	41.4498741232783	41.319219313226	41.20110777792	41.090989745908	40.9888446136385	40.8922386484863	40.7991960073597	40.7110538954711	40.6284044429904	40.5475118944088	40.463469930459	40.3727029540284	40.2736141742687	40.1664425327888	40.0520019063553	39.9312473119911	39.8043326221974	39.6682283417488	39.5224145486021	39.3656744992484	39.1965564655529	39.0140266076161	38.8189872660334	38.6107104656494	38.3826746694682	38.1280970112551	37.8421849157985	37.523848140428	37.176304968896	36.8061849694558	36.421955234745	36.0297351463194	35.632891685035	35.2298138344287	34.8193625240478	34.3989879771294	33.9672454718789	33.5215962409743	33.0686018036527	32.6140247814056
	27.4296280078158	27.4121320844197	27.3653144951532	27.3160425839891	27.3003022816278	27.3399517053233	27.4435182157397	27.5939306276696	27.7562473763194	27.8833617254389	27.942397002794	27.9219398498896	27.8317861228982	27.6865035493273	27.5087061349317	27.3134907260526	27.1048904531522	26.8747932297493	26.6116410158765	26.2989424561169	25.9254838727729	25.489364863509	24.9962131129233	24.4518119070107	23.8653901601079	23.2454832597257	22.5962988987915	21.9212385347463	21.2282674209972	20.5268787321396	19.8266538500892	19.1334481077947	18.4549863029384	17.8044871066386	17.1961275009911	16.6405348513777	16.1420517079386	15.7023074578429	15.3258898593757	15.0178399036975	14.7813265814193	14.6195358967643	14.5283849735995	14.494305339557	14.4992548007216	14.5293701923184	14.5767536902661	14.640216097259	14.7207586102207
	41.4819459108519	41.4578695340681	41.3311780099711	41.1359151148826	40.9163775280439	40.701631362344	40.5056493207959	40.3172014315556	40.1102896300064	39.8494569325797	39.514697980954	39.0997805087034	38.6245134653786	38.1257596975572	37.6514175521912	37.2330727051649	36.8781684911177	36.5729048091476	36.3003718307244	36.03603427277	35.7615916906767	35.474710784725	35.1776848256012	34.8632829882204	34.5244114175597	34.1569457834857	33.7587550584443	33.331835220324	32.8817421658748	32.4159515069839	31.9397084960206	31.45675247954	30.9668087846666	30.4660671130924	29.9481832443486	29.4097057841493	28.8506369023298	28.2772377516075	27.7009438189461	27.1383523350551	26.6046829750403	26.1040064348259	25.6404349801339	25.22903358423	24.8862014187758	24.6215453177913	24.435209957006	24.3195148860638	24.2647205804362
	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN	NaN
	44.6513695205289	45.3050147233332	45.8154797418235	46.2575138511562	46.7406306961258	47.3251797217814	48.0478917230609	48.8415980726762	49.5640410384019	50.0306304028627	50.1347734750453	49.8298142652622	49.1838669407447	48.324824950484	47.4312703703022	46.6309829409944	45.961706065752	45.3823334071286	44.8682167838267	44.3647452967958	43.8308032274725	43.2789322464252	42.7166457824969	42.1241069539603	41.4559196379858	40.7057206502678	39.8528053163987	38.9307160057305	38.0171530690834	37.2129401828664	36.5760076303886	36.1221930924427	35.8121798840547	35.5765285186705	35.3269987074063	34.9956528826822	34.5739188736171	34.081889138775	33.5223380029884	32.9076342465577	32.2475756573087	31.53648144302	30.777761855214	30.0012342631449	29.2448101327726	28.5368378360382	27.8888329618178	27.2968260745801	26.7579763979602
	49.5960269809503	49.6834672510348	49.8792139895439	50.1253460382335	50.3402959810986	50.4687790805881	50.4921996430833	50.4251487450703	50.2753515245898	50.0569705093834	49.7827649107291	49.4531455070435	49.0654609959763	48.6111259666499	48.0871138000698	47.4868693632426	46.8192593972898	46.0937900226432	45.3257991539265	44.5234865611655	43.7107325281531	42.8774506900432	42.0318666575265	41.2187181106954	40.4878142909519	39.8773711438973	39.4053282588012	39.0538305212912	38.7511978804562	38.40509949435	37.9536970667362	37.3724809475629	36.6777550245087	35.9216470413982	35.1640724769114	34.4555701567677	33.8094929501838	33.2088930060213	32.6359405995662	32.0659884826173	31.4768628832621	30.8656384604696	30.2495513994487	29.6397843506517	29.0647747166682	28.5404172338938	28.0718996270919	27.6519425714417	27.2675617467809
	43.1246922405984	43.2624098944346	43.4078843014888	43.5556187478067	43.69886415351	43.8332117487662	43.9572587807607	44.0725440338542	44.1813443280034	44.2869325698745	44.391397558795	44.4947253921389	44.5960405380728	44.6944555872072	44.7886967720481	44.877838203868	44.9607338752561	45.03755848439	45.1099164075584	45.179902619055	45.2494634011949	45.3156300590055	45.3770556785067	45.4314382574652	45.4760133193218	45.5082819279382	45.529022643771	45.5371637436061	45.5265827720045	45.4902366570734	45.4247967354877	45.3287692446137	45.2067225659913	45.0666689802136	44.918276573278	44.7681704395466	44.617334605245	44.4644789828088	44.3096535529223	44.1520301460478	43.9914098558328	43.8323483996772	43.6773563629719	43.5195269349248	43.3626123925472	43.2069025907001	43.052318850493	42.8950890305112	42.7281820722665
	44.0773193052612	44.0682900698547	44.0475554076418	44.0266866182877	44.0201281326866	44.0367977104427	44.0784389746673	44.1398385145068	44.2141316333795	44.2919679351167	44.3666057508738	44.4354647320972	44.4993176891586	44.5589221754626	44.6159874011869	44.6709565760009	44.722773134565	44.7687047876139	44.8055230228688	44.8295230405128	44.8381070331061	44.8314155561947	44.8097042280982	44.7712518245638	44.7140568352942	44.6370974934052	44.539590504484	44.4228761615184	44.2906798020046	44.1483557080559	44.0000603882098	43.846482275478	43.6869930240581	43.5226458769449	43.3540198947364	43.180758945597	43.0024360330037	42.8173705058899	42.6219933993938	42.4117115676443	42.1827144591289	41.9339251018446	41.664420523859	41.3713387358914	41.052436604818	40.7073256018997	40.3387209083794	39.9492653125974	39.539258304502
	47.5862068965517	47.962464420656	48.1445468635288	48.1963348456543	48.2038243354428	48.2243969692682	48.2516786577763	48.2625647447208	48.2742837486962	48.3025681746489	48.3484959588715	48.4480839816371	48.576672892381	48.6007160007787	48.3334014968713	47.648951843225	46.4818886543695	44.9092746098299	43.1251614747385	41.3936134048316	39.9003141498678	38.711682872428	37.7810389575095	37.0460336609988	36.4033933090136	35.7778593506445	35.1622872777593	34.5890340127613	34.0735676123568	33.6370064790823	33.2868656173322	33.0237830532121	32.8266591509465	32.6580440807707	32.4698128302448	32.232855559711	31.9309036924386	31.5775141457317	31.2077345731192	30.8680192246743	30.5898168087302	30.3783496299235	30.2162165536442	30.0830292757204	29.9495685988577	29.7945609783916	29.6161351482934	29.4163058173482	29.1840977785888
	45.2195731127482	45.4259301746473	45.6399539363369	45.8570851534517	46.0706477965712	46.2771093570389	46.4750246201025	46.6660668999273	46.8508619790926	47.0306257093556	47.2065202512415	47.3753658653615	47.5369870267408	47.69615662928	47.8592384724773	48.0279360411689	48.2021689906746	48.3751657020037	48.5380714775445	48.6795715977585	48.7929416679653	48.8800918271576	48.9416855437218	48.9668966501785	48.9459750667723	48.8741697453579	48.742591375865	48.563039161431	48.3733964270444	48.2132677355842	48.1016744045064	48.0503140411121	48.0342664998951	47.9906886885207	47.8393783093463	47.5342721570901	47.0607327605324	46.4565232576787	45.7846388624882	45.1221601714159	44.514629199122	43.9726764751115	43.4735505759193	42.9852764368833	42.4664463388057	41.894059995909	41.266777571432	40.6080423831857	39.9525275809275
	22.0053446516919	21.6985865264266	21.4400738569834	21.2311526313021	21.0680112607628	20.9464620068029	20.8683002010664	20.8323407799111	20.8265134884739	20.8348127277522	20.844020376387	20.8499011251009	20.8490266093494	20.8303219930125	20.7813732686984	20.6927521757827	20.5678522990758	20.4079405309048	20.2008635272518	19.9314566681701	19.5939530233379	19.1768189081172	18.6974536994206	18.2147896209587	17.8092067842494	17.5382132950819	17.4211512239422	17.4383942636379	17.5597356416345	17.7379032950196	17.9349651687164	18.1459423012871	18.3704148712372	18.5814451127715	18.7487337048216	18.8515306931081	18.8792584610779	18.8354728788399	18.7323980435797	18.5905978980261	18.426942983661	18.2482408957981	18.0543298927367	17.8479857134862	17.6301797114717	17.4040767273678	17.1676855082496	16.9297883402514	16.7159119662004
	24.0315309270679	24.0165602465604	24.0364774530402	24.0746268603866	24.1075784175593	24.1184659875711	24.1039647141167	24.0660282106389	23.9999545820985	23.9013747208709	23.766452969571	23.596951557947	23.3908850501221	23.1369648527058	22.8207572050087	22.4339122201748	21.9718421817152	21.4438180222338	20.8735573940233	20.2963082581124	19.7423602920499	19.2247351604259	18.7470588013247	18.3195477845565	17.9489392929096	17.6393296774651	17.3911834963332	17.2050351959446	17.083192248587	17.0274477682932	17.0350886102568	17.106404104947	17.2292512141926	17.3736012078918	17.5023925294387	17.5889003468748	17.625779994142	17.6161811844061	17.5586088427084	17.4549353330315	17.3087188692595	17.1180326666865	16.8866805102344	16.6318660571484	16.3748918271214	16.1311070740204	15.9060326243452	15.6984945223293	15.5081036469063
	45.9366910161648	46.3495683431792	46.7542966236314	47.1234318810283	47.4232413465604	47.6358847407333	47.7590357903071	47.8124093578127	47.8270930258704	47.8410402138333	47.8793439020562	47.944965292484	48.0307762279947	48.1364597334587	48.2596674807457	48.3968501830812	48.5442736745741	48.6978183384128	48.8522977159006	49.0019015912099	49.1399448220852	49.2583466866863	49.3498758956403	49.4094045728671	49.4323482239159	49.4130670017232	49.3538820082817	49.2470837568691	49.0679293828331	48.7875424737751	48.3901871877192	47.876677905173	47.2621418349557	46.5639799744578	45.8037597170286	44.99842851108	44.1545365502335	43.2775722253388	42.382543259441	41.4881561021836	40.6122430562525	39.7688479157252	38.966521910094	38.2130403411298	37.5152910142343	36.8802550266313	36.3027377040316	35.7861298300286	35.3486311085814
	39.5960334194638	41.0335148466271	42.4476915230759	43.7434828392501	44.8266431261576	45.6490028031919	46.2023228736661	46.5211339189396	46.6568932241765	46.675446333846	46.6221837082496	46.5190081839054	46.3606610069182	46.1342453121241	45.8184281566994	45.4080052527753	44.9039607423847	44.3380873183614	43.7706198296746	43.2742917914995	42.8966746957958	42.647770841042	42.5088850874778	42.4604122998064	42.4741114200507	42.5278521918916	42.6123449676256	42.7246526986715	42.8572651512437	43.0042916462696	43.1587289973963	43.3182149674406	43.4718877168166	43.5960867777745	43.6614636579856	43.6472063644377	43.5483017489477	43.368669121515	43.1086011701617	42.770855782089	42.3595362367487	41.8755556409874	41.3244677353029	40.7218144022718	40.0882651238865	39.4423993862479	38.7930622119673	38.1471022282685	37.5185266886715
	45.8379323168612	45.8308850909608	45.8134800098975	45.7986848126351	45.8027019514309	45.8346775408776	45.8966765126333	45.9808762638747	46.0745220010441	46.1615383267314	46.2316584061862	46.2815933228452	46.3156378289499	46.3406621233336	46.3658194954464	46.3962912283569	46.4327526394107	46.470808316326	46.5044114130582	46.5260915630119	46.5311104458055	46.5180902677325	46.4892671473626	46.447955256763	46.3985973740865	46.3437658748425	46.2856947451113	46.2227648827123	46.1497551188134	46.0602641875077	45.9516109269076	45.8250191383714	45.6861103571693	45.541938942884	45.400189503524	45.2659251274223	45.1398855226082	45.02193971932	44.9145123309392	44.8203887705394	44.741649544559	44.677613730089	44.6278272277212	44.5942364629569	44.5789687592254	44.5820646304201	44.6000087593262	44.6280371643645	44.6626731248896
	43.6249218537151	43.9337032586799	44.2218709489849	44.471483775131	44.6637969465357	44.786625715615	44.8351919086785	44.8119967392261	44.7222070949488	44.5736097667748	44.3715615873573	44.1135795440251	43.7977341613477	43.429402321478	43.0150500576348	42.5573222735288	42.0672974729215	41.540309341969	40.9477551735857	40.2541206685966	39.4427055759825	38.5144687670468	37.4973655835484	36.434163401168	35.3757888308142	34.357124962156	33.3827291750563	32.448425779423	31.566651375556	30.751005731797	30.0103620817506	29.3499563781229	28.7649695446787	28.2407621339051	27.7560149697317	27.2932768802211	26.8499696712424	26.4250007841357	26.0057060980819	25.5793199524127	25.1397978232154	24.6848090662986	24.221573520087	23.7653201468998	23.3341687773999	22.9393208879885	22.5806808114286	22.2538979845104	21.9595255617147
	41.4385614385614	41.5403460419538	41.6410110096023	41.7338511268064	41.811518558007	41.8702914150409	41.9018465311529	41.908290973201	41.9057281422512	41.9167832428386	41.9524428695736	42.0267832161085	42.1242744166115	42.192338692572	42.1682871032313	42.0133699184272	41.6938500084727	41.2151170066325	40.6340616620892	40.0779833090726	39.6761154494479	39.5092920490502	39.5495765959624	39.7083228564244	39.8615721891638	39.9370672997378	39.9361845084638	39.9009106602866	39.8582345303221	39.846354705023	39.8973509575894	39.9686499867848	40.0630572138109	40.2953864955698	40.8088757107093	41.6882806212092	43.0343519339868	44.8077116561184	46.7515252472163	48.4045791929715	49.369196992555	49.470593874323	48.8775246464572	47.9070848823961	46.9437747962657	46.2068916832476	45.7256181061688	45.411036141861	45.1909849460799
	42.7956457925948	42.9297668389374	43.0680983578576	43.2148464504632	43.3724383089452	43.5398284944375	43.7112767850214	43.8827060080422	44.0546048144751	44.2318630014065	44.4189683836823	44.6182474240824	44.8276833522028	45.0435968587959	45.2593535101561	45.468518017661	45.6680709481294	45.8566995918196	46.0310602588799	46.1869589553896	46.3201571219307	46.4274085660273	46.5058074541124	46.5529196886344	46.5667725413744	46.5466500604199	46.4935049193613	46.4084327148643	46.2909866930405	46.1403413209531	45.956139410215	45.7388316919711	45.4895637895838	45.2109589822444	44.9087353884177	44.5902844432772	44.2610849928873	43.9263080884379	43.5919558084885	43.2612801670649	42.9341402721227	42.609479629644	42.2855310184149	41.9591380156361	41.6277702268618	41.2906202854435	40.947315505978	40.5987813342344	40.2471152061118
	48.6600351082504	48.6216174336869	48.5760052127169	48.5110056107035	48.4006140836563	48.2394323635001	48.0153812298035	47.7480374329179	47.4932855863921	47.3134853312368	47.233298071446	47.2750522662228	47.4096478187317	47.5561674698041	47.5959805812893	47.440243837228	47.0553038721258	46.4845570478329	45.7986358120266	45.0859747255024	44.3910041387567	43.7188481187113	43.0520533612346	42.3963377804152	41.7580415233073	41.1610410077611	40.6121941462043	40.1263857136695	39.7383939101533	39.4757575112322	39.3494972137925	39.3791364639143	39.5406113354831	39.7550249953328	39.9255232456186	39.9761753168067	39.8863694528331	39.6797989292574	39.3887148934434	39.0701982979763	38.7677888565429	38.4862214060119	38.2183101415567	37.9779843541613	37.7792488810284	37.6318966617262	37.5345138787258	37.483627472858	37.4604124826201
	43.0483804959638	43.0048613603419	42.8935724601407	42.751815024263	42.6303132938188	42.5590779126752	42.5596026308126	42.6036647082525	42.6098832008506	42.4750047239688	42.132650507227	41.5695069550281	40.8218205574472	39.9378677988267	38.9920382086219	38.0495720431149	37.1223602618081	36.2190993650806	35.3979795514902	34.7246199306079	34.2390761755799	33.9521310087232	33.8393110424818	33.8557189087284	33.9410497285185	34.046914762191	34.1641274978311	34.2845236922142	34.3646719815101	34.3527760577915	34.2112582797758	33.930045091466	33.5146859218384	32.9630042532236	32.2780119486867	31.4669272977006	30.5284963502502	29.4785942551983	28.36379688062	27.2442268274607	26.1681723419041	25.1505002315388	24.1953818146977	23.3263693411198	22.5678365756089	21.935598877342	21.4411332809842	21.0799733176331	20.8307709383915
	43.3624651450079	44.0097183348986	44.6887972873597	45.3421213349111	45.8978711466954	46.3066954643628	46.5618276963386	46.677764910249	46.6573488844559	46.5091775669468	46.2453586414358	45.8634583791774	45.3775691253086	44.8356251569973	44.298009634097	43.807234068682	43.3793094303094	43.0038922835043	42.6637211377106	42.3316209855018	41.9885759383547	41.627781858034	41.2547541096902	40.8771217496327	40.5058365105836	40.1448639516476	39.7991212887765	39.4558948023071	39.0822712449021	38.6373530124137	38.0959418074732	37.4499469933929	36.7144136782131	35.9158830549614	35.0902552323239	34.262444613816	33.4420937135374	32.622983580288	31.7954911546154	30.9449217208016	30.0645440050207	29.1552421138613	28.2319035638176	27.319603720552	26.4510506635267	25.6515313177613	24.9280633403642	24.2800838927558	23.7147375528136
	42.3617752275706	42.5949448199897	42.7912837294252	42.9229885983471	42.957655034042	42.8803662378255	42.6785896727801	42.3766582439912	42.0388573429401	41.7458229995104	41.5473449655651	41.4596176097756	41.4540874629553	41.4809560011915	41.4749696614773	41.3947560106841	41.2265583892312	40.9897657020278	40.7164635219616	40.4502712703242	40.2170358401394	40.0270480622461	39.8598119018239	39.6744007652197	39.4178723289844	39.0575761986312	38.5849504032403	38.0205952367777	37.397422185663	36.7603369219642	36.1412482617823	35.550438186435	34.9805777207317	34.4244009744118	33.8691178633542	33.3072444300036	32.7376472864279	32.1684109817003	31.6114433592984	31.0814281200779	30.5869275907831	30.1307673729348	29.7064879077991	29.3019751950744	28.9012817405793	28.493663613855	28.0776556064565	27.6572297615015	27.2343202412406
	39.4841923538172	40.7032842884122	41.8528352658817	42.8785511427874	43.7269975700908	44.3698412698413	44.8027778433241	45.0467794206403	45.1336502026235	45.1034253171033	44.9872264049469	44.7993326182391	44.5440195748966	44.2303459188718	43.8648560708429	43.4568702723252	43.0112567818574	42.5438138903526	42.0855790149409	41.6720250554078	41.326459279972	41.0513883909184	40.8386031739266	40.6841531525644	40.581159303934	40.5208052394505	40.4974926580302	40.5009798486297	40.5117443612091	40.5076762536051	40.470774263904	40.3995504295571	40.2890963376288	40.1170368366744	39.8569548013109	39.4925175812482	39.0186120926428	38.4434764130897	37.7825909241264	37.0612590179315	36.3030676893556	35.5210514327765	34.7220396841685	33.917605133315	33.1173108764933	32.3303849304188	31.5548291570965	30.8011149623055	30.1025554091658
	45.9315570979017	46.0758501723932	46.224162920691	46.3667314460495	46.4904014306348	46.5884076123733	46.6597247758664	46.7120212878248	46.7571823387041	46.8097760916387	46.8784403426841	46.9652450796101	47.0651307310347	47.1705230850777	47.2712842586078	47.3604887052635	47.4383759128822	47.5072788784077	47.5657899541892	47.612811724806	47.6486709700747	47.6750019878987	47.6950096161094	47.7128478766411	47.7332746032803	47.7603763107424	47.7918399332881	47.8293121101773	47.8834915004958	47.9668748954049	48.085071295716	48.2378301221039	48.4158300929673	48.6045524396171	48.7865916769096	48.9498624794062	49.0915469671634	49.2129280894865	49.3121211062072	49.3879043282298	49.4394614658638	49.4661919450106	49.4679787247568	49.4453839163362	49.3993662602084	49.3312213156753	49.2405097955155	49.128740512906	49.0009955186655
	25.8605273448502	26.1868993232229	26.4645825512136	26.6633838462154	26.7535164582045	26.7176480155061	26.5418890243839	26.2365971984275	25.8401307614061	25.4061843049608	24.9749532409423	24.5617147222537	24.1622328262326	23.7737002235467	23.386838549286	22.9976445649439	22.6020374155119	22.2122390039441	21.8587486844158	21.5814318843386	21.4058515033406	21.3430506997628	21.3766252495263	21.4704605851241	21.5737592282816	21.6482013083158	21.6809404027313	21.6762637212295	21.6337960817547	21.5581786819255	21.4515780016019	21.3136679579598	21.1375487423149	20.9117836233961	20.6216171416048	20.2574099655371	19.8158348990033	19.3032549488656	18.7330919602067	18.1268038765307	17.5055896607947	16.8762038807488	16.24776552199	15.6487980071598	15.113388778948	14.667531612325	14.324152140495	14.0834912057977	13.941591405097
	43.6587095773212	42.5954821273775	41.192324674369	39.828757500124	38.7807057727979	38.0891631422034	37.7720379177754	37.6232883858811	37.236205006395	36.2285708414461	34.6316492321389	32.7639219759665	31.0030500594557	29.6000063394624	28.6789911034639	28.2037397953697	28.0489300188441	28.0807889537563	28.2172981641203	28.3987692361143	28.5953506698188	28.7961381399543	29.0007717454748	29.2079109354754	29.4150656375007	29.6126706637095	29.7903664672005	29.9306753622639	30.0079015784642	29.9965467486027	29.8812639823725	29.6675460936666	29.3601432152638	28.9489132508549	28.4266042879566	27.7990058123826	27.1017620091812	26.3601180700577	25.5681820144404	24.7138949020324	23.8025987213308	22.8264493120861	21.826275165505	20.8965172736778	20.1402923320555	19.6089196660726	19.3027437706924	19.171403816439	19.1500116389725
	23.2589764816101	23.2502669659206	23.2079366976497	23.1641706609759	23.1617820010052	23.2270978423003	23.3706893775675	23.5729888228834	23.7930454695016	23.9742600476758	24.0751519855129	24.0879082758551	24.0216967986079	23.8737405244785	23.6452528463835	23.3403542490602	22.9564812997673	22.5009336868513	22.0013247900969	21.4945947970759	21.0104566659992	20.5585329147386	20.1412767435334	19.772175423201	19.4642144366227	19.2258729572775	19.0623341394184	18.9709171219457	18.9409112808502	18.9561368142706	19.0020531819533	19.0760509626851	19.1731306465532	19.2733238775922	19.3524595800143	19.3928073780762	19.387640351656	19.3389125368263	19.2492206187427	19.1250659123245	18.9729586977067	18.7923731353588	18.586048119236	18.3682438903034	18.1570177258881	17.965821910086	17.8001985785967	17.6593084859943	17.5419592789355
	30.833067692595	30.8677595472446	30.8210981304242	30.7016328771545	30.5211222196666	30.2879821395878	30.0086825507954	29.6823447749128	29.3020174979416	28.8578152674289	28.3462505573455	27.7709326228601	27.1452883281574	26.4885162506865	25.8246092525616	25.1738320269827	24.5417883824176	23.9349818998974	23.3742303881286	22.8828195749256	22.4760480860618	22.1607398674568	21.9315760656573	21.7756854105606	21.6740184675593	21.6114132102743	21.5818477051471	21.5838897774558	21.6121128475007	21.6615876086027	21.726608146768	21.8048288125874	21.889170406462	21.9643327372475	22.0122107788733	22.0207906388184	21.9853891111157	21.910438265249	21.8048323959919	21.6814827979914	21.5500898551428	21.4124684047067	21.267840383884	21.120030563145	20.9731022759977	20.8303117972842	20.693132554443	20.5623283289831	20.4392674223023
	37.0024120909225	37.2719167914756	37.4580031557455	37.5569747148397	37.5707531386088	37.5067054024641	37.37094021513	37.1588241287439	36.8852530949512	36.5903097245816	36.2993655410184	36.0045987040958	35.7142842849367	35.429229790232	35.1472736049813	34.8705662649718	34.5952328780984	34.3281660069479	34.0830633429848	33.8763341247731	33.7105498700305	33.591376959709	33.5076052073777	33.4381894548655	33.3523378761365	33.2343904887033	33.0817551394555	32.895580864447	32.6735792863338	32.4161284600778	32.1235762244877	31.7940598156284	31.4329136542362	31.0354013961498	30.6079229647626	30.1566957879434	29.6853196346939	29.1959627138694	28.6973049268715	28.2007224196281	27.7100888332423	27.2339846667065	26.7720653076691	26.3262210000436	25.908210434897	25.5217277679638	25.1693214110721	24.8457476415329	24.5516966614482
	27.8630759001862	27.9259929187491	27.982005092029	28.0267018907388	28.0556965501407	28.0664449756025	28.0552858450198	28.0235610660655	27.9793929897823	27.9339294153338	27.8942125890521	27.86564181748	27.8441705724437	27.8162033803901	27.7631134965795	27.6731481821702	27.5385861148052	27.3685315749962	27.1887450917806	27.0334159979945	26.9245279265672	26.8713432758524	26.8615788830544	26.8699543124076	26.8605162490677	26.8082519517308	26.7080798619897	26.5689820292923	26.398040892077	26.207347760117	26.0069479278403	25.7957153799514	25.574313315523	25.3573468305676	25.162628482358	25.0016669411305	24.8794832003153	24.7897287914936	24.7180033993611	24.6436705050686	24.5513071442767	24.4377962961404	24.3053351796825	24.1507159984195	23.9719204846947	23.7691097173008	23.5406820679426	23.289294763893	23.0248508513015
	38.6192655421164	40.027905904033	41.3729741996079	42.584744119799	43.5941708430103	44.364197124308	44.8907026749046	45.198659581719	45.320845184812	45.299749783789	45.168977784504	44.9463387043853	44.6403855516567	44.263990713838	43.8275468714131	43.3439475024564	42.8172951549493	42.2671556473941	41.7369592960772	41.2780680415888	40.9236856376786	40.6791390837263	40.5299425353842	40.4621216988566	40.4551226772942	40.4907290539092	40.5604806514872	40.6557664643346	40.7582457457317	40.847661662502	40.9065832399394	40.9308243609355	40.9120162527605	40.8262994850887	40.646641290803	40.3558878200641	39.9516386551381	39.441628413377	38.8332810667448	38.1384694985463	37.3695864602325	36.5335307591987	35.6395883105022	34.7066634893744	33.7570353846808	32.8107022104058	31.8730995212592	30.9546111396919	30.0847322987763
	46.7159689145149	46.7521224731558	46.7945132899656	46.816612944633	46.7770263729273	46.6678299620139	46.4776609895412	46.2271926154158	45.9560092715885	45.7255127467893	45.5652052596701	45.4813846569909	45.4540494533074	45.4633795973551	45.4739726587663	45.468770115967	45.444687547981	45.4038867647196	45.3495929088513	45.2784185091958	45.1939737953993	45.0912358653054	44.973807106599	44.8457534594389	44.7111545290318	44.5780851176636	44.4432936302434	44.3071631912834	44.1739596482444	44.0512281135928	43.9440879497354	43.849989273804	43.7656898487467	43.6744462194801	43.5638437180067	43.4200441296017	43.2424750589773	43.0306919642857	42.7785698618118	42.4829494377486	42.1440732014569	41.7641518659002	41.3508499222785	40.9233291372698	40.4987706357569	40.0894490750153	39.6964910148919	39.3180123678786	38.9505101211805
	45.6929446677207	45.8722856385807	46.0530305496121	46.2131215415847	46.3263499859659	46.3750925292034	46.3602184670481	46.2850175185329	46.1409481200244	45.9195561965844	45.6190423706585	45.245860881557	44.8120128087887	44.3300709607488	43.8143676677688	43.2785216303322	42.7274859420343	42.1710309875452	41.6298182187207	41.1251141337758	40.6688729618702	40.2577895663047	39.8853852031881	39.5536802102537	39.2652281429143	39.0183166169201	38.815696335564	38.646197676564	38.4792853139429	38.2778512811546	38.0182410705281	37.6938591372247	37.3149005084645	36.8960015243612	36.4578124686441	36.0148146122969	35.5714377292032	35.1242555483638	34.6704043777364	34.2050359129363	33.7264581329013	33.2346410542806	32.7358482820384	32.2418953084391	31.767285238662	31.3215935281729	30.9073042942344	30.5207417851518	30.1572404316689
	39.3720084931268	40.3248481502013	41.2679448372076	42.144112191994	42.8867471932024	43.4552477991434	43.8451454568816	44.0787377799665	44.1792432331522	44.1787431931949	44.1042144802906	43.9537675333202	43.7348767927381	43.4909810852399	43.2731008403907	43.1115547376452	43.0252519990583	42.9953658123333	42.9697410777973	42.8797221782536	42.6835851779758	42.3681408280078	41.9619750444109	41.5150623768215	41.0915207287632	40.7308992715209	40.4383892784714	40.191039862549	39.963786074136	39.7227307044564	39.4430148385733	39.1244277631003	38.7694552308446	38.3615109206773	37.8814250407535	37.3177846401865	36.6657839093729	35.9339383420739	35.1410913863579	34.3134875573005	33.4715198136889	32.6274663028938	31.7821586895168	30.9317618268863	30.0679892086892	29.1890963367276	28.291819051022	27.3915081476154	26.5258680967039
	39.689836949859	40.1432876556548	40.7670934067361	41.2379174249049	41.2801665257269	40.798677605983	39.7263397947548	38.2529085020536	36.8262696477668	36.0137785542407	36.0997081180639	37.1272081173551	38.7422873512561	40.3890929787344	41.4951100244499	41.7797360936261	41.2141399188031	40.0195630909684	38.5036650989365	37.0676255414396	35.9751699194343	35.2939415708812	34.9061235712322	34.6554514356594	34.3273264912298	33.7717790004585	32.942120190609	31.9053916776877	30.7742706285891	29.7334687756978	28.9245396278295	28.3979083857523	28.1061716332845	27.9705014189311	27.8678192815284	27.7094930324653	27.482271151469	27.2077079859181	26.8679622062385	26.457233563439	25.9741934295477	25.404729965637	24.7585094488333	24.0758519168701	23.4157693009673	22.8179232900685	22.2951058634889	21.8404840885065	21.4432293899291
	44.4042855650578	44.4281916313435	44.5216776523498	44.6480796470097	44.7626913833156	44.8394505937328	44.8708703693864	44.8707322227158	44.8633682180436	44.8875739001913	44.9725776965265	45.1136645210066	45.2937559848343	45.514011661997	45.7786944051826	46.0863100929361	46.4495690040955	46.8474793742513	47.2118242592085	47.4596799361527	47.5452469453189	47.4531414205871	47.22685068993	46.9465833696547	46.7096149566769	46.5723438124667	46.5526960003542	46.6169292390964	46.7072569031369	46.7506874051366	46.7076791115023	46.5631640980767	46.3514587339223	46.138325068493	46.0027515340894	45.9863187629649	46.0963251934646	46.2920334282376	46.5092228835335	46.6697603004667	46.7260442865049	46.6673014022554	46.5174902723563	46.3076146039182	46.0780236416607	45.8525174740597	45.6374170248533	45.4179442030836	45.171425656949
	36.9255051183494	37.1512943701878	37.3553351704882	37.52935950974	37.6529592024403	37.7182654139835	37.7256137981298	37.6770060946279	37.5931920677105	37.4906368777236	37.3964303312515	37.3100904296596	37.2272416880784	37.1319670013707	36.9949095090767	36.8063173591902	36.5676444926625	36.2839759786401	35.9703306716074	35.6435189704531	35.3180733780511	34.9941381242333	34.6746194372166	34.3678641737782	34.0828215170438	33.8241219977611	33.593267544131	33.385726939255	33.1958049601217	33.0141970840293	32.8417967397279	32.6667718652304	32.4925190325452	32.310199807869	32.1072999642319	31.8740499101265	31.611432677046	31.3203772479877	31.0034915537299	30.6606348475763	30.2966183748828	29.9109890502909	29.5077849603237	29.100415113884	28.7074048967609	28.3413247289266	28.0048196093415	27.6940832524098	27.4106038145721
	46.1180656490508	46.3859909183726	46.6303126445899	46.8575190803884	47.0760190172073	47.293163891928	47.5056384603343	47.7155591177263	47.9407190790919	48.2028866771067	48.5129853831898	48.880505652617	49.2911056634647	49.7038988134663	50.0648338692654	50.3387214102044	50.5138582015429	50.609719289657	50.660453659132	50.7102522480319	50.7869081187069	50.88429313624	50.9889128051009	51.1067790623544	51.2435813404592	51.3964678257483	51.576158731408	51.7645963481959	51.9014155993987	51.9153660194492	51.7710289845939	51.4617099574329	51.0314644395429	50.5525858578107	50.1037382909663	49.7253713032419	49.423677472291	49.1691252056662	48.9202650010294	48.6257920935052	48.2558015784304	47.8082634305664	47.3037419355106	46.7649120996352	46.2208337847561	45.6917129493716	45.1814874831908	44.6871577126973	44.2116314246524
	44.8909785031643	44.9299776727459	44.9673367799132	45.0222233308759	45.1177415545909	45.2661671952166	45.4695609584334	45.713588275368	45.9733168790084	46.2180457397898	46.4278351474736	46.5941355257569	46.7237019699735	46.8300371842057	46.9316107673744	47.0379702493605	47.1530985504465	47.2661673003788	47.3553295616463	47.3940672734502	47.3677811781768	47.2756692859006	47.1309058679702	46.9508343114584	46.7569668427868	46.5642310386055	46.378971958813	46.2000699281921	46.025561270883	45.8513340273831	45.6765879336762	45.5018335686834	45.333961591172	45.185663733607	45.071862855243	45.0020690921983	44.9744804001193	44.9838840543413	45.0304090417366	45.1136770260745	45.2306798386362	45.3791954457306	45.5510236147705	45.7300052767815	45.8964605027475	46.0352881884054	46.1415884880211	46.2143079422807	46.2480764994588
	45.2873880648538	45.7922337692631	46.3627327387386	46.930717322288	47.413856979738	47.7637613381827	47.972852537531	48.0718814991954	48.1001931116466	48.108382650481	48.1303575230326	48.1647417312233	48.2020474336181	48.2535467096374	48.3300772492333	48.4343868572512	48.5698769377343	48.7228540152644	48.8591058513168	48.9372086151702	48.9316626624614	48.8424354951455	48.6838032042938	48.4653348915034	48.1992886240937	47.8960724733949	47.5567109027544	47.1864117919027	46.8021153213619	46.4223260770701	46.0577842414991	45.7156001968667	45.3901123149211	45.0643996997243	44.7164552296793	44.3340850965706	43.9096833003582	43.4548784682351	42.9985090172978	42.577618595659	42.2151600250559	41.9139197618378	41.6596312729376	41.4361106528181	41.2204482843225	40.9938321858194	40.7593235379076	40.5159198728916	40.2375823054076
];

wbcodes=[
    'AFG'
    'ALB'
    'DZA'
    'ASM'
    'ADO'
    'AGO'
    'ATG'
    'ARG'
    'ARM'
    'ABW'
    'AUS'
    'AUT'
    'AZE'
    'BHS'
    'BHR'
    'BGD'
    'BRB'
    'BLR'
    'BEL'
    'BLZ'
    'BEN'
    'BMU'
    'BTN'
    'BOL'
    'BIH'
    'BWA'
    'BRA'
    'BRN'
    'BGR'
    'BFA'
    'BDI'
    'KHM'
    'CMR'
    'CAN'
    'CPV'
    'CYM'
    'CAF'
    'TCD'
    'CHI'
    'CHL'
    'CHN'
    'COL'
    'COM'
    'ZAR'
    'COG'
    'CRI'
    'CIV'
    'HRV'
    'CUB'
    'CYP'
    'CZE'
    'DNK'
    'DJI'
    'DMA'
    'DOM'
    'EAP'
    'ECU'
    'EGY'
    'SLV'
    'GNQ'
    'ERI'
    'EST'
    'ETH'
    'ECA'
    'EMU'
    'FRO'
    'FJI'
    'FIN'
    'FRA'
    'PYF'
    'GAB'
    'GMB'
    'GEO'
    'DEU'
    'GHA'
    'GRC'
    'GRL'
    'GRD'
    'GUM'
    'GTM'
    'GIN'
    'GNB'
    'GUY'
    'HTI'
    'HPC'
    'HIC'
    'NOC'
    'OEC'
    'HND'
    'HKG'
    'HUN'
    'ISL'
    'IND'
    'IDN'
    'IRN'
    'IRQ'
    'IRL'
    'IMY'
    'ISR'
    'ITA'
    'JAM'
    'JPN'
    'JOR'
    'KAZ'
    'KEN'
    'KIR'
    'PRK'
    'KOR'
    'KWT'
    'KGZ'
    'LAO'
    'LAC'
    'LVA'
    'LDC'
    'LBN'
    'LSO'
    'LBR'
    'LBY'
    'LIE'
    'LTU'
    'LMY'
    'LIC'
    'LMC'
    'LUX'
    'MAC'
    'MKD'
    'MDG'
    'MWI'
    'MYS'
    'MDV'
    'MLI'
    'MLT'
    'MHL'
    'MRT'
    'MUS'
    'MYT'
    'MEX'
    'FSM'
    'MNA'
    'MIC'
    'MDA'
    'MCO'
    'MNG'
    'MNE'
    'MAR'
    'MOZ'
    'MMR'
    'NAM'
    'NPL'
    'NLD'
    'ANT'
    'NCL'
    'NZL'
    'NIC'
    'NER'
    'NGA'
    'MNP'
    'NOR'
    'OMN'
    'PAK'
    'PLW'
    'PAN'
    'PNG'
    'PRY'
    'PER'
    'PHL'
    'POL'
    'PRT'
    'PRI'
    'QAT'
    'ROM'
    'RUS'
    'RWA'
    'WSM'
    'SMR'
    'STP'
    'SAU'
    'SEN'
    'SRB'
    'SYC'
    'SLE'
    'SGP'
    'SVK'
    'SVN'
    'SLB'
    'SOM'
    'ZAF'
    'SAS'
    'ESP'
    'LKA'
    'KNA'
    'LCA'
    'VCT'
    'SSA'
    'SDN'
    'SUR'
    'SWZ'
    'SWE'
    'CHE'
    'SYR'
    'TJK'
    'TZA'
    'THA'
    'TMP'
    'TGO'
    'TON'
    'TTO'
    'TUN'
    'TUR'
    'TKM'
    'UGA'
    'UKR'
    'ARE'
    'GBR'
    'USA'
    'UMC'
    'URY'
    'UZB'
    'VUT'
    'VEN'
    'VNM'
    'VIR'
    'WBG'
    'WLD'
    'YEM'
    'ZMB'
    'ZWE'
    ];
    
TT=size(data,2);
    
% Now we need to load pwt71 and put the data in the proper order
%load pwt71;
load pwt80

[T,N]=size(rgdpe);
pop0to14=zeros(T,N)*NaN;
KeyYears=(1960:2008)';  % WB data span

wb=mat2cell(wbcodes,ones(size(wbcodes,1),1),3);  % Make it a cell instead of strmat

for i=1:N;
  indx=find(ismember(wb,codes(i))==1);
  if ~isempty(indx);
    pop0to14(KeyYears-1949,i)=data(indx,1:TT)'; 
  end;
end;

pop15over=100-pop0to14;
save WBAdultPopulation80 pop0to14 pop15over;

y=rgdpe(2007-1949,:)'./pop(2007-1949,:)'/1000;

figure(1); figsetup;
plotname(log(y),pop15over(2007-1949,:)',codes);
set(gca,'XTick',log([0.25 0.5 1 2 4 8 16 32 64]));
set(gca,'XTickLabel',strmat('0.25 0.5 1 2 4 8 16 32 64'));
chadfig('Per capita GDP (thousands)','Percent Aged 15 and Over',1,0);
makefigwide;
print WBAdultPopulation80.eps
