% CominHobijnTechAdoption   3/18/15
%
%   Fig 5 from their AER 2010 paper -- technology adoption lags are falling
%   over time. Data downloaded from the AER page:
%   https://www.aeaweb.org/articles.php?doi=10.1257/aer.100.5.2031

clear all;
diarychad('CominHobijnTechAdoption')
definecolors;

%https://www.aeaweb.org/articles.php?doi=10.1257/aer.100.5.2031

data=[
% Inventionyear  FE     Mean lag
1885	38.2122786667	43.68208   %  Cars                 
1973	14.8227386667	13.95691   %  PCs                  
1882	46.1518486667	56.36605   %  Electricity          
1885	36.6350486667	39.12677   %  Trucks               
1950	21.6506586667	16.30637   %  Blast oxygen         
1825	80.7163486667	79.59427   %  Railways - freight   
1825	93.9661486667	97.31877   %  Railways - passengers
1835	49.5114486667	45.6143    %  Telegrams            
1876	45.0440486667	51.54243   %  Telephones           
1903	44.7903486667	43.48985   %  Aviation - freight   
1903	35.3671986667	33.89628   %  Aviation - passengers
1973	13.1904586667	14.61374   %  Cellphones           
1983	9.8622886667	7.798244   %  Internet users       
1977	20.7054286667	5.301676   %  MRI units            
1788	118.4327486667	120.4513   %  Steam- and motorships
];

year=data(:,1);
lag=data(:,3);

% names=[
% 'Cars                 '
% 'PCs                  '
% 'Electricity          '
% 'Trucks               '
% 'Blast oxygen         '
% 'Railways - freight   '
% 'Railways - passengers'
% 'Telegrams            '
% 'Telephones           '
% 'Aviation - freight   '
% 'Aviation - passengers'
% 'Cellphones           '
% 'Internet users       '
% 'MRI units            '
% 'Steam- and motorships'
%     ]
    
names={
'Cars'
'PCs'
'Electricity'
'Trucks'
'Blast oxygen'
'Railways (freight)'
'Railways (passengers)'
'Telegrams'
'Telephones'
'Aviation (freight)'
'Aviation (passengers)'
'Cellphones'
'Internet users'
'MRI units'
'Steam- and motorships'
    };

figure(1); figsetup; makefigwide;
plotnamesym2(year,lag,names,10,[],30,8);
ax=axis; ax(1)=1781; axis(ax);
nums=(1800:50:2000)';
relabelaxis(nums,num2str(nums),'x');
chadfig2('Year of Invention','Adoption lag (years)',1,0);
print CominHobijnTechAdoption.eps
    
    