% CommodityMetals   2/28/15
%
%  Commodity metal prices from the Global Financial Data database.
%  See Data/GlobalFinancialData-Prices.xls
%
%  Prices in dollars.


diarychad('CommodityMetals')
definecolors;

data=[
% Aluminum     Copper	Zinc	Lead	IronOre	Coal	USCPI
1900	675.00	16.50	83.80	70.00	5.50	3.92	8.14
1901	680.00	17.00	87.00	64.00	4.25	4.33	8.24
1902	680.00	13.50	98.20	65.60	4.25	4.46	8.34
1903	680.00	13.00	103.00	68.00	4.50	4.83	8.53
1904	721.00	13.00	120.00	73.60	3.00	4.83	8.63
1905	721.00	18.00	125.00	89.60	3.75	4.82	8.53
1906	738.00	23.50	130.00	96.00	4.25	4.86	8.72
1907	927.70	15.38	94.50	76.00	5.00	4.82	9.11
1908	591.60	14.63	94.50	65.60	4.50	4.82	8.92
1909	453.50	13.50	119.00	75.20	4.50	4.82	8.82
1910	452.20	13.00	107.50	72.00	5.00	4.81	9.21
1911	376.00	14.25	124.00	71.20	4.50	5.00	9.21
1912	529.20	17.70	143.00	66.60	3.75	5.28	9.4
1913	377.00	15.38	102.50	70.40	4.40	5.31	9.6
1914	380.40	13.00	109.00	60.80	3.75	5.32	9.69
1915	1136.20	22.50	345.00	86.80	3.75	5.33	9.74
1916	1268.00	33.84	190.00	117.60	4.45	5.57	10.64
1917	740.00	23.50	152.50	103.00	5.95	5.94	12.82
1918	662.00	23.00	153.00	96.00	6.65	6.86	15.06
1919	649.60	18.75	180.00	127.20	6.45	8.27	17.3
1920	450.00	13.00	112.00	76.00	7.45	9.50	20.04
1921	350.00	13.75	97.00	70.80	6.45	10.53	17.9
1922	450.40	14.22	146.00	88.32	5.95	10.60	16.77
1923	526.20	12.98	129.00	117.60	6.45	10.88	17.07
1924	540.00	14.32	156.00	153.60	5.65	11.37	17.1
1925	560.00	13.96	176.50	148.00	4.55	11.19	17.53
1926	537.00	13.44	140.00	124.80	4.55	11.48	17.7
1927	485.20	13.95	128.50	104.00	4.55	10.95	17.37
1928	478.00	15.94	124.00	104.00	4.55	13.00	17.13
1929	478.00	17.87	135.50	100.00	4.80	12.89	17.13
1930	466.00	10.49	83.00	81.60	4.80	12.72	16.7
1931	466.00	6.72	77.00	60.00	4.80	11.40	15.23
1932	466.00	4.91	97.00	50.40	4.80	10.92	13.66
1933	466.00	8.00	97.00	68.80	4.80	9.92	12.96
1934	410.00	8.87	97.00	56.00	4.80	9.85	13.39
1935	410.00	9.12	97.00	72.00	4.80	10.05	13.73
1936	410.00	12.00	109.00	96.00	4.80	9.91	13.86
1937	400.00	10.13	115.00	76.00	5.25	9.64	14.36
1938	400.00	11.25	83.00	76.00	5.25	9.71	14.09
1939	400.00	12.50	115.00	84.00	5.25	9.16	13.89
1940	340.00	12.00	145.00	88.00	4.75	9.79	14.03
1941	300.00	12.00	165.00	93.60	4.75	10.29	14.73
1942	300.00	12.00	165.00	104.00	4.75	10.38	16.3
1943	300.00	12.00	165.00	104.00	4.75	11.41	17.3
1944	300.00	12.00	165.00	104.00	4.75	11.43	17.6
1945	300.00	12.00	165.00	104.00	4.95	12.39	18
1946	300.00	19.50	210.00	200.80	5.45	13.62	19.54
1947	300.00	21.50	210.00	240.00	5.95	14.80	22.34
1948	300.00	23.50	350.00	344.00	6.60	16.39	24.08
1949	300.00	18.50	195.00	192.00	7.60	12.17	23.85
1950	300.00	24.50	350.00	272.00	8.10	13.06	24.08
1951	380.00	24.50	390.00	304.00	8.70	14.51	25.98
1952	400.00	24.50	250.00	236.00	9.45	16.01	26.55
1953	430.00	29.50	200.00	216.00	10.30	15.53	26.75
1954	444.00	30.00	230.00	240.00	10.30	13.66	26.88
1955	488.00	43.00	260.00	256.00	10.40	13.64	26.78
1956	542.00	36.00	270.00	256.00	11.25	15.57	27.18
1957	520.00	27.00	200.00	208.00	11.85	15.51	28.15
1958	494.00	29.00	230.00	208.00	14.37	14.41	28.92
1959	520.00	33.00	250.00	192.00	12.23	14.65	29.16
1960	520.00	30.00	240.00	176.00	11.42	14.10	29.62
1961	480.00	31.00	240.00	164.00	11.02	13.93	29.92
1962	450.00	31.00	230.00	160.00	11.01	13.93	30.26
1963	460.00	31.00	260.00	200.00	11.02	14.42	30.62
1964	490.00	34.00	290.00	256.00	10.24	14.20	31.03
1965	490.00	36.00	290.00	256.00	10.24	12.99	31.56
1966	490.00	36.00	290.00	224.11	9.52	9.27	32.46
1967	500.00	38.00	270.00	224.11	8.86	9.02	33.4
1968	520.00	42.00	270.00	208.10	8.77	9.16	34.8
1969	560.00	56.00	310.00	256.12	9.84	10.47	36.67
1970	580.00	53.00	284.10	232.11	9.84	7.80	38.84
1971	580.00	50.25	372.90	227.31	10.33	8.68	40.51
1972	500.00	50.50	386.40	244.92	10.33	9.60	41.85
1973	580.00	68.10	1309.70	296.14	10.33	11.48	44.45
1974	780.00	68.60	702.60	392.19	13.38	16.89	49.33
1975	820.00	63.60	717.40	320.16	17.30	26.84	53.84
1976	960.00	65.00	689.30	413.00	22.72	27.16	56.94
1977	1060.00	63.00	555.90	528.26	23.06	28.68	60.61
1978	1060.00	71.25	725.40	608.29	21.45	30.15	65.22
1979	1320.00	103.00	751.30	920.45	23.50	32.37	72.57
1980	1520.00	86.25	818.90	656.32	28.09	44.98	82.38
1981	1520.00	78.00	903.80	496.24	28.09	56.50	90.93
1982	1520.00	72.00	689.50	340.96	32.50	45.50	96.5
1983	1630.00	68.00	912.20	408.20	29.00	29.25	99.6
1984	1630.00	63.00	783.00	384.19	26.15	33.75	103.9
1985	1630.00	66.50	622.00	305.75	26.56	33.75	107.6
1986	1080.00	63.25	724.00	414.60	26.26	29.25	109.6
1987	2035.00	150.00	786.00	697.94	25.30	31.00	113.6
1988	2550.00	156.75	1615.00	667.36	24.30	38.00	118.3
1989	1628.00	109.00	1338.00	718.95	27.83	38.00	124
1990	1526.00	120.00	1251.00	616.31	32.50	40.50	130.7
1991	1126.00	101.25	1178.00	538.85	34.76	39.50	136.2
1992	1232.00	105.50	1058.00	448.59	33.10	35.00	140.3
1993	1108.50	85.95	1001.50	474.00	29.09	31.00	144.5
1994	1952.00	143.35	1135.00	651.00	26.47	36.10	148.2
1995	1675.00	128.73	1001.50	715.00	28.38	39.35	152.4
1996	1515.50	103.50	1046.00	701.50	30.00	35.35	156.9
1997	1535.50	79.43	1091.00	559.00	30.15	31.40	160.5
1998	1238.00	72.80	916.00	497.00	31.00	26.10	163
1999	1630.50	88.00	1239.00	478.00	27.59	25.10	166.6
2000	1560.00	87.78	1021.00	471.00	28.79	30.75	172.2
2001	1335.00	68.30	767.50	504.00	30.03	27.35	177.1
2002	1344.50	72.45	749.50	421.50	29.31	24.50	179.9
2003	1592.50	108.05	1008.00	739.50	31.95	34.00	184
2004	1964.00	155.33	1270.00	1000.00	37.90	52.25	188.9
2005	2285.00	223.03	1915.00	1100.00	65.00	38.23	195.3
2006	2895.00	290.78	4331.00	1775.00	73.50	49.75	201.6
2007	2285.00	308.30	2287.50	2531.50	190.12	91.00	207.34
2008	1455.00	136.45	1120.50	949.00	69.98	78.65	215.3
2009	2208.00	325.10	2570.00	2395.00	105.07	83.10	214.54
2010	2461.00	441.40	2432.50	2587.00	163.10	118.29	218.06
2011	1970.50	348.02	1828.00	1980.00	136.39	111.56	224.94
2012	1855.00	369.60	2034.25	2339.75	128.51	92.88	229.59
2013	1764.25	348.50	2085.25	2205.50	135.79	84.34	232.96
2014	1831.25	292.40	2166.50	1852.50	68.00	62.44	236.74
];

yrs=data(:,1);
nominal=data(:,2:7);
cpi=data(:,8);
real=div(nominal,cpi)*100;

figure(1); figsetup;
plot(yrs,log(nominal));

figure(2); figsetup;
plot(yrs,log(real));

g=delta(log(real));
gAvg=mean(g')';
pcomm=exp([0; cumsum(gAvg)]);
pcomm=pcomm/pcomm(1)*100


figure(3); figsetup;
plot(yrs,100*ones(length(yrs)),'-','Color',mygrey,'LineWidth',2);
plot(yrs,20*ones(length(yrs)),'-','Color',mygrey,'LineWidth',2);
plot(yrs,pcomm,'-','Color',myblue,'LineWidth',4);
ax=axis; ax(2)=2015; ax(3)=0; axis(ax);
chadfig2('Year','Equally-weighted price index (initial value is 100)',1,0);
makefigwide;
set(gca,'Layer','top');
wait
print CommodityMetals.eps