% scidata.m
%
%  Uses my JPE/QJE data to start with, and then augments the data using the
%  1996 Science and Engineering Indicators (available on web).
%  In thousands...
%
%  Merge the data, then loglinear interpolate.    
%
%  Revised 5/5/2000 using SciEng 1998 edition.
%  Also, filling in data backwards to 1950 by some assumptions. 


if exist('scidata.log'); delete('scidata.log'); end;
diary scidata.log;
fprintf(['scidata                 ' date]);
disp ' ';
disp ' ';
help scidata


clear;

% U.K. data from SciEngInd1993
%       France   Germany    Japan      U.S.   
sci89=[
 1950      NaN       NaN       NaN     NaN    161.4;
 1951      NaN       NaN       NaN     NaN    178.8;
 1952      NaN       NaN       NaN     NaN    209.4;
 1953      NaN       NaN       NaN     NaN    232.9;
 1954      NaN       NaN       NaN     NaN    249.2;
 1955      NaN       NaN       NaN     NaN    254.4;
 1956      NaN       NaN       NaN     NaN    276.8;
 1957      NaN       NaN       NaN     NaN    315.6;
 1958      NaN       NaN       NaN     NaN    337.1;
 1959      NaN       NaN       NaN     NaN    369.8;
 1960      NaN       NaN       NaN     NaN    394.3;
 1961      NaN       NaN       NaN     NaN    418.8;
 1962      NaN       NaN       NaN     NaN    451.5;
 1963      NaN       NaN       NaN     NaN    486.2;
 1964      NaN       NaN       NaN     NaN    508.7;
 1965      42.8      61.0     117.6   49.9    524.0;
 1966      47.6      60.0     128.9   NaN     537.3;
 1967      52.4      64.5     138.7   NaN     565.9;
 1968      54.7      68.0     157.6   52.8    564.9;
 1969      57.2      74.9     157.1   NaN     560.8;
 1970      58.5      82.5     172.0   NaN     546.5;
 1971      60.1      90.2     194.3   NaN     526.4;
 1972      61.2      96.0     198.1   76.7    518.5;
 1973      62.7     101.0     226.6   NaN     520.4;
 1974      64.1     102.5     238.2   NaN     525.4;
 1975      65.3     103.7     255.2   80.5    534.8;
 1976      67.0     104.5     260.2   NaN     549.9;
 1977      68.0     111.0     272.0   NaN     570.3;
 1978      70.9     113.9     273.1   87.7    595.3;
 1979      72.9     116.9     281.9   NaN     621.0;
 1980      74.9     120.7     302.6   NaN     651.2;
 1981      85.5     124.7     317.5   95.4    683.3;
 1982      90.1     127.7     329.7   NaN     711.9;
 1983      92.7     130.8     342.2   94.0    751.7;
 1984      98.2     137.1     370.0   NaN     797.8;
 1985     102.3     143.6     381.3   97.8    849.2;
 1986     105.1     146.6     405.6   101.7   896.5;
 1987     108.2     151.5     418.3   101.4   923.3;
 1988      NaN       NaN       NaN    102.6   949.2];

%   France   Germany   Japan   U.K.   U.S.
sci98=[
1979  72.9    116.9    291.2  NaN    614.5;
1980  74.9    120.7    303.2  NaN    651.1;
1981  85.5    124.7    311.0  127    683.2;
1982  90.1    NaN      321.0  128    711.8;
1983  92.7    130.8    347.4  127    751.6;
1984  98.2    NaN      357.4  129    NaN  ;
1985  102.3   143.6    380.3  131    801.9;
1986  105.0   NaN      393.0  134    NaN  ;
1987  109.4   165.6    415.6  134    877.8;
1988  115.2   NaN      434.6  137    NaN  ;
1989  120.4   176.4    457.5  133    924.2;
1990  123.9   NaN      477.9  133    NaN  ;
1991  129.8   241.9    491.1  131    960.4;
1992  141.7   234.3      511.4  134    NaN  ;
1993  145.9   229.8     526.5  140    962.7];


% Merge year is 1979 for everyone except U.K.=1981.

yr0=1949;
mrgfactor=sci98(1,:)./sci89(1979-yr0,:);
mrgfactor(5)=sci98(3,5)/sci89(1981-yr0,5); % 5 bc of year

mrgfactor

sci89m=mult(sci89,mrgfactor);

yrs=(1950:1978)';
scieng=[sci89m(yrs-yr0,:); sci98];
scieng(:,1)=[];
yrs=(1950:1993)';

%  Display the data

disp ' ';
disp 'QJE/JPE data, 1989';
cshow(' ',sci89,'%6.0f %8.1f %8.1f %8.1f %8.1f %8.1f');
disp ' ';
disp ' ';
disp 'The merged data, not yet interpolated';
disp ' ';
cshow(' ',[yrs scieng],'%6.0f %8.1f %8.1f %8.1f %8.1f %8.1f');
disp ' ';


%  Now, do the interpolation with logs of the data
logsci=log(scieng);
logscinew=interplin3(logsci);

clf;
plot(yrs,logsci,'o');
hold on;
plot(yrs,logscinew);
hold off;

scieng=exp(logscinew);

% Now, get the data backwards to 1950 for total G-5,
%  First, we load the employment.m data
load employment; 			% employ5093

% Compute Shares of employment
ellA=scieng./employ5093;
disp ' '; disp ' ';
disp 'R&D Shares of Employment*100';
disp '  Year    France   Germany    Japan     U.K.    U.S.';
disp '-----------------------------------------------------';
fmt='%6.0f %8.3f %8.3f %8.3f %8.3f %8.3f';
cshow(' ',[yrs ellA*100],fmt);


% Now, the backcasting back to 1950.  To do this, we assume the ratio of
% ellA(Jpn)/ella(US) in 1950 is the same as in 1965, and then interpolate
% linearly.
ratio65=ellA(1965-1949,1:4)/ellA(1965-1949,5)
ellA50=ratio65*ellA(1950-1949,5)
ellA(1950-1949,1:4)=ellA50;
ellAint=interplin3(ellA(:,1:4));
ellA(:,1:4)=ellAint;

% Compute Shares of employment
disp ' '; disp ' ';
disp 'AFTER BACKCASTING to 1950:';
disp 'R&D Shares of Employment*100';
disp '  Year    France   Germany    Japan     U.K.    U.S.';
disp '-----------------------------------------------------';
fmt='%6.0f %8.3f %8.3f %8.3f %8.3f %8.3f';
cshow(' ',[yrs ellA*100],fmt);

% Finally, update scieng levels
scieng=employ5093.*ellA;

% Now show the data and save
disp ' ';
disp ' ';
disp 'The final data:';
disp ' ';
cshow(' ',[yrs scieng],'%6.0f %8.1f %8.1f %8.1f %8.1f %8.1f');
disp ' ';

disp ' '; disp ' ';
disp 'World G-5 Totals';
G5sci=sum(scieng')';
G5emp=sum(employ5093')';
ellAG5=G5sci./G5emp;
disp 'Year   G5Sci   G5emp   ellAG5*100';
disp '----------------------------------';
cshow(' ',[yrs G5sci G5emp ellAG5*100],'%6.0f %8.0f %8.0f %8.3f');

figure(1); clf;
plot(yrs,ellA);
title('ellA for each country');
print scidata.ps;
   
figure(2); clf;
plot(yrs,scieng);
title('scieng');
print -append scidata.ps;

figure(3); clf;
plot(yrs,[ellA(:,5) ellAG5]);
title('ellA, U.S. and G-5');
print -append scidata.ps;

save scieng scieng employ5093 ellA G5sci G5emp ellAG5;

diary off;