% Divergence.m   3/5/15
%
% divergePC.m  9/1/05  -- Per Capita version
%   Use PWT61 to plot var(log) and top5/bot5 like book
%   Copied from Work/Book/SecondEdition/Ch3/divergePC70.m

diarychad('Divergence');

clear;
load pwt80;
load regions80;
definecolors;

yrT=2011
yrs=(1960:yrT);
yr0=1949;
num=5


gdp=rgdpo;
ypc=div(rgdpo,pop);       % per capita  
y=div(ypc,ypc(:,USA))*100; % US=100

% Let's make sure we have a constant set of countries.
ctys=(~isnan(ypc(1960-yr0,:)')) & (~isnan(ypc(yrT-yr0,:)')) & ~outliersAfter1980;
if any(isnan(ypc(yrs-yr0,ctys))); disp 'Still not clean...'; keyboard; end;

fprintf('Number of Countries: %6.0f\n',sum(ctys));

yratio=[];
richpoor=[];
stdlog=[];
ymedian=[];
for t=yrs;
%  y=packr(ypc(t-yr0,:)');
%  y=packr(pcgdp(t-yr0,:)');
  y=ypc(t-yr0,ctys)';
  yl=sort(y);
  yh=-sort(-y);
  yratio=[yratio; yh(num)/yl(num)];
  ymedian=[ymedian; yh(2)/median(y)];
  richpoor=[richpoor; yh(1)/yl(1)];
  stdlog=[stdlog; sqrt(variance(log(y)))];
end;

%set(0,'defaultAxesLineWidth',1);  % Otherwise, default=0
%set(0,'defaultLineLineWidth',2);

% figsetup;
% [ax h1 h2]=plotyy(yrs,yratio,yrs,stdlog);
% xlabel('Year');
% set(ax(1),'YLim',[0 85]);
% set(ax(2),'YLim',[0.9 1.5]);
% str1=mlstring('Standard Deviation of\\  Log GDP per person\\         (right scale)');
% str2=mlstring('Ratio of GDP per person,\\  5th Richest to 5th Poorest\\             (left scale)');
% text(1982,6,str1);
% text(1963,36,str2);
% chadfig(' ',' ',1,0);
% print divergePC70.ps;

LW=4;

% Now show the individual plots in levels
figure(1); figsetup; 
[ax h1 h2]=plotyy(yrs,stdlog,yrs,yratio);
darkfactor=.8;
set(h1,'LineWidth',LW,'Color',myblue);
set(h2,'LineWidth',LW,'Color',mygreen);
set(ax(1),'ycolor',myblue*darkfactor);
set(ax(2),'ycolor',mygreen*darkfactor);

set(ax(1),'YLim',[0.9 1.4001]);
set(ax(2),'YLim',[20 80]);
str1=mlstring('Standard deviation of\\  log GDP per person\\         (left scale)');
str2=mlstring('Ratio of GDP per person,\\  5th Richest to 5th Poorest\\             (right scale)');
text(1975,1.3,str1);
text(1994,1.02,str2);

% a1=axis(ax(1)); a1(3)=-3; a1(2)=2014; axis(ax(1),a1);
% a2=axis(ax(2)); a2(3)=37; a2(2)=2014; axis(ax(2),a2);
% %lab2=strmat('1.2 1.4 1.6 1.8 2.0 2.2 2.4');
% %lab1=strmat('0.2 0.3 0.4 0.5');
% lab=strmat('1960 1970 1980 1990 2000 2010');
 set(ax(2),'XLim',[1960 2014]);
 set(ax(1),'XLim',[1960 2014]);
% set(ax(2),'XTick',str2num(lab));
% set(ax(2),'XTickLabel',lab);
% set(ax(1),'XTick',str2num(lab));
% set(ax(1),'XTickLabel',lab);
set(ax(1),'Box','off');
set(ax(2),'Box','off');
makefigwide;
chadfig2(' ','Standard Deviation',1,0);
chadfigyy(ax(2),'Ratio');
print Divergence.eps



tle='Years 5thRatio RichPoor 2nd/Mdn Stdev(log)';
cshow(' ',[yrs' yratio richpoor ymedian stdlog],'%8.0f %8.2f %8.2f %8.3f',tle);


% Let's also make a table with various percentiles over time.
yrs=[1960 1970 1980 1990 2000 2008];
prc=[0 5 10 20 50 80 90 95 100]';
y=div(ypc,ypc(:,USA))*100;  %USA=100
y=y(yrs-1949,ctys)';
yprc=getprctile(y,prc);

disp ' '; disp ' ';
disp 'Percentiles of the Country Distribution';
disp ' ';
tle=num2str([0 yrs],'%5.0f');
cshow(' ',[prc yprc],'%6.0f %7.1f',tle);


disp ' '; disp ' ';
disp 'Various ratios...';
disp ' ';

data=[];
ratios=[100 0; 95 5; 90 10; 80 20; 95 50; 90 50; 80 50; 95 80; 50 5; 50 10; 50 20];
for i=1:size(ratios,1);
  indx1=find(prc==ratios(i,1));
  indx2=find(prc==ratios(i,2));
  data=[data; yprc(indx1,:)./yprc(indx2,:)];
end;
tle=num2str([1000 1000 yrs],'%5.0f');
fmt='%4.0f %4.0f %7.1f %7.1f %7.1f %7.1f %7.1f';
cshow(' ',[ratios data],fmt,tle);

disp ' '; disp ' ';
disp 'Factor increase';
cshow(' ',[ratios data(:,5)./data(:,1)],'%4.0f %4.0f %8.2f');

diary off;
