clc
clear all
FileName='C:\Users\Bob Hall\Dropbox\CPS flows\Tex\MME052713';
input=fileread([FileName '.tex']);
FiguresAndTablesOnly=false;
nChar=numel(input);
if FiguresAndTablesOnly
    keeps={'\xl'};
else
    keeps={'\eq','\xl'};
end
nkeep=numel(keeps);
fileID=fopen([FileName 'slides.tex'],'wt');
iChar=1;
EndDoc=false;
for line=1:10000
    keepThisLine=false;
    for keep=1:nkeep
        
        %  Currently positioned at beginning of a line
        
        if strcmp(input(iChar:iChar+7),'\end{doc')
            EndDoc=true;
        end
        if strcmp(input(iChar:iChar+2),keeps{keep})
            keepThisLine=true;
            disp(['Keeping line ' num2str(line)])
        end
    end
    if EndDoc
        break
    end
    
    %  Find the end of the line
    
    BeamerLine=' ';
    for iB=1:2000
        char=input(iChar);
        BeamerLine(iB)=char;
        iChar=iChar+1;
        if uint8(char)==10
            break
        end
    end
    disp(['Current line ' BeamerLine])
    
    % Keep this line and write to EasyBeamer file
    
    if keepThisLine
        disp(['Keeping line ' BeamerLine])
        lineEnd=iB;
        if strcmp(BeamerLine(1:4),'\eq{')
            BeamerLine=BeamerLine(4:iB);
            lineEnd=iB-3;
        end
        if strcmp(BeamerLine(1:4),'\eql')
            disp(BeamerLine)
            BeamerLine=BeamerLine(5:iB);
            lineEnd=iB-4;
        end
        if BeamerLine(lineEnd-2)==',' || BeamerLine(lineEnd-2)=='.'
            BeamerLine=[BeamerLine(1:lineEnd-3) BeamerLine(lineEnd-1:lineEnd)];
        end
        fprintf(fileID,'%s',BeamerLine);
    end
    if iChar>nChar
        break
    end
end
fprintf(fileID,'%s',BeamerLine);   %  Add end document
fclose(fileID);

