% Fertility   3/4/15
%
%  Fertility rates in the U.S. and Europe. 
%
% Fertility and Mortality in the United States
% Michael Haines
% http://eh.net/encyclopedia/fertility-and-mortality-in-the-united-states/
%
% The Baby Boom and Baby Bust:
% O.E.C.D. Fertility Data
% Jeremy Greenwood and Guillaume Vandenbroucke
% 2004
%   http://guillaumevdb.net/BabyBoom-data.pdf


diarychad('Fertility')
definecolors;


% Fertility and Mortality in the United States
% Michael Haines
% http://eh.net/encyclopedia/fertility-and-mortality-in-the-united-states/
dataUS=[
% Birth rate for U.S., whites
1800	55.0  
1810	54.3  
1820	52.8  
1830	51.4  
1840	48.3  
1850	43.3  
1860	41.4  
1870	38.3  
1880	35.2  
1890	31.5  
1900	30.1  
1910	29.2  
1920	26.9  
1930	20.6  
1940	18.6  
1950	23.0  
1960	22.7  
1970	17.4  
1980	15.1  
1990	15.8  
2000	13.9  
];

yrsUS=dataUS(:,1);
birthUS=dataUS(:,2);

% The Baby Boom and Baby Bust:
% O.E.C.D. Fertility Data
% Jeremy Greenwood and Guillaume Vandenbroucke
% 2004
%   http://guillaumevdb.net/BabyBoom-data.pdf

data=[
% Australia Belgium Canada Denmark Finland France Greece Ireland
1800 NaN NaN NaN 29.9 37.6 NaN NaN NaN
1801 NaN NaN NaN 31.1 39.6 32.9 NaN NaN
1802 NaN NaN NaN 32.2 39.2 33 NaN NaN
1803 NaN NaN NaN 33.1 35.6 32.5 NaN NaN
1804 NaN NaN NaN 32.3 39.1 31.3 NaN NaN
1805 NaN NaN NaN 32.8 38.4 31.6 NaN NaN
1806 NaN NaN NaN 30.2 35.7 31.4 NaN NaN
1807 NaN NaN NaN 31 36.2 31.8 NaN NaN
1808 NaN NaN NaN 30.6 30.4 31.3 NaN NaN
1809 NaN NaN NaN 29.3 28.6 32 NaN NaN
1810 NaN NaN NaN 30.3 40.5 31.8 NaN NaN
1811 NaN NaN NaN 30.5 36.4 31.6 NaN NaN
1812 NaN NaN NaN 29.8 38.9 30.1 NaN NaN
1813 NaN NaN NaN 29.1 35.6 30.5 NaN NaN
1814 NaN NaN NaN 30.4 36.7 33.9 NaN NaN
1815 NaN NaN NaN 34.1 37.5 32.5 NaN NaN
1816 NaN NaN NaN 32.9 38.8 32.9 NaN NaN
1817 NaN NaN NaN 32.8 39 31.8 NaN NaN
1818 NaN NaN NaN 32.1 38.4 30.6 NaN NaN
1819 NaN NaN NaN 32.5 36.1 32.9 NaN NaN
1820 NaN NaN NaN 31.5 36.6 31.7 NaN NaN
1821 NaN NaN NaN 32.1 41.4 31.7 NaN NaN
1822 NaN NaN NaN 33.7 35.6 31.7 NaN NaN
1823 NaN NaN NaN 32.6 40.3 31.2 NaN NaN
1824 NaN NaN NaN 31.3 37.8 31.6 NaN NaN
1825 NaN NaN NaN 31.3 38.5 31 NaN NaN 
1826 NaN NaN NaN 31.4 37.6 31.4 NaN NaN
1827 NaN NaN NaN 29.2 36.7 30.8 NaN NaN
1828 NaN NaN NaN 30.3 39.3 30.5 NaN NaN
1829 NaN NaN NaN 29.6 38.7 30 NaN NaN
1830 NaN 32.3 NaN 28.9 36.6 29.9 NaN NaN
1831 NaN 33 NaN 29.7 35.2 30.3 NaN NaN
1832 NaN 34.5 NaN 27 34.5 28.6 NaN NaN
1833 NaN 33.2 NaN 32.2 30.2 29.5 NaN NaN
1834 NaN 33.3 NaN 33 36.6 29.8 NaN NaN
1835 NaN 34 NaN 31.7 34.3 29.9 NaN NaN
1836 NaN 34 NaN 30.5 31.1 29.2 NaN NaN
1837 NaN 33.4 NaN 30 31.6 28 NaN NaN
1838 NaN 35.2 NaN 29.8 31.8 28.5 NaN NaN
1839 NaN 33.7 NaN 29 33.7 28.2 NaN NaN
1840 NaN 34.2 NaN 30.4 34.7 27.9 NaN NaN
1841 NaN 34 NaN 29.7 34 28.5 NaN NaN
1842 NaN 32.6 NaN 30.1 37.2 28.5 NaN NaN
1843 NaN 31.9 NaN 29.8 35.8 28.2 NaN NaN
1844 NaN 31.8 NaN 30.3 35 27.5 NaN NaN
1845 NaN 32.2 NaN 30.6 35.7 27.9 NaN NaN
1846 NaN 27.8 NaN 30.1 33.2 27.3 NaN NaN
1847 NaN 27.2 NaN 30.6 33.9 25.4 NaN NaN
1848 NaN 27.7 NaN 30.6 36.5 26.5 NaN NaN
1849 NaN 31 NaN 31 37.5 27.7 NaN NaN
1850 36.9 30 NaN 31.4 35.7 26.8 NaN NaN 
1851 37.4 30.3 NaN 30.1 38.2 27.1 NaN NaN
1852 35.1 30 NaN 33.2 35 26.8 NaN NaN
1853 37.5 28.3 NaN 31.6 35.1 26 NaN NaN
1854 36.3 28.8 NaN 32.7 37.5 25.5 NaN NaN
1855 39.7 27.7 NaN 31.9 35.8 25 NaN NaN
1856 38.7 29.1 NaN 32.4 36.3 26.3 NaN NaN
1857 42 31.6 NaN 32.9 32.8 25.9 NaN NaN
1858 42.6 31.7 NaN 33.2 36.5 26.7 NaN NaN
1859 42.9 32.4 NaN 33.6 35.8 27.9 NaN NaN
1860 42.6 31 NaN 32.6 36.4 26.2 NaN NaN
1861 42.3 31.1 NaN 31.6 37.8 26.9 NaN NaN
1862 43.3 30.4 NaN 30.8 37.3 26.5 NaN NaN
1863 41.7 32.2 NaN 30.9 36.2 26.9 NaN NaN
1864 42.9 32.1 NaN 30.1 39.3 26.6 NaN 24.2
1865 42.1 31.6 NaN 31.1 34.2 26.5 NaN 25.9
1866 39.8 31.7 NaN 32 32 26.4 NaN 26.5
1867 40.4 32.6 NaN 30.3 32.3 26.2 NaN 26.3
1868 40.5 31.9 NaN 31 24.6 25.7 NaN 26.7
1869 38.6 32 NaN 29.3 33.7 26 NaN 26.7
1870 38.7 32.7 NaN 30.3 36.3 25.9 NaN 27.7
1871 38 31.2 NaN 30.1 37.3 22.9 NaN 28.1
1872 37.1 32.7 NaN 30.3 36.4 26.7 NaN 27.8
1873 37.4 33 NaN 30.8 37 26 NaN 27.1
1874 36.8 33.1 NaN 30.9 37.9 26.2 NaN 26.6
1875 35.9 32.9 NaN 31.9 36.6 25.9 NaN 26.1
1876 35.9 32.7 NaN 32.6 36.7 26.2 NaN 26.4
1877 35 32.8 NaN 32.3 38.2 25.5 NaN 26.2
1878 35.4 31.9 NaN 31.6 35.4 25.2 NaN 25.1
1879 35.8 31.9 NaN 31.9 37.8 25.1 NaN 25.2
1880 35.2 31 NaN 31.7 36.5 24.6 NaN 24.7
1881 35.3 31.8 NaN 32.3 35 24.9 NaN 24.5
1882 34.5 31.6 NaN 32.3 36.3 24.8 NaN 24
1883 34.8 30.9 NaN 31.8 35.9 24.8 NaN 23.5
1884 35.6 30.9 NaN 33.3 36.1 24.7 NaN 23.9
1885 35.7 30.3 NaN 32.5 34.2 24.3 NaN 23.5
1886 35.4 29.9 NaN 32.4 35.3 23.9 NaN 23.2
1887 35.6 29.7 NaN 31.7 36.2 23.5 NaN 23.1
1888 35.5 29.4 NaN 31.5 34.9 23.1 NaN 22.8
1889 34.7 29.4 NaN 31.2 33.4 23 NaN 22.7
1890 35 29 NaN 30.5 32.9 21.8 NaN 22.3
1891 34.5 30 NaN 31 34.3 22.6 NaN 23.1
1892 33.7 28.9 NaN 29.6 31.6 22.3 NaN 22.5
1893 32.8 29.5 NaN 30.8 30.1 22.8 NaN 23
1894 30.8 29 NaN 30.4 31.1 22.3 NaN 22.9
1895 30.4 28.5 NaN 30.3 32.9 21.7 NaN 23.3
1896 28.4 29 NaN 30.5 32.5 22.5 NaN 23.7
1897 28.2 29 NaN 29.8 32.3 22.2 NaN 23.5
1898 27.1 28.6 NaN 30.2 34.4 21.7 NaN 23.3
1899 27.3 28.8 NaN 29.7 33.7 21.8 NaN 23.1
1900 26.7 28.9 27.2 29.7 32.6 21.3 NaN 22.7
1901 27.2 29.4 31.2 29.7 33.2 22 NaN 22.7
1902 26.7 28.4 31.3 29.2 32.4 21.6 NaN 23
1903 25.3 27.5 31.3 28.7 31.5 21.1 NaN 23.1
1904 26.4 27.1 31.4 28.9 33 20.9 NaN 23.6
1905 26.2 26.2 31 28.4 31.8 20.6 NaN 23.4
1906 26.6 25.6 29.9 28.5 32.8 20.5 NaN 23.5
1907 26.8 25.2 29.5 28.2 32.8 19.7 NaN 23.2
1908 26.6 24.8 30.3 28.6 32.2 20.1 NaN 23.3
1909 26.7 23.8 30.2 28.2 32.8 19.5 NaN 23.4
1910 26.7 23.7 30.4 27.5 31.7 19.6 NaN 23.3
1911 27.2 22.8 30.1 26.7 30.8 18.7 NaN 23.2
1912 28.7 22.5 31.3 26.6 30.8 18.9 NaN 23
1913 28.3 22.3 31.7 25.6 28.8 18.8 NaN 22.8
1914 28.1 20.4 31.9 25.6 28.7 18.1 NaN 22.6
1915 27.1 16.1 31.9 24.2 27 11.8 NaN 22
1916 26.6 12.9 30.7 24.4 25.7 9.5 NaN 20.3
1917 26.3 11.3 29.1 23.7 25.9 10.4 NaN 19.7
1918 25 11.3 28.8 24.1 25.4 12.1 NaN 19.8
1919 23.5 16.9 27.7 22.6 20.5 13 NaN 20
1920 25.5 22.2 29.2 25.4 27 21.4 NaN 22.8
1921 25 21.7 29.3 24 25.9 20.7 21.2 21.15
1922 24.7 20.4 28.3 22.2 25 19.3 21.5 19.5
1923 23.8 20.3 26.7 22.3 25.3 19.1 19 20.5
1924 23.2 19.8 26.7 21.8 23.8 18.7 19.5 21.1
1925 22.9 19.6 26.1 21 23.7 19 26.3 20.8
1926 22 18.9 24.7 20.5 23 18.8 30 20.6
1927 21.7 18.2 24.3 19.6 22.5 18.2 28.8 20.3
1928 21.3 18.2 24.1 19.6 22.8 18.3 30.5 20.1
1929 20.3 18.1 23.5 18.6 22.2 17.7 28.9 19.8
1930 19.9 18.6 23.9 18.7 21.8 18 31.3 19.9
1931 18.2 18.1 23.2 18 20.7 17.5 30.8 19.5
1932 16.9 17.5 22.5 18 19.8 17.3 28.5 19.1
1933 16.8 16.3 21 17.3 18.4 16.2 28.6 19.4
1934 16.4 15.9 20.7 17.8 19.1 16.2 31.1 19.5
1935 16.6 15.2 20.5 17.7 19.6 15.3 28.2 19.6
1936 17.1 15.1 20.3 17.8 19.1 15 27.9 19.6
1937 17.4 15 20.1 18 19.9 14.7 26.2 19.2
1938 17.5 15.5 20.7 18.1 21 14.6 25.9 19.4
1939 17.6 15 20.6 17.8 21.2 14.6 24.8 19.1
1940 17.9 13.3 21.6 18.3 17.8 13.6 24.5 19.1
1941 18.9 11.9 22.4 18.5 24.2 13.1 18.3 19
1942 19 12.8 23.5 20.4 16.6 14.5 18.1 22.3
1943 20.6 14.6 24.2 21.4 20.4 15.7 16.7 21.9
1944 21 15 24 22.7 21.3 16.1 20 22.2
1945 21.7 15.3 24.3 23.5 25.5 16.2 25.1 22.7
1946 23.6 17.5 27.2 23.4 27.9 20.9 28.2 22.9
1947 24.1 17 28.9 22.1 28 21.3 27.4 23.2
1948 23.1 17.2 27.3 20.3 27.6 21.1 27 22
1949 22.9 16.8 27.3 18.9 26.1 20.9 18.6 21.5
1950 23.3 16.5 27.1 18.7 24.5 20.5 20 21.4
1951 23 16.4 27.2 17.8 23 19.5 20.3 21.2
1952 23.3 16.7 27.9 17.8 23.1 19.3 19.3 21.9
1953 22.9 16.7 28.1 17.9 22 18.7 18.4 21.2
1954 22.5 16.8 28.5 17.3 21.5 18.7 19.2 21.3
1955 22.6 16.7 28.2 17.3 21.2 18.5 19.4 21
1956 22.5 16.8 28 17.2 20.8 18.4 19.7 21
1957 22.9 17 28.2 16.8 20.1 18.4 19.3 21.2
1958 22.6 17.1 27.5 16.5 18.6 18.1 19 20.9
1959 22.6 17.4 27.4 16.3 18.9 18.3 19.4 21.1
1960 22.4 16.9 26.7 16.6 18.5 17.9 18.9 21.5
1961 22.8 17.2 26 16.6 18.4 18.2 17.9 21.2
1962 22.2 16.8 25.2 16.7 18.1 17.7 18 21.8
1963 21.6 17.1 24.6 17.6 18.2 18.2 17.5 22.2
1964 20.6 17.1 23.4 17.7 17.7 18.2 18 22.4
1965 19.6 16.4 21.3 18 17.1 17.8 17.7 22.1
1966 19.2 15.9 19.3 18.4 17 17.6 17.9 21.6
1967 19.4 14.7 18.2 16.8 16.8 17 18.7 21.1
1968 20.1 14.7 17.6 15.3 15.9 16.7 18.3 20.9
1969 20.4 14.6 17.6 14.6 14.6 16.7 17.6 21.5
1970 20.6 14.6 17.5 14.4 14 16.7 16.5 21.9
1971 21.1 14.4 16.8 15.2 13.2 17.1 16 22.7
1972 19.9 13.8 15.9 15.1 12.7 16.9 15.9 22.7
1973 18.3 13.3 15.6 14.3 12.2 16.4 15.4 22.4
1974 17.9 12.6 15.5 14.1 13.3 15.3 16.1 22.1
1975 16.8 12.2 15.8 14.2 13.9 14.1 15.7 21.2
1976 16.2 12.3 15.7 12.9 14.1 13.6 16 21
1977 15.9 12.4 15.5 12.9 13.9 14 15.5 21.1
1978 15.6 12.4 15.3 12.2 13.5 13.8 15.7 21.2
1979 15.4 12.6 15.4 11.6 13.3 14.1 15.7 21.5
1980 15.3 12.7 15.4 11.2 13.2 14.9 15.4 21.9
1981 15.8 12.7 15.3 10.4 13.2 14.9 14.5 21
1982 15.8 12.2 15.1 10.3 13.7 14.6 14 20.3
1983 15.8 11.9 15 9.9 13.8 13.7 13.5 19.1
1984 15 11.8 15.1 10.1 13.3 13.8 12.7 18.2
1985 15.7 11.6 14.9 10.5 12.8 13.9 11.7 17.6
1986 15.2 11.9 14.7 10.8 12.3 14.1 11.3 17.4
1987 15 11.9 14.4 11 12 13.8 10.6 16.6
1988 14.9 12.1 14.5 11.5 12.8 13.8 10.7 15.3
1989 14.9 12.2 14.9 12 12.8 13.6 10.1 14.8
1990 15.4 12.4 15.2 12.3 13.1 13.4 10.2 15.1
1991 14.9 12.6 14.6 12.5 13.1 13.3 10 14.9
1992 15.1 12.3 14.6 13.1 13.3 13 10.1 14.5
1993 14.7 12 13.4 13 12.8 12.3 9.8 13.9
];
%     2        3      4       5       6      7      8       9
% Australia Belgium Canada Denmark Finland France Greece Ireland

yrs=data(:,1);
birthFra=data(:,7);

figure(1); figsetup;
plot(yrs,birthFra,'-','Color',mygreen,'LineWidth',4);
plot(yrsUS,birthUS,'-','Color',myblue,'LineWidth',4);
chadfig2('Year','Annual births per 1000 population',1,0);
makefigwide;
ax=axis; ax(3)=0; ax(4)=56; axis(ax);
text(1880,40,'United States');
text(1850,20,'France');
print Fertility.eps
