% GreatDivergence   3/11/15
%
%  See Data/MaddisonData2013.xls

diarychad('GreatDivergence');
definecolors;


%GDP per capita							
%(1990 Int. GK$)		
data=[
%		UK	USA	Argent	China	Japan	Ghana
1		600	587	600	600	402	439
1280		677	587	600	600	527	439
1650		925	587	600	600	559	439
1800		2097	1296	931	600	641	439
1850		2330	1849	1251	600	681	439
1870		3190	2445	1468	530	737	439
1913		4921	5301	3797	552	1387	781
1950		6939	9561	4987	448	1921	1122
1980		12931	18577	8206	1061	13428	1157
2010		23777	30491	10256	8032	21935	1922
];

yrs=data(:,1);
y0=300;
uk=data(:,2)/y0;
us=data(:,3)/y0;
arg=data(:,4)/y0;
chn=data(:,5)/y0;
jpn=data(:,6)/y0;
gha=data(:,7)/y0;
LW=4;


figure(1); figsetup;
plot(yrs,gha,'-','Color',mygreen*1.1,'LineWidth',LW);
plot(yrs,chn,'-','Color',myblue*1.1,'LineWidth',LW);
plot(yrs,jpn,'-','Color',myred*.9,'LineWidth',LW);
plot(yrs,arg,'-','Color',mypurp*1.1,'LineWidth',LW);
plot(yrs,uk,'-','Color',mygreen,'LineWidth',LW);
plot(yrs,us,'-','Color',myblue*.9,'LineWidth',LW);
chadfig2('Year','GDP per person (multiple of 300 dollars)',1,0)
%relabelaxis(str2num(axlabel),strmat(axlabel),'y');
ax=axis; ax(1)=1200; ax(2)=2099; ax(3)=.1; ax(4)=102; axis(ax);
%set(gca,'YGrid','on')
makefigwide;
text(2020,100,'U.S.');
text(2020,80,'U.K.');
text(2020,72,'Japan');
text(2020,36,'Argentina');
text(2020,28,'China');
text(2020,6,'Ghana');
print GreatDivergence.eps

