% GrowthSince1980


if exist('GrowthSince1980.log'); delete('GrowthSince1980.log'); end;
diary GrowthSince1980.log;
fprintf(['GrowthSince1980                 ' date]);
disp ' ';
disp ' ';
help GrowthSince1980

clear;

load pwt80;
load regions80
region=region80;

startup;  % for mypurp etc
definecolors;

ctys=[USA CHN IND JPN RUS BRA];

%gdp=rgdpch.*pop;
%y=div(rgdpch,rgdpch(:,USA))*100;  % Relative to US=100

gdp=rgdpo;
ypc=div(rgdpo,pop);       % per capita  
y=div(ypc,ypc(:,USA))*100; % US=100
africa=(region==1) & (~isnan(y(1980-1949,:)'));



%yAfr=sum(gdp(:,africa)')'./sum(pop(:,africa)')'/rgdpch(2007-1949,USA)*100;
%yWEur=sum(gdp(:,westerneurope)')'./sum(pop(:,westerneurope)')'/rgdpch(2007-1949,USA)*100;
yAfr=sum(gdp(:,africa)')'./sum(pop(:,africa)')';
yWEur=sum(gdp(:,westerneurope)')'./sum(pop(:,westerneurope)')';
yAfr=div(yAfr,ypc(:,USA))*100;
yWEur=div(yWEur,ypc(:,USA))*100;

yrs=(1980:2010)';
t=yrs-1949;

lw=4;

figure(1); figsetup;
plot(yrs,log(5)*ones(length(yrs)),'-','Color',mygrey,'LineWidth',1);
plot(yrs,log(10)*ones(length(yrs)),'-','Color',mygrey,'LineWidth',1);
plot(yrs,log(20)*ones(length(yrs)),'-','Color',mygrey,'LineWidth',1);
plot(yrs,log(40)*ones(length(yrs)),'-','Color',mygrey,'LineWidth',1);
plot(yrs,log(80)*ones(length(yrs)),'-','Color',mygrey,'LineWidth',1);
set(gca,'Layer','top');
plot(yrs,log(y(t,USA)),'-','Color',myblue*.9,'LineWidth',lw); 
plot(yrs,log(y(t,CHN)),'-','Color',myred,'LineWidth',lw);
plot(yrs,log(y(t,IND)),'-','Color',mygreen,'LineWidth',lw); 
plot(yrs,log(y(t,JPN)),'-','Color',mygreen,'LineWidth',lw); 
plot(yrs,log(y(t,RUS)),'-','Color',myred*.9,'LineWidth',lw); 
plot(yrs,log(y(t,BRA)),'-','Color',mypurp,'LineWidth',lw);
plot(yrs,log(yWEur(t)),'-','Color',myblue*1.1,'LineWidth',lw);
plot(yrs,log(yAfr(t)),'-','Color',myblue,'LineWidth',lw); 
%plot(yrs,log(y(t,NZL)),'Color','c');
set(gca,'YTick',log([5 10 20 40 80]));
set(gca,'YTickLabel',strmat('5 10 20 40 80'));
chadfig2('Year','GDP per Person (US=100)',1,0);
text(1982,log(125),'United States'); %,'Color','b');
text(1998.5,log(89),'Japan'); %,'Color',mygreen);
text(1994,log(58),'Western Europe'); %,'Color',myorng);
%text(1982,log(55),'Western Europe','Color',myorng);  % New Zealnd version
text(1985,log(23),'Brazil'); %,'Color','b');
text(1995.2,log(35),'Russia'); %,'Color',mypurp);
text(1999.5,log(11.5),'China'); %,'Color','r');
text(2005,log(8),'India'); %,'Color',mygreen);
text(2001,log(2.8),'Sub-Saharan Africa'); %,'Color','b');
%text(2000,log(50),'New Zealand','Color','c');
%set(gca,'YGrid','on');
makefigwide;
ax=axis; ax(3)=log(2); axis(ax);
print GrowthSince1980.eps

% Total GDP rank and size
Y=rgdpo;
Y2010=Y(2010-1949,:)';
Y2010=Y2010/Y2010(USA)*100;
[blah,indx]=sort(-Y2010);
disp 'Ranking of countries by Total GDP, and size relative to US';
cshow(namesSTR(indx,:),Y2010(indx),'%8.3f')
diary off;
