% GrowthwithInequality   6/8/11
%
%  Combine the Saez data on top income inequality with my favorite US growth
%  picture to produce a new chart that show growth for Top 1% and bottom 99%
%
%  US data on inequality from http://g-mond.parisschoolofeconomics.eu/topincomes/
%   downloaded today.  See SaezUSInequality2011.xls



if exist('GrowthwithInequality.log'); delete('GrowthwithInequality.log'); end;
diary GrowthwithInequality.log;
fprintf(['GrowthwithInequality                 ' date]);
disp ' ';
disp ' ';
help GrowthwithInequality

definecolors;

% US per capita GDP % In chained 2009 dollars. BEA data after 1929, Maddison
% before.

load uspcgdp; % Through 2012
ydata=[yrs newgdp];

% Top 0.1% from Oct 2013 version of data set.  See ../InProgress/GrowthwithInequality.m for old version
saez=[
1913  8.62
1914  8.6
1915  9.22
1916  9.87
1917  8.36
1918  6.74
1919  6.45
1920  5.37
1921  5.6
1922  6.17
1923  5.5
1924  6.14
1925  6.75
1926  7.07
1927  7.47
1928  8.19
1929  7.62
1930  6.4
1931  5.68
1932  5.9
1933  6.05
1934  5.82
1935  5.8
1936  6.69
1937  6.16
1938  5.16
1939  5.45
1940  5.57
1941  5.29
1942  4.48
1943  3.78
1944  3.33
1945  3.32
1946  3.43
1947  3.24
1948  3.44
1949  3.34
1950  3.53
1951  3.12
1952  2.76
1953  2.51
1954  2.57
1955  2.49
1956  2.38
1957  2.36
1958  2.29
1959  2.19
1960  2.1
1961  2.05
1962  1.98
1963  1.96
1964  1.97
1965  2.04
1966  2.15
1967  2.16
1968  2.15
1969  2
1970  1.94
1971  1.91
1972  1.92
1973  1.89
1974  2.11
1975  2.04
1976  2.02
1977  2.04
1978  2.08
1979  2.16
1980  2.23
1981  2.23
1982  2.45
1983  2.61
1984  2.83
1985  2.91
1986  2.87
1987  3.73
1988  5.21
1989  4.74
1990  4.9
1991  4.36
1992  5.21
1993  4.72
1994  4.7
1995  4.98
1996  5.33
1997  5.81
1998  6.2
1999  6.64
2000  7.13
2001  6.26
2002  5.94
2003  6.11
2004  6.9
2005  7.76
2006  7.92
2007  8.16
2008  7.82
2009  7.04
2010  7.52
2011  7.38
2012  8.82
];
    
  

yyrs=ydata(:,1);  % Starts 1870
yall=ydata(:,2)/1000;
iyrs=saez(:,1);   % Starts 1913
topshare=saez(:,2);
%bins=[10 5 1 0.5 0.1];
bins=0.1;
y=yall(iyrs-1869);  % matching years
nums=[5 10 20 40 80 160 320 640 1280 2560 5120]';
growthyrs=[1950 1980; 1980 2007; 1950 2007]-1912;

for i=1:size(topshare,2);  % Loop through the various inequality variables
%for i=1:1;
  ytop=topshare(:,i).*y/bins(i);
  ybottom=(100-topshare(:,i))/(100-bins(i)).*y;
  figure(i); figsetup; makefigwide;
  plot(iyrs,log(ytop),'-','Color',myblue,'LineWidth',4); 
  %plotlog(iyrs,ytop,'-',axlabel); 
  plot(iyrs,log(ybottom),'-','Color',mygreen,'LineWidth',4);
  relabelaxis(log(nums),num2str(nums),'y');
  ax=axis; ax(1)=1912; ax(2)=2013; axis(ax);
  chadfig2('Year','Thousands of 2009 chained dollars',1,0);
  tle=['Top ' num2str(bins(i)) '% share'];
  %title(tle);
  %set(gca,'Ygrid','on');
  tsize=.04; lwidth=2; fcolor='k';
  maketickmark(1950,log(ytop(1950-1912)),tsize,lwidth,fcolor);
  maketickmark(1950,log(ybottom(1950-1912)),tsize,lwidth,fcolor);
  maketickmark(1980,log(ytop(1980-1912)),tsize,lwidth,fcolor);
  maketickmark(1980,log(ybottom(1980-1912)),tsize,lwidth,fcolor);
  
  
  disp ' '; disp ' ';
  yall=newgdp(iyrs-1869);
  cshow(' ',[iyrs ytop*1000 ybottom*1000 yall],'%6.0f %12.0f','Year Top Bottom Average');
  
  disp ' '; disp ' ';
  disp(tle);
  disp 'Growth Rates since 1950:  '
  disp '             1950-1980 1980-2007 1950-2007';
  tle2=['Top share    '; 'Bottom share '; 'All          '];
  gg=growthrate([ytop ybottom yall],growthyrs)'*100;
  cshow(tle2,gg,'%8.2f');
  
  text(1990,log(1000),'Top 0.1%','Color',myblue*.8);
  text(1990,log(60),'Bottom 99.9%','Color',mygreen*.8);
  text(1960,log(650),sprintf('%4.2f%%',gg(1,1)));
  text(1994,log(4180),sprintf('%4.2f%%',gg(1,2)));
  text(1960,log(12),sprintf('%4.2f%%',gg(2,1)));
  text(1994,log(22),sprintf('%4.2f%%',gg(2,2)));
end;

% Per capita GDP looks very close to 99.9...
%plot(iyrs,log(newpcgdp(iyrs-1869)/1000),'-','LineWidth',1);
makefigwide;

print GrowthwithInequality.eps

diary off;

