% HsiehKlenowFacts  March 2015
%
%  Create some figures from HK (2009) and HK (2014)
%  See Data/HsiehKlenow/HsiehKlenowData.xls
%   -- Data provided by Chang Hsieh.

diarychad('HsiehKlenowFacts')
definecolors;

% TFPQ
tfpqdata=[
% pdf            TFPQ (log2)   Country
0.00001072	-6.2934923172	2
0.00001318	-6.0784454346	2
0.00020888	-5.8633990288	2
0.00123061	-5.648352623	2
0.0025666901	-5.4333062172	2
0.0042053699	-5.2182593346	2
0.0061742002	-5.0032129288	2
0.0088343099	-4.788166523	2
0.0115280896	-4.5731196404	2
0.0153878704	-4.3580732346	2
0.0216395594	-4.1430268288	2
0.0304963496	-3.9279801846	2
0.0415878594	-3.7129337788	2
0.0554885417	-3.4978871346	2
0.0716711208	-3.2828404903	2
0.0892222822	-3.0677940845	2
0.1085109636	-2.8527474403	2
0.1312025934	-2.6377010345	2
0.157646805	-2.4226543903	2
0.1870770156	-2.2076079845	2
0.2177099288	-1.9925613403	2
0.2465476543	-1.7775148153	2
0.2695971429	-1.5624682903	2
0.2860352695	-1.3474216461	2
0.2961051166	-1.1323752403	2
0.2998771071	-0.9173286557	2
0.2966311276	-0.7022821307	2
0.2864895463	-0.4872355759	2
0.2691917419	-0.2721890211	2
0.2458200455	-0.0571424887	2
0.2182201296	0.1579040438	2
0.1885384172	0.3729505837	2
0.1572604477	0.5879971385	2
0.1251116842	0.8030436635	2
0.0955103412	1.0180902481	2
0.0697320998	1.2331366539	2
0.0485777296	1.4481832981	2
0.0331255086	1.6632298231	2
0.0222157594	1.8782763481	2
0.0142168701	2.0933229923	2
0.0087057604	2.3836939335	2
0.0049727201	2.5234160423	2
0.00252115	2.7384624481	2
1.64091059861234E-005	-7.5946648187	1
1.59299465080708E-005	-7.3447079965	1
0.000303188	-7.0947511744	1
0.0006823925	-6.8447943522	1
0.0019738135	-6.59483753	1
0.001706097	-6.3448807078	1
0.002965481	-6.0949238856	1
0.0038129019	-5.8449670635	1
0.0054602445	-5.5950102413	1
0.0081375154	-5.3450534191	1
0.0117211403	-5.0950965969	1
0.0192966248	-4.8451397747	1
0.0260330063	-4.5951829526	1
0.0381033845	-4.3452261304	1
0.0550056519	-4.0952693082	1
0.0650716221	-3.845312486	1
0.0786663449	-3.5953556638	1
0.1015598663	-3.3453988417	1
0.1197547208	-3.0954420195	1
0.1472094276	-2.8454851973	1
0.181923833	-2.5955283751	1
0.2074503885	-2.345571553	1
0.2341892263	-2.0956147308	1
0.2584099803	-1.8456579086	1
0.2795756059	-1.5957010864	1
0.2911725329	-1.3457442642	1
0.2779146657	-1.0957874421	1
0.2620809432	-0.8458306199	1
0.2390581064	-0.5958737977	1
0.2179600287	-0.3459169755	1
0.191819388	-0.0959601533	1
0.1598943523	0.1539966688	1
0.1264958341	0.403953491	1
0.1086608217	0.6539103132	1
0.0816688899	0.9038671354	1
0.0600004172	1.1538239576	1
0.0475166523	1.4037807797	1
0.0333906653	1.6537376019	1
0.0230201687	1.9036944241	1
0.0135568644	2.1536512463	1
0.0076688549	2.4036080685	1
0.0042710173	2.6535648906	1
0.0029208052	-8.618606993	0
0.0036875633	-8.3076639619	0
0.0076325309	-7.9967209307	0
0.009624537	-7.6857778996	0
0.0118222655	-7.3748348685	0
0.0134243498	-7.0638918373	0
0.0150048824	-6.7529488062	0
0.0198721556	-6.442005775	0
0.0329947215	-6.1310627439	0
0.0491428441	-5.8201197128	0
0.0549320503	-5.5091766816	0
0.0655825972	-5.1982336505	0
0.0837544957	-4.8872906193	0
0.0985689295	-4.5763475882	0
0.1131842231	-4.2654045571	0
0.1373507829	-3.9544615259	0
0.1668975857	-3.6435184948	0
0.186012775	-3.3325754636	0
0.1985157817	-3.0216324325	0
0.2142269489	-2.7106894014	0
0.2158784909	-2.3997463702	0
0.206005858	-2.0888033391	0
0.1890920196	-1.777860308	0
0.1739038429	-1.4669172768	0
0.1557870339	-1.1559742457	0
0.1355139859	-0.8450312145	0
0.1231832293	-0.5340881834	0
0.1086639342	-0.2231451523	0
0.0963180916	0.0877978789	0
0.0821808838	0.39874091	0
0.0649460204	0.7096839412	0
0.0508897213	1.0206269723	0
0.0412979436	1.3315700034	0
0.029772317	1.6425130346	0
0.019869331	1.9534560657	0
0.0130214327	2.2643990969	0
0.0080969415	2.575342128	0    
    ];

% TFPR
tfprdata=[
% pdf            TFPR (log2)   Country
0.00003605	-2.6791825294	2
0.00009722	-2.5449507236	2
0.00033299	-2.4107189178	2
0.00068571	-2.2764868736	2
0.00134076	-2.1422548294	2
0.0024695999	-2.0080230236	2
0.0042821099	-1.8737910986	2
0.0073378398	-1.7395591736	2
0.0125537096	-1.6053272486	2
0.0208455399	-1.4710954428	2
0.0333240591	-1.3368635178	2
0.0520798713	-1.2026315928	2
0.0806524307	-1.0683996677	2
0.1196515113	-0.9341677427	2
0.1724027991	-0.7999358177	2
0.2554275393	-0.6657039523	2
0.358417809	-0.5314720273	2
0.4571088254	-0.3972401023	2
0.5382592082	-0.2630082071	2
0.594039917	-0.128776297	2
0.6186337471	0.0054556201	2
0.6099470854	0.1396875232	2
0.5070579052	0.2739194334	2
0.5037961602	0.4081513584	2
0.4182552695	0.5423832536	2
0.3423927128	0.6766151786	2
0.2860083282	0.8108471036	2
0.2396801412	0.945078969	2
0.2004117519	1.079310894	2
0.1674818844	1.213542819	2
0.1398112029	1.347774744	2
0.1165590137	1.4820065498	2
0.0971471071	1.6162384748	2
0.081213221	1.7504705191	2
0.0681518614	1.8847024441	2
0.0569574684	2.0189342499	2
0.0474189818	2.1531662941	2
0.0390800014	2.2873980999	2
0.0320191905	2.4216299057	2
0.0259042196	2.5558619499	2
0.0206741393	2.6900937557	2
0.0161619894	2.8243257999	2
0.0123436097	2.9585576057	2
0.0092417002	3.0927894115	2
0.0068126498	3.2270202637	2
0.0048746099	3.3612535	2
0.0032832101	3.4954853058	2
0.0060222418	-2.9918005048	0
0.0100548211	-2.734339101	0
0.0162204153	-2.4768776971	0
0.0249116099	-2.2194162933	0
0.0387127105	-1.9619548895	0
0.0583454742	-1.7044934857	0
0.0871071737	-1.4470320818	0
0.1298467611	-1.189570678	0
0.1908405362	-0.9321092742	0
0.2688170811	-0.6746478704	0
0.3476859244	-0.4171864665	0
0.403731263	-0.1597250627	0
0.4227348163	0.0977363411	0
0.4021855111	0.355197745	0
0.3528243249	0.6126591488	0
0.2906162628	0.8701205526	0
0.2279672412	1.1275819564	0
0.1705782846	1.3850433603	0
0.1246719893	1.6425047641	0
0.0880398298	1.8999661679	0
0.0621873691	2.1574275717	0
0.0440306502	2.4148889756	0
0.0305764718	2.6723503794	0
0.0217723634	2.9298117832	0
0.0153775765	3.1872731871	0
0.0115317176	3.4447345909	0
0.0014648181	-3.0058053503	1
0.0028747698	-2.7902354824	1
0.0048229063	-2.5746656145	1
0.0081428726	-2.3590957466	1
0.0138550543	-2.1435258788	1
0.0226390314	-1.9279560109	1
0.0362893081	-1.712386143	1
0.0578359426	-1.4968162751	1
0.0903646395	-1.2812464072	1
0.1366250305	-1.0656765393	1
0.1980616895	-0.8501066714	1
0.2687680431	-0.6345368035	1
0.3396645739	-0.4189669356	1
0.3987679983	-0.2033970677	1
0.4327560185	0.0121728002	1
0.4361918559	0.2277426681	1
0.4115982349	0.443312536	1
0.3661730451	0.6588824039	1
0.3096473176	0.8744522718	1
0.2531249034	1.0900221396	1
0.2012171573	1.3055920075	1
0.1572707905	1.5211618754	1
0.1223866506	1.7367317433	1
0.0947101034	1.9523016112	1
0.0727855519	2.1678714791	1
0.0556802578	2.383441347	1
0.0414776691	2.5990112149	1
0.0300477858	2.8145810828	1
0.0216231533	3.0301509507	1
0.0155329355	3.2457208186	1
0.0110088307	3.4612906865	1
];



% % For now with artificial data
% N=10000;
% xus=randn(N,1);
% xchn=randn(N,1)*2;
% xind=randn(N,1)*2.5;
% [pdfUS,tfpUS]=hist(xus,sqrt(N));
% [pdfCHN,tfpCHN]=hist(xchn,sqrt(N));
% [pdfIND,tfpIND]=hist(xind,sqrt(N));


% TFPQ
% Countries: 0=India   1=China   2=US
iIND=find(tfpqdata(:,3)==0);
iCHN=find(tfpqdata(:,3)==1);
iUSA=find(tfpqdata(:,3)==2);

pdfqIND=tfpqdata(iIND,1);
tfpqIND=tfpqdata(iIND,2);
pdfqCHN=tfpqdata(iCHN,1);
tfpqCHN=tfpqdata(iCHN,2);
pdfqUSA=tfpqdata(iUSA,1);
tfpqUSA=tfpqdata(iUSA,2);


lw=4; 
mygrey=mygrey*0.8;
figure(1); figsetup; makefigwide;
area(tfpqUSA,pdfqUSA,'EdgeColor',mygrey,'FaceColor',mygrey,'LineWidth',2);
plot(tfpqCHN,pdfqCHN,'-','Color',myblue,'LineWidth',lw);
plot(tfpqIND,pdfqIND,'-','Color',mygreen,'LineWidth',lw);
chadfig2('Quantity TFP, TFPQ','Density',1,0);
ynums=[0 .1 .2 .3]';
relabelaxis(ynums,num2str(ynums),'y');
xlabs=strmat('1/256# 1/64# 1/16# 1/4 #  1  #  4  ','#');
xnums=log2([1/256 1/64 1/16 1/4 1 4]');
relabelaxis(xnums,xlabs,'x');
set(gca,'XLim',[-8.8 2.9]);
text(.45,.23,'U.S.');
text(-3.3,.27,'China');
text(-5.3,.16,'India');
set(gca,'Layer','top');
print HKtfpq.eps


% TFPR
% Countries: 0=India   1=China   2=US
iIND=find(tfprdata(:,3)==0);
iCHN=find(tfprdata(:,3)==1);
iUSA=find(tfprdata(:,3)==2);

pdfrIND=tfprdata(iIND,1);
tfprIND=tfprdata(iIND,2);
pdfrCHN=tfprdata(iCHN,1);
tfprCHN=tfprdata(iCHN,2);
pdfrUSA=tfprdata(iUSA,1);
tfprUSA=tfprdata(iUSA,2);


figure(2); figsetup; makefigwide;
area(tfprUSA,pdfrUSA,'EdgeColor',mygrey,'FaceColor',mygrey,'LineWidth',2);
plot(tfprIND,pdfrIND,'-','Color',mygreen,'LineWidth',lw);
plot(tfprCHN,pdfrCHN,'-','Color',myblue,'LineWidth',lw);
chadfig2('Revenue TFP, TFPR','Density',1,0);
ynums=[0 .2 .4 .6]';
relabelaxis(ynums,num2str(ynums),'y');
xlabs=strmat('1/8#1/4# 1/2# 1 # 2 # 4 # 8 ','#');
xnums=log2([1/8 1/4 1/2 1 2 4 8]');
relabelaxis(xnums,xlabs,'x');
set(gca,'XLim',[-3 3.5]);
set(gca,'YLim',[0 .62]);
text(.45,.58,'U.S.');
text(log2(1.8),.36,'China');
text(log2(.25),.13,'India');
set(gca,'Layer','top');
print HKtfpr.eps


% Employment growth (Fig 4 from QJE 2014 paper)
logemp=[
%India	Mexico	USA
0	0	0                             % <5     
-0.0199436992	0.4609014094	1.0183659792  % 5-9    
0.0136211002	0.6035379767	1.58821702    % 10-14  
0.100356102	0.6826062202	2.0467550755  % 15-19  
0.1997085065	0.9136840105	2.4099071026  % 20-24  
0.2644869983	0.961263895	2.7801508904  % 25-29  
0.2744377851	1.1008230448	3.137403965   % 30-34  
0.4866524935	1.016149044	3.3180689812  % 35+    
    ];

emp=2.^logemp;
binlabs=strmat(' < 5  # 5-9 #10-14#15-19#20-24#25-29#30-34# 35+ ','#');
bins=[2 7 12 17 22 27 32 37]';

figure(3); figsetup; makefigwide;
plot(bins,logemp(:,1),'-','Color',mygreen,'LineWidth',lw);
plot(bins,logemp(:,2),'-','Color',myblue*1.2,'LineWidth',lw);
plot(bins,logemp(:,3),'-','Color',myblue*0.8,'LineWidth',lw);
%xstr=mlstring('Average employment (Index = 1 for Age<5)\\     (log scale)');
xstr='Average employment (Age<5 = 1, log scale)';
chadfig2('Age',xstr,1,0);
relabelaxis(bins,binlabs,'x');
nums=[1 2 4 6 8 10]';
relabelaxis(log2(nums),num2str(nums),'y');
set(gca,'Xlim',[1 38]);
set(gca,'Ylim',log2([0.8 10.1]));
set(gca,'YGrid','on');
text(27,log2(9),'U.S.');
text(30,log2(2.45),'Mexico');
text(33,log2(1.1),'India');
print HKLifeCycle.eps