% Investment.m   2/11/2015
%
%  Plots investment share of GDP since 1929.  See Data/Section5ALL_Hist.xls
%  Note: GDP data copied from RND_nipa.m
%
%  The index (2009=100) for capital is from BEA-FixedAssets2015.xls
%  and is a chained index (so not clear what it means to divide by GDP!)
%   -- it is private+govt nonresidential fixed capital (i.e. no land either)

diarychad('Investment');



data=[
%Structures Equipment   Total       GDP      K(Index)   GDPCA(Real)
1929	12.2	5.8	18.0        104.6    10.6   	1056.6 
1930	9.8	4.4	14.2        92.2     10.889     966.7  
1931	7.2	2.9	10.1        77.4     10.999     904.8  
1932	4.2	1.7	5.9         59.5     10.952     788.2  
1933	3.5	1.6	5.1         57.2     10.864     778.3  
1934	4.5	2.4	6.9         66.8     10.861     862.2  
1935	5.1	3.3	8.4         74.3     10.936     939.0  
1936	7.4	4.3	11.7        84.9     11.172     1060.5 
1937	8.2	5.3	13.5        93.0     11.435     1114.6 
1938	7.9	3.9	11.8        87.4     11.609     1077.7 
1939	9.3	4.5	13.8        93.5     11.832     1163.6 
1940	9.9	5.8	15.7        102.9    12.101     1266.1 
1941	13.8	10.6	24.4        129.4    12.724     1490.3 
1942	16.7	20.5	37.2        166.0    13.965     1771.8 
1943	10.4	35.7	46.1        203.1    15.408     2073.7 
1944	7.2	38.3	45.5        224.6    16.678     2239.4 
1945	7.6	28.5	36.1        228.2    17.265     2217.8 
1946	17.1	11.5	28.6        227.8    16.951     1960.9 
1947	23.3	16.6	39.9        249.9    16.812     1939.4 
1948	29.9	19.6	49.5        274.8    16.833     2020.0 
1949	30.3	18.9	49.2        272.8    17.011     2008.9 
1950	37.7	20.4	58.1        300.2    17.269     2184.0 
1951	40.2	27.8	68.0        347.3    17.904     2360.0 
1952	42.2	30.8	73.0        367.7    18.62      2456.1 
1953	45.0	33.8	78.8        389.7    19.424     2571.4 
1954	47.4	31.0	78.4        391.1    20.126     2556.9 
1955	52.6	32.7	85.3        426.2    20.863     2739.0 
1956	55.6	35.2	90.8        450.1    21.659     2797.4 
1957	56.5	38.1	94.6        474.9    22.463     2856.3 
1958	56.9	34.6	91.5        482.0    23.134     2835.3 
1959	63.6	40.3	103.9       522.5    23.91      3031.0 
1960	63.1	41.3	104.4       543.3    24.727     3108.7 
1961	64.7	42.0	106.7       563.3    25.587     3188.1 
1962	69.0	46.2	115.2       605.1    26.547     3383.1 
1963	74.0	47.2	121.2       638.6    27.554     3530.4 
1964	79.9	51.1	131.0       685.8    28.689     3734.0 
1965	86.3	57.0	143.3       743.7    30.031     3976.7 
1966	89.8	66.1	155.9       815.0    31.579     4238.9 
1967	91.6	68.7	160.3       861.7    33.044     4355.2 
1968	102.3	72.1	174.4       942.5    34.472     4569.0 
1969	111.1	78.1	189.2       1019.9   35.882     4712.5 
1970	112.9	79.4	192.3       1075.9   37.075     4722.0 
1971	132.1	78.3	210.4       1167.8   38.087     4877.6 
1972	151.2	88.7	239.9       1282.4   39.195     5134.3 
1973	167.7	106.0	273.7       1428.5   40.508     5424.1 
1974	171.0	118.7	289.7       1548.8   41.742     5396.0 
1975	172.6	124.2	296.8       1688.9   42.666     5385.4 
1976	197.6	140.4	338.0       1877.6   43.654     5675.4 
1977	234.1	169.7	403.8       2086.0   44.789     5937.0 
1978	283.1	203.7	486.8       2356.6   46.241     6267.2 
1979	323.3	235.4	558.7       2632.1   47.9       6466.2 
1980	331.0	247.5	578.5       2862.5   49.42      6450.4 
1981	362.2	276.9	639.1       3211.0   50.985     6617.7 
1982	353.4	277.2	630.6       3345.0   52.263     6491.3 
1983	381.1	296.7	677.8       3638.1   53.437     6792.0 
1984	440.3	350.3	790.6       4040.7   55.133     7285.0 
1985	475.7	375.7	851.4       4346.7   57.027     7593.8 
1986	500.3	391.6	891.9       4590.2   58.712     7860.5 
1987	519.5	398.3	917.8       4870.2   60.305     8132.6 
1988	538.0	421.1	959.1       5252.6   61.871     8474.5 
1989	551.7	452.9	1004.6      5657.7   63.464     8786.4 
1990	555.2	458.5	1013.7      5979.6   65.045     8955.0 
1991	521.8	446.5	968.3       6174.0   66.271     8948.4 
1992	547.0	466.5	1013.5      6539.3   67.41      9266.6 
1993	585.1	504.5	1089.6      6878.7   68.682     9521.0 
1994	635.3	553.9	1189.2      7308.8   70.034     9905.4 
1995	666.1	607.0	1273.1      7664.1   71.673     10174.8
1996	727.1	645.4	1372.5      8100.2   73.588     10561.0
1997	781.5	686.5	1468.0      8608.5   75.713     11034.9
1998	854.1	738.9	1593.0      9089.2   78.083     11525.9
1999	921.5	799.7	1721.2      9660.6   80.671     12065.9
2000	993.2	853.5	1846.7      10284.8  83.436     12559.7
2001	1048.5	799.7	1848.2      10621.8  85.657     12682.2
2002	1062.4	755.2	1817.6      10977.5  87.366     12908.8
2003	1147.3	769.2	1916.5      11510.7  89.031     13271.1
2004	1287.2	826.4	2113.6      12274.9  90.784     13773.5
2005	1448.5	903.7	2352.2      13093.7  92.569     14234.2
2006	1521.5	979.4	2500.9      13855.9  94.72      14613.8
2007	1478.1	1016.5	2494.6      14477.6  97.016     14873.7
2008	1378.6	972.2	2350.8      14718.6  99.06      14830.4
2009	1149.3	792.6	1941.9      14418.7  100        14418.7
2010	1056.3	883.0	1939.3      14964.4  100.998    14783.8
2011	1068.7	983.3	2052.0      15517.9  102.211    15020.6
2012	1173.2	1046.7	2219.9      16163.2  103.515    15369.2
2013	1250.4	1084.3	2334.7      16768.1  104.806    15710.3
];
%Structures Equipment   Total       GDP    
    
yrs=data(:,1);
struc=data(:,2);
equip=data(:,3);
total=data(:,4);
gdp=data(:,5);
K=data(:,6);
realgdp=data(:,7);

istruc=struc./gdp*100;
iequip=equip./gdp*100;
itotal=total./gdp*100;
KY=K./realgdp; KY=KY/KY(2009-1928)*100;  % Index = 100 in 2009


tle='Year Equip Struct Total';
cshow(' ',[yrs iequip istruc itotal],'%6.0f %8.2f',tle);


series=[iequip istruc];

figure(1); figsetup;
cmap=colormap(winter);
colormap(2/3+cmap/3);
%brighten(-.2); % darken the colormap
area(yrs,series); hold on;
relabelaxis([0 5 10 15 20 25],strmat('0% 5% 10% 15% 20% 25%'));
ax=axis; ax(1)=1929; ax(2)=2015; axis(ax)
chadfig2('Year','Share of GDP',1,0);
makefigwide;
text(1965,3,'Equipment');
text(1960,15,'Structures');
set(gca,'Layer','top');
%line([1993 1998],[8.3 7],'Color','k','LineWidth',1)
%wait;
print Investment.eps

myblue=[        0    0.4470    0.7410];

figure(1); figsetup;
plot(yrs,KY,'-','Color',myblue,'LineWidth',4);
%relabelaxis([0 5 10 15 20 25],strmat('0% 5% 10% 15% 20% 25%'));
chadfig2('Year','Index (Value in 2009 is 100)',1,0);
makefigwide;
%print KYbea.eps  

