% KYJEPGraphs  7/8/14
%
%  Main program for making the graphs for the JEP paper.
%  Data copied from Piketty spreadsheets. See PikettyDataforJEP.xls
%
%  -- Select a few for the Facts paper...  2/12/15

if exist('KYJEPGraphs.log'); delete('KYJEPGraphs.log'); end;
diary KYJEPGraphs.log;
fprintf(['KYJEPGraphs                 ' date]);
disp ' ';
disp ' ';
help KYJEPGraphs
clear;

% mygreen=[0 .6 .4];   % for 'Color' property
% myred=[.7 0 0];
% myorng=[237 145 33]/255;
% %mypurp=[186 85 211]/255;
% mypurp=[125 38 205]/255;

% % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % CAPITAL SHARE
% % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% % Year   France   UK     US
% data=[
% 1820	30.015	40.000	NaN
% 1830	34.634	41.000	NaN
% 1840	36.597	42.000	NaN
% 1850	43.261	43.000	NaN
% 1860	43.366	43.000	NaN
% 1870	41.626	41.000	NaN
% 1880	29.880	37.000	NaN
% 1890	25.626	33.000	NaN
% 1900	26.056	35.000	NaN
% 1910	34.350	36.000	NaN
% 1920	29.088	21.412	NaN
% 1930	27.831	25.044	NaN
% 1940	14.200	27.741	23.153
% 1950	23.100	26.101	26.880
% 1960	23.048	23.858	26.019
% 1970	21.338	19.559	26.301
% 1980	19.068	20.862	23.191
% 1990	23.872	24.418	26.354
% 2000	24.580	27.676	28.157
% 2010	25.980	26.635	27.445
% ];


% years=data(:,1);
% france=data(:,2);
% uk=data(:,3);
% us=data(:,4);

% figure(1); figsetup;
% plot(years,us); hold on; plot(years,us,'o');
% plot(years,france,'-','Color',mygreen);
% plot(years,france,'+','Color',mygreen);
% plot(years,uk,'-','Color',mypurp);
% plot(years,uk,'x','Color',mypurp);
% ax=axis; ax(2)=2019; axis(ax);
% chadfig('Year','Capital share of factor payments (percent)',1,0);
% makefigwide
% text(1980,28,'U.S.','Color','b');
% text(1945,17,'France','Color',mygreen);
% text(1890,37,'U.K.','Color',mypurp);
% print CapitalShare.eps


% % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % CAPITAL-OUTPUT RATIO
% % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %(% national income)
% %	USA	France	UK
% data=[
% 1870	443	719	672
% 1880	452	695	676
% 1890	505	695	676
% 1900	475	695	676
% 1910	475	671	679
% 1920	434	291	288
% 1930	537	384	361
% 1940	350	284	261
% 1950	384	278	235
% 1960	409	320	284
% 1970	400	363	333
% 1980	418	365	398
% 1990	419	368	462
% 2000	492	503	492
% 2010	431	605	523
% ];
% years=data(:,1);
% data=data/100;
% us=data(:,2);
% france=data(:,3);
% uk=data(:,4);

% figure(2); figsetup;
% plot(years,us); hold on; plot(years,us,'o');
% plot(years,france,'-','Color',mygreen);
% plot(years,france,'+','Color',mygreen);
% plot(years,uk,'-','Color',mypurp);
% plot(years,uk,'x','Color',mypurp);
% ax=axis; ax(2)=2019; ax(3)=0.9; ax(4)=8; axis(ax);
% chadfig('Year','Capital-Output Ratio',1,0);
% makefigwide
% text(1940,4.5,'U.S.','Color','b');
% text(1990,6.2,'France','Color',mygreen);
% text(1890,6.4,'U.K.','Color',mypurp);
% print KY.eps



% % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % WEALTH INEQUALITY
% % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %Top 1% Numbers collected from table above			
% %	France	U.K.	U.S.
% data=[
% 1810	45.6	54.9	25.0
% 1820	46.7	NaN	NaN
% 1830	47.5	NaN	NaN
% 1840	46.0	NaN	NaN
% 1850	50.3	NaN	NaN
% 1860	52.0	NaN	NaN
% 1870	50.4	61.1	32.0
% 1880	49.5	NaN	NaN
% 1890	51.1	NaN	NaN
% 1900	58.7	NaN	NaN
% 1910	60.5	69.0	45.1
% 1920	49.2	61.0	43.7
% 1930	47.4	55.0	37.4
% 1940	36.3	NaN	30.4
% 1950	33.4	47.2	29.7
% 1960	31.9	33.9	31.4
% 1970	22.0	22.6	28.2
% 1980	22.0	22.7	30.1
% 1990	21.7	24.0	32.9
% 2000	23.5	27.0	33.1
% 2010	24.4	28.0	33.8
% ];
% years=data(:,1);
% france=data(:,2);
% uk=data(:,3); iuk=~isnan(uk);
% us=data(:,4); ius=~isnan(us);


% figure(3); figsetup;
% plot(years(ius),us(ius)); hold on; plot(years(ius),us(ius),'o');
% plot(years,france,'-','Color',mygreen);
% plot(years,france,'+','Color',mygreen);
% plot(years(iuk),uk(iuk),'-','Color',mypurp);
% plot(years(iuk),uk(iuk),'x','Color',mypurp);
% ax=axis; ax(2)=2026; axis(ax);
% nums=(1800:40:2000)';
% relabelaxis(nums,num2str(nums),'x');
% relabelaxis((20:10:70)',strmat('20% 30% 40% 50% 60% 70%'),'y');
% chadfig('Year','Wealth share of top 1%',1,0);
% makefigwide
% text(1995,37,'U.S.','Color','b');
% text(1860,47,'France','Color',mygreen);
% text(1935,57,'U.K.','Color',mypurp);
% print WealthInequality.eps



% % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % TOTAL INCOME INEQUALITY
% % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% load ../WorldTopInequalityDatabase2013;

% T=2012
% yrs=(1910:T)';
% yr0=1869;
% yy=yrs-yr0;


% % Top 1% shares
% figure(1); figsetup;
% plot(yrs,is01(yy,FRA),'-','Color',mygreen); hold on;
% %plot(yrs,is01(yy,FRA),'+','Color',mygreen);
% plot(yrs,is01(yy,USA),'b-');
% %plot(yrs,is01(yy,USA),'bo');
% % No uniform series for the UK
% %plot(yrs,is01(yy,GBR),'-','Color',mypurp);
% %plot(yrs,is01(yy,GBR),'x','Color',mypurp);
% %plot(yrs,,'r-');
% ax=axis; ax(1)=1910; ax(2)=2021; axis(ax);
% makefigwide;
% relabelaxis((6:4:22)',strmat('6% 10% 14% 18% 22%'),'y');
% relabelaxis((1910:20:2010)',strmat('1910 1930 1950 1970 1990 2010'),'x');
% chadfig('Year','Income share of top 1 percent',1,0);
% text(1990,18,'U.S.');
% text(1999,10,'France');
% print IncomeInequality.eps

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CAPITAL-OUTPUT RATIO -- excluding land and housing
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%	UK	France	US
data=[
1810	267	269	106
1850	347	236	157
1880	379	286	223
1910	501	371	283
1920	179	141	271
1950	124	148	210
1970	199	209	230
1990	271	187	236
2010	219	225	237
];

years=data(:,1);
data=data/100;
us=data(:,4);
france=data(:,3);
uk=data(:,2);

clrs=[
        0    0.4470    0.7410
    0.8500    0.3250    0.0980
    0.9290    0.6940    0.1250
    0.4940    0.1840    0.5560
    0.4660    0.6740    0.1880
    0.3010    0.7450    0.9330
    0.6350    0.0780    0.1840
];

LW=4;
myblue=clrs(1,:);
mygreen=clrs(2,:);
mypurp=clrs(5,:); mypurp(2)=.65; %[0 .6 .4];

figure(1); figsetup;
plot(years,us,'Color',myblue,'LineWidth',LW); hold on; plot(years,us,'o','Color',myblue,'LineWidth',2,'MarkerFaceColor',myblue);
plot(years,france,'-','Color',mygreen,'LineWidth',LW);
%plot(years,france,'+','Color',mygreen,'LineWidth',3);
plot(years,uk,'-','Color',mypurp,'LineWidth',LW);
%plot(years,uk,'x','Color',mypurp,'LineWidth',3);
ax=axis; ax(2)=2019; ax(3)=0.9; ax(4)=5.9; axis(ax);
nums=(1800:40:2000)';
relabelaxis(nums,num2str(nums),'x');
nums=(1:6)';
relabelaxis(nums,num2str(nums),'y');
chadfig2('Year','excludes land and housing',1,0);
makefigwide
text(1940,2.7,'U.S.','Color',myblue);
text(1990,1.5,'France','Color',mygreen);
text(1870,4.5,'U.K.','Color',mypurp);
print KYnoland.eps


diary off;