% KYbea   2/20/15
%
%  The U.S. ratio of Real K / Real GDP. See Data/BEA-FixedAssets2015.xls
%
%  K = Private+Public nonresidential fixed capital (no land) = K in Solow
%  Chained 2009 dollars


diarychad('KYbea')

clear all;
definecolors;

data=[
%        --- Public and Private ---             --- Private only ---            --- Total incl Housing
%       Indx     K       GDP      K/Y            Indx     K      K/Y             Indx     K      K/Y 
1929	10.6	3064	1056.6	2.900		12.557	2279.3	2.157		11.871	5335.4	5.050
1930	10.889	3148	966.7	3.256		12.785	2320.7	2.401		12.091	5434.3	5.621
1931	10.999	3180	904.8	3.514		12.736	2311.8	2.555		12.175	5472.0	6.048
1932	10.952	3166	788.2	4.017		12.49	2267.1	2.876		12.115	5445.1	6.908
1933	10.864	3141	778.3	4.035		12.23	2219.9	2.852		12.019	5401.9	6.941
1934	10.861	3140	862.2	3.641		12.064	2189.8	2.540		11.996	5391.6	6.253
1935	10.936	3161	939	3.367		11.993	2176.9	2.318		12.046	5414.1	5.766
1936	11.172	3230	1060.5	3.045		12.069	2190.7	2.066		12.228	5495.9	5.182
1937	11.435	3306	1114.6	2.966		12.246	2222.8	1.994		12.436	5589.3	5.015
1938	11.609	3356	1077.7	3.114		12.245	2222.6	2.062		12.577	5652.7	5.245
1939	11.832	3420	1163.6	2.939		12.29	2230.8	1.917		12.792	5749.4	4.941
1940	12.101	3498	1266.1	2.763		12.449	2259.7	1.785		13.059	5869.4	4.636
1941	12.724	3678	1490.3	2.468		12.703	2305.8	1.547		13.583	6104.9	4.096
1942	13.965	4037	1771.8	2.278		12.636	2293.6	1.295		14.456	6497.2	3.667
1943	15.408	4454	2073.7	2.148		12.483	2265.8	1.093		15.432	6935.9	3.345
1944	16.678	4821	2239.4	2.153		12.463	2262.2	1.010		16.248	7302.6	3.261
1945	17.265	4991	2217.8	2.250		12.674	2300.5	1.037		16.604	7462.7	3.365
1946	16.951	4900	1960.9	2.499		13.174	2391.3	1.219		16.556	7441.1	3.795
1947	16.812	4860	1939.4	2.506		13.786	2502.4	1.290		16.678	7495.9	3.865
1948	16.833	4866	2020	2.409		14.406	2614.9	1.295		16.948	7617.3	3.771
1949	17.011	4918	2008.9	2.448		14.853	2696.0	1.342		17.296	7773.7	3.870
1950	17.269	4992	2184	2.286		15.375	2790.8	1.278		17.809	8004.2	3.665
1951	17.904	5176	2360	2.193		15.911	2888.1	1.224		18.49	8310.3	3.521
1952	18.62	5383	2456.1	2.192		16.41	2978.6	1.213		19.214	8635.7	3.516
1953	19.424	5615	2571.4	2.184		16.996	3085.0	1.200		20.002	8989.9	3.496
1954	20.126	5818	2556.9	2.275		17.505	3177.4	1.243		20.743	9322.9	3.646
1955	20.863	6031	2739	2.202		18.129	3290.7	1.201		21.564	9691.9	3.538
1956	21.659	6261	2797.4	2.238		18.832	3418.3	1.222		22.379	10058.2	3.596
1957	22.463	6494	2856.3	2.273		19.514	3542.1	1.240		23.173	10415.1	3.646
1958	23.134	6688	2835.3	2.359		19.958	3622.7	1.278		23.882	10733.7	3.786
1959	23.91	6912	3031	2.280		20.487	3718.7	1.227		24.753	11125.2	3.670
1960	24.727	7148	3108.7	2.299		21.095	3829.0	1.232		25.607	11509.0	3.702
1961	25.587	7397	3188.1	2.320		21.676	3934.5	1.234		26.487	11904.6	3.734
1962	26.547	7674	3383.1	2.268		22.371	4060.6	1.200		27.471	12346.8	3.650
1963	27.554	7965	3530.4	2.256		23.114	4195.5	1.188		28.53	12822.8	3.632
1964	28.689	8293	3734	2.221		24.027	4361.2	1.168		29.701	13349.1	3.575
1965	30.031	8681	3976.7	2.183		25.249	4583.0	1.152		30.986	13926.6	3.502
1966	31.579	9129	4238.9	2.154		26.675	4841.9	1.142		32.351	14540.1	3.430
1967	33.044	9552	4355.2	2.193		27.949	5073.1	1.165		33.641	15119.9	3.472
1968	34.472	9965	4569	2.181		29.246	5308.6	1.162		34.963	15714.1	3.439
1969	35.882	10373	4712.5	2.201		30.637	5561.0	1.180		36.284	16307.8	3.461
1970	37.075	10718	4722	2.270		31.851	5781.4	1.224		37.423	16819.7	3.562
1971	38.087	11010	4877.6	2.257		32.944	5979.8	1.226		38.573	17336.6	3.554
1972	39.195	11330	5134.3	2.207		34.193	6206.5	1.209		39.885	17926.3	3.491
1973	40.508	11710	5424.1	2.159		35.753	6489.7	1.196		41.319	18570.8	3.424
1974	41.742	12067	5396	2.236		37.177	6748.1	1.251		42.527	19113.7	3.542
1975	42.666	12334	5385.4	2.290		38.137	6922.4	1.285		43.441	19524.5	3.625
1976	43.654	12619	5675.4	2.224		39.176	7111.0	1.253		44.509	20004.5	3.525
1977	44.789	12948	5937	2.181		40.472	7346.2	1.237		45.812	20590.2	3.468
1978	46.241	13367	6267.2	2.133		42.156	7651.9	1.221		47.366	21288.6	3.397
1979	47.9	13847	6466.2	2.141		44.088	8002.6	1.238		49.003	22024.3	3.406
1980	49.42	14286	6450.4	2.215		45.811	8315.3	1.289		50.35	22629.8	3.508
1981	50.985	14739	6617.7	2.227		47.658	8650.6	1.307		51.663	23219.9	3.509
1982	52.263	15108	6491.3	2.327		49.117	8915.4	1.373		52.668	23671.6	3.647
1983	53.437	15448	6792	2.274		50.372	9143.2	1.346		53.828	24192.9	3.562
1984	55.133	15938	7285	2.188		52.273	9488.3	1.302		55.435	24915.2	3.420
1985	57.027	16485	7593.8	2.171		54.312	9858.4	1.298		57.174	25696.8	3.384
1986	58.712	16972	7860.5	2.159		55.98	10161.2	1.293		58.883	26464.9	3.367
1987	60.305	17433	8132.6	2.144		57.484	10434.2	1.283		60.535	27207.4	3.345
1988	61.871	17886	8474.5	2.111		59.053	10718.9	1.265		62.139	27928.3	3.296
1989	63.464	18346	8786.4	2.088		60.691	11016.3	1.254		63.695	28627.7	3.258
1990	65.045	18803	8955	2.100		62.255	11300.2	1.262		65.161	29286.5	3.270
1991	66.271	19158	8948.4	2.141		63.366	11501.8	1.285		66.298	29797.6	3.330
1992	67.41	19487	9266.6	2.103		64.403	11690.0	1.262		67.444	30312.6	3.271
1993	68.682	19855	9521	2.085		65.759	11936.2	1.254		68.783	30914.5	3.247
1994	70.034	20245	9905.4	2.044		67.304	12216.6	1.233		70.222	31561.2	3.186
1995	71.673	20719	10174.8	2.036		69.237	12567.5	1.235		71.83	32283.9	3.173
1996	73.588	21273	10561	2.014		71.497	12977.7	1.229		73.699	33123.9	3.136
1997	75.713	21887	11034.9	1.983		74.109	13451.8	1.219		75.711	34028.2	3.084
1998	78.083	22572	11525.9	1.958		77.058	13987.1	1.214		77.967	35042.2	3.040
1999	80.671	23320	12065.9	1.933		80.243	14565.2	1.207		80.411	36140.6	2.995
2000	83.436	24120	12559.7	1.920		83.668	15186.9	1.209		82.954	37283.6	2.969
2001	85.657	24762	12682.2	1.952		86.179	15642.7	1.233		85.135	38263.8	3.017
2002	87.366	25256	12908.8	1.956		87.773	15932.0	1.234		87.068	39132.6	3.031
2003	89.031	25737	13271.1	1.939		89.255	16201.0	1.221		89.094	40043.2	3.017
2004	90.784	26244	13773.5	1.905		90.87	16494.2	1.198		91.271	41021.7	2.978
2005	92.569	26760	14234.2	1.880		92.683	16823.3	1.182		93.423	41988.9	2.950
2006	94.72	27382	14613.8	1.874		94.966	17237.7	1.180		95.774	43045.5	2.946
2007	97.016	28045	14873.7	1.886		97.487	17695.3	1.190		97.837	43972.7	2.956
2008	99.06	28636	14830.4	1.931		99.596	18078.1	1.219		99.366	44659.9	3.011
2009	100	28908	14418.7	2.005		100	18151.4	1.259		100	44944.9	3.117
2010	100.998	29197	14783.8	1.975		100.566	18254.1	1.235		100.665	45243.8	3.060
2011	102.211	29547	15020.6	1.967		101.683	18456.9	1.229		101.482	45611.0	3.037
2012	103.515	29924	15369.2	1.947		103.178	18728.3	1.219		102.42	46032.6	2.995
2013	104.806	30297	15710.3	1.929		104.798	19022.3	1.211		103.507	46521.1	2.961
];

yrs=data(:,1);
KY=data(:,5);
KYpvt=data(:,8);
KYtot=data(:,11);

figure(1); figsetup;
plot(yrs,KY,'-','Color',mygreen,'LineWidth',4); 
plot(yrs,KYpvt,'-','Color',myred,'LineWidth',4);
plot(yrs,KYtot,'-','Color',myblue,'LineWidth',4);
axlabel=strmat('0 1 2 3 4 5 6 7');
relabelaxis((str2num(axlabel)),axlabel,'y');
ax=axis; ax(1)=1925; ax(2)=2015; axis(ax);
chadfig2('Year','Ratio of Real K / Real GDP',1,0);
%set(gca,'YGrid','on')
makefigwide;
text(1985,4,'Total');
text(1995,2.4,'Non-residential')
text(1990,.9,'Private non-residential');
print KYbea.eps


diary off;
