% Levels1960_2011   3/6/15
%
%   Also Barro convergence graph

diarychad('Levels1960_2011');

load pwt80;
load regions80
definecolors;

gdp=rgdpo;
ypc=div(rgdpo,pop);       % per capita  
y=div(ypc,ypc(:,USA)); % US=1

yr0=1949;
y0=y(1960-yr0,:)';
y1=y(2011-yr0,:)';

y0(outliersAfter1980)=NaN; % Shut off outliers

ctys=[USA JPN HKG FRA ZAF MEX IND CHN KEN THA VNM BWA ARG ZWE]';
namethese=zeros(length(y0),1);
namethese(ctys)=1;

labs=strmat('1/256#1/128# 1/64 # 1/32 # 1/16 #  1/8  #  1/4  #  1/2  #   1   ','#');

figure(1); figsetup;
plotlog(log(y0),y1,namesSTR,labs,10,[],.8,.5,namethese);
set(gca,'XTick',log([1/256 1/128 1/64 1/32 1/16 1/8 1/4 1/2 1]));
set(gca,'XTickLabel',labs);
ax=axis; ax(1)=log(1/64); ax(3)=log(1/172); ax(4)=log(1.5); axis(ax);
hold on;
gg=[log(1/256) log(1.5)];
plot(gg,gg,'b-','LineWidth',1);
chadfig2('GDP per person (US=1) in 1960','GDP per person (US=1) in 2011',1,0);
makefigwide;
print Levels1960_2011.eps

disp 'Factor poorer than US = 1/income';
cshow(namesSTR,[1./y0 1./y1],'%8.1f','1960 2011');

g=log(ypc(2011-1949,:)./ypc(1960-1949,:))/(2011-1960);
g=g';


figure(2); figsetup;
plotnamesym2(log(y0(~oecd)),g(~oecd),namesSTR(~oecd,:),10,[],.8,.01,namethese,0,myblue*1.1);
plotnamesym2(log(y0(oecd)),g(oecd),namesSTR(oecd,:),10,myred*.8,.8,.5,namethese,0,myblue*.6);
set(gca,'XTick',log([1/256 1/128 1/64 1/32 1/16 1/8 1/4 1/2 1]));
set(gca,'XTickLabel',labs);
ax=axis; ax(1)=log(1/64); axis(ax);
nums=(-.02:.01:.07)';
plabs=strmat('-2% -1% 0% 1% 2% 3% 4% 5% 6% 7%');
relabelaxis(nums,plabs,'y');
chadfig2('GDP per person (US=1) in 1960','Growth rate, 1960 - 2011',1,0);
makefigwide;
print Levels1960_2011_growth.eps

figure(3); figsetup;
addols=0;
%plotnamesym2(log(y0(~oecd)),g(~oecd),namesSTR(~oecd,:),10,[],.8,.5,namethese);
plotnamesym2(log(y0(oecd)),g(oecd),namesSTR(oecd,:),10,myred*.8,.8,.5,namethese,addols);
set(gca,'XTick',log([1/256 1/128 1/64 1/32 1/16 1/8 1/4 1/2 1]));
set(gca,'XTickLabel',labs);
ax=axis; ax(1)=log(1/5.5); axis(ax);
nums=(.015:.005:.045)';
plabs=strmat('1.5% 2% 2.5% 3% 3.5% 4% 4.5%');
relabelaxis(nums,plabs,'y');
chadfig2('GDP per person (US=1) in 1960','Growth rate, 1960 - 2011',1,0);
makefigwide;
print Levels1960_2011_oecd.eps

X=[ones(sum(oecd),1) log(y0(oecd))];
ols(g(oecd),X,'Barro Regression','g',strmat('Constant log(y0)'));
b=lstiny(g(oecd),X);
beta=b(2);
T=(2011-1960);
lambda=-1/T*log(1+beta*T);
fprintf('OLS coeff = %6.4f    Speed of Convergence = %6.4f\n',[beta lambda]);


fprintf('Number negative growth 1960-2011: %3.0f  Fraction: %4.2f\n',[sum(g<0) sum(g<0)/sum(~isnan(y0.*y1))]);