% MarkovFive2015   11/20/96
%
% Estimates a simple Markov transition matrix for 121 countries, 1960-1997
%        Five2015 Year data...
%
%   3/26/97 -- Adds 2010 and 2050 distributions
%
%  3/21/01 -- Revised for Second Edition of Book: Use BookData 
%     Five2015 = Use 1960 65 70 75 80 85 90 95 as the years.
%
%  9/20/12 -- Use PWT70 for Third Edition
%  3/5/15 -- Use PWT80 for Handbook Chapter
% 12/15/15 -- Starting year is 1980 instead of 1960

diarychad('MarkovFive2015');

clear;
%load BookData;
load pwt80
load regions80


yr0=1949;
%yrs=(1963:5:2008)';
%YearGap=5
%yrs=[(1960:10:2000)'; 2008]

yrs=(1980:10:2010)';
YearGap=10

%yrs=(1960:5:2010)';
%YearGap=5

%yrs=(1960:1:2010)';
%YearGap=1

gdp=rgdpo;
ypc=div(rgdpo,pop);       % per capita  
ypc=ypc(yrs-yr0,:);
y=div(ypc,ypc(:,USA)); %US=1



%y=gdpw(yrs-yr0,:);
%y=rgdpch(yrs-yr0,:);
%y=rgdpwok(yrs-yr0,:);
%y=div(y,y(:,USA)); 			% US=1 always

% Get sample 121 countries
KK=length(yrs)
smpl=~isnan(y(1,:)'.*y(KK,:)') & ~outliersAfter1980;

Nctys=sum(smpl)
y0=vector(y((1:(KK-1))',smpl));
y1=vector(y((2:KK)',smpl));

%bins=[.1 .2 .4 2.5]';
%bins=[.1 .2 .4 .7 1 2.5]';
%bins=[.05 .1 .2 .3 .5 .75 1 2.5]';
bins=[.05 .1 .2 .4 .8 4]';

N=length(bins);

M=zeros(N,N);


% %%%%%%%%%%
% Initial (1960) and Final (2008) distributions
%  Why wasn't this already in the program? 9/20/12
yinit=y(1,smpl)';
yfin=y(end,smpl)';
dist0=zeros(N,1);
distT=zeros(N,1);
for cty=1:length(yinit);
  i=getbin(yinit(cty),bins);
  dist0(i)=dist0(i)+1;
  i=getbin(yfin(cty),bins);
  distT(i)=distT(i)+1;
end;
dist0=dist0/Nctys
distT=distT/Nctys
  
% %%%%%%%%%%


y=packr([y0 y1]);
[blah,indx]=sort(y(:,1));
y=y(indx,:); 				% 1960 and 1988, sorted by 1960

NN=length(y)

% Construct the matrix
for cty=1:length(y)
  i=getbin(y(cty,1),bins);
  j=getbin(y(cty,2),bins);
  M(i,j)=M(i,j)+1;
end;

rowsum=sum(M')';
colsum=sum(M)';
disp 'The Markov matrix by countries';
cshow(' ',[bins M rowsum],'%6.2f');

disp ' ';
disp 'The Markov matrix by probabilities';
P=div(M,rowsum);
cshow(' ',[bins P],'%8.3f');

% Now, compute the Ergodic distribution 
P=P'
disp 'Setting P=Ptrans to match Hamilton'; disp ' ';
[V,D]=eig(P)

A=[eye(N)-P; ones(1,N)];
AA=inv(A'*A)*A';
ergdist=AA(:,N+1);
disp ' ';
disp 'The ergodic distribution is'; disp ' ';
cshow(' ',[bins ergdist],'%8.2f %8.4f');



% %%%%%%%%%% See Markov6097.m for the 1960 adn 1997 disttributions
% %% disp 'For some reason, this doesnt work dist60 and distT .... Careful!'
% %% disp ' ';
% %% disp '    Bins    1960     1997    Ergodic';
% %% disp '-------------------------------------';
% %% cshow(' ',[bins dist60 distT ergdist],'%8.2f  %8.4f %8.4f %8.4f');


% %% 
% %% % Distribution in 2010 and 2050
% %% %  2010-1997 = 13
% %% %  2050-1997 = 53
% %% disp ' ';
% %% disp 'The distribution in 2010, 13 years hence';
% %% P^13*dist97
% %% 
% %% disp ' ';
% %% disp 'The distribution in 2050, 53 years hence';
% %% P^53*dist97
% %% 

disp ' ';
disp ' ';
disp 'Now find times to Shuffle!';
disp ' ';

maxT=1000
precsn=.01
years=zeros(N,1);
for i=1:N;
  curdist=zeros(N,1);
  curdist(i)=1;
  T=shuffling(P,ergdist,curdist,precsn,maxT);
  years(i)=T;
end;
cshow(' ',[bins years],'%8.2f %8.0f');


disp ' '; disp ' ';
disp 'Table for Book/Paper';
disp ' '
tle='Bins dist0 distT ergdist shuffle';
fmt='%8.2f %8.0f'; % %8.4f %8.4f %8.0f'
cshow(' ',[bins [dist0 distT ergdist]*100 years*YearGap],fmt,tle);





disp ' ';
disp ' ';
disp 'Now, some sample calculations (recording my testing...)';
disp ' ';
v=zeros(N,1);
v(N)=1;
disp 'P^125*[0 0 0 0 0 1]:  125 years to get 10 percent prob <10 percent y';
P^125*v

disp ' ';
disp 'Korea (<10 percent to 40<y<80)'
v=zeros(N,1);
v(2)=1;
disp 'P^37*[0 1 0 0 0 0]:  10 percent prob to become rich after 37 years'
P^37*v

disp ' ';
disp 'Japan (<20 to y>80)'
v=zeros(N,1);
v(3)=1;
disp 'P^50*[0 0 1 0 0 0]:  10 percent prob to become rich after 50 years'
P^50*v



diary off;