% MillionCities    3/1/15
%
% Satterthwaite
%  http://pubs.iied.org/pdfs/9531IIED.pdf



diarychad('MillionCities')
definecolors;


%Table 3: The distribution of the world’s largest cities by region over time
%Region 1800 1900 1950 2000
%Number of “million-cities”
% World 2 17 86 387
% Africa 0 0 2 35
% Asia 1 4 31 194
% Europe 1 9 30 62
% Latin America and the Caribbean 0 0 7 49
% Northern America 0 4 14 41
% Oceania 0 0 2 6 

% 1800 1900 1950 2000
% 2 17 86 387  % World 
% 0 0 2 35    % Africa 
% 1 4 31 194  % Asia 
% 1 9 30 62   % Europe 
% 0 0 7 49    % Latin America and the Caribbean 
% 0 4 14 41   % Northern America 
% 0 0 2 6     % Oceania 
    
data=[    
1800 1900 1950 2000
2 17 86 387  % World 
0 0 2 35    % Africa 
1 4 33 200  % Asia+Oceania
1 9 30 62   % Europe 
0 0 7 49    % Latin America and the Caribbean 
0 4 14 41   % Northern America 
];

yrs=data(1,:)';
world=data(2,:)';
africa=data(3,:)';
asia=data(4,:)';
europe=data(5,:)';
samer=data(6,:)';
namer=data(7,:)';

yrsAdj=yrs; yrsAdj(1)=1850; % For plotting

figure(1); figsetup;
bar(yrsAdj,[asia europe samer namer africa]);
ax=axis; ax(1)=1820; ax(2)=2050; axis(ax);
relabelaxis(yrsAdj,num2str(yrs),'x');
text(1991,180,'Asia','Color',myblue*.6,'Rotation',50);
text(1993,69,'Europe','Color',myblue*.8,'Rotation',50);
text(2008,46,'N. America','Color',myred*.9,'Rotation',50);
text(2017,39,'Africa','Color',myred*.6,'Rotation',50);
text(2000,56,'S. America','Color',mygreen*.9,'Rotation',50);
makefigwide;

print MillionCities.eps