% OECDHealth   3/3/15
%
%  See Data/OECD-Health-Statistics-2014.xls
%  OECD Health Statistics 2014 - Frequently Requested Data

clear all;
diarychad('OECDHealth')
definecolors;

data=[
%	US	UK	Fra	Ger	Jpn
1960	5.1	3.9	3.8	NaN	3.0
% 1961	5.3	4.0	NaN	NaN	3.4
% 1962	5.3	4.0	NaN	NaN	3.6
% 1963	5.5	4.1	NaN	NaN	3.8
% 1964	5.7	4.1	NaN	NaN	3.5
1965	5.7	4.1	4.8	NaN	4.4
% 1966	5.7	4.3	NaN	NaN	4.5
% 1967	6.1	4.4	NaN	NaN	4.6
% 1968	6.3	4.5	NaN	NaN	4.6
% 1969	6.6	4.4	NaN	NaN	4.6
1970	6.8	4.5	5.4	6.0	4.4
% 1971	6.9	4.5	NaN	6.5	4.5
% 1972	7.1	4.6	NaN	6.8	4.7
% 1973	7.1	4.6	NaN	7.2	4.5
% 1974	7.4	5.2	NaN	7.7	5.0
1975	7.7	5.4	6.4	8.4	5.5
% 1976	8.0	5.4	NaN	8.4	5.5
% 1977	8.2	5.3	NaN	8.3	5.6
% 1978	8.1	5.3	NaN	8.4	5.8
% 1979	8.2	5.2	NaN	8.2	6.0
1980	8.7	5.6	7.0	8.4	6.4
% 1981	9.1	5.9	NaN	8.7	6.4
% 1982	9.8	5.7	NaN	8.6	6.6
% 1983	10.0	5.9	NaN	8.6	6.7
% 1984	9.9	5.9	NaN	8.6	6.5
1985	10.0	5.8	8.0	8.8	6.5
% 1986	10.2	5.8	NaN	8.7	6.5
% 1987	10.5	5.9	NaN	8.8	6.5
% 1988	10.9	5.8	NaN	8.9	6.2
% 1989	11.2	5.8	NaN	8.3	6.0
1990	11.9	5.8	8.4	8.3	5.8
1991	12.6	6.3	8.6	8.95	5.9
1992	12.9	6.7	8.9	9.6	6.1
1993	13.2	6.7	9.3	9.6	6.4
1994	13.1	6.8	9.3	9.8	6.7
1995	13.2	6.7	10.4	10.1	6.8
1996	13.1	6.7	10.4	10.4	7.0
1997	13.0	6.5	10.3	10.3	6.9
1998	13.1	6.6	10.1	10.3	7.2
1999	13.1	6.8	10.2	10.4	7.4
2000	13.1	6.9	10.1	10.4	7.6
2001	13.8	7.2	10.2	10.5	7.8
2002	14.6	7.5	10.6	10.7	7.9
2003	15.1	7.8	10.8	10.9	8.0
2004	15.2	7.9	10.9	10.7	8.0
2005	15.2	8.1	10.9	10.8	8.2
2006	15.3	8.3	10.9	10.6	8.2
2007	15.6	8.4	10.8	10.5	8.2
2008	16.1	8.8	10.9	10.7	8.6
2009	17.1	9.7	11.6	11.8	9.5
2010	17.0	9.4	11.6	11.6	9.6
2011	17.0	9.2	11.5	11.2	10.1
2012	16.9	9.3	11.6	11.3	10.3
2013	NaN	NaN	NaN	11.3	NaN
];
%	US	UK	Fra	Ger	Jpn

yrs=data(:,1);
us=data(:,2);
uk=data(:,3);
fra=data(:,4);
ger=data(:,5);
jpn=data(:,6);

figure(1); figsetup;
plot(yrs,us,'-','Color',myblue,'LineWidth',4);
plot(yrs,uk,'-','Color',mygreen,'LineWidth',4);
plot(yrs,fra,'-','Color',myred,'LineWidth',4);
plot(yrs,ger,'--','Color',mygreen,'LineWidth',4);
plot(yrs,jpn,'--','Color',myblue,'LineWidth',4);
ax=axis; ax(2)=2014; axis(ax);
chadfig2('Year','Percent',1,0);
makefigwide;
text(2000,17,'U.S.','Color',myblue*.8);
text(1969,9.5,'Germany','Color',mygreen*.8);
text(2008,12.8,'France','Color',myred*.8);
text(2000,5.7,'U.K.','Color',mygreen*.8);
text(1970,3.5,'Japan','Color',myblue*.8);
print OECDHealth.eps
