% Pollution   3/3/15
%
%  See Data/Pollution-Tier1.xls
% http://www.epa.gov/ttnchie1/trends/
% National Emissions Inventory (NEI) Air Pollutant Emissions Trends Data



diarychad('Pollution')
definecolors;

data=[
%	CO	NOX	PM10	SO2	VOC
1970	204042	26883	13022	31218	34659
1975	188398	26377	7555	28044	30765
1980	185408	27079	7013	25926	31107
1985	176845	25757	41323	23307	27403
1990	154188	25529	27753	23077	24108
1991	147128	25179	27345	22375	23577
1992	140895	25260	27098	22082	23066
1993	135902	25357	27364	21773	22730
1994	133558	25349	28608	21346	22570
1995	126778	24956	25820	18619	22042
1996	128858	24787	22857	18385	20871
1997	117910	24705	22909	18840	19530
1998	115380	24348	22893	18944	18781
1999	114541	22845	23383	17545	18270
2000	114467	22598	23747	16347	17512
2001	106262	21549	23708	15932	17111
2002	102033	23959	21576	15032	20289
2003	99593	22651	21664	14808	19911
2004	97147	21331	21749	14571	19514
2005	88546	20355	21302	14546	17753
2006	85837	19227	21401	13123	17902
2007	83128	18099	21501	11699	18050
2008	79655	16909	21580	10324	17759
2009	73380	15877	21243	9135	17667
2010	74653	14974	20897	7805	17914
2011	75760	14574	20907	6557	18169
2012	74597	13707	20884	5280	17956
2013	73433	13119	20861	5170	17744
]
%	CO	NOX	PM10	SO2	VOC

yrs=data(:,1);
polldata=data(:,2:6);
g=delta(log(polldata))
gAvg=mean(g')'
pollindx=exp([0; cumsum(gAvg)]);
pollindx=pollindx/pollindx(1)*100;

co=data(:,2);
nox=data(:,3);
pm10=data(:,4);
so2=data(:,5);
voc=data(:,6);

figure(1); figsetup;
plot(yrs,pollindx,'-','Color',myblue,'LineWidth',4);
ax=axis; ax(2)=2015; ax(3)=0; axis(ax);
chadfig2('Year','Equally-weighted index of 5 pollutants (initial value is 100)',1,0);
makefigwide;
%print Pollution.eps

figure(2); figsetup;
plot(yrs,log(co),'-','Color',myblue,'LineWidth',4);
plot(yrs,log(nox),'-','Color',mygreen,'LineWidth',4);
plot(yrs,log(pm10),'-','Color',myred,'LineWidth',4);
plot(yrs,log(so2),'-','Color',mygrey,'LineWidth',4);
plot(yrs,log(voc),'-','Color',myblue,'LineWidth',4);
%ax=axis; ax(2)=2015; ax(3)=0; axis(ax);
chadfig2('Year','Tons of pollutant',1,0);
makefigwide;
print Pollution.eps



diary off;