% RND_nipa.m    2/11/2015
%
%  NIPA data on R&D and Intellectual Property Products, via FRED (RND data list)
%  See RND2015-Nipa.xls
%
%  
%  GDPA	        -- Nominal GDP
%  Y001RC1A027NBEA -- Gross Private Domestic Investment: Intellectual Property Products
%  Y006RC1A027NBEA --   GPDI: Intellectual Property Products: R%D
%  Y055RC1A027NBEA -- Government Gross Investment: Intellectual Property Products
%  Y057RC1A027NBEA --   GGI: Intellectual Property Products: R%D
%  Y694RC1A027NBEA -- Gross Domestic Product: Research and Development

diarychad('RND_nipa');
clear all;

data=[
%DATE	GDPA	Y001RC1A027NBEA	Y006RC1A027NBEA	Y055RC1A027NBEA	Y057RC1A027NBEA	Y694RC1A027NBEA
%             GDP PrivInvIPP PrivInvRND GovtInvIPP GovtInvRND TotRND
1929-01-01	104.6	0.6	0.2	0.1	0.1	0.3
1930-01-01	92.2	0.6	0.2	0.1	0.1	0.3
1931-01-01	77.4	0.5	0.2	0.1	0.1	0.3
1932-01-01	59.5	0.4	0.2	0.1	0.1	0.3
1933-01-01	57.2	0.4	0.2	0.1	0.1	0.3
1934-01-01	66.8	0.5	0.2	0.1	0.1	0.3
1935-01-01	74.3	0.6	0.2	0.1	0.1	0.3
1936-01-01	84.9	0.6	0.2	0.1	0.1	0.4
1937-01-01	93.0	0.7	0.3	0.1	0.1	0.4
1938-01-01	87.4	0.8	0.3	0.1	0.1	0.4
1939-01-01	93.5	0.8	0.3	0.1	0.1	0.4
1940-01-01	102.9	0.8	0.4	0.1	0.1	0.5
1941-01-01	129.4	1.1	0.6	0.3	0.3	0.9
1942-01-01	166.0	1.2	0.6	0.5	0.5	1.1
1943-01-01	203.1	1.1	0.5	0.9	0.9	1.4
1944-01-01	224.6	1.2	0.5	1.6	1.6	2.1
1945-01-01	228.2	1.4	0.5	1.5	1.5	2.1
1946-01-01	227.8	1.8	0.8	1.4	1.4	2.2
1947-01-01	249.9	2.0	1.1	1.4	1.4	2.4
1948-01-01	274.8	2.1	1.1	1.6	1.6	2.7
1949-01-01	272.8	2.0	1.0	1.7	1.7	2.7
1950-01-01	300.2	2.3	1.2	1.9	1.9	3.1
1951-01-01	347.3	2.4	1.4	2.1	2.1	3.5
1952-01-01	367.7	3.0	1.9	2.4	2.4	4.3
1953-01-01	389.7	3.7	2.4	2.7	2.7	5.1
1954-01-01	391.1	3.9	2.5	3.0	3.0	5.6
1955-01-01	426.2	4.3	2.7	3.6	3.6	6.3
1956-01-01	450.1	5.2	3.6	4.8	4.8	8.4
1957-01-01	474.9	5.6	3.7	5.9	5.9	9.6
1958-01-01	482.0	6.0	4.0	6.4	6.4	10.4
1959-01-01	522.5	6.6	4.4	7.0	7.0	11.4
1960-01-01	543.3	7.1	4.9	7.8	7.8	12.7
1961-01-01	563.3	8.0	5.2	8.8	8.8	13.9
1962-01-01	605.1	8.4	5.6	9.9	9.8	15.4
1963-01-01	638.6	9.2	6.0	11.7	11.6	17.6
1964-01-01	685.8	9.8	6.5	12.9	12.8	19.3
1965-01-01	743.7	11.1	7.2	13.8	13.6	20.8
1966-01-01	815.0	12.8	8.1	15.4	15.1	23.2
1967-01-01	861.7	14.0	9.0	16.2	15.9	24.9
1968-01-01	942.5	15.6	9.9	17.0	16.7	26.6
1969-01-01	1019.9	17.2	11.0	17.7	17.2	28.2
1970-01-01	1075.9	17.9	11.5	17.6	16.8	28.3
1971-01-01	1167.8	18.7	11.9	18.1	17.2	29.1
1972-01-01	1282.4	20.6	12.9	19.3	18.4	31.3
1973-01-01	1428.5	22.7	14.6	20.3	19.2	33.8
1974-01-01	1548.8	25.5	16.4	21.5	20.0	36.4
1975-01-01	1688.9	27.8	17.5	23.3	21.5	39.0
1976-01-01	1877.6	32.2	19.6	25.5	23.5	43.1
1977-01-01	2086.0	35.8	21.8	27.9	25.8	47.5
1978-01-01	2356.6	40.4	24.9	31.0	28.5	53.5
1979-01-01	2632.1	48.1	29.1	35.0	31.8	60.9
1980-01-01	2862.5	54.4	34.2	39.6	35.7	69.8
1981-01-01	3211.0	64.8	39.7	45.0	40.3	79.9
1982-01-01	3345.0	72.7	44.8	49.7	44.2	89.0
1983-01-01	3638.1	81.3	49.6	55.2	48.8	98.4
1984-01-01	4040.7	95.1	56.9	62.2	54.6	111.4
1985-01-01	4346.7	105.3	63.0	71.0	62.1	125.1
1986-01-01	4590.2	113.5	66.5	75.2	65.5	132.0
1987-01-01	4870.2	120.1	69.2	81.7	70.9	140.2
1988-01-01	5252.6	132.7	75.5	85.1	72.7	148.2
1989-01-01	5657.7	150.1	82.8	87.8	73.1	155.9
1990-01-01	5979.6	164.4	89.3	91.1	75.0	164.2
1991-01-01	6174.0	179.1	96.0	91.4	74.0	170.0
1992-01-01	6539.3	187.7	98.6	91.6	73.2	171.9
1993-01-01	6878.7	196.9	99.2	91.4	72.8	172.0
1994-01-01	7308.8	205.7	101.3	92.0	73.6	175.0
1995-01-01	7664.1	226.8	112.0	94.0	75.5	187.5
1996-01-01	8100.2	253.3	123.6	95.5	76.3	199.8
1997-01-01	8608.5	288.0	134.4	98.3	77.7	212.0
1998-01-01	9089.2	317.7	143.3	102.3	79.0	222.4
1999-01-01	9660.6	364.0	155.7	106.5	81.5	237.2
2000-01-01	10284.8	409.5	169.5	113.2	86.0	255.6
2001-01-01	10621.8	412.6	171.3	119.7	91.8	263.2
2002-01-01	10977.5	406.4	165.7	126.0	100.0	265.7
2003-01-01	11510.7	420.9	167.2	136.5	110.3	277.6
2004-01-01	12274.9	442.1	173.0	145.5	118.3	291.2
2005-01-01	13093.7	475.1	188.1	153.9	125.0	313.1
2006-01-01	13855.9	504.6	204.5	160.6	130.1	334.6
2007-01-01	14477.6	537.9	223.3	169.0	136.6	360.0
2008-01-01	14718.6	563.4	237.7	177.2	142.7	380.5
2009-01-01	14418.7	550.9	229.0	179.8	145.8	374.8
2010-01-01	14964.4	564.3	240.2	187.4	151.9	392.1
2011-01-01	15517.9	592.2	250.0	191.6	154.1	404.1
2012-01-01	16163.2	621.0	261.1	192.8	154.2	415.3
2013-01-01	16768.1	647.1	274.9	188.4	149.0	424.0
2014-01-01	17420.7	684.7	298.9	181.9	141.7	440.6
];
%             GDP PrivInvIPP PrivInvRND GovtInvIPP GovtInvRND TotRND

yrT=2014
yrs=(1929:yrT)';
gdp=data(:,2);
PrivInvIPP =data(:,3);
PrivInvRND =data(:,4);
GovtInvIPP =data(:,5);
GovtInvRND =data(:,6);
TotRND     =data(:,7);  

RND_gdp=TotRND./gdp*100;
PrivRND_gdp=PrivInvRND./gdp*100;
GovtRND_gdp=GovtInvRND./gdp*100;
IPP_gdp=(PrivInvIPP+GovtInvIPP)./gdp*100;


e=(TotRND-PrivInvRND-GovtInvRND)./gdp*100;
OtherIPP_gdp=IPP_gdp-RND_gdp;

tle='Year IPP OtherIPP RND PrivRND GovtRND err';
cshow(' ',[yrs IPP_gdp OtherIPP_gdp RND_gdp PrivRND_gdp GovtRND_gdp e],'%6.0f %8.2f',tle);


series=[PrivRND_gdp GovtRND_gdp OtherIPP_gdp];

figure(1); figsetup;
cmap=colormap(winter);
colormap(2/3+cmap/3);
%brighten(-.2); % darken the colormap
area(yrs,series); hold on;
relabelaxis([0 1 2 3 4 5 6],strmat('0% 1% 2% 3% 4% 5% 6%'));
chadfig2('Year','Share of GDP',1,0);
makefigwide;
text(1991,.75,'Private R&D');
text(1968,1.85,'Government R&D');
text(1995,3.6,mlstring('Software and \\  Entertainment'));
ax=axis; ax(1)=1929; ax(2)=2014; axis(ax);
set(gca,'Layer','top');
%line([1993 1998],[8.3 7],'Color','k','LineWidth',1)
%wait;
print RND_nipa.eps

