% RND_scieng.m    2/11/2015
%
%  From OECD Main Science and Technology Indicators
%  See Data/RND-Personnel-OECD.xls
%
% From "Sources of U.S. Economic Growth..." (AER 2002):
% Scientists and Engineers Engaged in R&D.  The data for 1965 to 1993 is
% taken from National Science Board (1993, 1998).  For years prior to 1965
% for the U.S., data from the Historical Statistics of the United States,
% Colonial Times to 1970 and various editions of the Statistical
% Abstract of the United States are used.  Missing data are log-linearly
% interpolated.

diarychad('RND_scieng');
clear all;





data=[
% Researcher shares of the population
% Percent of the population    
%    	US	OECD	OECD+Ch/Ru
1981	0.231	0.180	NaN
1982	0.238	0.185	NaN
1983	0.248	0.194	NaN
1984	0.260	0.201	NaN
1985	0.254	0.205	NaN
1986	0.269	0.215	NaN
1987	0.281	0.224	NaN
1988	0.284	0.231	NaN
1989	0.291	0.238	NaN
1990	0.294	0.245	NaN
1991	0.294	0.221	NaN
1992	0.297	0.227	NaN
1993	0.300	0.231	NaN
1994	0.293	0.236	0.166
1995	0.298	0.236	0.166
1996	0.312	0.248	0.171
1997	0.322	0.253	0.174
1998	0.339	0.262	0.174
1999	0.345	0.269	0.179
2000	0.348	0.275	0.188
2001	0.355	0.283	0.193
2002	0.364	0.287	0.197
2003	0.388	0.301	0.207
2004	0.377	0.304	0.209
2005	0.372	0.313	0.218
2006	0.378	0.320	0.225
2007	0.376	0.321	0.232
2008	0.391	0.329	0.242
2009	0.407	0.335	0.231
2010	0.387	0.336	0.231
2011	0.402	0.345	0.240
];


yrs=data(:,1);
us=data(:,2);
oecd=data(:,3);
oecdchru=data(:,4);

cshow(' ',[yrs us oecd oecdchru],'%6.0f %8.3f','Year US oecd OecdChRu');

% From scidataSourcesAER.m, which in turn takes these data
% from my dissertation / JPE paper.
%
%  US pop is from uspcgdp = FRED/BEA B230RC0
%          
%          USsci  USpop
sci89=[
 1950      161.4  151684
 1951      178.8  154287
 1952      209.4  156954
 1953      232.9  159565
 1954      249.2  162391
 1955      254.4  165275
 1956      276.8  168221
 1957      315.6  171274
 1958      337.1  174141
 1959      369.8  177130
 1960      394.3  180760
 1961      418.8  183742
 1962      451.5  186590
 1963      486.2  189300
 1964      508.7  191927
 1965      524.0  194347
 1966      537.3  196599
 1967      565.9  198752
 1968      564.9  200745
 1969      560.8  202736
 1970      546.5  205089
 1971      526.4  207692
 1972      518.5  209924
 1973      520.4  211939
 1974      525.4  213898
 1975      534.8  215981
 1976      549.9  218086
 1977      570.3  220289
 1978      595.3  222629
 1979      621.0  225106
 1980      651.2  227726
 1981      683.3  230008
% 1982      711.9  232218
% 1983      751.7  234333
% 1984      797.8  236394
% 1985      849.2  238506
% 1986      896.5  240683
% 1987      923.3  242843
% 1988      949.2  245061
];
        	
yrsold=sci89(:,1);
sciold=sci89(:,2);
scipop=sci89(:,3);

usold=sciold./(scipop)*100;
xsplice=us(1)/usold(end)
ussplice=usold*xsplice;


cshow(' ',[yrsold sciold scipop usold ussplice],'%6.0f %8.1f %8.0f %8.3f %8.3f','Year Sci Pop Share Spliced');



LW=4;
myblue=[        0    0.4470    0.7410];
mygreen=[    0.4660    0.64    0.1880];
myred=[    0.8500    0.3250    0.0980];
mygrey=[210 210 210]/255;



figure(1); figsetup;
plot(yrs,us,'-','Color',myblue,'LineWidth',LW); 
plot(yrsold,ussplice,'--','Color',myblue,'LineWidth',LW); 
plot(yrs,oecd,'-','Color',mygreen,'LineWidth',LW);
plot(yrs,oecdchru,'-','Color',myred,'LineWidth',LW);
chadfig2('Year','Share of the population',1,0);
labs=(0:.1:.4)';
relabelaxis(labs,strmat('0% 0.1% 0.2% 0.3% 0.4%'),'y');
ax=axis; ax(2)=2015; ax(4)=.41; axis(ax);
makefigwide;
text(1980,.33,'United States');
text(2009,.31,'OECD');
text(2001,.16,mlstring('OECD plus China\\      and Russia'));
print RND_scieng.eps

diary off;
