% RameyHoursWork   2/28/15
%
% Ramey and Francis, "A Century of Work and Leisure" AEJMacro 2009
% See Data/RameyCenturyofLeisure.xls

diarychad('RameyHoursWork')
definecolors;

data=[
%Average Weekly Hours of Work				Home Prod.	Weekly hours of leisure
%	-------market-----      HomeP   Leisure				
%	Males	Females	All	Males	All
1900	44.81	9.59	27.65	4.02	36.89
1901	45.66	9.87	28.24	3.96	36.31
1902	46.46	10.14	28.80	3.90	35.78
1903	46.74	10.30	29.04	3.91	35.55
1904	45.02	10.01	28.03	4.01	36.58
1905	46.09	10.35	28.76	3.93	35.89
1906	46.78	10.60	29.25	3.83	35.48
1907	46.77	10.70	29.31	3.87	35.38
1908	43.81	10.12	27.51	4.19	37.05
1909	45.09	10.51	28.38	4.06	36.23
1910	45.18	10.63	28.50	4.07	36.11
1911	45.37	10.73	28.63	4.17	35.88
1912	46.13	10.96	29.11	4.09	35.46
1913	45.65	10.90	28.81	4.09	35.81
1914	44.08	10.58	27.83	4.30	36.68
1915	43.19	10.41	27.26	4.35	37.28
1916	45.67	11.07	28.84	4.17	35.77
1917	46.68	11.37	29.49	4.08	35.19
1918	47.91	11.96	30.57	3.80	34.46
1919	44.80	11.11	28.43	3.89	36.65
1920	44.02	10.87	27.82	4.10	37.01
1921	38.95	9.71	24.64	4.57	40.00
1922	41.09	10.34	26.01	4.37	38.67
1923	43.37	11.01	27.48	4.08	37.36
1924	41.50	10.63	26.32	4.16	38.55
1925	42.22	10.91	26.80	4.39	37.92
1926	42.90	11.18	27.26	4.54	37.39
1927	41.96	11.03	26.69	4.87	37.79
1928	41.62	11.04	26.50	5.20	37.81
1929	41.74	11.17	26.60	5.35	37.69
1930	38.38	10.36	24.48	5.98	39.53
1931	34.92	9.51	22.30	6.51	41.43
1932	30.74	8.44	19.65	7.09	43.82
1933	30.43	8.43	19.48	7.15	44.10
1934	30.07	8.40	19.27	7.04	44.59
1935	31.34	8.83	20.10	7.10	43.73
1936	33.83	9.61	21.73	7.00	42.15
1937	34.90	9.99	22.44	7.12	41.33
1938	32.11	9.27	20.67	7.49	42.95
1939	33.19	9.66	21.38	7.59	42.15
1940	34.10	10.00	21.99	7.63	41.58
1941	36.92	10.91	23.84	7.57	39.75
1942	40.51	12.06	26.18	7.46	37.69
1943	45.10	13.53	29.18	7.44	35.06
1944	45.51	13.76	29.48	7.55	34.62
1945	42.15	12.84	27.33	7.85	36.57
1946	36.54	11.21	23.72	8.33	39.48
1947	35.76	11.05	23.24	8.46	39.71
1948	35.65	11.09	23.19	8.52	39.72
1949	34.15	10.70	22.23	8.87	40.49
1950	34.37	10.63	22.29	9.02	40.39
1951	36.21	11.11	23.42	8.99	39.24
1952	36.40	11.27	23.58	9.14	38.91
1953	36.04	11.35	23.42	9.32	38.88
1954	34.21	10.96	22.31	9.66	39.74
1955	34.67	11.36	22.72	9.77	39.30
1956	34.58	11.55	22.76	9.89	39.18
1957	33.63	11.43	22.21	10.09	39.53
1958	31.96	11.04	21.18	10.43	40.34
1959	32.02	11.26	21.31	10.50	40.09
1960	32.11	11.47	21.44	10.68	39.81
1961	31.46	11.42	21.09	10.88	39.90
1962	31.42	11.57	21.13	10.95	39.72
1963	31.07	11.61	20.97	11.08	39.70
1964	30.83	11.74	20.91	11.17	39.59
1965	31.43	12.07	21.36	11.29	38.99
1966	31.71	12.29	21.60	11.27	39.17
1967	31.24	12.23	21.32	11.26	39.85
1968	30.75	12.43	21.18	11.28	40.33
1969	30.58	12.71	21.23	11.32	40.69
1970	29.36	12.47	20.51	11.44	41.74
1971	28.83	12.39	20.22	11.53	42.32
1972	28.88	12.75	20.44	11.59	42.53
1973	29.08	12.95	20.64	11.62	42.79
1974	28.36	13.00	20.33	11.70	43.50
1975	26.82	12.89	19.54	11.90	44.53
1976	26.95	13.19	19.76	12.07	44.49
1977	27.37	13.54	20.15	12.22	44.24
1978	27.78	14.31	20.74	12.36	43.81
1979	27.75	14.60	20.88	12.56	43.81
1980	26.72	14.64	20.41	12.85	44.34
1981	26.22	14.68	20.20	13.11	44.63
1982	25.94	14.88	20.17	13.47	44.61
1983	25.98	15.33	20.43	13.71	44.35
1984	27.20	15.97	21.35	13.81	43.51
1985	27.36	16.40	21.65	13.98	43.23
1986	27.57	16.86	21.99	14.17	42.77
1987	27.86	17.16	22.29	14.32	42.42
1988	28.43	17.78	22.89	14.48	41.72
1989	28.81	18.02	23.20	14.65	41.33
1990	28.30	18.11	23.00	14.86	41.40
1991	27.43	17.91	22.48	15.13	41.74
1992	26.78	17.82	22.13	15.32	41.99
1993	27.13	18.05	22.42	15.46	41.58
1994	27.61	18.27	22.76	15.59	41.15
1995	27.87	18.19	22.85	15.70	41.00
1996	27.60	18.46	22.86	15.82	40.90
1997	27.92	18.85	23.22	15.93	40.46
1998	27.79	18.87	23.17	16.06	40.46
1999	27.98	19.17	23.42	16.19	40.12
2000	28.00	19.30	23.50	16.33	39.94
2001	27.13	19.03	22.94	16.53	40.38
2002	26.71	18.68	22.55	16.73	40.59
2003	26.95	18.80	22.73	16.92	40.26
2004	27.00	18.84	22.77	16.77	40.43
2005	27.30	18.91	22.95	16.35	40.59
];
%	-------market-----      HomeP   Leisure				
%	Males	Females	All	Males	All

yrs=data(:,1);
men=data(:,2);
women=data(:,3);
total=data(:,4);
menHomeP=data(:,5);

menWorkplusHomeP=men+menHomeP;

figure(1); figsetup;
plot(yrs,men,'-','Color',myblue,'LineWidth',4);
plot(yrs,women,'-','Color',mygreen,'LineWidth',4);
nums=(0:10:60)';
relabelaxis(nums,num2str(nums),'y');
plot(yrs,menWorkplusHomeP,'-','Color',myred,'LineWidth',4);
chadfig2('Year','Average Weekly Hours',1,0);
ax=axis; ax(2)=2006; axis(ax);
makefigwide;
text(1980,31.5,'Market work (men)');
text(1985,12,'Market work (women)');
text(1960,47.5,'Market + home production (men)');
print RameyHoursWork.eps


% Let's also look at the PWT 8.0
clear all;
load pwt80;
definecolors;

ctys=[USA GBR FRA JPN KOR];
figure(2); figsetup;
plot(years,avh(:,USA),'-','Color',myblue*.8,'LineWidth',4);
plot(years,avh(:,GBR),'-','Color',mygreen,'LineWidth',4);
plot(years,avh(:,FRA),'-','Color',myred,'LineWidth',4);
plot(years,avh(:,JPN),'-','Color',myblue*1.2,'LineWidth',4);
plot(years,avh(:,KOR),'-','Color',mygreen*.8,'LineWidth',4);
chadfig2('Year','Average annual hours worked',1,0);
ax=axis; ax(2)=2014; axis(ax);
makefigwide;
text(1995,2700,'S. Korea');
text(1960,1780,'U.S.');
text(1990,2120,'Japan');
text(1990,1550,'France');
text(1980,1900,'U.K.');
print PWTHoursWork.eps

cshow(' ',[years avh(:,ctys)],'%6.0f %8.0f','Years USA GBR FRA JPN KOR');


diary off;