% RelativeGDP   3/5/15
%
%  The spread of growth since 1870 (maddison) and since 1980 (pwt)
%   See Data/Maddison2013.xls 
% Bolt, J. and J. L. van Zanden (2014). The Maddison Project: collaborative research on historical national accounts. The Economic History Review, 67 (3): 627–651.


diarychad('RelativeGDP')
definecolors;

data=[
% From the Bolt van Zanden update of Maddison
%	Arg	China	Japan	SAfrica	U.S.	U.K.    France
1870	1468	530	737	807	2445	3190	1876
1890	2416	540	1012	1148	3392	4009	2376
1900	2875	545	1180	937	4091	4492	2876
1913	3797	552	1387	NaN	5301	4921	3485
1930	4080	568	1850	1413	6213	5441	4532
1950	4987	448	1921	2535	9561	6939	5186
1960	5559	662	3986	3041	11328	8645	7398
1970	7302	778	9714	4045	15030	10767	11410
1980	8206	1061	13428	4390	18577	12931	14766
1990	6433	1871	18789	3834	23201	16430	17647
2000	8410	3421	20481	3920	28702	21046	20392
2010	10256	8032	21935	5080	30491	23777	21477
];

yrs=data(:,1);
reldata=data(:,2:8);
reldata=div(reldata,reldata(:,5))*100;
arg=reldata(:,1);
chn=reldata(:,2);
jpn=reldata(:,3);
zaf=reldata(:,4);
us=reldata(:,5);
uk=reldata(:,6);
fra=reldata(:,7);

zaf(4)=.5*(zaf(3)+zaf(5));

figure(1); figsetup;
plot(yrs,us,'-','Color',myblue*.9,'LineWidth',4);
plot(yrs,uk,'-','Color',myblue*1.2,'LineWidth',4);
plot(yrs,fra,'-','Color',myred*.9,'LineWidth',4);
plot(yrs,jpn,'-','Color',mygreen*.9,'LineWidth',4);
plot(yrs,zaf,'-','Color',myblue*1,'LineWidth',4);
plot(yrs,arg,'-','Color',mygreen*1.2,'LineWidth',4);
plot(yrs,chn,'-','Color',myred,'LineWidth',4);
chadfig2('Year','GDP per person (US=100)',1,0);
makefigwide;
text(1980,108,'United States');
text(1885,127,'U.K.');
text(1965,85,'France');
text(1986,40,'Argentina');
text(1971,60,'Japan');
text(1880,40,'S. Africa');
text(1960,13,'China');
ax=axis; ax(1)=1865; ax(2)=2014; axis(ax);
print RelativeGDP1870.eps
