% ReversalofFortune   3/12/15

clear all;
diarychad('ReversalofFortune')
definecolors;


fmts='%s '; fmtf='%f '; 
zz=ones(1,1)*fmts;  fmt1=vector(char(zz)')';
zz=ones(12,1)*fmtf;  fmt2=vector(char(zz)')';
fmt=[fmt1 fmt2]; fmt(end)=[]; % delete last space


%[countrycode,country,currency_unit,year,rgdpe,rgdpo,pop,emp,avh,hc,cgdpe,cgdpo,ck,ctfp,rgdpna,rkna,rtfpna,labsh,xr,pl_gdpe,pl_gdpo,i_cig,i_xm,i_xr,i_outlier,cor_exp,statcap,csh_c,csh_i,csh_g,csh_x,csh_m,csh_r,pl_c,pl_i,pl_g,pl_x,pl_m,pl_k] ...
%=textread('pwt80.csv',fmt,'delimiter',',','headerlines',1,'emptyvalue',NaN);

[ShortNam,euro1900,avgexpr,logpgp95,cons1,cons90,ex2col,urbz1995,pd1500s,lpd1500s,lpd1000s,sjb1500,baserf]...
=textread('chadreversal.csv',fmt,'delimiter',',','headerlines',1,'emptyvalue',NaN);


load pwt80;
N=size(pop,2); % Number of countries in PWT

PopDens1500=zeros(N,1)*NaN;
LogGDPpc95=zeros(N,1)*NaN;
Urban1500=zeros(N,1)*NaN;
ReversalSample=zeros(N,1)*NaN;

CodesRF=cell2mat(ShortNam);
CodesPWT=cell2mat(codes);

for i=1:length(ShortNam);
    if mod(i,20)==0; disp ' '; end;
    if exist(CodesRF(i,:))==1;
        say(CodesRF(i,:)); 
        cty=eval(CodesRF(i,:));
        PopDens1500(cty)=pd1500s(i);
        LogGDPpc95(cty)=logpgp95(i);
        Urban1500(cty)=sjb1500(i);
        %ReversalSample(cty)=baserf(i);
        ReversalSample(cty)=ex2col(i);    % Ex colonies
    end;
end;
disp ' ';
ReversalSample(isnan(ReversalSample))=0;
ReversalSample=logical(ReversalSample);

% First replicate AJR figure
figure(1); figsetup;
plotname(log(PopDens1500(ReversalSample)),LogGDPpc95(ReversalSample),codes(ReversalSample));
chadfig('log Pop Density in 1500','log GDP per person, 1995',1,0);


% pwt
gdp=rgdpo;
ypc=div(rgdpo,pop);       % per capita  
y=div(ypc,ypc(:,USA)); % US=100
y=y(2011-1949,:)';


PopDens1500(PopDens1500==0)=NaN; % Not sure why there are zeros!

figure(2); figsetup;
ctys=[USA HKG ZAF MEX IND KEN THA VNM BWA BRA ARG ZWE]';
namethese=zeros(length(y),1);
namethese(ctys)=1;
labs=strmat('1/256#1/128# 1/64 # 1/32 # 1/16 #  1/8  #  1/4  #  1/2  #   1   ','#');
plotlog(log(PopDens1500(ReversalSample)),y(ReversalSample),namesSTR(ReversalSample,:),labs,10,[],.8,.5,namethese);
set(gca,'XTick',log([1/16 1/4 1 4 16 64 256]));
set(gca,'XTickLabel',strmat('1/16# 1/4#  1 #  4 # 16 # 64 # 256','#'));
ax=axis; ax(4)=log(1.5); axis(ax);
hold on;
%gg=[log(1/256) log(1.5)];
%plot(gg,gg,'b-','LineWidth',1);
chadfig2('Population Density in 1500 (people per square km)','GDP per person (US=1) in 2011',1,0);
makefigwide;
print ReversalofFortune.eps
