% saez
%
%  Income inequality from Emmanuel Saez spreadsheet, downloaded
%  from his Berkeley web page, 2/23/10 --  See SaezIncomeData.xls
%   -- His Figure 12
%
%  Updated 4/25/12 -- see ~/Work/Inequality/SaezInequality*.xls
%
%  Income share for the top 0.1% of tax returns

clear all;
diarychad('SaezTopInequality');

% yrs=data(:,1);
% xFra=data(:,2);
% xUS=data(:,3);
% xUK=data(:,4);

%load /home/chad/Work/Inequality/WorldTopInequalityDatabase2013;
load WorldTopInequalityDatabase2013;
definecolors;

T=2012
yrs=(1913:T)';
yr0=1869;
yy=yrs-yr0;

xFra=is001(yy,FRA);
xUS=is001(yy,USA);
xUK=is001(yy,GBR);

figure(1); figsetup; makefigwide;
plot(yrs,xFra,'-','Color',mygreen,'LineWidth',4);
plot(yrs,xUS,'-','Color',myblue,'LineWidth',4);
%plot(yrs,xUK,'r-');
ax=axis; ax(1)=1910; ax(2)=2014; axis(ax);
set(gca,'YTick',[0 2 4 6 8 10 12]);
set(gca,'YTickLabel',strmat('0% 2% 4% 6% 8% 10% 12%'));
chadfig2('Year','Income share of top 0.1 percent',1,0);
text(1990,9,'United States');
%text(1925,95,'United Kingdom');
text(1930,3.5,'France');
print SaezTopInequality.eps

