% TaxShareUS   3/13/15
%
%  Reproduce the Stokey and Rebelo (1995) graph

clear all;
diarychad('TaxShareUS')
definecolors;


% FRED Graph Observations			
% Federal Reserve Economic Data			
% Link: http://research.stlouisfed.org/fred2			
% Help: http://research.stlouisfed.org/fred2/help-faq			
% Economic Research Division			
% Federal Reserve Bank of St. Louis			
			
% W021RC1A027NBEA	Government current receipts, Billions of Dollars, Annual, Not Seasonally Adjusted		
% GDPA	Gross Domestic Product, Billions of Dollars, Annual, Not Seasonally Adjusted		
			
% Frequency: Annual			
data=[
% observation_date	W021RC1A027NBEA	GDPA	Tax/GDP
1929-01-01	10.5	104.6	10.0382409178
1930-01-01	10.0	92.2	10.8459869848
1931-01-01	8.7	77.4	11.2403100775
1932-01-01	8.2	59.5	13.781512605
1933-01-01	8.6	57.2	15.034965035
1934-01-01	9.7	66.8	14.5209580838
1935-01-01	10.5	74.3	14.131897712
1936-01-01	11.9	84.9	14.0164899882
1937-01-01	14.3	93.0	15.376344086
1938-01-01	13.9	87.4	15.9038901602
1939-01-01	14.2	93.5	15.1871657754
1940-01-01	16.6	102.9	16.1321671526
1941-01-01	23.8	129.4	18.3925811437
1942-01-01	31.2	166.0	18.7951807229
1943-01-01	47.6	203.1	23.4367306745
1944-01-01	49.4	224.6	21.9946571683
1945-01-01	51.4	228.2	22.5241016652
1946-01-01	50.4	227.8	22.1246707638
1947-01-01	55.4	249.9	22.168867547
1948-01-01	56.8	274.8	20.6695778748
1949-01-01	53.6	272.8	19.6480938416
1950-01-01	66.1	300.2	22.0186542305
1951-01-01	81.9	347.3	23.5819176504
1952-01-01	86.4	367.7	23.497416372
1953-01-01	90.8	389.7	23.2999743392
1954-01-01	85.9	391.1	21.9636921503
1955-01-01	96.7	426.2	22.6888784608
1956-01-01	104.1	450.1	23.1281937347
1957-01-01	109.8	474.9	23.1206569804
1958-01-01	108.2	482.0	22.4481327801
1959-01-01	122.5	522.5	23.4449760766
1960-01-01	133.9	543.3	24.6456837843
1961-01-01	138.5	563.3	24.5872536837
1962-01-01	150.0	605.1	24.7892910263
1963-01-01	161.6	638.6	25.3053554651
1964-01-01	166.0	685.8	24.2053076699
1965-01-01	179.7	743.7	24.1629689391
1966-01-01	202.1	815.0	24.7975460123
1967-01-01	216.9	861.7	25.1711732622
1968-01-01	251.2	942.5	26.6525198939
1969-01-01	282.5	1019.9	27.6987939994
1970-01-01	285.7	1075.9	26.5545125012
1971-01-01	302.1	1167.8	25.8691556773
1972-01-01	345.4	1282.4	26.9338739863
1973-01-01	388.5	1428.5	27.196359818
1974-01-01	430.0	1548.8	27.7634297521
1975-01-01	440.9	1688.9	26.1057493043
1976-01-01	505.0	1877.6	26.8960374947
1977-01-01	566.7	2086.0	27.1668264621
1978-01-01	645.4	2356.6	27.3869133497
1979-01-01	728.6	2632.1	27.6813190988
1980-01-01	798.7	2862.5	27.9021834061
1981-01-01	918.0	3211.0	28.5892245406
1982-01-01	939.9	3345.0	28.0986547085
1983-01-01	1001.1	3638.1	27.5171105797
1984-01-01	1113.9	4040.7	27.5670057168
1985-01-01	1216.0	4346.7	27.9752455886
1986-01-01	1291.7	4590.2	28.1403860398
1987-01-01	1405.5	4870.2	28.8591844277
1988-01-01	1505.5	5252.6	28.6619959639
1989-01-01	1629.8	5657.7	28.8067589303
1990-01-01	1710.9	5979.6	28.612281758
1991-01-01	1761.0	6174.0	28.5228377065
1992-01-01	1846.0	6539.3	28.2293211812
1993-01-01	1950.1	6878.7	28.3498335441
1994-01-01	2094.0	7308.8	28.6503940455
1995-01-01	2218.2	7664.1	28.9427330019
1996-01-01	2382.3	8100.2	29.4103849288
1997-01-01	2559.3	8608.5	29.7299181042
1998-01-01	2731.7	9089.2	30.0543502178
1999-01-01	2903.4	9660.6	30.0540339109
2000-01-01	3133.1	10284.8	30.4634023024
2001-01-01	3118.2	10621.8	29.3566062249
2002-01-01	2967.0	10977.5	27.0280118424
2003-01-01	3042.8	11510.7	26.4345348241
2004-01-01	3265.1	12274.9	26.5998093671
2005-01-01	3663.5	13093.7	27.9791044548
2006-01-01	4001.8	13855.9	28.8815594801
2007-01-01	4202.4	14477.6	29.0269105377
2008-01-01	4041.8	14718.6	27.4604921664
2009-01-01	3689.0	14418.7	25.58483081
2010-01-01	3885.0	14964.4	25.9616155676
2011-01-01	4077.6	15517.9	26.2767513646
2012-01-01	4301.0	16163.2	26.6098297367
2013-01-01	4788.6	16768.1	28.557797246
];

yrstax=(1929:2013)';
taxshare=data(:,4);

load uspcgdp  % Maddison + NIPA since 1929
g=delta(logYL)*100;
gg=smooth(g,5); % Twosided moving average +/- 5 years

figure(1); figsetup; makefigwide;
[ax,h1,h2]=plotyy(trimr(yrs,0,1),gg,yrstax,taxshare);
darkfactor=.8;
set(h1,'LineWidth',LW,'Color',myblue);
set(h2,'LineWidth',LW,'Color',mygreen);
set(ax(1),'ycolor',myblue*darkfactor);
set(ax(2),'ycolor',mygreen*darkfactor);


%a1=axis(ax(1)); a1(3)=-3; a1(2)=2014; axis(ax(1),a1);
%a2=axis(ax(2)); a2(3)=37; a2(2)=2014; axis(ax(2),a2);
%lab2=strmat('1.2 1.4 1.6 1.8 2.0 2.2 2.4');
%lab1=strmat('0.2 0.3 0.4 0.5');
%lab=strmat('1960 1970 1980 1990 2000 2010');
set(ax(2),'XLim',[1880 2014]);
set(ax(1),'XLim',[1880 2014]);
set(ax(2),'YLim',[0 33]);
set(ax(1),'YLim',[-3 25]);
% set(ax(2),'XTick',str2num(lab));
% set(ax(2),'XTickLabel',lab);
% set(ax(1),'XTick',str2num(lab));
% set(ax(1),'XTickLabel',lab);
fs=14;
str=mlstring('Total government revenues\\ as a share of GDP (right scale)');
text(1935,23,str,'FontSize',fs);
str=mlstring('Annual growth of GDP per person\\ (moving average, +/-5 years, left scale)');
%str=mlstring(['Annual growth of GDP per person\\ (moving average, Chad' 177 '5 years, left scale)']);
text(1950,5.5,str,'FontSize',fs);
set(ax(1),'Box','off');
set(ax(2),'Box','off');
chadfig2(' ','Growth Rate (Percent)',1,0);
chadfigyy(ax(2),'Tax Share (Percent)');
print TaxShareUS.eps;