% TaxShareWorld   3/13/15
%
%   Tax Share of GDP versus GDP per person
%   World Bank, World Development Indicators
%   See Data/TaxShareofGDP-WDI.xls
%
% Central government finances.
% Revenue is cash receipts from taxes, social contributions, and other
% revenues such as fines, fees, rent, and income from property or sales.
% Grants are also considered as revenue but are excluded here.
%
% http://data.worldbank.org/indicator/GC.REV.XGRT.GD.ZS/countries
% http://wdi.worldbank.org/table/4.12#


clear all;
diarychad('TaxShareWorld')
definecolors;

fmts='%s '; fmtf='%f '; 
zz=ones(1,1)*fmts;  fmt1=vector(char(zz)')';
zz=ones(25,1)*fmtf;  fmt2=vector(char(zz)')';
fmt=[fmt1 fmt2]; fmt(end)=[]; % delete last space


[Code,y1990,y1991,y1992,y1993,y1994,y1995,y1996,y1997,y1998,y1999,y2000,y2001,y2002,y2003,y2004,y2005,y2006,y2007,y2008,y2009,y2010,y2011,y2012,y2013,y2014]...
=textread('TaxShareofGDP-WDI.csv',fmt,'delimiter',',','headerlines',1,'emptyvalue',NaN);


load pwt80;
N=size(pop,2); % Number of countries in PWT
T=(2014-1990+1);
TaxShare=zeros(T,N)*NaN;

CodesWB=cell2mat(Code);
CodesPWT=cell2mat(codes);

for i=1:length(Code);
    if mod(i,20)==0; disp ' '; end;
    if exist(CodesWB(i,:))==1;
        say(CodesWB(i,:)); 
        cty=eval(CodesWB(i,:));
        TaxShare(:,cty)=[y1990(i) y1991(i) y1992(i) y1993(i) y1994(i) y1995(i) y1996(i) y1997(i) y1998(i) y1999(i) y2000(i) y2001(i) y2002(i) y2003(i) y2004(i) y2005(i) y2006(i) y2007(i) y2008(i) y2009(i) y2010(i) y2011(i) y2012(i) y2013(i) y2014(i)]';
    end;
end;

yrs=(2000:2014)';
AvgTax=meannan(TaxShare(yrs-1989,:))';

% pwt
gdp=rgdpo;
ypc=div(rgdpo,pop);       % per capita  
y=div(ypc,ypc(:,USA)); % US=100
y=y(2011-1949,:)';
disp ' ';

figure(2); figsetup;
ctys=[USA GBR FRA SWE JPN NOR HKG ZAF MEX IND KEN THA VNM BWA BRA ARG ZWE]';
namethese=zeros(length(y),1);
namethese(ctys)=1;
labs=strmat('1/256#1/128# 1/64 # 1/32 # 1/16 #  1/8  #  1/4  #  1/2  #   1   #   2   ','#');
plotnamesym2(log(y),AvgTax,namesSTR,10,[],.7,5,namethese);
set(gca,'XTick',log(str2num(labs)))
set(gca,'XTickLabel',labs);
%ax=axis; ax(4)=log(1.5); axis(ax);
hold on;
%gg=[log(1/256) log(1.5)];
%plot(gg,gg,'b-','LineWidth',1);
chadfig2('GDP per person (US=1) in 2011','percent of GDP',1,0);
makefigwide;
print TaxShareWorld.eps







