% USgrowthPeak2Peak
%
%  Use NBER dates to show peak to peak growth in per capita gdp


if exist('USgrowthPeak2Peak.log'); delete('USgrowthPeak2Peak.log'); end;
diary USgrowthPeak2Peak.log;
fprintf(['USgrowthPeak2Peak                 ' date]);
disp ' ';
disp ' ';
help USgrowthPeak2Peak

clear;
nberdates;  % start = 2007.9 for example -- just round down
load uspcgdp;

yrT=2007

y=newgdp;
peakdates=floor(start);
peakdates=trimr(peakdates,4,0);  % Pre 1870 dates

TT=length(peakdates);

periods=[peakdates(1:TT) [peakdates(2:TT); yrT]];
gr=growthrate(y,periods-1869);


fmt='%6.0f %6.0f %8.2f';
tle='Period . Growth';
cshow(' ',[periods gr*100],fmt,tle);

disp ' '; disp ' ';
disp 'Other Dates';

other=[1870 yrT;
       1870 1929;
       1929 yrT;
       1870 1950;
       1900 1950;
       1950 yrT;
       1950 1973;
       1973 yrT;
       1973 1990;
       1990 yrT;
       1973 2003;
       1973 1981;
       1979 2003;
       1973 1995;
       1995 2007;
       1995 2001;
       2001 2007;
       2003 yrT;
       1870 1960;
       1880 1960;
       1890 1960;
       1900 1960;
       1960 2007;
      ];

gr=growthrate(y,other-1869);
cshow(' ',[other gr*100],fmt,tle);

fmt='%6.0f %6.0f %8.2f %8.2f';
[gr,se]=growthrate2(y,other-1869);
cshow(' ',[other gr*100 se*100],fmt,tle);


disp ' '; disp ' ';
disp 'Growth rates as Slope of time trend';
disp '  (tighter standard errors)';
disp ' ';
[gr,se]=growthrate3(y,other-1869);
cshow(' ',[other gr*100 se*100],fmt,tle);



diary off;
