% World Income Dist  -- taken from Book/SecondEdition/Ch1  (GrowthBook)
%   Revsied 4/12/05
%
%   4/27/07:  Plot cumulative distn instead of pdf!
%
%   1/31/10:  pwt63
%   3/7/15 :  pwt80

diarychad('WorldDistribution'); 

clear;
%load /home/chad/Work/Data/PWT71/pwt71
load pwt80
load regions80

%wkrs=rgdpch./rgdpw.*pop;
%gdpw=rgdpw;
%pcgdp=rgdpch;

definecolors;

gdp=rgdpo;
pcgdp=div(rgdpo,pop);       % per capita  

t0=1949;

yrs=[1960 2011];
y=pcgdp(yrs-t0,:)';
yUS=y(USA,:);
N=pop(yrs-t0,:)';
blah=y(:,1).*y(:,2).*N(:,1).*N(:,2);
smpl=~isnan(blah) & ~outliersAfter1980;
NN=sum(smpl)

y=y(smpl,:);
N=N(smpl,:);
[ys1 indx1]=sort(y(:,1));
Ns1=N(indx1,1);
NTot1=sum(Ns1);

%ys1=ys1/yUS(2);    % Percent of U.S. in 2011!!!
ys1=ys1/365;    % Dollars per day
Ns1=Ns1/NTot1;
CumNs1=cumsum(Ns1);

[ys2 indx2]=sort(y(:,2));
Ns2=N(indx2,2);
NTot2=sum(Ns2);
%ys2=ys2/yUS(2);    % Percent of U.S. in 2011!!!
ys2=ys2/365;    % Dollars per day
Ns2=Ns2/NTot2;
CumNs2=cumsum(Ns2);


figure(1); figsetup;
plot(log(ys1),CumNs1,'-','Color',mygreen,'LineWidth',4);
hold on;
plot(log(ys2),CumNs2,'-','Color',myblue,'LineWidth',4);
set(gca,'YTick',[.2:.2:1]);
set(gca,'YTickLabel',strmat('20 40 60 80 100'));
%set(gca,'XTick',log([1/128 1/64 1/32 1/16 1/8 1/4 1/2 1]));
%set(gca,'XTickLabel',strmat('1/128#1/64#1/32#1/16# 1/8 # 1/4 # 1/2 #   1  ','#'));
set(gca,'XTick',log([1 2 4 8 16 32 64 128 256 512]));
set(gca,'XTickLabel',strmat(' 1 # 2 # 4 # 8 # 16# 32# 64#128#256#512','#'));
%ax=axis; ax(1)=log(1/200); ax(4)=1.02; axis(ax);
ax=axis; ax(1)=log(.77); ax(4)=1.02; axis(ax);

xlab='Daily income per person';
ylab='Share of world population (percent)';
text(log(70),.78,'2011');
text(log(8),.85,'1960');
chadfig2(xlab,ylab,1,0);
text(log(12),.30,'India');
text(log(27),.64,'China');
makefigwide;
print WorldDistribution.eps;
size(ys1)

order=(1:size(pop,2));
ctys=order(smpl);
disp '1960';
ctys=ctys(indx1);
cshow(namesSTR(ctys,:),[Ns1 CumNs1 ys1],'%8.3f','Pop CumPop y');
disp ' '; disp ' ';
disp '2011';
ctys=order(smpl);
ctys=ctys(indx2);
cshow(namesSTR(ctys,:),[Ns2 CumNs2 ys2],'%8.3f','Pop CumPop y');


diary off;