% autor.m  9/8/2004  -- Updated 2/10/2015
%
% Data from David Autor on college wage premium and supply
%  See Facts/Data/Autor/*
%
% Skills, Education, and the Rise of Earnings Inequality Among the "Other 99 Percent" 
% David H. Autor
% Science, 23 May 2014: 344 (6186), 843-851.
%
% Science (2014) article, figure 3
% http://www.sciencemag.org/content/344/6186/843.full.pdf
%
% Data Archive
% http://economics.mit.edu/faculty/dautor/data/autor-14
%
%
% Note: The wage data are available directly in the file  fig-km-plot.log
% But I had to rerun fig3achad.do and give it a "list" command to get the
% supply numbers. Run on yen/Autor/ using stata there. Easy!
%
% The Data:
%
% . list clg_sh_all -- this is the share of hours worked *100
% . list year exp_clphsg_all exp_gap_quadratic;  exp_clphsg_all is the
% wage premium
%
%  2004: Chad note:  the relative supply measure is in "efficiency units".  See the data appendix. 
%    That is, there is an adjustment for the relative wage in adding up the hours worked
%    by college and highschool workers.


diarychad('autor2015');
definecolors;

% $$$ From: David Autor <dautor@mit.edu>	Mailed-By: mit.edu
% $$$ Reply-To: dautor@mit.edu
% $$$ To: Chad Jones <chad@econ.berkeley.edu>
% $$$ Date: Sep 29, 2004 8:36 PM
% $$$ Subject: RE: Lcoll / Lhs
% $$$ 
% $$$ Dear Chad,
% $$$ 
% $$$ The end of the month approaches, and so I have done the promised
% $$$ calculations. Here is the share of hours worked by college equivalents
% $$$ (college-plus + 1/2 of some college) overall and by gender from 1963 to
% $$$ 2002:
% $$$ 
% $$$ I hope that answers the query.
% $$$ 
% $$$ Best,
% $$$ 
% $$$ - David


% Year  WagePremium   CollShare
%-------------------------------
data=[
 1963   47.36552       18.4556
 1964   50.70834      19.06469
 1965   52.29047      19.33143
 1966   51.23235       19.9714
 1967   55.99303      20.76256
 1968    57.1955      21.06579
 1969   56.21484      21.83714
 1970   55.06253      23.14588
 1971   58.99775      23.75302
 1972   56.93801      24.76233
 1973   57.24273      25.77997
 1974   54.21219      27.13618
 1975    53.2226      28.84653
 1976    52.7319      29.42709
 1977   50.31841      29.86903
 1978   46.87915      30.80903
 1979   48.32542      31.39199
 1980   49.36456      32.04375
 1981   47.62582      32.91262
 1982    51.3962      35.04922
 1983   56.52249      35.50609
 1984   58.44057      35.81092
 1985   61.49051      36.31089
 1986   63.06059      36.79288
 1987   62.94626       36.8769
 1988   65.50692      37.92279
 1989   69.95631      38.19014
 1990   70.16536      38.43137
 1991   74.18776      39.27567
 1992   74.31613      40.70573
 1993   78.85191      41.42678
 1994   79.87336      42.21188
 1995   80.25054      42.15663
 1996    79.2226      42.16347
 1997   80.13094      42.67762
 1998   83.14601      43.20901
 1999    88.5294      43.75942
 2000     87.656      44.10649
 2001   89.97824      44.68804
 2002   90.57852      45.21684
 2003   86.47313      45.64785
 2004     89.195      45.44754
 2005   93.41473      45.91333
 2006   93.08253      46.52637
 2007    92.6243      47.69875
 2008   96.22548       48.2436
 2009   94.68098      49.07869
 2010   96.03049      50.32943
 2011   97.60943      50.57298
 2012   95.76183      51.24923
];


yrs=data(:,1);
w=data(:,2);
%w=exp(logw);
frac=data(:,3);
L=frac;
logL=log(frac);
LW=4;

% Now show the individual plots in levels
figure(1); figsetup; makefigwide;
%plotlog(yrs,[w L],'-','0.4 0.8 1.2 1.6 2.0');
%ax=plotyy(yrs,logL,yrs,logw);
[ax,h1,h2]=plotyy(yrs,L,yrs,w);
darkfactor=.8;
set(h1,'LineWidth',LW,'Color',myblue);
set(h2,'LineWidth',LW,'Color',mygreen);
set(ax(1),'ycolor',myblue*darkfactor);
set(ax(2),'ycolor',mygreen*darkfactor);


a1=axis(ax(1)); a1(3)=-3; a1(2)=2014; axis(ax(1),a1);
a2=axis(ax(2)); a2(3)=37; a2(2)=2014; axis(ax(2),a2);
%lab2=strmat('1.2 1.4 1.6 1.8 2.0 2.2 2.4');
%lab1=strmat('0.2 0.3 0.4 0.5');
lab=strmat('1960 1970 1980 1990 2000 2010');
set(ax(2),'XLim',[1960 2014]);
set(ax(1),'XLim',[1960 2014]);
set(ax(2),'XTick',str2num(lab));
set(ax(2),'XTickLabel',lab);
set(ax(1),'XTick',str2num(lab));
set(ax(1),'XTickLabel',lab);
str=mlstring('Fraction of hours worked\\ by college-educated workers\\         (left scale)');
text(1967,41,str);
str=mlstring('College wage premium\\   (right scale)');
text(1991,27,str);
set(ax(1),'Box','off');
set(ax(2),'Box','off');
chadfig2(' ','Percent',1,0);
chadfigyy(ax(2),'Percent');
%print -depsc autor.eps;
print autor.eps;

disp ' ';
disp 'Data for the College vs. High School Figure';
cshow(' ',[yrs w L],'%6.0f %8.3f','Years wC/wH LC/Ltotal');

diary off;