% capitalshare  2/12/15
%
%  Capital shares for the US from PikettyZucman (2014 QJE) and
%  Karabarbounis-Neiman (2014 QJE).
%   -- See Data/USA-CapitalShare.xls
%
%  The BLS number is from the Data/mfp_tables_historical2015.xls 
%  and applies to the private business sector.


diarychad('capitalshare')

data=[
%		Karabarbounis	
%	PikettyZucman	Neiman	BLS
%       PZ      KN          BLSMFP
1929	29.01	NaN	    NaN
1930	26.19	NaN	    NaN
1931	21.48	NaN	    NaN
1932	16.57	NaN	    NaN
1933	15.12	NaN	    NaN
1934	19.56	NaN	    NaN
1935	20.97	NaN	    NaN
1936	22.70	NaN	    NaN
1937	22.04	NaN	    NaN
1938	20.17	NaN	    NaN
1939	22.06	NaN	    NaN
1940	24.97	NaN	    NaN
1941	27.10	NaN	    NaN
1942	27.22	NaN	    NaN
1943	25.88	NaN	    NaN
1944	24.74	NaN	    NaN
1945	22.47	NaN	    NaN
1946	21.13	NaN	    NaN
1947	23.03	NaN	    NaN
1948	25.20	NaN	  0.354
1949	24.44	NaN	  0.350
1950	26.31	NaN	  0.363
1951	25.66	NaN	  0.363
1952	23.83	NaN	  0.349
1953	22.93	NaN	  0.335
1954	23.19	NaN	  0.336
1955	25.31	NaN	  0.355
1956	23.77	NaN	  0.341
1957	23.19	NaN	  0.339
1958	22.08	NaN	  0.340
1959	23.99	NaN	  0.348
1960	23.39	NaN	  0.339
1961	23.45	NaN	  0.341
1962	24.34	NaN	  0.346
1963	24.81	NaN	  0.353
1964	25.20	NaN	  0.352
1965	25.93	NaN	  0.359
1966	25.40	NaN	  0.354
1967	24.20	NaN	  0.347
1968	23.52	NaN	  0.345
1969	22.08	NaN	  0.333
1970	20.22	NaN	  0.321
1971	20.98	NaN	  0.331
1972	21.25	NaN	  0.337
1973	20.94	NaN	  0.335
1974	19.72	NaN	  0.325
1975	21.06	37.08	  0.346
1976	21.43	37.23	  0.346
1977	22.17	37.41	  0.347
1978	22.24	37.14	  0.342
1979	21.52	35.82	  0.333
1980	20.78	35.28	  0.326
1981	22.41	36.93	  0.341
1982	22.51	36.84	  0.342
1983	24.06	37.73	  0.345
1984	25.44	38.36	  0.356
1985	25.05	37.99	  0.351
1986	23.90	36.46	  0.339
1987	24.58	36.35	  0.346
1988	25.04	36.46	  0.338
1989	25.20	36.34	  0.347
1990	24.84	35.73	  0.344
1991	24.75	36.09	  0.338
1992	24.52	35.46	  0.336
1993	24.82	35.94	  0.339
1994	25.71	37.22	  0.342
1995	26.75	37.82	  0.341
1996	27.55	38.21	  0.347
1997	27.83	38.36	  0.344
1998	26.59	37.16	  0.325
1999	25.85	36.65	  0.327
2000	24.50	35.62	  0.317
2001	23.68	35.50	  0.318
2002	23.48	37.11	  0.326
2003	23.38	38.24	  0.341
2004	24.79	39.13	  0.351
2005	26.33	40.61	  0.366
2006	27.12	41.65	  0.366
2007	25.99	40.25	  0.367
2008	24.21	38.97	  0.369
2009	25.75	41.09	  0.371
2010	28.56	42.76	  0.385
2011	NaN	42.65	  0.380
2012	NaN	42.76	  0.387
2013	NaN	NaN	   NaN
2014	NaN	NaN	   NaN
];

yrs=data(:,1);
pz=data(:,2);
kn=data(:,3);
bls=data(:,4)*100;
mpz=mean(pz((1929:1980)-1928))
mkn=mean(kn((1975:2000)-1928))
mbls=mean(bls((1948:2000)-1928))

LW=4;
myblue=[        0    0.4470    0.7410];
mygreen=[    0.4660    0.64    0.1880];
myred=[    0.8500    0.3250    0.0980];
mygrey=[210 210 210]/255;


%h2a.Color(4)=0.3;   %70 transparent


figure(1); figsetup; 
%plot(yrs,20*ones(length(yrs)),'-','Color',mygrey,'LineWidth',2);
plot(yrs,30*ones(length(yrs)),'-','Color',mygrey,'LineWidth',2);
plot(yrs,40*ones(length(yrs)),'-','Color',mygrey,'LineWidth',2);
%h=plot(yrs,mbls*ones(length(yrs)),'-','Color',mygrey,'LineWidth',2);
plot(yrs,bls,'-','Color',myblue,'LineWidth',LW);
%h=plot(yrs,mkn*ones(length(yrs)),'-','Color',mygrey,'LineWidth',2);
plot(yrs,kn,'-','Color',mygreen,'LineWidth',LW); 
ax=axis; ax(1)=1945; ax(2)=2015; ax(3)=0; ax(4)=50; axis(ax);
nums=(0:10:50)';
relabelaxis(nums,num2str(nums),'y');
chadfig2('Year','Percent',1,0);
makefigwide;
%text(1975,15,'Piketty and Zucman (2014)');
text(1965,28,'Bureau of Labor Statistics');
text(1970,45,'Karabarbounis and Neiman (2014)');
set(gca,'Layer','top');
print capitalshare.eps


figure(1); figsetup; 
%plot(yrs,20*ones(length(yrs)),'-','Color',mygrey,'LineWidth',2);
plot(yrs,30*ones(length(yrs)),'-','Color',mygrey,'LineWidth',2);
plot(yrs,40*ones(length(yrs)),'-','Color',mygrey,'LineWidth',2);
plot(yrs,60*ones(length(yrs)),'-','Color',mygrey,'LineWidth',2);
plot(yrs,70*ones(length(yrs)),'-','Color',mygrey,'LineWidth',2);
%h=plot(yrs,mbls*ones(length(yrs)),'-','Color',mygrey,'LineWidth',2);
plot(yrs,bls,'-','Color',myblue,'LineWidth',LW);
plot(yrs,100-bls,'-','Color',myblue,'LineWidth',LW);
%h=plot(yrs,mkn*ones(length(yrs)),'-','Color',mygrey,'LineWidth',2);
plot(yrs,kn,'-','Color',mygreen,'LineWidth',LW); 
plot(yrs,100-kn,'-','Color',mygreen,'LineWidth',LW); 
ax=axis; ax(1)=1945; ax(2)=2015; ax(3)=20; ax(4)=80; axis(ax);
nums=(20:10:80)';
relabelaxis(nums,num2str(nums),'y');
chadfig2('Year','Percent',1,0);
makefigwide;
%text(1975,15,'Piketty and Zucman (2014)');
%text(1962,72.5,'Bureau of Labor Statistics');
%text(1980,48,'Karabarbounis and Neiman (2014)');
text(1955,72.5,'Labor share');
text(1958,42.5,'Capital share');
set(gca,'Layer','top');
print capitalshare2.eps


diary off;


