% equipprice   2/12/2015
%
% Relative price of (private) equipment investment to GDP
% See Data/EquipmentPrice.xls  -- graph saved in FRED as EquipPrice

diarychad('equipprice')

data=[
%   Structure  Equipme	IP    Residential
1929	38.77	233.16	159.19	51.95
1930	38.17	232.78	158.50	52.86
1931	38.75	244.84	164.79	53.11
1932	37.96	260.64	169.01	48.87
1933	39.41	257.33	161.57	49.46
1934	37.69	259.19	156.80	52.37
1935	38.67	251.83	156.20	50.61
1936	38.14	248.42	158.03	52.44
1937	41.80	253.34	158.36	55.53
1938	41.77	264.27	160.56	58.37
1939	41.84	264.80	163.42	59.49
1940	42.13	269.42	164.47	60.73
1941	42.31	268.91	163.17	62.26
1942	43.58	273.07	167.38	61.74
1943	45.22	262.03	176.48	63.77
1944	45.14	260.86	187.24	68.32
1945	45.98	258.74	187.67	71.15
1946	45.76	251.63	175.60	68.63
1947	49.88	256.34	173.39	73.92
1948	52.54	260.20	172.66	75.87
1949	52.38	270.69	173.06	76.91
1950	52.55	275.00	175.51	78.10
1951	54.90	279.48	174.51	78.40
1952	55.15	279.01	172.93	78.83
1953	55.51	276.04	173.71	78.38
1954	54.28	279.77	173.06	77.90
1955	54.59	278.51	174.98	78.40
1956	57.28	289.29	175.50	77.72
1957	57.73	295.26	174.97	75.30
1958	55.51	294.19	175.14	73.41
1959	55.08	295.64	175.65	72.66
1960	54.26	294.07	175.90	72.16
1961	53.35	289.28	175.11	71.48
1962	53.12	284.41	173.82	70.72
1963	52.97	279.78	172.11	69.39
1964	52.91	275.41	172.12	68.87
1965	53.47	270.81	170.21	69.53
1966	53.88	264.25	168.07	70.08
1967	53.99	262.66	165.82	70.45
1968	54.39	258.87	164.61	71.15
1969	55.25	253.71	163.81	72.58
1970	55.93	250.01	163.01	71.16
1971	57.33	245.45	160.81	71.64
1972	58.90	238.35	158.73	72.84
1973	60.19	229.88	158.00	75.22
1974	62.88	226.81	158.55	76.17
1975	64.41	239.15	156.72	76.14
1976	64.05	240.62	155.13	76.86
1977	65.55	240.52	152.50	79.76
1978	67.16	237.23	149.92	83.69
1979	69.25	233.31	147.69	86.04
1980	69.41	232.79	145.90	87.41
1981	72.17	228.38	143.32	86.37
1982	73.39	224.14	142.76	85.77
1983	68.82	216.27	142.48	84.48
1984	67.03	207.14	141.45	84.00
1985	66.50	200.72	139.34	83.63
1986	66.43	200.69	137.64	85.58
1987	65.88	197.17	136.76	87.15
1988	66.35	193.13	136.24	87.13
1989	66.37	189.45	132.80	86.61
1990	66.06	186.40	129.35	85.43
1991	65.10	183.48	128.16	83.77
1992	63.66	179.12	123.83	82.91
1993	64.01	172.90	121.78	84.28
1994	64.89	169.01	119.73	85.51
1995	66.31	163.74	120.57	86.76
1996	66.78	157.16	118.82	87.03
1997	68.16	150.24	117.46	87.62
1998	70.51	141.96	115.69	88.97
1999	71.66	134.55	116.25	91.00
2000	72.82	128.69	117.39	92.92
2001	74.94	122.12	115.11	95.16
2002	76.91	117.88	112.19	96.05
2003	78.14	113.59	109.75	98.63
2004	81.78	110.37	106.72	102.72
2005	89.21	107.23	104.35	106.65
2006	97.08	103.70	102.84	109.50
2007	100.29	101.30	101.89	108.05
2008	103.06	99.47	101.62	104.46
2009	100.00	100.00	100.00	100.00
2010	97.65	96.82	99.32	98.44
2011	98.58	95.69	98.61	97.17
2012	100.28	94.92	97.80	96.36
2013	101.57	93.93	97.15	99.73
2014	102.66	93.15	96.81	104.00
];
%   Structure  Equipme	IP    Residential

definecolors;                                          

yrs=data(:,1);
pstruc=data(:,2);
peq=data(:,3);
pres=data(:,5);

figure(1); figsetup;
plot(yrs,log(pres),'-','Color',myred,'LineWidth',4);
plot(yrs,log(pstruc),'-','Color',mygreen,'LineWidth',4);
plot(yrs,log(peq),'-','Color',myblue,'LineWidth',4);
axlabel=strmat('50 100 150 200 250 300');
relabelaxis(log(str2num(axlabel)),axlabel,'y');
ax=axis; ax(1)=1925; ax(2)=2015; ax(4)=log(320); axis(ax);
chadfig2('Year','Index (2009 value = 100, log scale)',1,0);
%set(gca,'YGrid','on')
makefigwide;
text(1990,log(210),'Equipment');
text(1970,log(100),'Residential');
text(1980,log(55),'Non-residential structures');
print equipprice.eps


diary off;
