% goldinkatz
%
%  Draw the 2 GK figures for our paper.  Both are in Goldin and Katz 2007 BPEA.
%
%  Wage premiums = Figure 6  -- data in Appendix D of their Race book, Table D1
%  Ed Att by birth cohort = Figure 7  -- data emailed from Katz??


if exist('goldinkatz.log'); delete('goldinkatz.log'); end;
diary goldinkatz.log;
fprintf(['goldinkatz                 ' date]);
disp ' ';
disp ' ';
help goldinkatz

%startup;
mygreen=[0 .6 .4];

clrs=[
        0    0.4470    0.7410
    0.8500    0.3250    0.0980
    0.9290    0.6940    0.1250
    0.4940    0.1840    0.5560
    0.4660    0.6740    0.1880
    0.3010    0.7450    0.9330
    0.6350    0.0780    0.1840
];

% Wage premium data  -- log differences 1915=Iowa, others = census
data=[% Year  College    HS/dropout
    1915 .638 .243*242/185
    1940 .498 .242
    1950 .313 .149
    1960 .396 .159
    1970 .465 .167
    1980 .391 .179
    1990 .549 .213
    2000 .607 .255
      ];

wcol=exp(data(:,2));
whs=exp(data(:,3));
yrs=data(:,1);

figure(1); figsetup;
plot(yrs,wcol,'-');
hold on;
plot(yrs,whs,'-','Color',mygreen);
chadfig('Year','Wage ratio',1,0);
text(1937,1.75,'College grads to High school grads','Color','b');
text(1947,1.26,'High school grads to dropouts','Color',mygreen);
%set(gca,'YGrid','on')
makefigwide
print goldinkatz1.eps

                                             
%Figure 7: Years of Schooling by Birth Cohort, U.S. Born
%1876 to 1980 Birth Cohorts, 1940-2000 Census IPUMS, 2005 CPS MORG
%Normalized to Age 30; Brookings

data=[
%             Sch Yrs
     1876   7.299824
     1877   7.485543
     1878   7.532481
     1879   7.724184
     1880   7.408234
     1881   7.571872
     1882   7.588793
     1883   7.685691
     1884   7.703062
     1885   7.684282
     1886   7.777152
     1887   7.818285
     1888   7.887937
     1889   8.024898
     1890   7.928769
     1891   8.087016
     1892   8.082022
     1893   8.278461
     1894    8.37764
     1895   8.367172
     1896   8.482187
     1897   8.531677
     1898   8.583932
     1899   8.778252
     1900   8.490784
     1901   8.670907
     1902   8.783048
     1903   8.971072
     1904   9.001726
     1905   9.082109
     1906   9.255662
     1907    9.48364
     1908   9.519979
     1909   9.744022
     1910   9.529063
     1911   9.737823
     1912   9.791346
     1913   9.951436
     1914   9.998403
     1915   10.06334
     1916   10.11017
     1917   10.31065
     1918       10.3
     1919   10.48309
     1920   10.37391
     1921   10.60382
     1922   10.72419
     1923   10.76775
     1924   10.89817
     1925   10.89547
     1926   10.91322
     1927   11.01737
     1928    10.9848
     1929   11.10345
     1930    11.2032
     1931   11.37483
     1932   11.45547
     1933   11.50788
     1934   11.56767
     1935   11.61558
     1936   11.68111
     1937   11.80539
     1938   11.89304
     1939   12.00426
     1940   12.01014
     1941   12.18727
     1942   12.32625
     1943   12.47928
     1944   12.48872
     1945   12.62273
     1946   12.85965
     1947   13.03035
     1948   13.07057
     1949    13.1316
     1950    13.1566
     1951   13.22445
     1952   13.21909
     1953   13.21257
     1954   13.23451
     1955   13.25896
     1956   13.32479
     1957   13.28146
     1958   13.32571
     1959   13.33261
     1960   13.33235
     1961   13.38051
     1962   13.39652
     1963   13.42405
     1964   13.48527
     1965   13.46362
     1966   13.45676
     1967   13.53664
     1968   13.59707
     1969   13.68218
     1970   13.71873
     1971   13.78106
     1972   13.81025
     1973   13.79087
     1974   13.89233
     1975   13.91564
     1976   14.00161
     1977   13.90365
     1978   13.91001
     1979   13.87868
     1980    13.9268
];
%Figure 7: Years of Schooling by Birth Cohort, U.S. Born
%1876 to 1980 Birth Cohorts, 1940-2000 Census IPUMS, 2005 CPS MORG
%Normalized to Age 30; Brookings

yrs=data(:,1);
edbirth=data(:,2);

% Average educational attainment, CPS data
% See Data/EdAttainment2015.xls
data2=[    
2014	13.47
2013	13.46
2012	13.40
2011	13.38
2010	13.34
2009	13.31
2008	13.30
2007	13.24
2006	13.20
2005	13.17
2004	13.18
2003	13.13
2002	13.10
2001	13.09
2000	13.06
1999	12.97
1998	12.96
1997	12.91
1996	12.89
1995	12.86
1994	12.79
1993	12.72
1992	12.66
1991	12.54
1990	12.49
1989	12.45
1988	12.40
1987	12.36
1986	12.30
1985	12.26
1984	12.21
1983	12.15
1982	12.06
1981	11.98
1980	11.94
1979	11.87
1978	11.77
1977	11.71
1976	11.64
1975	11.53
1974	11.44
1973	11.35
1972	11.27
1971	11.14
1970	11.07
1969	10.99
1968	10.92
1967	10.84
1966	10.76
1965	10.69
1964	10.63
1962	10.52
1960	10.27
1959	10.18
1957	10.01
1952	9.95
1950	9.48
1947	9.52
1940	8.98
];

yrsE=data2(:,1);
edatt=data2(:,2);
definecolors;

figure(2); figsetup;
plot(yrs,edbirth,'-','Color',clrs(1,:),'LineWidth',4);
plot(yrsE,edatt,'-','Color',mygreen,'LineWidth',4);
ax=axis; ax(1)=1872; ax(4)=15.1; ax(2)=2015; axis(ax);
chadfig2('Year','Years of Schooling',1,0);
%set(gca,'YGrid','on')
makefigwide;
text(1975,11,'Adult labor force');
text(1910,14,'By birth cohort');
print goldinkatz.eps


diary off;
