% patents
%    Creates the Patents figure
%  Patent grants by the USPTO
%
%   2/24/15 -- Updated using USPTO data
%    See Data/patents-uspto.xls
%    From http://www.uspto.gov/web/offices/ac/ido/oeip/taf/h_counts.htm 
%    http://www.uspto.gov/web/offices/ac/ido/oeip/taf/us_stat.htm

diarychad('patents');
clear;
definecolors;

% get the data

% From http://www.uspto.gov/web/offices/ac/ido/oeip/taf/h_counts.htm 
pats=[  %Total      US
1900	26414	22931
1901	27288	23886
1902	27761	24262
1903	31568	27805
1904	30816	27531
1905	30263	26971
1906	31794	28323
1907	36449	32583
1908	33493	30155
1909	37249	33437
1910	35769	32050
1911	33865	29807
1912	37538	33049
1913	35598	31386
1914	41614	37019
1915	44662	40328
1916	45651	41884
1917	42439	39230
1918	39657	36774
1919	38318	34631
1920	39542	35780
1921	41069	37106
1922	39988	35533
1923	40541	36408
1924	45243	40520
1925	49256	43909
1926	47335	42232
1927	44105	39187
1928	45514	40296
1929	48174	42253
1930	47938	41853
1931	54698	47801
1932	56448	49072
1933	51218	44048
1934	47372	40883
1935	44529	38549
1936	44388	38654
1937	42875	37237
1938	43130	37354
1939	48711	42373
1940	48467	42319
1941	47656	42345
1942	42242	38299
1943	33330	30705
1944	31007	28443
1945	29235	27123
1946	24640	22984
1947	22293	20676
1948	27973	25989
1949	39675	36570
1950	47847	43439
1951	48548	43660
1952	46676	41041
1953	43259	38928
1954	36446	32013
1955	33248	29183
1956	49894	43248
1957	45236	38954
1958	50835	43440
1959	55278	46938
1960	49828	42130
1961	50964	42750
1962	58082	47970
1963	48773	40268
1964	50189	41223
1965	66401	53876
1966	71707	57699
1967	68902	54191
1968	62528	48806
1969	70997	53424
1970	67695	49823
1971	81544	58694
1972	77910	54095
1973	78308	54964
1974	80843	54329
1975	76432	40161
1976	74966	47832
1977	69371	44687
1978	70150	44435
1979	52104	32642
1980	65885	40493
1981	70699	42942
1982	63005	37471
1983	61620	36286
1984	72350	41962
1985	76969	43173
1986	76602	41822
1987	89140	47552
1988	84028	44403
1989	102216	54412
1990	98707	52613
1991	106433	57489
1992	107034	58462
1993	109414	60883
1994	113270	64046
1995	113518	64191
1996	121417	69150
1997	123792	69685
1998	162844	90446
1999	168637	93760
2000	175455	96584
2001	183490	98317
2002	183915	96814
2003	186591	98333
2004	181001	93950
2005	157473	82427
2006	195886	101944
2007	182391	93384
2008	184577	91648
2009	191474	94797
2010	243394	120700
2011	246684	120686
2012	275966	133786
2013	302150	147259
];



lastyear=pats(end,1)

figure(1); figsetup;
yr0=1899;
yrs=(1900:lastyear)';
plot(yrs,pats(yrs-yr0,3)/1000,'-','Color',mygreen,'LineWidth',4);
plot(yrs,pats(yrs-yr0,2)/1000,'-','Color',myblue,'LineWidth',4);
%axis([yrs(1) 2000 0 100000]);
%set(gca,'YTick',[0 25000 50000 75000 100000 125000 150]);
%set(gca,'YTickLabels',[0 25000 50000 75000 100000]);
text(1910,270,'Total in 2013: 302,000');
text(1910,250,'   U.S. origin: 147,000');
text(1910,230,sprintf('   Foreign share: %2.0f%%',(1-147259/302150)*100));
text(1990,180,'Total'); %,'Color','b');
text(1998,45,'U.S. origin'); %,'Color',mygreen);
ax=axis; ax(2)=2015; ax(4)=305; axis(ax);
chadfig2('Year','Thousands',1,0);
makefigwide;
print patents.eps

diary off;