% patents
%    Creates the Patents figure
%  Patent grants by the USPTO
%
%   2/24/15 -- Updated since 1963 using USPTO data
%    See Data/patents-uspto.xls
%    http://www.uspto.gov/web/offices/ac/ido/oeip/taf/us_stat.htm

diarychad('patents');
clear;
definecolors;

% get the data

% First numbers from Growth book, Ch4 patents.m
pats=[  %Total      US
1870	12137	   11493;
1871	11659	   11137;
1872	12180	   11599;
1873	11616	   11123;
1874	12230	   11683;
1875	13291	   12728;
1876	14169	   13382;
1877	12920	   12330;
1878	12345	   11764;
1879	12125	   11477;
1880	12903	   12117;
1881	15500	   14505;
1882	18091	   16956;
1883	21162	   19903;
1884	19118	   17834;
1885	23285	   21736;
1886	21767	   20278;
1887	20403	   18937;
1888	19551	   18015;
1889	23324	   21321;
1890	25313	   23208;
1891	22312	   20384;
1892	22647	   20596;
1893	22750	   20277;
1894	19855	   17689;
1895	20856	   18807;
1896	21822	   19795;
1897	22067	   19846;
1898	20377	   17625;
1899	23278	   20967;
1900	24644	   21161;
1901	25546	   22144;
1902	27119	   23620;
1903	31029	   27266;
1904	30258	   26973;
1905	29775	   26483;
1906	31170	   27699;
1907	35859	   31973;
1908	32735	   29397;
1909	36561	   32749;
1910	35141	   31422;
1911	32856	   28798;
1912	36198	   31709;
1913	33917	   29705;
1914	39892	   35297;
1915	43118	   38784;
1916	43892	   40125;
1917	40935	   37726;
1918	38452	   35569;
1919	36797	   33110;
1920	37060	   33298;
1921	37798	   33835;
1922	38369	   33914;
1923	38616	   34483;
1924	42574	   37851;
1925	46432	   41085;
1926	44733	   39630;
1927	41717	   36799;
1928	42357	   37139;
1929	45267	   39346;
1930	45226	   39141;
1931	51756	   44859;
1932	53458	   46082;
1933	48774	   41604;
1934	44420	   37931;
1935	40618	   34638;
1936	39782	   34048;
1937	37683	   32045;
1938	38061	   32285;
1939	43073	   36735;
1940	42238	   36090;
1941	41109	   35798;
1942	38449	   34506;
1943	31054	   28429;
1944	28053	   25489;
1945	25695	   23583;
1946	21803	   20147;
1947	20139	   18522;
1948	23963	   21979;
1949	35131	   32026;
1950	43040	   38632;
1951	44326	   39438;
1952	43616	   37981;
1953	40468	   36137;
1954	33809	   29376;
1955	30432	   26367;
1956	46817	   40171;
1957	42744	   36462;
1958	48330	   40935;
1959	52408	   44068;
1960	47170	   39320;
1961	48368	   39984;
1962	55691		45436;
% 1963	45679	   36943;
% 1964	47376	   38208;
% 1965	62857		50075;
% 1966	68406		54398;
% 1967	65652		50941;
% 1968	59102		45380;
% 1969	67557		49984;
% 1970	64429		47077;
% 1971	78317		55984;
% 1972	74810		51524;
% 1973	74143		51500;
% 1974	76278		50641;
% 1975	72000		46715;
% 1976	70226		44280;
% 1977	65269		41485;
% 1978	66097		41250;
% 1979	48849		30076;
% 1980	61810		37351;
% 1981	65766		39221;
% 1982	57881		33891;
% 1983	56855		32867;
% 1984	67189		38358;
% %1985	71649		39550;
% %1986	70790		38088;
% %1987	82863		43465;
% %1988	77809		40415;
% %1989	95321		50063;
% %1990	90158		47283;
% %1991	96047		50895;
% % These numbers are from patents.xls (NSF SciEng 2008)
% 1985	71661	39556
% 1986	70860	38126
% 1987	82952	43520
% 1988	77924	40497
% 1989	95537	50185
% 1990	90365	47391
% 1991	96511	51177
% 1992	97444	52253
% 1993	98342	53231
% 1994	101676	56066
% 1995	101419	55739
% 1996	109645	61104
% 1997	111984	61708
% 1998	147518	80289
% 1999	153485	83905
% 2000	157494	85068
% 2001	166036	87600
% 2002	167331	86971
% 2003	169023	87893
% 2004	164291	84271
% 2005	143806	74637
% 2006    173772	89823	% NSF SciEng 2010 Appendix Table 6-57
% 2007    157282	79526	
% 2008    157772  77501
1963	45679	37174   % From Data/patents-uspto.xls
1964	47375	38410
1965	62857	50331
1966	68405	54634
1967	65652	51273
1968	59104	45781
1969	67559	50394
1970	64429	47072
1971	78317	55976
1972	74810	51518
1973	74143	51500
1974	76278	50645
1975	72000	46715
1976	70226	44280
1977	65269	41484
1978	66102	41255
1979	48854	30078
1980	61819	37355
1981	65771	39223
1982	57888	33896
1983	56860	32871
1984	67200	38367
1985	71661	39555
1986	70860	38126
1987	82952	43520
1988	77924	40497
1989	95537	50185
1990	90365	47391
1991	96511	51177
1992	97444	52253
1993	98342	53231
1994	101676	56066
1995	101419	55739
1996	109645	61104
1997	111984	61708
1998	147517	80289
1999	153485	83906
2000	157494	85068
2001	166035	87600
2002	167331	86971
2003	169023	87893
2004	164290	84270
2005	143806	74637
2006	173772	89823
2007	157282	79526
2008	157772	77502
2009	167349	82382
2010	219614	107791
2011	224505	108622
2012	253155	121026
2013	277835	133593        
];



lastyear=pats(end,1)

figure(1); figsetup;
yr0=1869;
yrs=(1900:lastyear)';
plot(yrs,pats(yrs-yr0,2)/1000,'-','Color',myblue);
plot(yrs,pats(yrs-yr0,3)/1000,'-','Color',mygreen);
%axis([yrs(1) 2000 0 100000]);
%set(gca,'YTick',[0 25000 50000 75000 100000 125000 150]);
%set(gca,'YTickLabels',[0 25000 50000 75000 100000]);
text(1910,270,'Total in 2013: 278,000');
text(1910,250,'   U.S. Origin: 133,500');
text(1910,230,sprintf('   Foreign share: %2.0f%%',(1-133593/277835)*100));
text(1990,180,'Total'); %,'Color','b');
text(1998,45,'U.S. Origin'); %,'Color',mygreen);
ax=axis; ax(2)=2015; axis(ax);
chadfig2('Year','Thousands',1,0);
makefigwide;
print patents.eps

diary off;