function T=shuffling(P,ergdist,curdist,precsn,maxT);

% Calcates the number of years it takes "curdist" to evolve to within
% "precsn" of "ergdist", given Markov transition matrix P.
%
%  E.g.   ergdist=[.20 .50 .30]'   curdist=[0 0 1]';  precsn=.01
%   ==> find T such that 
%
%        ergdist - P^T*curdist = epsilon
%
%   where abs(epsilon)<precsn element by element.

keepgoing=1; 				% Use to flag when precsn reached
T=1;
PT=P;

while (T<=maxT) & keepgoing;
  e=abs(ergdist)-PT*curdist;
  if all(e<precsn);
    keepgoing=0;
  else;
    T=T+1;
    PT=PT*P;
  end;
end;
