% uspcgdp.m  Updated to 2009
%
%  Per capita GDP graph, combining Maddison (through 1929) and the BEA NIPA
%  data for 1929-2009.  Downloaded USGDPpercapita.xls on 3/8/2005
%   chained 2000 dollars for 1929-2004.

if exist('uspcgdp.log'); delete('uspcgdp.log'); end;
diary uspcgdp.log;
fprintf(['uspcgdp                 ' date]);
disp ' ';
disp ' ';
help uspcgdp


clear all;
stopit=0

% Table 7.1. Selected Per Capita Product and Income Series in Current and Chained Dollars                                                                                                                                                                   
% [Dollars]   2009 Chained Dollars A939RX0
% Annual data from 1929 To 1969
% Annual data from 1969 To 2014
% Bureau of Economic Analysis
% Data published January 30, 2015  
% File created 1/29/2015 4:03:47 PM


BEAdata=[
%	A939RX0	B230RC0
1929	8669	121878
1930	7847	123188
1931	7288	124149
1932	6308	124949
1933	6192	125690
1934	6817	126485
1935	7373	127362
1936	8273	128181
1937	8643	128961
1938	8292	129969
1939	8881	131028
1940	9583	132122
1941	11171	133402
1942	13138	134860
1943	15166	136739
1944	16181	138397
1945	15850	139928
1946	13869	141389
1947	13457	144126
1948	13776	146631
1949	13466	149188
1950	14398	151684
1951	15296	154287
1952	15649	156954
1953	16115	159565
1954	15745	162391
1955	16573	165275
1956	16630	168221
1957	16677	171274
1958	16282	174141
1959	17112	177130
1960	17198	180760
1961	17351	183742
1962	18131	186590
1963	18650	189300
1964	19456	191927
1965	20462	194347
1966	21561	196599
1967	21913	198752
1968	22760	200745
1969	23244	202736
1970	23024	205089
1971	23485	207692
1972	24458	209924
1973	25593	211939
1974	25227	213898
1975	24934	215981
1976	26024	218086
1977	26951	220289
1978	28151	222629
1979	28725	225106
1980	28325	227726
1981	28772	230008
1982	27953	232218
1983	28984	234333
1984	30817	236394
1985	31839	238506
1986	32659	240683
1987	33489	242843
1988	34581	245061
1989	35517	247387
1990	35794	250181
1991	35295	253530
1992	36068	256922
1993	36580	260282
1994	37598	263455
1995	38167	266588
1996	39156	269714
1997	40427	272958
1998	41737	276154
1999	43196	279328
2000	44475	282398
2001	44464	285225
2002	44829	287955
2003	45664	290626
2004	46967	293262
2005	48090	295993
2006	48905	298818
2007	49300	301696
2008	48697	304543
2009	46930	307240
2010	47724	309776
2011	48138	312034
2012	48908	314246
2013	49643	316465
2014	50488	318688
];


% Maddison2008.xls (see ~/Work/Data/Maddison/maddison2008.xls)
maddison=[
1870	40241	2445
1871	41098	2503
1872	42136	2541
1873	43174	2604
1874	44212	2527
1875	45245	2599
1876	46287	2570
1877	47325	2595
1878	48362	2646
1879	49400	2909
1880	50458	3184
1881	51743	3215
1882	53027	3338
1883	54311	3339
1884	55595	3320
1885	56879	3270
1886	58164	3294
1887	59448	3368
1888	60732	3282
1889	62016	3413
1890	63302	3392
1891	64612	3467
1892	65922	3728
1893	67231	3478
1894	68541	3314
1895	69851	3644
1896	71161	3504
1897	72471	3769
1898	73781	3780
1899	75091	4051
1900	76391	4091
1901	77888	4464
1902	79469	4421
1903	80946	4551
1904	82485	4410
1905	84147	4642
1906	85770	5079
1907	87339	5065
1908	89055	4561
1909	90845	5017
1910	92767	4964
1911	94234	5046
1912	95703	5201
1913	97606	5301
1914	99505	4799
1915	100941	4864
1916	102364	5459
1917	103817	5248
1918	104958	5659
1919	105473	5680
1920	106881	5552
1921	108964	5323
1922	110484	5540
1923	112387	6164
1924	114558	6233
1925	116284	6282
1926	117857	6602
1927	119502	6576
1928	120971	6569
1929	122245	6899
1930	123668	6213
1931	124633	5691
1932	125436	4908
1933	126180	4777
1934	126978	5114
1935	127859	5467
1936	128681	6204
1937	129464	6430
1938	130476	6126
1939	131539	6561
1940	132637	7010
1941	133922	8206
1942	135386	9741
1943	137272	11518
1944	138937	12333
1945	140474	11709
1946	141940	9197
1947	144688	8886
1948	147203	9065
1949	149770	8944
1950	152271	9561
1951	154878	10116
1952	157553	10316
1953	160184	10613
1954	163026	10359
1955	165931	10897
1956	168903	10914
1957	171984	10920
1958	174882	10631
1959	177830	11230
1960	180671	11328
1961	183691	11402
1962	186538	11905
1963	189242	12242
1964	191889	12773
1965	194303	13419
1966	196560	14134
1967	198712	14330
1968	200706	14863
1969	202677	15179
1970	205052	15030
1971	207661	15304
1972	209896	15944
1973	211909	16689
1974	213854	16491
1975	215973	16284
1976	218035	16975
1977	220239	17567
1978	222585	18373
1979	225055	18789
1980	227726	18577
1981	229966	18856
1982	232188	18325
1983	234307	18920
1984	236348	20123
1985	238466	20717
1986	240651	21236
1987	242804	21788
1988	245021	22499
1989	247342	23059
1990	250132	23201
1991	253493	22849
1992	256894	23298
1993	260255	23616
1994	263436	24279
1995	266557	24603
1996	269667	25230
1997	272912	26052
1998	276115	26849
1999	279295	27735
2000	282339	28449
2001	285024	28395
2002	287676	28587
2003	290343	29039
2004	293028	29823
2005	295734	30458
2006	298444	31049
];

gdpBEA=BEAdata(:,2);   %1929-2014
popBEA=BEAdata(:,3);   % 
             
gdpMad=maddison(:,3);  %1870-2006
popMad=maddison(:,2);

% Now, let's copy the rest from Work/Data/Maddison/US.m
% uspcgdp.m  3/30/2005  Update of US.m for Macrobook
%
%  In particular use the latest BEA data for 1929 on...
%  and Maddison before that.


yrT=2014
yrs=(1870:yrT)';
yr0=1869;

% Now, let's link the two series together using the 1929 observation
newgdp=zeros(length(yrs),1);
newpop=zeros(length(yrs),1);
convfactor=gdpBEA(1929-1928)/gdpMad(1929-1869)
newgdp((1929:yrT)-1869)=gdpBEA;
newgdp((1870:1929)-1869)=gdpMad((1870:1929)-1869)*convfactor;

convfactor=popBEA(1929-1928)/popMad(1929-1869)
newpop((1929:yrT)-1869)=popBEA;
newpop((1870:1929)-1869)=popMad((1870:1929)-1869)*convfactor;



% Now, let's show the data
data=zeros(length(1870:yrT),2);
data((1929:yrT)-1869,1)=gdpBEA;
data((1870:2006)-1869,2)=gdpMad;
data=[data newgdp newpop];
cshow(' ',[yrs data],'%8.0f','Years BEA Maddison Merged Population');


% Now, compute growth rates from 1929-2006 using both series.
fprintf('Growth rate 1929-2006, Maddison: %8.4f\n',log(gdpMad(2006-1869)/gdpMad(1929-1869))/(2006-1929));
fprintf('Growth rate 1929-2006, BEA:      %8.4f\n',log(gdpBEA(2006-1928)/gdpBEA(1929-1928))/(2006-1929));
fprintf('Growth rate 1929-2006, Merged:   %8.4f\n',log(newgdp(2006-1869)/newgdp(1929-1869))/(2006-1929));
disp ' ';
fprintf('Growth rate 1870-1929, Maddison: %8.4f\n',log(gdpMad(1929-1869)/gdpMad(1870-1869))/(1929-1870));
fprintf('Growth rate 1929-yrT, BEA:      %8.4f\n',log(gdpBEA(yrT-1928)/gdpBEA(1929-1928))/(yrT-1929));
fprintf('Growth rate 1870-1929, Merged:   %8.4f\n',log(newgdp(1929-1869)/newgdp(1870-1869))/(1929-1870));
fprintf('Growth rate 1929-yrT, Merged:   %8.4f\n',log(newgdp(yrT-1869)/newgdp(1929-1869))/(yrT-1929));
fprintf('Growth rate 1950-yrT, Merged:   %8.4f\n',log(newgdp(yrT-1869)/newgdp(1950-1869))/(yrT-1950));
fprintf('Growth rate 1870-yrT, Merged:   %8.4f\n',log(newgdp(yrT-1869)/newgdp(1870-1869))/(yrT-1870));


clrs=[
        0    0.4470    0.7410
    0.8500    0.3250    0.0980
    0.9290    0.6940    0.1250
    0.4940    0.1840    0.5560
    0.4660    0.6740    0.1880
    0.3010    0.7450    0.9330
    0.6350    0.0780    0.1840
];

LW=4


% Now some plots
logYL=log(newgdp);
save uspcgdp;


figure(1); figsetup;
plot(yrs,logYL);
hold on;

% First, let's do the Jones1995 experiment with this new data
% Tricky, bc it is chained after 1929 but fixed weight before...  very weird

% $$$ % regression 1870 to 1929:
% $$$ yr0=1869;
% $$$ yr=(1870:1929)';
% $$$ y=logYL(yr-yr0);
% $$$ x=[ones(length(yr),1) yr];
% $$$ b=lstiny(y,x);
% $$$ yhat=[ones(length(yrs),1) yrs]*b;  % i.e. out to yrT!
% $$$ plot(yrs,yhat,'g--');  % dashed for forecast
% $$$ plot(yr,yhat(yr-yr0),'g-'); % solid for fitted value
% $$$ val=[2500 5000 10000 15000 20000 25000]';
% $$$ labs=strmat('$2500 $5000 $10000 $15000 $20000 $25000');
% $$$ logv=log(val);
% $$$ set(gca,'YTick',logv);
% $$$ set(gca,'YTickLabel',labs);
% $$$ chadfig('Year','Per Capita GDP',1,0);
%     pause;

figure(1); figsetup;
plot(yrs,exp(logYL));
%val=[2500 5000 10000 15000 20000 25000]';
val=[2.5 5 10 15 20 25 30 35 40 45]'*1000;
%labs=strmat('$2500 $5000 $10000 $15000 $20000 $25000');
labs=num2str(val);
logv=log(val);
set(gca,'YTick',exp(logv));
set(gca,'YTickLabel',labs);
%text(1975,log(16000),'2.0% per year');
str{1}='Per Capita GDP';
str{2}='(2009 dollars)';
ax=axis; ax(1)=1870; ax(2)=2015; axis(ax);
makefigwide;
chadfig('Year',str,1,stopit);
print uspcgdp1.eps;



% Now let's do with just the full sample regression line.
figure(2); figsetup;
x=[ones(length(yrs),1) yrs];
b=lstiny(logYL,x)
plot(yrs,x*b,'--','Color',clrs(2,:),'LineWidth',2);  % dashed for forecast
plot(yrs,logYL,'Color',clrs(1,:),'LineWidth',LW);
%val=[2500 5000 10000 15000 20000 25000]';
val=[2 4 8 16 32 64]'*1000;
%labs=strmat('$2500 $5000 $10000 $15000 $20000 $25000');
labs=strmat('2,000 4,000 8,000 16,000 32,000 64,000');
%labs=num2str(val);
logv=log(val);
set(gca,'YTick',logv);
set(gca,'YTickLabel',labs);
text(1975,log(16000),'2.0% per year');
%str{1}='Per Capita GDP';
%str{2}='(ratio scale, 2009 dollars)';
str2='log scale, chained 2009 dollars';
ax=axis; ax(1)=1870; ax(2)=2015; ax(4)=log(64100); axis(ax);
makefigwide;
chadfig2('Year',str2,1,stopit);
print uspcgdp2.eps;

% abc

% % Aggregate, Per Capita, and Population
% figure(3); figsetup;
% aggGDP=newgdp/10^3.*newpop/10^4;  % In trillions of dollars
% YY=[newpop/10^5 newgdp/10^3 aggGDP];
% plotlog(yrs,YY);
% hold on;
% x=[ones(length(yrs),1) yrs];
% b=inv(x'*x)*x'*log(YY)
% g=(YY(139,:)./YY(1,:)).^(1/139)-1
% %plot(yrs,x*b,'g--');  % dashed for forecast
% text(1980,log(1.7),'1.5%');
% text(1980,log(16),'2.0%');
% text(1980,log(350),'3.5%');
% text(1920,log(350),'Total GDP');
% text(1915,log(16),'Per Capita GDP');
% text(1920,log(1.7),'Population');
% set(gca,'YTick',[]);
% set(gca,'YTickLabel',[]);
% ax=axis; ax(1)=1870; ax(2)=2015; axis(ax);
% makefigwide;
% chadfig('Year','Ratio Scale',1,stopit);
% print uspcgdp3.eps;


% % HP Filtered trend  -- This is for the Chapter 1, Figure 1.6
% trend=hpfilter(logYL,100);

% figure(4); figsetup;
% plot(yrs,logYL);
% hold on;
% plot(yrs,trend,'g--');
% val=[2 4 8 16 32 64]'*1000;
% labs=strmat('2,000 4,000 8,000 16,000 32,000 64,000');
% %labs=num2str(val);
% logv=log(val);
% set(gca,'YTick',logv);
% set(gca,'YTickLabel',labs);
% txt=mlstring('The average annual\\ growth rate is\\ 2% per year');
% text(1920,log(24000),txt);
% str='Per capita GDP (2009 dollars)';
% %str{2}='(ratio scale, 2009 dollars)';
% ax=axis; ax(2)=2010; axis(ax);
% ax=axis; ax(1)=1870; ax(2)=2015; axis(ax);
% chadfig('Year',str,1,stopit);
% makefigwide;
% print uspcgdp4.eps;


% % HP Filtered trend  -- This is for the Chapter 9, Figure 9.1
% %  start in 1929
% aggtrend=hpfilter(log(aggGDP/100),100);
% yy=(1929:yrT)-1869;

% figure(5); figsetup;
% plot(yrs(yy),log(aggGDP(yy)/100));
% hold on;
% plot(yrs(yy),aggtrend(yy),'g--');
% val=[1 2 4 8 16]';
% %labs=strmat('$2500 $5000 $10000 $15000 $20000 $25000');
% labs=num2str(val);
% logv=log(val);
% set(gca,'YTick',logv);
% set(gca,'YTickLabel',labs);
% str='Trillions of chained 2009 dollars, ratio scale';
% %str{2}='(ratio scale, 2009 dollars)';
% ax=axis; ax(1)=1929; ax(2)=2015; axis(ax);
% chadfig('Year',str,1,stopit);
% text(1940,log(2.2),'Actual');
% text(1945,log(1.6),'Potential');
% makefigwide;
% print uspcgdp5.eps;

% disp ' '; 
% disp ' ';
% disp 'Data for Figures X.x in the LRIntro Chapter';
% disp '===========================================';
% fmt='%6.0f %9.0f';
% cshow(' ',[yrs newgdp newpop aggGDP*10],fmt,'Years PerCapita  Population  TotalGDP');
% disp 'NOTE:  Per capita is in dollars, population is in thousands, and total GDP ';
% disp 'is in billions of dollars';




diary off;

