% verylongrunWest.m  -- 3/29/05.  Updated 2/9/15 for Facts
%
%  Figure of very long run per capita gdp, from maddison2005.xls
%  (downloaded from his web page today)
%
%    http://www.eco.rug.nl/~Maddison/

if exist('verylongrunWest.log'); delete('verylongrunWest.log'); end;
diary verylongrunWest.log;
fprintf(['verylongrunWest                 ' date]);
disp ' ';
disp ' ';
help verylongrunWest


% % Western Europe (12 countries) data -- Maddison 2008 spreadsheet from Oct 2008
% %  See maddison2008.xls
% %  http://www.ggdc.net/maddison/

% %	GDP per person		Population
% %			
% %	12 W. Europe		12 W. Europe
% data=[
% 1	599		18600
% 1000	425		19700
% 1500	798		48192
% 1600	907		62580
% 1700	1032		68796
% 1820	1243		114571
% 1850	1658		143615
% 1870	2087		162386
% %1890	2643		187219
% 1900	3076		203501
% %1910	3380		223009
% 1920	3304		223731
% %1930	4288		235975
% 1940	4984		248417
% %1950	5018		256376
% 1960	7607		273807
% %1970	10959		295723
% 1980	14056		305157
% %1990	16870		312802
% 2000	20102		324285
% 2006	21784		328938
% ];
% Western europe
%yrs=data(:,1);
%gdppc=data(:,2)/1000;
%pop=data(:,3);


%  The West (Western Europe + US)
%   Year Pop GDP GDPPC
data=[
1	19280	11418	592
%1	19280	11418	423    % Assume zero growth before 1000 instead!
1000	21000	8886	423
1500	50192	39250	782
1600	64080	57384	896
1700	69796	71515	1025
1820	124552	154947	1244
1850	167195	280735	1679
1870	202627	437352	2158
1890	250521	709474	2832
1900	279892	938521	3353
1910	315776	1214164	3845
1920	330612	1332739	4031
1930	359643	1780115	4950
1940	381054	2167753	5689
1950	408647	2742350	6711
1960	454478	4129622	9087
1970	500775	6322646	12626
1980	532883	8519788	15988
1990	562934	11080055	19683
2000	606624	14550849	23987
2006	627382	16432006	26191
];

% The "West"
yrs=data(:,1);
gdppc=data(:,4);
pop=data(:,2)/1000;

% % WORLD data from Maddison (2008)  2/16/2015
% %	World Per 	World
% %	Capita GDP	Population
% data=[
% %1	467	225820 % Assuming zero growth from 1 to 1000 for graphing
% 1	453	225820
% 1000	453	267330
% 1500	566	438428
% 1600	596	556148
% 1700	615	603490
% 1820	667	1041720
% 1870	873	1271916
% 1900	1262	1563464
% 1913	1526	1791214
% 1940	1962	2295142
% 1950	2113	2525501
% 1960	2775	3040118
% 1970	3736	3685775
% 1980	4521	4433174
% 1990	5162	5256680
% 2000	6053	6061593
% 2006	7275	6496812
% ];
% yrs=data(:,1);
% gdppc=data(:,2);
% pop=data(:,3);


yindx=gdppc/gdppc(1)*1; % Normalize to 1 in year 1
yindx(2)=1; % For plotting, drop out the negative growth
pindx=pop/pop(1)*1; % Normalize to 1 in year 1.
disp 'population normalized to 1 in year 1';


gyrs=[
    1     1000
    1000  1500
    1500  1820
    1820  1900
    1900  2006
      ];

fmt='%4.0f %5.0f %8.2f %8.2f';
tle='Year Year Y/Pop Pop';
ygr=100*growthrate4(gdppc,yrs,gyrs);
popgr=100*growthrate4(pop,yrs,gyrs);
cshow(' ',[gyrs ygr popgr],fmt,tle);

i=[1 2 3 6 10 21]';
fmt='%6.0f %8.0f %8.2f %8.0f %8.2f';
tle='Year GDP/N Growth Pop Growth';
cshow(' ',[yrs(i) gdppc(i) [NaN; ygr] pop(i) [NaN; popgr]],fmt,tle);


mygreen=[0 .6 .4];

% figure(1); clf;
% plot(yrs,log(pop),'-','Color',mygreen);
% hold on;
% plotlog(yrs,gdppc,'-','0.5 1 2 4 8 16 32 64')
% chadfig('Year','Log Scale, Initialized to 1.0',1,1)
% ax=axis; ax(2)=2010; ax(4)=log(70); axis(ax);
% text(1000,log(3),'Population','Color',mygreen);
% text(1600,log(1.2),'Per capita GDP','Color','b');
% set(gca,'YGrid','on')
% makefigwide;
% wait;
% print verylongrunWest.eps


% figure(1); figsetup;
% plot(yrs,log(pop),'--','Color',mygreen,'LineWidth',2);
% hold on;
% axlabel='0.5 1 2 4 8 16 32 64';
% plot(yrs,log(gdppc),'-','LineWidth',4');
% chadfig('Year','Log Scale, Initialized to 1.0',1,1)
%    logval=log(str2num(axlabel));
%    set(gca,'YTick',logval);
%    set(gca,'YTickLabel',strmat(axlabel));
% ax=axis; ax(2)=2010; ax(3)=log(.8); ax(4)=log(70); axis(ax);
% text(1000,log(3),'Population','Color',mygreen,'FontWeight','bold');
% text(1600,log(1.3),'Per capita GDP','Color','b','FontWeight','bold');
% set(gca,'YGrid','on')
% makefigwide;
% wait;
% print verylongrunWest.eps

%clrs=get(groot,'DefaultAxesColorOrder')
definecolors;
LW=4;


figure(1); figsetup;
plot(yrs,pindx,'--','Color',mygreen,'LineWidth',LW);
hold on;
%axlabel='1 2 4 8 16 32 64';
plot(yrs,yindx,'-','Color',myblue,'LineWidth',LW);
chadfig2('Year','Index (1.0 in initial year)',1,0)
%relabelaxis(str2num(axlabel),strmat(axlabel),'y');
ax=axis; ax(2)=2010; ax(3)=.8; ax(4)=45; axis(ax);
text(1450,8,'Population');% ,'Color',mygreen,'FontWeight','bold');
text(1500,40,'Per capita GDP'); %,'Color',myblue,'FontWeight','bold');
%set(gca,'YGrid','on')
makefigwide;
printopt
print verylongrunWest.eps



% figure(2); figsetup;
% x=(1:10)';
% for i=1:8;
%     y(i,:)=i*x;
% end;
% plot(x,y);


cshow(' ',[yrs yindx pindx],'%7.0f %8.2f','Year GDPPC Pop');

figure(2); figsetup;
%plot(yrs,pindx,'--','Color',mygreen,'LineWidth',LW);
%hold on;
%axlabel='1 2 4 8 16 32 64';
plot(yrs,yindx,'-','Color',myblue,'LineWidth',LW);
chadfig2('Year','Index (1.0 in initial year)',1,0)
%relabelaxis(str2num(axlabel),strmat(axlabel),'y');
ax=axis; ax(2)=2010; ax(3)=.8; ax(4)=45; axis(ax);
%text(1450,8,'Population');% ,'Color',mygreen,'FontWeight','bold');
%text(1500,40,'Per capita GDP'); %,'Color',myblue,'FontWeight','bold');
%set(gca,'YGrid','on')
makefigwide;
print verylongrunWestblank.eps


diary off;
