% GDPDeflator.m
%
%  Loads the annual GDP Deflator from FRED.
%
% FRED Graph Observations	
% Federal Reserve Economic Data	
% Link: https://fred.stlouisfed.org	
% Help: https://fred.stlouisfed.org/help-faq	
% Economic Research Division	
% Federal Reserve Bank of St. Louis	
	
% A191RD3A086NBEA	Gross domestic product (implicit price deflator), Index 2009=100, Annual, Not Seasonally Adjusted
% Frequency: Annual	
% observation_date	A191RD3A086NBEA

data=[
1929	9.896
1930	9.535
1931	8.555
1932	7.553
1933	7.345
1934	7.749
1935	7.908
1936	8.001
1937	8.347
1938	8.109
1939	8.033
1940	8.131
1941	8.680
1942	9.369
1943	9.795
1944	10.027
1945	10.288
1946	11.618
1947	12.887
1948	13.605
1949	13.581
1950	13.745
1951	14.716
1952	14.972
1953	15.157
1954	15.298
1955	15.559
1956	16.091
1957	16.625
1958	17.001
1959	17.237
1960	17.476
1961	17.669
1962	17.886
1963	18.088
1964	18.366
1965	18.702
1966	19.227
1967	19.786
1968	20.627
1969	21.642
1970	22.784
1971	23.941
1972	24.978
1973	26.337
1974	28.703
1975	31.361
1976	33.083
1977	35.135
1978	37.602
1979	40.706
1980	44.377
1981	48.520
1982	51.530
1983	53.565
1984	55.466
1985	57.240
1986	58.395
1987	59.885
1988	61.982
1989	64.392
1990	66.773
1991	68.996
1992	70.569
1993	72.248
1994	73.785
1995	75.324
1996	76.699
1997	78.012
1998	78.859
1999	80.065
2000	81.887
2001	83.754
2002	85.039
2003	86.735
2004	89.120
2005	91.988
2006	94.814
2007	97.337
2008	99.246
2009	100.000
2010	101.221
2011	103.311
2012	105.214
2013	106.929
2014	108.686
2015	109.775
];

PriceIndexYears=data(:,1);
PriceIndexGDP=data(:,2);

save GDPDeflator PriceIndexYears PriceIndexGDP;
