% BasicGraphs    8/15/12

if exist('BasicGraphs.log'); delete('BasicGraphs.log'); end;
diary BasicGraphs.log;
fprintf(['BasicGraphs                 ' date]);
disp ' ';
disp ' ';
help BasicGraphs

clear;
load WorldTopInequalityDatabase2016;

T=2015
yrs=(1950:T)';
yy=yrs-yr0;


% Offsets for particular countries to get a uniform series
% Note well: we are replacing the "base" series with a variant...
is10(:,CAN)=is01lad(:,CAN);
is01(:,CAN)=is01lad(:,CAN);
is001(:,CAN)=is01lad(:,CAN);
is10(:,DNK)=is01adlt(:,DNK);
is01(:,DNK)=is01adlt(:,DNK);
is001(:,DNK)=is01adlt(:,DNK);
is10(:,NZL)=is01adlt(:,NZL);
is01(:,NZL)=is01adlt(:,NZL);
is001(:,NZL)=is01adlt(:,NZL);

% Merge the married and adult series for ZAF and GBR
% They break around 1990 but are very similar in surrounding years.
is10(:,GBR)=nanmean([is10mar(:,GBR) is10adlt(:,GBR)]')';
is01(:,GBR)=nanmean([is01mar(:,GBR) is01adlt(:,GBR)]')';
is001(:,GBR)=nanmean([is001mar(:,GBR) is001adlt(:,GBR)]')';
is10(:,ZAF)=nanmean([is10mar(:,ZAF) is10adlt(:,ZAF)]')';
is01(:,ZAF)=nanmean([is01mar(:,ZAF) is01adlt(:,ZAF)]')';
is001(:,ZAF)=nanmean([is001mar(:,ZAF) is001adlt(:,ZAF)]')';

definecolors;
LW=4

figure(1); figsetup;
plot(yrs,is001(yy,FRA),'-','Color',mygreen,'LineWidth',LW); hold on;
plot(yrs,is001(yy,USA),'-','Color',myblue,'LineWidth',LW);
plot([2006 2011],is001([2006 2011]-yr0,FRA),'--','Color',mygreen,'LineWidth',1);
%plot(yrs,,'r-');
ax=axis; ax(2)=T+1; axis(ax);
makefigwide;
set(gca,'YTick',[0 2 4 6 8 10 12]);
set(gca,'YTickLabel',strmat('0% 2% 4% 6% 8% 10% 12%'));
chadfig2('Year','Income share of top 0.1 percent',1,0);
text(1982,7,'United States');
text(1998,3,'France');
wait
print('-depsc','BasicGraph1');

fmt='%6.0f %8.1f';
ctys=[USA FRA JPN NOR SWE GBR SGP IND CHN];
tle='Year USA FRA JPN NOR SWE GBR SGP IND CHN';
disp ' ';
disp 'Top 0.1% shares';
cshow(' ',[yrs is001(yy,ctys)],fmt,tle);

disp ' ';
disp 'Top 1% shares';
cshow(' ',[yrs is01(yy,ctys)],fmt,tle);


yrs=(1960:T)';
yy=yrs-yr0;
figure(2); figsetup;
NotStartEnd=1;  % Don't interpolate at beginning or end of data
y=interplin3(is001(yy,:),NaN,NotStartEnd);
y(:,TZA)=NaN;  % only data through 1970, skews appearance of plot
plot(yrs,y); % Interpolate missing values
%ax=axis; ax(1)=1910; ax(2)=2010; axis(ax);
ax=axis; ax(2)=T+1; axis(ax);
makefigwide;
set(gca,'YTick',[0 2 4 6 8]);
set(gca,'YTickLabel',strmat('0% 2% 4% 6% 8%'));
%set(gca,'YTick',[0 2 4 6 8 10 12 14 16 18]);
%set(gca,'YTickLabel',strmat('0% 2% 4% 6% 8% 10% 12% 14% 16% 18%'));
chadfig2('Year','Income share of top 0.1 percent',1,0);
wait
print('-depsc','BasicGraph2');



figure(3); figsetup; hold on;
plot(yrs,y(:,USA),'Color','b');      
plot(yrs,y(:,FRA),'Color','k');    
plot(yrs,y(:,GER),'Color',myred);  
plot(yrs,y(:,ARG),'Color',myorng); 
plot(yrs,y(:,JPN),'Color',myred);  
plot(yrs,y(:,NOR),'Color',mypurp); 
plot(yrs,y(:,IND),'Color',mygreen);
plot(yrs,y(:,CHN),'Color','b');
%plot(yrs,y(:,SGP),'Color',mygreen);
ax=axis; ax(2)=T+1; axis(ax);
chadfig2('Year','Income share of top 0.1 percent',1,0);
makefigwide;
set(gca,'YTick',[0 2 4 6 8]);
set(gca,'YTickLabel',strmat('0% 2% 4% 6% 8%'));
text(1987,5.8,'U.S.','Color','b');    
text(1962,2.7,'France','Color','k');    
text(1975,4.5,'Germany','Color',myred);  
text(1961,5.15,'Argentina','Color',myorng); 
text(2000,1.7,'Japan','Color',myred);  
text(2007,4,'Norway','Color',mypurp); 
text(1972,3,'India','Color',mygreen);
text(2003,0.8,'China','Color','b');
wait
print BasicGraph3.eps




disp 'Top 0.1 percent shares...';
fprintf('               '); say(num2str((1960:5:2010)')); disp ' ';
cshow(Countries,y((1960:5:T)-1959,:)','%6.1f');


disp 'Top 0.1 percent shares for select countries, annually';
tle='Year USA CAN ARG NOR GER SGP ZAF CHN'
cshow(' ',[yrs y(:,[USA CAN ARG NOR GER SGP ZAF CHN])],'%6.0f %6.1f',tle);


% Bar chart for all countries
y=[is01(1981-yr0,:)' is01(2005-yr0,:)' is01(2008-yr0,:)' is001(1981-yr0,:)' is001(2005-yr0,:)' is001(2008-yr0,:)'];
tle='is01(81) is01(05) is01(08) is001(81) is001(05) is001(08)';
cshow(Countries,y,'%9.1f',tle);


figure(4); figsetup;
%y=[is01(1981-yr0,:)' is01(2005-yr0,:)'];
yy=[meannan(is01((1980:1982)-yr0,:))' meannan(is01((2004:2006)-yr0,:))'];
keep=~isnan(yy(:,1).*yy(:,2));
y=yy(keep,:);
[blah,indx]=sort(y(:,2)-y(:,1));

bar(y(indx,:));
colormap('summer')
chadfig2(' ','Income share of the top 1% (percent)',1,0);
set(gca,'YTick',[0 2 4 6 8 10 12 14 16 18]);
set(gca,'YTickLabel',strmat('0% 2% 4% 6% 8% 10% 12% 14% 16% 18%'));N=sum(keep);
newcodes=codes(keep,:);
set(gca,'XTick',(1:N));
set(gca,'XTickLabel',newcodes(indx,:),'FontSize',10);
wait
print BasicGraph4.eps


% figure(5); figsetup;
% plotnamesym(yy(:,1),yy(:,2),Countries,10,[],.03,.0);
% hold on;
% plot(3:18,3:18,'k--','LineWidth',1);
% chadfig2('Top 1% share, 1980-82','Top 1% share, 2004-06',1,0)
% text(14,13,'45-degree line','Color','k','FontSize',10)
% print BasicGraph5.eps
% disp ' '; disp ' ';
% disp '1980-82 vs 2004-2006'; disp ' ';
% cshow(Countries,yy,'%8.1f');

FS=14;
yy=[meannan(is01((1980:1982)-yr0,:))' meannan(is01((2006:2008)-yr0,:))'];
figure(5); figsetup;
plotnamesym(yy(:,1),yy(:,2),Countries,FS,[],.03,.0,0,myblue);
hold on;
plot(3:18,3:18,'k--','LineWidth',0.5);
chadfig2('Top 1% share, 1980-82','Top 1% share, 2006-08',1,0)
text(14,13,'45-degree line','Color','k','FontSize',FS)
wait
print BasicGraph5.eps
disp ' '; disp ' ';
disp '1980-82 vs 2006-2008'; disp ' ';
cshow(Countries,yy,'%8.1f');

% yy=[meannan(is01((1980:1982)-yr0,:))' meannan(is01((2010:2012)-yr0,:))'];
% figure(5); figsetup;
% plotnamesym(yy(:,1),yy(:,2),Countries,10,[],.03,.0);
% hold on;
% plot(3:18,3:18,'k--','LineWidth',1);
% chadfig2('Top 1% share, 1980-82','Top 1% share, 2010-12',1,0)
% text(14,13,'45-degree line','Color','k','FontSize',10)
% print BasicGraph5b.eps

% disp ' '; disp ' ';
% disp '1980-82 vs 2010-2012'; disp ' ';
% cshow(Countries,yy,'%8.1f');

diary off;
