% LorenzData_main   
%
% Main program for getting results from NBER/IRS public use data
% That is: Does labor income look like a Pareto distribution?
%   How has this changed between 1980 and 2005?
% 
% Find records with incomes greater than z in file fname.txt
% Tabulate zmean/z as in Saez (2001)
%   zmean / z = Mean of incomes above z, divided by z
%
% Will save the key results in x2005Lorenz.asc and x1980Lorenz.asc


if exist('LorenzData_main.log'); delete('LorenzData_main.log'); end;
diary LorenzData_main.log;
fprintf(['LorenzData_main                 ' date]);
disp ' ';
disp ' ';
help LorenzData_main

clear all;

more off  % Turn off the pause in interactive Octave when displaying data
warning off;

zstart=10000
includebusiness=1

% Put everything in 2005 dollars
%http://www.usinflationcalculator.com/inflation/consumer-price-index-and-annual-percent-changes-from-1913-to-2008/
cpi1980=82.4;
cpi2005=195.3;
cpi1980=cpi1980/cpi2005*100;
cpi2005=100;


disp ' '; disp ' ';
disp '*************************************';
disp '*               1980                *';
disp '*************************************';
lorenzdata(1980,zstart,cpi1980,includebusiness);

disp ' '; disp ' ';
disp '*************************************';
disp '*               2005                *';
disp '*************************************';
lorenzdata(2005,zstart,cpi2005,includebusiness);
disp ' '; disp ' ';



diary off;