function [s,estarH,estarL,g,eta,dlta,muH,muL]=solveideamodel(ss,Omega,beta,rho,phiH,phiL,gamma,sigmaH,sigmaL,theta,lambda,zbar,Lbar,mbar,dltabar,tau,pbar,qbar);

% function [s,estarH,estarL,g,eta,dlta,muH,muL]=solveideamodel(ss,Omega,beta,rho,phiH,phiL,gamma,sigmaH,sigmaL,theta,lambda,zbar,Lbar,mbar,dltabar,pbar,qbar);
%
%  4/9/14 Key solving function for basic model in 2014-04-02-IdeaMktShare.xoj
%    -- That is, researchers who succeed become entrepreneurs...
%  9/24/14 -- updated to include zbar (blocking of innovations)
%  6/17/15 -- Two state Luttmer/GLLM model with muH, muL, sigmaH, sigmaL, pbar, qbar
%             (and no reflecting barrier so Ex and Elogx are easy to compute)

Omega=1-tau;
dlta=lambda*(1-zbar)*ss*Lbar;
estarH=Omega-beta*(rho+dlta+dltabar)/phiH;
estarL=Omega-beta*(rho+dlta+dltabar)/phiL;
g=dlta*log(gamma);
muH=phiH*estarH;
muL=phiL*estarL;
mutildeH=muH-1/2*sigmaH^2;
mutildeL=muL-1/2*sigmaL^2;

xi=-mutildeH/sigmaH^2 + sqrt( (mutildeH/sigmaH^2)^2+2*(dltabar+pbar)/sigmaH^2 );
eta=1/xi;

piH=dltabar*qbar/(pbar+dltabar);
piL=1-piH;
cH=beta*log(Omega-estarH)+mutildeH/(rho+dlta+dltabar);
cL=beta*log(Omega-estarL)+mutildeL/(rho+dlta+dltabar);

%if cH<cL; 
%    fprintf('Problem in solveideamodel.m:  cH = %8.4f    cL = %8.4f\n',[cH cL]);
%end;

Dpi=piH*((rho+dlta+dltabar)*cH+pbar*cL)/(rho+dlta+dltabar+pbar) + piL*cL;
Dqbar=qbar*((rho+dlta+dltabar)*cH+pbar*cL)/(rho+dlta+dltabar+pbar) + (1-qbar)*cL;

% Key moments of the f(x) distribution
Ex=dltabar*qbar/(dltabar+pbar-muH)+dltabar*(1-qbar)/(dltabar-muL)+dltabar*qbar*pbar/(dltabar-muL)/(dltabar+pbar-muH);
Elogx=(dltabar*qbar*mutildeH+(pbar+dltabar*(1-qbar))*mutildeL)/dltabar/(dltabar+pbar);

R=ss*Lbar;
dbarR=dltabar/R;
term3=(rho+dlta+dltabar)*log(mbar);
term4=lambda*(1-zbar)*(Elogx+Dpi);
term5=dbarR*Dqbar;
logL=log(theta/(1-theta))+log(Ex)-(term3+term4+term5)/(lambda*(1-zbar)+dbarR);
s=1-exp(logL)/Lbar;    

