% Calibrate    2/4/11
%
%  Calibrate the growth drag in "Life and Growth"
%
%  From Prop 2:  1+beta*x / 1+(gamma-1)*x   where x=1+alpha*lambda/(1-phi)


if exist('Calibrate.log'); delete('Calibrate.log'); end;
diary Calibrate.log;
fprintf(['Calibrate                 ' date]);
disp ' ';
disp ' ';
help Calibrate


Gamma=[1.5 2];
X=[ 1/2  1  2]';
Beta=[1/4 .10]';
Results=zeros(length(X),length(Gamma),length(Beta));

for n=1:length(Beta);

  beta=Beta(n);
  disp ' '; disp ' ';
  fprintf('Results for beta=%5.2f\n',beta);
  for i=1:length(Gamma);
    for j=1:length(X);
      Results(j,i,n)=(1+beta*(1+X(j)))/(1+(Gamma(i)-1)*(1+X(j)));
    end;
  end;
  cshow(' ',[X Results(:,:,n)],'%8.2f','X gam=1.5 gam=2');
end;
disp ' ';
fprintf('  Mean of results: %8.2f\n',mean(vector(Results)));




diary off;
