% Consumption.m   2/3/2011
%
%  See NIPA-Consumption.xls for derivations of the numbers.
%Note:  Nonhealth 1 = tornqvist calculation – requires price index for health to be correct		
%          Nonhealth 2 = (Nominal PCE – Nominal Health) / PCEDeflator – imposes same price deflator for health and nonhealth		
%   Health 1 = Real Health from NIPA		
%   Health 2 = Nominal Health deflated by total PCEDeflator – same prices for health and nonhealth.		


if exist('Consumption.log'); delete('Consumption.log'); end;
diary Consumption.log;
fprintf(['Consumption                 ' date]);
disp ' ';
disp ' ';
help Consumption


clear all;
mygreen=[0 .6 .4];   % for 'Color' property
myorng=[255 60 0 ]/255;
mypurp=[186 85 211]/255;

data=[		
%	Index Numbers – Real Per Capita (1950=100)				
%	PCE     NonH1	Nonh2	Hlth 1	Hlth 2
 1929	71.435	71.760	71.866	64.379	62.627
 1930 	66.884	67.107	67.060	62.006	62.543
 1931 	64.293	64.515	64.421	59.443	62.304
 1932 	58.150	58.286	58.083	55.034	59.390
 1933 	56.530	56.748	56.515	51.748	55.644
 1934 	60.180	60.432	60.338	54.684	58.191
 1935 	63.416	63.804	63.598	55.103	58.979
 1936 	69.427	69.946	69.745	58.432	63.120
 1937 	71.561	72.074	71.817	60.666	65.376
 1938 	69.859	70.349	70.067	59.430	66.373
 1939 	73.169	73.681	73.370	62.270	68.941
 1940 	76.319	76.916	76.523	63.738	72.641
 1941 	80.947	81.607	81.398	67.070	72.263
 1942 	78.178	78.507	78.501	71.087	71.517
 1943 	79.262	79.527	79.620	73.574	71.772
 1944 	80.542	80.699	80.826	77.213	75.438
 1945 	84.592	84.866	84.990	78.629	76.533
 1946 	94.128	94.338	94.464	89.582	87.031
 1947 	94.113	94.308	94.470	89.906	86.711
 1948 	94.588	94.549	94.671	95.437	92.890
 1949 	95.545	95.513	95.557	96.238	95.632
 1950 	100.000	100.000	100.000	100.000	100.000
 1951 	99.860	99.719	99.816	102.923	100.712
 1952 	101.258	101.029	101.073	106.229	105.359
 1953 	104.357	104.129	104.060	109.320	111.383
 1954 	104.698	104.281	104.119	113.530	117.392
 1955 	110.459	110.221	109.889	115.620	123.572
 1956 	111.703	111.230	110.834	121.469	131.110
 1957 	112.433	111.750	111.305	126.273	137.381
 1958 	111.545	110.491	109.988	132.452	145.637
 1959 	115.890	114.688	114.095	139.649	155.092
 1960 	116.682	115.477	114.595	140.518	162.244
 1961 	117.154	115.666	114.791	146.160	168.795
 1962 	121.070	119.145	118.205	158.034	183.119
 1963 	124.255	122.072	121.046	165.926	193.834
 1964 	129.854	127.207	126.053	179.907	212.686
 1965 	136.347	133.730	132.382	185.967	222.321
 1966 	142.431	139.725	138.193	193.792	234.426
 1967 	145.110	142.197	140.369	200.098	248.170
 1968 	151.957	148.609	146.526	214.512	269.740
 1969 	156.100	152.157	149.840	228.610	291.687
 1970 	157.928	153.352	150.780	240.669	312.916
 1971 	161.892	156.793	154.097	253.243	330.840
 1972 	170.022	164.511	161.640	268.490	351.430
 1973 	176.748	170.629	167.870	285.429	369.223
 1974 	173.677	166.876	164.453	293.338	373.431
 1975 	175.901	168.594	165.785	303.867	395.192
 1976 	183.907	176.537	172.928	313.410	421.958
 1977 	189.729	182.114	178.116	323.524	441.965
 1978 	196.013	188.048	183.677	335.728	463.978
 1979 	198.464	190.040	185.539	345.332	479.327
 1980 	195.485	186.408	181.816	351.665	492.334
 1981 	196.482	186.622	181.159	364.024	523.899
 1982 	197.328	187.716	180.982	361.576	547.622
 1983 	206.726	197.303	189.032	370.229	586.007
 1984 	215.789	206.840	197.190	375.111	614.513
 1985 	225.019	216.273	205.386	383.937	646.083
 1986 	232.027	223.206	210.913	393.570	684.917
 1987 	237.059	227.606	214.566	407.088	727.330
 1988 	244.383	234.541	219.934	420.725	777.005
 1989 	248.928	239.359	223.013	423.734	813.341
 1990 	251.173	240.762	222.974	435.088	864.989
 1991 	248.225	237.272	218.223	436.316	900.983
 1992 	253.302	242.445	221.383	442.282	947.561
 1993 	258.911	249.137	226.251	440.090	969.209
 1994 	265.558	256.784	232.413	440.309	986.506
 1995 	269.539	260.737	235.484	446.009	1010.188
 1996 	275.710	267.095	241.155	452.859	1027.262
 1997 	282.492	273.549	246.941	465.006	1055.616
 1998 	293.866	284.985	256.762	480.120	1100.760
 1999 	306.413	298.538	268.570	488.797	1129.591
 2000 	318.430	310.675	279.256	504.364	1170.584
 2001 	323.698	314.219	281.596	525.628	1239.208
 2002 	329.089	317.313	283.571	551.334	1318.472
 2003 	335.189	323.116	287.835	562.175	1364.410
 2004 	343.641	331.401	294.645	575.264	1408.436
 2005 	351.900	339.261	301.552	589.919	1446.082
 2006 	358.638	346.295	307.523	597.002	1469.535
 2007 	363.561	350.840	311.197	606.799	1501.464
 2008 	359.263	344.507	306.085	616.422	1514.768
 2009 	351.893	334.805	295.765	623.342	1570.971
   ];

years=data(:,1);
pce=data(:,2);
nonhealth1=data(:,3);
nonhealth2=data(:,4);
health1=data(:,5);
health2=data(:,6);

yr0=1928;
yrs=(1950:2009)';


cshow(' ',data(yrs-yr0,:),'%8.0f','PCE NonH1 NonH2 Hlth1 Hlth2');


disp ' ';
fprintf('Average growth rate 1950-2009: Total     = %8.4f\n',mean(delta(log(pce(yrs-yr0)))));
fprintf('Average growth rate 1950-2009: Nonhealth1 = %8.4f\n',mean(delta(log(nonhealth1(yrs-yr0)))));
fprintf('Average growth rate 1950-2009: Nonhealth2 = %8.4f\n',mean(delta(log(nonhealth2(yrs-yr0)))));
fprintf('Average growth rate 1950-2009: Health1   = %8.4f\n',mean(delta(log(health1(yrs-yr0)))));
fprintf('Average growth rate 1950-2009: Health2   = %8.4f\n',mean(delta(log(health2(yrs-yr0)))));


yrs1=(1980:2007)';
disp ' ';
fprintf('Average growth rate 1980-2007: Total     = %8.4f\n',mean(delta(log(pce(yrs1-yr0)))));
fprintf('Average growth rate 1980-2007: Nonhealth1 = %8.4f\n',mean(delta(log(nonhealth1(yrs1-yr0)))));
fprintf('Average growth rate 1980-2007: Nonhealth2 = %8.4f\n',mean(delta(log(nonhealth2(yrs1-yr0)))));
fprintf('Average growth rate 1980-2007: Health1   = %8.4f\n',mean(delta(log(health1(yrs1-yr0)))));
fprintf('Average growth rate 1980-2007: Health2   = %8.4f\n',mean(delta(log(health2(yrs1-yr0)))));


figure(1); figsetup;
plot(yrs,nonhealth1(yrs-yr0),'b-');  hold on;
plot(yrs,nonhealth2(yrs-yr0),'Color',mygreen);
plot(yrs,(health1(yrs-yr0)),'Color',myorng);
plot(yrs,(health2(yrs-yr0)),'Color',mypurp);
chadfig('Year','Real quantity per person (1950=100)',1,0);
makefigwide;
grid on;
text(1990.3,1350,'Health (pce)','Color',mypurp);
text(1992.3,1250,'4.67%','Color',mypurp);
text(1996,750,'Health (official)','Color',myorng);
text(1999,650,'3.10%','Color',myorng);
%text(1983,100,'Consumption (pce)','Color',mygreen);
text(1993.5,100,'pce','Color',mygreen);
text(1973,100,'Non-health consumption (      ,official)','Color','b');
text(2004,450,'2.05%','Color','b');
text(2004,250,'1.84%','Color',mygreen);
set(gca,'XGrid','off');


figure(2); figsetup;
plot(yrs,log(health2(yrs-yr0)),'Color',mypurp); hold on;
plot(yrs,log(nonhealth1(yrs-yr0)),'b-');  
plot(yrs,log(nonhealth2(yrs-yr0)),'Color',mygreen);
plot(yrs,log(health1(yrs-yr0)),'Color',myorng);
set(gca,'YTick',log([100 200 400 800 1600]));
set(gca,'YTickLabel',strmat('100 200 400 800 1600'));
chadfig('Year','Real quantity per person (1950=100)',1,0);
makefigwide;
grid on;
text(1990.3,log(1450),'Health (pce)','Color',mypurp);
text(1992.3,log(1220),'4.67%','Color',mypurp);
text(1991,log(650),'Health (official)','Color',myorng);
text(1994,log(540),'3.10%','Color',myorng);
%text(1983,100,'Consumption (pce)','Color',mygreen);
text(1998.5,log(150),'pce','Color',mygreen);
text(1978,log(150),'Non-health consumption (      ,official)','Color','b');
text(1992,log(300),'2.05%','Color','b');
text(2004,log(250),'1.84%','Color',mygreen);
set(gca,'XGrid','off');
print Consumption.eps



diary off;