% HealthOECD    2/1/11
%
%  Health Share of R&D using OECD STAN and GBAORD data.
%
%   See STAN-HealthRND.xls for details of data construction.
%   Reports both an "OECD" and a US total, for comparison.

clear;
%Health Share of R&D (Total)		
%	OECD	US
data=[
1987	NaN	9.03
1988	NaN	9.57
1989	NaN	10.23
1990	NaN	10.57
1991	9.03	11.41
1992	9.72	12.27
1993	10.27	13.21
1994	10.83	14.16
1995	10.99	13.87
1996	10.62	13.09
1997	11.08	13.85
1998	11.27	14.11
1999	11.56	14.43
2000	11.69	14.48
2001	11.58	14.25
2002	13.13	16.52
2003	13.47	16.99
2004	15.79	20.95
2005	15.88	20.84
2006	16.07	20.80
  ];

yrs=data(:,1);
oecd=data(:,2);
us=data(:,3);

figure(1); figsetup;
plot(yrs,us,'b-'); hold on;
plot(yrs,oecd,'Color',[0 .6 .4]);
ax=axis; ax(3)=0; axis(ax);
chadfig('Year','Health Share of R&D (percent)',1,0);
makefigwide;
grid on;
text(1990.1,15,'U.S.','Color','b');
text(1995,9,'OECD','Color',[0 .6 .4]);
set(gca,'XGrid','off');
print HealthOECD.eps




