% HealthRNDShare    1/28/11
%
%  My various attempts to measure the health share of R&D.  Two basic
%  sets of numbers here:
%
%  1.  HealthRND-Chad.xls -- from CMMS and NSF
%  2.  NIHDataBook.xls  -- from past issues of NIH Data Book
%
%  See NIHDataBook.xls for detailed sources and data construction.
%  Basically from the NIH Data Book for 1982, 1989, and 1994 (last one).
%
%  5/16/11 -- Updated to include 2006-2007 from Raymond Wolfe (email)
%
%  See NSF-AllYears-IndustrialRND.xls for my data construction.

clear;

%(1) = NHE CMMS research measure – excludes commercial research			
%(2) = (1) + IRIS industry R&D			
%(3) = (1) + NSF recent industry R&D data, which has better industry data but for a short period			
			
%		Health R&D Share	
%	(1)	(2)	(3)
nsfdata=[
1960	5.06	6.91	NaN 
1961	6.08	7.99	NaN 
1962	6.83	8.78	NaN 
1963	6.96	8.84	NaN 
1964	7.15	NaN 	NaN 
1965	7.51	NaN 	NaN 
1966	7.36	NaN 	NaN 
1967	7.60	NaN 	NaN 
1968	7.61	NaN 	NaN 
1969	7.40	NaN 	NaN 
1970	7.44	NaN 	NaN 
1971	7.83	NaN 	NaN 
1972	8.20	NaN 	NaN 
1973	8.08	NaN 	NaN 
1974	8.29	NaN 	NaN 
1975	9.45	NaN 	NaN 
1976	9.40	NaN 	NaN 
1977	8.92	NaN 	NaN 
1978	9.11	NaN 	NaN 
1979	8.68	NaN 	NaN 
1980	8.59	13.01	NaN 
1981	7.89	12.38	NaN 
1982	7.46	12.31	NaN 
1983	7.27	12.24	NaN 
1984	7.44	12.44	NaN 
1985	7.26	12.14	NaN 
1986	7.49	12.40	NaN 
1987	7.93	13.02	NaN 
1988	8.09	13.58	NaN 
1989	8.27	13.93	NaN 
1990	8.34	13.96	NaN 
1991	8.59	14.65	NaN 
1992	9.13	15.80	NaN 
1993	9.94	17.34	NaN 
1994	10.49	18.05	NaN 
1995	10.17	17.60	NaN 
1996	9.02	15.77	NaN 
1997	9.26	16.47	20.24
1998	9.50	17.05	19.39
1999	9.54	NaN 	20.73
2000	9.53	NaN 	20.30
2001	10.28	NaN 	19.83
2002	11.60	NaN 	25.22
2003	12.09	NaN 	25.17
2004	12.87	NaN 	24.65
2005	12.52	NaN 	24.97
2006	11.93	NaN 	24.54
2007	11.26	NaN 	25.76
2008	10.88	NaN 	NaN 
    ];

nsfyears=nsfdata(:,1);
nsfshare1=nsfdata(:,2);
nsfshare2=nsfdata(:,3);
nsfshare3=nsfdata(:,4);



nihdata=[
1971	11.63
1972	12.16
1973	11.96
1974	13.24
1975	13.08
1976	12.82
1977	12.87
1978	12.78
1979	12.71
1980	12.40
1981	11.75
1982	11.76
1983	11.93
1984	12.06
1985	11.95
1986	12.46
1987	13.48
1988	14.20
1989	14.84
1990	15.78
1991	16.17
1992	17.51
1993	17.78
];

nihyears=nihdata(:,1);
nihshare=nihdata(:,2);

figure(1); figsetup;
plot(nsfyears,nsfshare1,'b-'); hold on;
plot(nsfyears,nsfshare2,'Color',[0 .6 .4]);
plot(nsfyears,nsfshare3,'m');
plot(nihyears,nihshare,'r--');
ax=axis; ax(3)=0; axis(ax);
chadfig('Year','Health Share of R&D (percent)',1,0);
makefigwide;
grid on;
text(1972,4,'Non-commercial health research (CMMS)','Color','b');
text(1970,16,'NIH estimates','Color','r');
text(1995,14,'CMMS + NSF IRIS','Color',[0 .6 .4]);
text(1993,27,'CMMS + NSF Recent','Color','m');
set(gca,'XGrid','off');
print HealthRNDShare.eps




