% Patents.m   3/29/13
%
%  See PatentFigureFromJeffClemens.xls
%  Paper is "The Effect of US Health Insurance Expansions on Medical Innovation"
%
%  Note: "US Inventors" is the fraction of US-inventor patents granted to 
%         medical eq or pharma.  Ditto for foreign.


data=[
%Fraction of Patents in Med Equipment and Pharma		
%	Total	US Inventors	Foreign Inventors
1963	0.0400622	0.0379835	0.0491476
1964	0.0361372	0.0334028	0.0478528
1965	0.0307205	0.0276371	0.0431104
1966	0.033097	0.0307867	0.0422627
1967	0.0348504	0.0332722	0.0404785
1968	0.0334833	0.0326773	0.0362531
1969	0.039447	0.0393698	0.0396738
1970	0.0415341	0.0425934	0.038661
1971	0.041332	0.0414999	0.0409113
1972	0.0434701	0.0428006	0.0449511
1973	0.0470442	0.0476884	0.045579
1974	0.0519023	0.0519488	0.0518102
1975	0.0575833	0.0591673	0.0546569
1976	0.0635662	0.0628501	0.0647884
1977	0.0706001	0.0664016	0.0779259
1978	0.0656561	0.0618122	0.072038
1979	0.0716216	0.0668927	0.0791969
1980	0.0774681	0.0737806	0.0830983
1981	0.0775266	0.071922	0.0858069
1982	0.078721	0.0749941	0.0839863
1983	0.0742702	0.0732257	0.0757014
1984	0.0776785	0.0776709	0.0776887
1985	0.077141	0.0792041	0.074599
1986	0.0868614	0.0923779	0.0804363
1987	0.0939218	0.1025965	0.0843478
1988	0.0939762	0.1029238	0.0842951
1989	0.102578	0.1087355	0.0957641
1990	0.104234	0.1127875	0.0948015
1991	0.1076436	0.1180976	0.0958421
1992	0.1088317	0.1192276	0.0968113
1993	0.1122511	0.1270688	0.0947663
1994	0.1127011	0.1319159	0.0890814
1995	0.1171181	0.1361345	0.0939142
1996	0.1207351	0.1421511	0.0937764
1997	0.1408874	0.1681657	0.1074071
1998	0.1370671	0.1652613	0.1033944
1999	0.1318165	0.1582962	0.0998851
];

years=data(:,1);
total=data(:,2)*100;
us=data(:,3)*100;
foreign=data(:,4)*100;

lw=3;

figure(1); figsetup;
plot(years,total,'-','LineWidth',lw); 
hold on;
plot(years,us,'--','Color',mygreen,'LineWidth',lw); 
chadfig('Year','Percent',1,0);
text(1989,15,'U.S. only','Color',mygreen);
text(1990,9,'Total','Color','b');
makefigwide;
print Patents.eps

